/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectGlobalTargetTcpProxyName
implements ResourceName {
    private final String project;
    private final String targetTcpProxy;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/global/targetTcpProxies/{targetTcpProxy}");
    public static final String SERVICE_ADDRESS = "https://compute.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectGlobalTargetTcpProxyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.targetTcpProxy = (String)Preconditions.checkNotNull((Object)builder.getTargetTcpProxy());
    }

    public static ProjectGlobalTargetTcpProxyName of(String project, String targetTcpProxy) {
        return ProjectGlobalTargetTcpProxyName.newBuilder().setProject(project).setTargetTcpProxy(targetTcpProxy).build();
    }

    public static String format(String project, String targetTcpProxy) {
        return ProjectGlobalTargetTcpProxyName.of(project, targetTcpProxy).toString();
    }

    public String getProject() {
        return this.project;
    }

    public String getTargetTcpProxy() {
        return this.targetTcpProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectGlobalTargetTcpProxyName projectGlobalTargetTcpProxyName = this;
            synchronized (projectGlobalTargetTcpProxyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"targetTcpProxy", (Object)this.targetTcpProxy);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectGlobalTargetTcpProxyName> newFactory() {
        return new ResourceNameFactory<ProjectGlobalTargetTcpProxyName>(){

            public ProjectGlobalTargetTcpProxyName parse(String formattedString) {
                return ProjectGlobalTargetTcpProxyName.parse(formattedString);
            }
        };
    }

    public static ProjectGlobalTargetTcpProxyName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectGlobalTargetTcpProxyName.parse: formattedString not in valid format");
        return ProjectGlobalTargetTcpProxyName.of((String)matchMap.get("project"), (String)matchMap.get("targetTcpProxy"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "targetTcpProxy", this.targetTcpProxy});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectGlobalTargetTcpProxyName) {
            ProjectGlobalTargetTcpProxyName that = (ProjectGlobalTargetTcpProxyName)o;
            return Objects.equals(this.project, that.getProject()) && Objects.equals(this.targetTcpProxy, that.getTargetTcpProxy());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.project, this.targetTcpProxy);
    }

    public static class Builder {
        private String project;
        private String targetTcpProxy;

        public String getProject() {
            return this.project;
        }

        public String getTargetTcpProxy() {
            return this.targetTcpProxy;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setTargetTcpProxy(String targetTcpProxy) {
            this.targetTcpProxy = targetTcpProxy;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectGlobalTargetTcpProxyName projectGlobalTargetTcpProxyName) {
            this.project = projectGlobalTargetTcpProxyName.project;
            this.targetTcpProxy = projectGlobalTargetTcpProxyName.targetTcpProxy;
        }

        public ProjectGlobalTargetTcpProxyName build() {
            return new ProjectGlobalTargetTcpProxyName(this);
        }
    }
}

