/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.deprecated;

import com.google.cloud.compute.deprecated.Compute;
import com.google.cloud.compute.deprecated.ComputeOptions;
import com.google.cloud.compute.deprecated.DiskId;
import com.google.cloud.compute.deprecated.LicenseId;
import com.google.cloud.compute.deprecated.Operation;
import com.google.cloud.compute.deprecated.SnapshotId;
import com.google.cloud.compute.deprecated.SnapshotInfo;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Objects;

public class Snapshot
extends SnapshotInfo {
    private static final long serialVersionUID = -973924811396336695L;
    private final ComputeOptions options;
    private transient Compute compute;

    Snapshot(Compute compute, SnapshotInfo.BuilderImpl infoBuilder) {
        super(infoBuilder);
        this.compute = (Compute)Preconditions.checkNotNull((Object)compute);
        this.options = (ComputeOptions)compute.getOptions();
    }

    public boolean exists() {
        return this.reload(Compute.SnapshotOption.fields(new Compute.SnapshotField[0])) != null;
    }

    public Snapshot reload(Compute.SnapshotOption ... options) {
        return this.compute.getSnapshot(this.getSnapshotId().getSnapshot(), options);
    }

    public Operation delete(Compute.OperationOption ... options) {
        return this.compute.deleteSnapshot(this.getSnapshotId(), options);
    }

    public Compute getCompute() {
        return this.compute;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Snapshot.class)) {
            return false;
        }
        Snapshot other = (Snapshot)obj;
        return Objects.equals(this.toPb(), other.toPb()) && Objects.equals((Object)this.options, (Object)other.options);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.options});
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.compute = (Compute)this.options.getService();
    }

    static Snapshot fromPb(Compute compute, com.google.api.services.compute.model.Snapshot snapshotPb) {
        return new Snapshot(compute, new SnapshotInfo.BuilderImpl(snapshotPb));
    }

    public static class Builder
    extends SnapshotInfo.Builder {
        private final Compute compute;
        private final SnapshotInfo.BuilderImpl infoBuilder;

        Builder(Compute compute, SnapshotId snapshotId, DiskId sourceDisk) {
            this.compute = compute;
            this.infoBuilder = new SnapshotInfo.BuilderImpl();
            this.infoBuilder.setSnapshotId(snapshotId);
            this.infoBuilder.setSourceDisk(sourceDisk);
        }

        Builder(Snapshot snapshot) {
            this.compute = snapshot.compute;
            this.infoBuilder = new SnapshotInfo.BuilderImpl(snapshot);
        }

        @Override
        Builder setGeneratedId(String generatedId) {
            this.infoBuilder.setGeneratedId(generatedId);
            return this;
        }

        @Override
        Builder setCreationTimestamp(Long creationTimestamp) {
            this.infoBuilder.setCreationTimestamp(creationTimestamp);
            return this;
        }

        @Override
        public Builder setSnapshotId(SnapshotId snapshotId) {
            this.infoBuilder.setSnapshotId(snapshotId);
            return this;
        }

        @Override
        public Builder setDescription(String description) {
            this.infoBuilder.setDescription(description);
            return this;
        }

        @Override
        Builder setStatus(SnapshotInfo.Status status) {
            this.infoBuilder.setStatus(status);
            return this;
        }

        @Override
        Builder setDiskSizeGb(Long diskSizeGb) {
            this.infoBuilder.setDiskSizeGb(diskSizeGb);
            return this;
        }

        @Override
        Builder setLicenses(List<LicenseId> licenses) {
            this.infoBuilder.setLicenses((List)licenses);
            return this;
        }

        @Override
        public Builder setSourceDisk(DiskId sourceDisk) {
            this.infoBuilder.setSourceDisk(sourceDisk);
            return this;
        }

        @Override
        Builder setSourceDiskId(String sourceDiskId) {
            this.infoBuilder.setSourceDiskId(sourceDiskId);
            return this;
        }

        @Override
        Builder setStorageBytes(Long storageBytes) {
            this.infoBuilder.setStorageBytes(storageBytes);
            return this;
        }

        @Override
        Builder setStorageBytesStatus(SnapshotInfo.StorageBytesStatus storageBytesStatus) {
            this.infoBuilder.setStorageBytesStatus(storageBytesStatus);
            return this;
        }

        @Override
        public Snapshot build() {
            return new Snapshot(this.compute, this.infoBuilder);
        }
    }
}

