/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AbandonInstancesInstanceGroupManagerHttpRequest;
import com.google.cloud.compute.v1.AggregatedListInstanceGroupManagersHttpRequest;
import com.google.cloud.compute.v1.DeleteInstanceGroupManagerHttpRequest;
import com.google.cloud.compute.v1.DeleteInstancesInstanceGroupManagerHttpRequest;
import com.google.cloud.compute.v1.GetInstanceGroupManagerHttpRequest;
import com.google.cloud.compute.v1.InsertInstanceGroupManagerHttpRequest;
import com.google.cloud.compute.v1.InstanceGroupManager;
import com.google.cloud.compute.v1.InstanceGroupManagerAggregatedList;
import com.google.cloud.compute.v1.InstanceGroupManagerList;
import com.google.cloud.compute.v1.InstanceGroupManagerSettings;
import com.google.cloud.compute.v1.InstanceGroupManagersAbandonInstancesRequest;
import com.google.cloud.compute.v1.InstanceGroupManagersDeleteInstancesRequest;
import com.google.cloud.compute.v1.InstanceGroupManagersListManagedInstancesResponse;
import com.google.cloud.compute.v1.InstanceGroupManagersRecreateInstancesRequest;
import com.google.cloud.compute.v1.InstanceGroupManagersScopedList;
import com.google.cloud.compute.v1.InstanceGroupManagersSetInstanceTemplateRequest;
import com.google.cloud.compute.v1.InstanceGroupManagersSetTargetPoolsRequest;
import com.google.cloud.compute.v1.ListInstanceGroupManagersHttpRequest;
import com.google.cloud.compute.v1.ListManagedInstancesInstanceGroupManagersHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchInstanceGroupManagerHttpRequest;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectZoneInstanceGroupManagerName;
import com.google.cloud.compute.v1.ProjectZoneName;
import com.google.cloud.compute.v1.RecreateInstancesInstanceGroupManagerHttpRequest;
import com.google.cloud.compute.v1.ResizeInstanceGroupManagerHttpRequest;
import com.google.cloud.compute.v1.SetInstanceTemplateInstanceGroupManagerHttpRequest;
import com.google.cloud.compute.v1.SetTargetPoolsInstanceGroupManagerHttpRequest;
import com.google.cloud.compute.v1.stub.InstanceGroupManagerStub;
import com.google.cloud.compute.v1.stub.InstanceGroupManagerStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class InstanceGroupManagerClient
implements BackgroundResource {
    private final InstanceGroupManagerSettings settings;
    private final InstanceGroupManagerStub stub;

    public static final InstanceGroupManagerClient create() throws IOException {
        return InstanceGroupManagerClient.create(InstanceGroupManagerSettings.newBuilder().build());
    }

    public static final InstanceGroupManagerClient create(InstanceGroupManagerSettings settings) throws IOException {
        return new InstanceGroupManagerClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final InstanceGroupManagerClient create(InstanceGroupManagerStub stub) {
        return new InstanceGroupManagerClient(stub);
    }

    protected InstanceGroupManagerClient(InstanceGroupManagerSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((InstanceGroupManagerStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected InstanceGroupManagerClient(InstanceGroupManagerStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final InstanceGroupManagerSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public InstanceGroupManagerStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation abandonInstancesInstanceGroupManager(ProjectZoneInstanceGroupManagerName instanceGroupManager, InstanceGroupManagersAbandonInstancesRequest instanceGroupManagersAbandonInstancesRequestResource) {
        AbandonInstancesInstanceGroupManagerHttpRequest request = AbandonInstancesInstanceGroupManagerHttpRequest.newBuilder().setInstanceGroupManager(instanceGroupManager == null ? null : instanceGroupManager.toString()).setInstanceGroupManagersAbandonInstancesRequestResource(instanceGroupManagersAbandonInstancesRequestResource).build();
        return this.abandonInstancesInstanceGroupManager(request);
    }

    @BetaApi
    public final Operation abandonInstancesInstanceGroupManager(String instanceGroupManager, InstanceGroupManagersAbandonInstancesRequest instanceGroupManagersAbandonInstancesRequestResource) {
        AbandonInstancesInstanceGroupManagerHttpRequest request = AbandonInstancesInstanceGroupManagerHttpRequest.newBuilder().setInstanceGroupManager(instanceGroupManager).setInstanceGroupManagersAbandonInstancesRequestResource(instanceGroupManagersAbandonInstancesRequestResource).build();
        return this.abandonInstancesInstanceGroupManager(request);
    }

    @BetaApi
    public final Operation abandonInstancesInstanceGroupManager(AbandonInstancesInstanceGroupManagerHttpRequest request) {
        return (Operation)this.abandonInstancesInstanceGroupManagerCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<AbandonInstancesInstanceGroupManagerHttpRequest, Operation> abandonInstancesInstanceGroupManagerCallable() {
        return this.stub.abandonInstancesInstanceGroupManagerCallable();
    }

    @BetaApi
    public final AggregatedListInstanceGroupManagersPagedResponse aggregatedListInstanceGroupManagers(ProjectName project) {
        AggregatedListInstanceGroupManagersHttpRequest request = AggregatedListInstanceGroupManagersHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.aggregatedListInstanceGroupManagers(request);
    }

    @BetaApi
    public final AggregatedListInstanceGroupManagersPagedResponse aggregatedListInstanceGroupManagers(String project) {
        AggregatedListInstanceGroupManagersHttpRequest request = AggregatedListInstanceGroupManagersHttpRequest.newBuilder().setProject(project).build();
        return this.aggregatedListInstanceGroupManagers(request);
    }

    @BetaApi
    public final AggregatedListInstanceGroupManagersPagedResponse aggregatedListInstanceGroupManagers(AggregatedListInstanceGroupManagersHttpRequest request) {
        return (AggregatedListInstanceGroupManagersPagedResponse)((Object)this.aggregatedListInstanceGroupManagersPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<AggregatedListInstanceGroupManagersHttpRequest, AggregatedListInstanceGroupManagersPagedResponse> aggregatedListInstanceGroupManagersPagedCallable() {
        return this.stub.aggregatedListInstanceGroupManagersPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<AggregatedListInstanceGroupManagersHttpRequest, InstanceGroupManagerAggregatedList> aggregatedListInstanceGroupManagersCallable() {
        return this.stub.aggregatedListInstanceGroupManagersCallable();
    }

    @BetaApi
    public final Operation deleteInstanceGroupManager(ProjectZoneInstanceGroupManagerName instanceGroupManager) {
        DeleteInstanceGroupManagerHttpRequest request = DeleteInstanceGroupManagerHttpRequest.newBuilder().setInstanceGroupManager(instanceGroupManager == null ? null : instanceGroupManager.toString()).build();
        return this.deleteInstanceGroupManager(request);
    }

    @BetaApi
    public final Operation deleteInstanceGroupManager(String instanceGroupManager) {
        DeleteInstanceGroupManagerHttpRequest request = DeleteInstanceGroupManagerHttpRequest.newBuilder().setInstanceGroupManager(instanceGroupManager).build();
        return this.deleteInstanceGroupManager(request);
    }

    @BetaApi
    public final Operation deleteInstanceGroupManager(DeleteInstanceGroupManagerHttpRequest request) {
        return (Operation)this.deleteInstanceGroupManagerCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteInstanceGroupManagerHttpRequest, Operation> deleteInstanceGroupManagerCallable() {
        return this.stub.deleteInstanceGroupManagerCallable();
    }

    @BetaApi
    public final Operation deleteInstancesInstanceGroupManager(ProjectZoneInstanceGroupManagerName instanceGroupManager, InstanceGroupManagersDeleteInstancesRequest instanceGroupManagersDeleteInstancesRequestResource) {
        DeleteInstancesInstanceGroupManagerHttpRequest request = DeleteInstancesInstanceGroupManagerHttpRequest.newBuilder().setInstanceGroupManager(instanceGroupManager == null ? null : instanceGroupManager.toString()).setInstanceGroupManagersDeleteInstancesRequestResource(instanceGroupManagersDeleteInstancesRequestResource).build();
        return this.deleteInstancesInstanceGroupManager(request);
    }

    @BetaApi
    public final Operation deleteInstancesInstanceGroupManager(String instanceGroupManager, InstanceGroupManagersDeleteInstancesRequest instanceGroupManagersDeleteInstancesRequestResource) {
        DeleteInstancesInstanceGroupManagerHttpRequest request = DeleteInstancesInstanceGroupManagerHttpRequest.newBuilder().setInstanceGroupManager(instanceGroupManager).setInstanceGroupManagersDeleteInstancesRequestResource(instanceGroupManagersDeleteInstancesRequestResource).build();
        return this.deleteInstancesInstanceGroupManager(request);
    }

    @BetaApi
    public final Operation deleteInstancesInstanceGroupManager(DeleteInstancesInstanceGroupManagerHttpRequest request) {
        return (Operation)this.deleteInstancesInstanceGroupManagerCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteInstancesInstanceGroupManagerHttpRequest, Operation> deleteInstancesInstanceGroupManagerCallable() {
        return this.stub.deleteInstancesInstanceGroupManagerCallable();
    }

    @BetaApi
    public final InstanceGroupManager getInstanceGroupManager(ProjectZoneInstanceGroupManagerName instanceGroupManager) {
        GetInstanceGroupManagerHttpRequest request = GetInstanceGroupManagerHttpRequest.newBuilder().setInstanceGroupManager(instanceGroupManager == null ? null : instanceGroupManager.toString()).build();
        return this.getInstanceGroupManager(request);
    }

    @BetaApi
    public final InstanceGroupManager getInstanceGroupManager(String instanceGroupManager) {
        GetInstanceGroupManagerHttpRequest request = GetInstanceGroupManagerHttpRequest.newBuilder().setInstanceGroupManager(instanceGroupManager).build();
        return this.getInstanceGroupManager(request);
    }

    @BetaApi
    public final InstanceGroupManager getInstanceGroupManager(GetInstanceGroupManagerHttpRequest request) {
        return (InstanceGroupManager)this.getInstanceGroupManagerCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetInstanceGroupManagerHttpRequest, InstanceGroupManager> getInstanceGroupManagerCallable() {
        return this.stub.getInstanceGroupManagerCallable();
    }

    @BetaApi
    public final Operation insertInstanceGroupManager(ProjectZoneName zone, InstanceGroupManager instanceGroupManagerResource) {
        InsertInstanceGroupManagerHttpRequest request = InsertInstanceGroupManagerHttpRequest.newBuilder().setZone(zone == null ? null : zone.toString()).setInstanceGroupManagerResource(instanceGroupManagerResource).build();
        return this.insertInstanceGroupManager(request);
    }

    @BetaApi
    public final Operation insertInstanceGroupManager(String zone, InstanceGroupManager instanceGroupManagerResource) {
        InsertInstanceGroupManagerHttpRequest request = InsertInstanceGroupManagerHttpRequest.newBuilder().setZone(zone).setInstanceGroupManagerResource(instanceGroupManagerResource).build();
        return this.insertInstanceGroupManager(request);
    }

    @BetaApi
    public final Operation insertInstanceGroupManager(InsertInstanceGroupManagerHttpRequest request) {
        return (Operation)this.insertInstanceGroupManagerCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertInstanceGroupManagerHttpRequest, Operation> insertInstanceGroupManagerCallable() {
        return this.stub.insertInstanceGroupManagerCallable();
    }

    @BetaApi
    public final ListInstanceGroupManagersPagedResponse listInstanceGroupManagers(ProjectZoneName zone) {
        ListInstanceGroupManagersHttpRequest request = ListInstanceGroupManagersHttpRequest.newBuilder().setZone(zone == null ? null : zone.toString()).build();
        return this.listInstanceGroupManagers(request);
    }

    @BetaApi
    public final ListInstanceGroupManagersPagedResponse listInstanceGroupManagers(String zone) {
        ListInstanceGroupManagersHttpRequest request = ListInstanceGroupManagersHttpRequest.newBuilder().setZone(zone).build();
        return this.listInstanceGroupManagers(request);
    }

    @BetaApi
    public final ListInstanceGroupManagersPagedResponse listInstanceGroupManagers(ListInstanceGroupManagersHttpRequest request) {
        return (ListInstanceGroupManagersPagedResponse)((Object)this.listInstanceGroupManagersPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListInstanceGroupManagersHttpRequest, ListInstanceGroupManagersPagedResponse> listInstanceGroupManagersPagedCallable() {
        return this.stub.listInstanceGroupManagersPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListInstanceGroupManagersHttpRequest, InstanceGroupManagerList> listInstanceGroupManagersCallable() {
        return this.stub.listInstanceGroupManagersCallable();
    }

    @BetaApi
    public final InstanceGroupManagersListManagedInstancesResponse listManagedInstancesInstanceGroupManagers(ProjectZoneInstanceGroupManagerName instanceGroupManager) {
        ListManagedInstancesInstanceGroupManagersHttpRequest request = ListManagedInstancesInstanceGroupManagersHttpRequest.newBuilder().setInstanceGroupManager(instanceGroupManager == null ? null : instanceGroupManager.toString()).build();
        return this.listManagedInstancesInstanceGroupManagers(request);
    }

    @BetaApi
    public final InstanceGroupManagersListManagedInstancesResponse listManagedInstancesInstanceGroupManagers(String instanceGroupManager) {
        ListManagedInstancesInstanceGroupManagersHttpRequest request = ListManagedInstancesInstanceGroupManagersHttpRequest.newBuilder().setInstanceGroupManager(instanceGroupManager).build();
        return this.listManagedInstancesInstanceGroupManagers(request);
    }

    @BetaApi
    public final InstanceGroupManagersListManagedInstancesResponse listManagedInstancesInstanceGroupManagers(ListManagedInstancesInstanceGroupManagersHttpRequest request) {
        return (InstanceGroupManagersListManagedInstancesResponse)this.listManagedInstancesInstanceGroupManagersCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<ListManagedInstancesInstanceGroupManagersHttpRequest, InstanceGroupManagersListManagedInstancesResponse> listManagedInstancesInstanceGroupManagersCallable() {
        return this.stub.listManagedInstancesInstanceGroupManagersCallable();
    }

    @BetaApi
    public final Operation patchInstanceGroupManager(ProjectZoneInstanceGroupManagerName instanceGroupManager, InstanceGroupManager instanceGroupManagerResource, List<String> fieldMask) {
        PatchInstanceGroupManagerHttpRequest request = PatchInstanceGroupManagerHttpRequest.newBuilder().setInstanceGroupManager(instanceGroupManager == null ? null : instanceGroupManager.toString()).setInstanceGroupManagerResource(instanceGroupManagerResource).addAllFieldMask(fieldMask).build();
        return this.patchInstanceGroupManager(request);
    }

    @BetaApi
    public final Operation patchInstanceGroupManager(String instanceGroupManager, InstanceGroupManager instanceGroupManagerResource, List<String> fieldMask) {
        PatchInstanceGroupManagerHttpRequest request = PatchInstanceGroupManagerHttpRequest.newBuilder().setInstanceGroupManager(instanceGroupManager).setInstanceGroupManagerResource(instanceGroupManagerResource).addAllFieldMask(fieldMask).build();
        return this.patchInstanceGroupManager(request);
    }

    @BetaApi
    public final Operation patchInstanceGroupManager(PatchInstanceGroupManagerHttpRequest request) {
        return (Operation)this.patchInstanceGroupManagerCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<PatchInstanceGroupManagerHttpRequest, Operation> patchInstanceGroupManagerCallable() {
        return this.stub.patchInstanceGroupManagerCallable();
    }

    @BetaApi
    public final Operation recreateInstancesInstanceGroupManager(ProjectZoneInstanceGroupManagerName instanceGroupManager, InstanceGroupManagersRecreateInstancesRequest instanceGroupManagersRecreateInstancesRequestResource) {
        RecreateInstancesInstanceGroupManagerHttpRequest request = RecreateInstancesInstanceGroupManagerHttpRequest.newBuilder().setInstanceGroupManager(instanceGroupManager == null ? null : instanceGroupManager.toString()).setInstanceGroupManagersRecreateInstancesRequestResource(instanceGroupManagersRecreateInstancesRequestResource).build();
        return this.recreateInstancesInstanceGroupManager(request);
    }

    @BetaApi
    public final Operation recreateInstancesInstanceGroupManager(String instanceGroupManager, InstanceGroupManagersRecreateInstancesRequest instanceGroupManagersRecreateInstancesRequestResource) {
        RecreateInstancesInstanceGroupManagerHttpRequest request = RecreateInstancesInstanceGroupManagerHttpRequest.newBuilder().setInstanceGroupManager(instanceGroupManager).setInstanceGroupManagersRecreateInstancesRequestResource(instanceGroupManagersRecreateInstancesRequestResource).build();
        return this.recreateInstancesInstanceGroupManager(request);
    }

    @BetaApi
    public final Operation recreateInstancesInstanceGroupManager(RecreateInstancesInstanceGroupManagerHttpRequest request) {
        return (Operation)this.recreateInstancesInstanceGroupManagerCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<RecreateInstancesInstanceGroupManagerHttpRequest, Operation> recreateInstancesInstanceGroupManagerCallable() {
        return this.stub.recreateInstancesInstanceGroupManagerCallable();
    }

    @BetaApi
    public final Operation resizeInstanceGroupManager(Integer size, ProjectZoneInstanceGroupManagerName instanceGroupManager) {
        ResizeInstanceGroupManagerHttpRequest request = ResizeInstanceGroupManagerHttpRequest.newBuilder().setSize(size).setInstanceGroupManager(instanceGroupManager == null ? null : instanceGroupManager.toString()).build();
        return this.resizeInstanceGroupManager(request);
    }

    @BetaApi
    public final Operation resizeInstanceGroupManager(Integer size, String instanceGroupManager) {
        ResizeInstanceGroupManagerHttpRequest request = ResizeInstanceGroupManagerHttpRequest.newBuilder().setSize(size).setInstanceGroupManager(instanceGroupManager).build();
        return this.resizeInstanceGroupManager(request);
    }

    @BetaApi
    public final Operation resizeInstanceGroupManager(ResizeInstanceGroupManagerHttpRequest request) {
        return (Operation)this.resizeInstanceGroupManagerCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<ResizeInstanceGroupManagerHttpRequest, Operation> resizeInstanceGroupManagerCallable() {
        return this.stub.resizeInstanceGroupManagerCallable();
    }

    @BetaApi
    public final Operation setInstanceTemplateInstanceGroupManager(ProjectZoneInstanceGroupManagerName instanceGroupManager, InstanceGroupManagersSetInstanceTemplateRequest instanceGroupManagersSetInstanceTemplateRequestResource) {
        SetInstanceTemplateInstanceGroupManagerHttpRequest request = SetInstanceTemplateInstanceGroupManagerHttpRequest.newBuilder().setInstanceGroupManager(instanceGroupManager == null ? null : instanceGroupManager.toString()).setInstanceGroupManagersSetInstanceTemplateRequestResource(instanceGroupManagersSetInstanceTemplateRequestResource).build();
        return this.setInstanceTemplateInstanceGroupManager(request);
    }

    @BetaApi
    public final Operation setInstanceTemplateInstanceGroupManager(String instanceGroupManager, InstanceGroupManagersSetInstanceTemplateRequest instanceGroupManagersSetInstanceTemplateRequestResource) {
        SetInstanceTemplateInstanceGroupManagerHttpRequest request = SetInstanceTemplateInstanceGroupManagerHttpRequest.newBuilder().setInstanceGroupManager(instanceGroupManager).setInstanceGroupManagersSetInstanceTemplateRequestResource(instanceGroupManagersSetInstanceTemplateRequestResource).build();
        return this.setInstanceTemplateInstanceGroupManager(request);
    }

    @BetaApi
    public final Operation setInstanceTemplateInstanceGroupManager(SetInstanceTemplateInstanceGroupManagerHttpRequest request) {
        return (Operation)this.setInstanceTemplateInstanceGroupManagerCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetInstanceTemplateInstanceGroupManagerHttpRequest, Operation> setInstanceTemplateInstanceGroupManagerCallable() {
        return this.stub.setInstanceTemplateInstanceGroupManagerCallable();
    }

    @BetaApi
    public final Operation setTargetPoolsInstanceGroupManager(ProjectZoneInstanceGroupManagerName instanceGroupManager, InstanceGroupManagersSetTargetPoolsRequest instanceGroupManagersSetTargetPoolsRequestResource) {
        SetTargetPoolsInstanceGroupManagerHttpRequest request = SetTargetPoolsInstanceGroupManagerHttpRequest.newBuilder().setInstanceGroupManager(instanceGroupManager == null ? null : instanceGroupManager.toString()).setInstanceGroupManagersSetTargetPoolsRequestResource(instanceGroupManagersSetTargetPoolsRequestResource).build();
        return this.setTargetPoolsInstanceGroupManager(request);
    }

    @BetaApi
    public final Operation setTargetPoolsInstanceGroupManager(String instanceGroupManager, InstanceGroupManagersSetTargetPoolsRequest instanceGroupManagersSetTargetPoolsRequestResource) {
        SetTargetPoolsInstanceGroupManagerHttpRequest request = SetTargetPoolsInstanceGroupManagerHttpRequest.newBuilder().setInstanceGroupManager(instanceGroupManager).setInstanceGroupManagersSetTargetPoolsRequestResource(instanceGroupManagersSetTargetPoolsRequestResource).build();
        return this.setTargetPoolsInstanceGroupManager(request);
    }

    @BetaApi
    public final Operation setTargetPoolsInstanceGroupManager(SetTargetPoolsInstanceGroupManagerHttpRequest request) {
        return (Operation)this.setTargetPoolsInstanceGroupManagerCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetTargetPoolsInstanceGroupManagerHttpRequest, Operation> setTargetPoolsInstanceGroupManagerCallable() {
        return this.stub.setTargetPoolsInstanceGroupManagerCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListInstanceGroupManagersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstanceGroupManagersHttpRequest, InstanceGroupManagerList, InstanceGroupManager, ListInstanceGroupManagersPage, ListInstanceGroupManagersFixedSizeCollection> {
        private ListInstanceGroupManagersFixedSizeCollection(List<ListInstanceGroupManagersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInstanceGroupManagersFixedSizeCollection createEmptyCollection() {
            return new ListInstanceGroupManagersFixedSizeCollection(null, 0);
        }

        protected ListInstanceGroupManagersFixedSizeCollection createCollection(List<ListInstanceGroupManagersPage> pages, int collectionSize) {
            return new ListInstanceGroupManagersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInstanceGroupManagersPage
    extends AbstractPage<ListInstanceGroupManagersHttpRequest, InstanceGroupManagerList, InstanceGroupManager, ListInstanceGroupManagersPage> {
        private ListInstanceGroupManagersPage(PageContext<ListInstanceGroupManagersHttpRequest, InstanceGroupManagerList, InstanceGroupManager> context, InstanceGroupManagerList response) {
            super(context, (Object)response);
        }

        private static ListInstanceGroupManagersPage createEmptyPage() {
            return new ListInstanceGroupManagersPage(null, null);
        }

        protected ListInstanceGroupManagersPage createPage(PageContext<ListInstanceGroupManagersHttpRequest, InstanceGroupManagerList, InstanceGroupManager> context, InstanceGroupManagerList response) {
            return new ListInstanceGroupManagersPage(context, response);
        }

        public ApiFuture<ListInstanceGroupManagersPage> createPageAsync(PageContext<ListInstanceGroupManagersHttpRequest, InstanceGroupManagerList, InstanceGroupManager> context, ApiFuture<InstanceGroupManagerList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInstanceGroupManagersPagedResponse
    extends AbstractPagedListResponse<ListInstanceGroupManagersHttpRequest, InstanceGroupManagerList, InstanceGroupManager, ListInstanceGroupManagersPage, ListInstanceGroupManagersFixedSizeCollection> {
        public static ApiFuture<ListInstanceGroupManagersPagedResponse> createAsync(PageContext<ListInstanceGroupManagersHttpRequest, InstanceGroupManagerList, InstanceGroupManager> context, ApiFuture<InstanceGroupManagerList> futureResponse) {
            ApiFuture<ListInstanceGroupManagersPage> futurePage = ListInstanceGroupManagersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListInstanceGroupManagersPage, ListInstanceGroupManagersPagedResponse>(){

                public ListInstanceGroupManagersPagedResponse apply(ListInstanceGroupManagersPage input) {
                    return new ListInstanceGroupManagersPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListInstanceGroupManagersPagedResponse(ListInstanceGroupManagersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInstanceGroupManagersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListInstanceGroupManagersFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListInstanceGroupManagersHttpRequest, InstanceGroupManagerAggregatedList, InstanceGroupManagersScopedList, AggregatedListInstanceGroupManagersPage, AggregatedListInstanceGroupManagersFixedSizeCollection> {
        private AggregatedListInstanceGroupManagersFixedSizeCollection(List<AggregatedListInstanceGroupManagersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListInstanceGroupManagersFixedSizeCollection createEmptyCollection() {
            return new AggregatedListInstanceGroupManagersFixedSizeCollection(null, 0);
        }

        protected AggregatedListInstanceGroupManagersFixedSizeCollection createCollection(List<AggregatedListInstanceGroupManagersPage> pages, int collectionSize) {
            return new AggregatedListInstanceGroupManagersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListInstanceGroupManagersPage
    extends AbstractPage<AggregatedListInstanceGroupManagersHttpRequest, InstanceGroupManagerAggregatedList, InstanceGroupManagersScopedList, AggregatedListInstanceGroupManagersPage> {
        private AggregatedListInstanceGroupManagersPage(PageContext<AggregatedListInstanceGroupManagersHttpRequest, InstanceGroupManagerAggregatedList, InstanceGroupManagersScopedList> context, InstanceGroupManagerAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListInstanceGroupManagersPage createEmptyPage() {
            return new AggregatedListInstanceGroupManagersPage(null, null);
        }

        protected AggregatedListInstanceGroupManagersPage createPage(PageContext<AggregatedListInstanceGroupManagersHttpRequest, InstanceGroupManagerAggregatedList, InstanceGroupManagersScopedList> context, InstanceGroupManagerAggregatedList response) {
            return new AggregatedListInstanceGroupManagersPage(context, response);
        }

        public ApiFuture<AggregatedListInstanceGroupManagersPage> createPageAsync(PageContext<AggregatedListInstanceGroupManagersHttpRequest, InstanceGroupManagerAggregatedList, InstanceGroupManagersScopedList> context, ApiFuture<InstanceGroupManagerAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListInstanceGroupManagersPagedResponse
    extends AbstractPagedListResponse<AggregatedListInstanceGroupManagersHttpRequest, InstanceGroupManagerAggregatedList, InstanceGroupManagersScopedList, AggregatedListInstanceGroupManagersPage, AggregatedListInstanceGroupManagersFixedSizeCollection> {
        public static ApiFuture<AggregatedListInstanceGroupManagersPagedResponse> createAsync(PageContext<AggregatedListInstanceGroupManagersHttpRequest, InstanceGroupManagerAggregatedList, InstanceGroupManagersScopedList> context, ApiFuture<InstanceGroupManagerAggregatedList> futureResponse) {
            ApiFuture<AggregatedListInstanceGroupManagersPage> futurePage = AggregatedListInstanceGroupManagersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListInstanceGroupManagersPage, AggregatedListInstanceGroupManagersPagedResponse>(){

                public AggregatedListInstanceGroupManagersPagedResponse apply(AggregatedListInstanceGroupManagersPage input) {
                    return new AggregatedListInstanceGroupManagersPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListInstanceGroupManagersPagedResponse(AggregatedListInstanceGroupManagersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListInstanceGroupManagersFixedSizeCollection.createEmptyCollection());
        }
    }
}

