/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListResourcePoliciesHttpRequest;
import com.google.cloud.compute.v1.DeleteResourcePolicyHttpRequest;
import com.google.cloud.compute.v1.GetIamPolicyResourcePolicyHttpRequest;
import com.google.cloud.compute.v1.GetResourcePolicyHttpRequest;
import com.google.cloud.compute.v1.InsertResourcePolicyHttpRequest;
import com.google.cloud.compute.v1.ListResourcePoliciesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.ResourcePoliciesScopedList;
import com.google.cloud.compute.v1.ResourcePolicy;
import com.google.cloud.compute.v1.ResourcePolicyAggregatedList;
import com.google.cloud.compute.v1.ResourcePolicyClient;
import com.google.cloud.compute.v1.ResourcePolicyList;
import com.google.cloud.compute.v1.SetIamPolicyResourcePolicyHttpRequest;
import com.google.cloud.compute.v1.TestIamPermissionsResourcePolicyHttpRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.HttpJsonResourcePolicyStub;
import com.google.cloud.compute.v1.stub.ResourcePolicyStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class ResourcePolicyStubSettings
extends StubSettings<ResourcePolicyStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final PagedCallSettings<AggregatedListResourcePoliciesHttpRequest, ResourcePolicyAggregatedList, ResourcePolicyClient.AggregatedListResourcePoliciesPagedResponse> aggregatedListResourcePoliciesSettings;
    private final UnaryCallSettings<DeleteResourcePolicyHttpRequest, Operation> deleteResourcePolicySettings;
    private final UnaryCallSettings<GetResourcePolicyHttpRequest, ResourcePolicy> getResourcePolicySettings;
    private final UnaryCallSettings<GetIamPolicyResourcePolicyHttpRequest, Policy> getIamPolicyResourcePolicySettings;
    private final UnaryCallSettings<InsertResourcePolicyHttpRequest, Operation> insertResourcePolicySettings;
    private final PagedCallSettings<ListResourcePoliciesHttpRequest, ResourcePolicyList, ResourcePolicyClient.ListResourcePoliciesPagedResponse> listResourcePoliciesSettings;
    private final UnaryCallSettings<SetIamPolicyResourcePolicyHttpRequest, Policy> setIamPolicyResourcePolicySettings;
    private final UnaryCallSettings<TestIamPermissionsResourcePolicyHttpRequest, TestPermissionsResponse> testIamPermissionsResourcePolicySettings;
    private static final PagedListDescriptor<AggregatedListResourcePoliciesHttpRequest, ResourcePolicyAggregatedList, ResourcePoliciesScopedList> AGGREGATED_LIST_RESOURCE_POLICIES_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListResourcePoliciesHttpRequest, ResourcePolicyAggregatedList, ResourcePoliciesScopedList>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListResourcePoliciesHttpRequest injectToken(AggregatedListResourcePoliciesHttpRequest payload, String token) {
            return AggregatedListResourcePoliciesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public AggregatedListResourcePoliciesHttpRequest injectPageSize(AggregatedListResourcePoliciesHttpRequest payload, int pageSize) {
            return AggregatedListResourcePoliciesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListResourcePoliciesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(ResourcePolicyAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ResourcePoliciesScopedList> extractResources(ResourcePolicyAggregatedList payload) {
            return payload.getItemsMap() != null ? payload.getItemsMap().values() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListResourcePoliciesHttpRequest, ResourcePolicyList, ResourcePolicy> LIST_RESOURCE_POLICIES_PAGE_STR_DESC = new PagedListDescriptor<ListResourcePoliciesHttpRequest, ResourcePolicyList, ResourcePolicy>(){

        public String emptyToken() {
            return "";
        }

        public ListResourcePoliciesHttpRequest injectToken(ListResourcePoliciesHttpRequest payload, String token) {
            return ListResourcePoliciesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListResourcePoliciesHttpRequest injectPageSize(ListResourcePoliciesHttpRequest payload, int pageSize) {
            return ListResourcePoliciesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListResourcePoliciesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(ResourcePolicyList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ResourcePolicy> extractResources(ResourcePolicyList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<AggregatedListResourcePoliciesHttpRequest, ResourcePolicyAggregatedList, ResourcePolicyClient.AggregatedListResourcePoliciesPagedResponse> AGGREGATED_LIST_RESOURCE_POLICIES_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListResourcePoliciesHttpRequest, ResourcePolicyAggregatedList, ResourcePolicyClient.AggregatedListResourcePoliciesPagedResponse>(){

        public ApiFuture<ResourcePolicyClient.AggregatedListResourcePoliciesPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListResourcePoliciesHttpRequest, ResourcePolicyAggregatedList> callable, AggregatedListResourcePoliciesHttpRequest request, ApiCallContext context, ApiFuture<ResourcePolicyAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_RESOURCE_POLICIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ResourcePolicyClient.AggregatedListResourcePoliciesPagedResponse.createAsync((PageContext<AggregatedListResourcePoliciesHttpRequest, ResourcePolicyAggregatedList, ResourcePoliciesScopedList>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListResourcePoliciesHttpRequest, ResourcePolicyList, ResourcePolicyClient.ListResourcePoliciesPagedResponse> LIST_RESOURCE_POLICIES_PAGE_STR_FACT = new PagedListResponseFactory<ListResourcePoliciesHttpRequest, ResourcePolicyList, ResourcePolicyClient.ListResourcePoliciesPagedResponse>(){

        public ApiFuture<ResourcePolicyClient.ListResourcePoliciesPagedResponse> getFuturePagedResponse(UnaryCallable<ListResourcePoliciesHttpRequest, ResourcePolicyList> callable, ListResourcePoliciesHttpRequest request, ApiCallContext context, ApiFuture<ResourcePolicyList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_RESOURCE_POLICIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ResourcePolicyClient.ListResourcePoliciesPagedResponse.createAsync((PageContext<ListResourcePoliciesHttpRequest, ResourcePolicyList, ResourcePolicy>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListResourcePoliciesHttpRequest, ResourcePolicyAggregatedList, ResourcePolicyClient.AggregatedListResourcePoliciesPagedResponse> aggregatedListResourcePoliciesSettings() {
        return this.aggregatedListResourcePoliciesSettings;
    }

    public UnaryCallSettings<DeleteResourcePolicyHttpRequest, Operation> deleteResourcePolicySettings() {
        return this.deleteResourcePolicySettings;
    }

    public UnaryCallSettings<GetResourcePolicyHttpRequest, ResourcePolicy> getResourcePolicySettings() {
        return this.getResourcePolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyResourcePolicyHttpRequest, Policy> getIamPolicyResourcePolicySettings() {
        return this.getIamPolicyResourcePolicySettings;
    }

    public UnaryCallSettings<InsertResourcePolicyHttpRequest, Operation> insertResourcePolicySettings() {
        return this.insertResourcePolicySettings;
    }

    public PagedCallSettings<ListResourcePoliciesHttpRequest, ResourcePolicyList, ResourcePolicyClient.ListResourcePoliciesPagedResponse> listResourcePoliciesSettings() {
        return this.listResourcePoliciesSettings;
    }

    public UnaryCallSettings<SetIamPolicyResourcePolicyHttpRequest, Policy> setIamPolicyResourcePolicySettings() {
        return this.setIamPolicyResourcePolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsResourcePolicyHttpRequest, TestPermissionsResponse> testIamPermissionsResourcePolicySettings() {
        return this.testIamPermissionsResourcePolicySettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ResourcePolicyStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonResourcePolicyStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ResourcePolicyStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ResourcePolicyStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ResourcePolicyStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListResourcePoliciesSettings = settingsBuilder.aggregatedListResourcePoliciesSettings().build();
        this.deleteResourcePolicySettings = settingsBuilder.deleteResourcePolicySettings().build();
        this.getResourcePolicySettings = settingsBuilder.getResourcePolicySettings().build();
        this.getIamPolicyResourcePolicySettings = settingsBuilder.getIamPolicyResourcePolicySettings().build();
        this.insertResourcePolicySettings = settingsBuilder.insertResourcePolicySettings().build();
        this.listResourcePoliciesSettings = settingsBuilder.listResourcePoliciesSettings().build();
        this.setIamPolicyResourcePolicySettings = settingsBuilder.setIamPolicyResourcePolicySettings().build();
        this.testIamPermissionsResourcePolicySettings = settingsBuilder.testIamPermissionsResourcePolicySettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ResourcePolicyStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListResourcePoliciesHttpRequest, ResourcePolicyAggregatedList, ResourcePolicyClient.AggregatedListResourcePoliciesPagedResponse> aggregatedListResourcePoliciesSettings;
        private final UnaryCallSettings.Builder<DeleteResourcePolicyHttpRequest, Operation> deleteResourcePolicySettings;
        private final UnaryCallSettings.Builder<GetResourcePolicyHttpRequest, ResourcePolicy> getResourcePolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyResourcePolicyHttpRequest, Policy> getIamPolicyResourcePolicySettings;
        private final UnaryCallSettings.Builder<InsertResourcePolicyHttpRequest, Operation> insertResourcePolicySettings;
        private final PagedCallSettings.Builder<ListResourcePoliciesHttpRequest, ResourcePolicyList, ResourcePolicyClient.ListResourcePoliciesPagedResponse> listResourcePoliciesSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyResourcePolicyHttpRequest, Policy> setIamPolicyResourcePolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsResourcePolicyHttpRequest, TestPermissionsResponse> testIamPermissionsResourcePolicySettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListResourcePoliciesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_RESOURCE_POLICIES_PAGE_STR_FACT);
            this.deleteResourcePolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getResourcePolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicyResourcePolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertResourcePolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listResourcePoliciesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_RESOURCE_POLICIES_PAGE_STR_FACT);
            this.setIamPolicyResourcePolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsResourcePolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListResourcePoliciesSettings, this.deleteResourcePolicySettings, this.getResourcePolicySettings, this.getIamPolicyResourcePolicySettings, this.insertResourcePolicySettings, this.listResourcePoliciesSettings, this.setIamPolicyResourcePolicySettings, this.testIamPermissionsResourcePolicySettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ResourcePolicyStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ResourcePolicyStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ResourcePolicyStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ResourcePolicyStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListResourcePoliciesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteResourcePolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getResourcePolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getIamPolicyResourcePolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertResourcePolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listResourcePoliciesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setIamPolicyResourcePolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.testIamPermissionsResourcePolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(ResourcePolicyStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListResourcePoliciesSettings = settings.aggregatedListResourcePoliciesSettings.toBuilder();
            this.deleteResourcePolicySettings = settings.deleteResourcePolicySettings.toBuilder();
            this.getResourcePolicySettings = settings.getResourcePolicySettings.toBuilder();
            this.getIamPolicyResourcePolicySettings = settings.getIamPolicyResourcePolicySettings.toBuilder();
            this.insertResourcePolicySettings = settings.insertResourcePolicySettings.toBuilder();
            this.listResourcePoliciesSettings = settings.listResourcePoliciesSettings.toBuilder();
            this.setIamPolicyResourcePolicySettings = settings.setIamPolicyResourcePolicySettings.toBuilder();
            this.testIamPermissionsResourcePolicySettings = settings.testIamPermissionsResourcePolicySettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListResourcePoliciesSettings, this.deleteResourcePolicySettings, this.getResourcePolicySettings, this.getIamPolicyResourcePolicySettings, this.insertResourcePolicySettings, this.listResourcePoliciesSettings, this.setIamPolicyResourcePolicySettings, this.testIamPermissionsResourcePolicySettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListResourcePoliciesHttpRequest, ResourcePolicyAggregatedList, ResourcePolicyClient.AggregatedListResourcePoliciesPagedResponse> aggregatedListResourcePoliciesSettings() {
            return this.aggregatedListResourcePoliciesSettings;
        }

        public UnaryCallSettings.Builder<DeleteResourcePolicyHttpRequest, Operation> deleteResourcePolicySettings() {
            return this.deleteResourcePolicySettings;
        }

        public UnaryCallSettings.Builder<GetResourcePolicyHttpRequest, ResourcePolicy> getResourcePolicySettings() {
            return this.getResourcePolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyResourcePolicyHttpRequest, Policy> getIamPolicyResourcePolicySettings() {
            return this.getIamPolicyResourcePolicySettings;
        }

        public UnaryCallSettings.Builder<InsertResourcePolicyHttpRequest, Operation> insertResourcePolicySettings() {
            return this.insertResourcePolicySettings;
        }

        public PagedCallSettings.Builder<ListResourcePoliciesHttpRequest, ResourcePolicyList, ResourcePolicyClient.ListResourcePoliciesPagedResponse> listResourcePoliciesSettings() {
            return this.listResourcePoliciesSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyResourcePolicyHttpRequest, Policy> setIamPolicyResourcePolicySettings() {
            return this.setIamPolicyResourcePolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsResourcePolicyHttpRequest, TestPermissionsResponse> testIamPermissionsResourcePolicySettings() {
            return this.testIamPermissionsResourcePolicySettings;
        }

        public ResourcePolicyStubSettings build() throws IOException {
            return new ResourcePolicyStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

