/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListReservationsHttpRequest;
import com.google.cloud.compute.v1.DeleteReservationHttpRequest;
import com.google.cloud.compute.v1.GetIamPolicyReservationHttpRequest;
import com.google.cloud.compute.v1.GetReservationHttpRequest;
import com.google.cloud.compute.v1.InsertReservationHttpRequest;
import com.google.cloud.compute.v1.ListReservationsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.Reservation;
import com.google.cloud.compute.v1.ReservationAggregatedList;
import com.google.cloud.compute.v1.ReservationClient;
import com.google.cloud.compute.v1.ReservationList;
import com.google.cloud.compute.v1.ReservationsScopedList;
import com.google.cloud.compute.v1.ResizeReservationHttpRequest;
import com.google.cloud.compute.v1.SetIamPolicyReservationHttpRequest;
import com.google.cloud.compute.v1.TestIamPermissionsReservationHttpRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.HttpJsonReservationStub;
import com.google.cloud.compute.v1.stub.ReservationStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class ReservationStubSettings
extends StubSettings<ReservationStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final PagedCallSettings<AggregatedListReservationsHttpRequest, ReservationAggregatedList, ReservationClient.AggregatedListReservationsPagedResponse> aggregatedListReservationsSettings;
    private final UnaryCallSettings<DeleteReservationHttpRequest, Operation> deleteReservationSettings;
    private final UnaryCallSettings<GetReservationHttpRequest, Reservation> getReservationSettings;
    private final UnaryCallSettings<GetIamPolicyReservationHttpRequest, Policy> getIamPolicyReservationSettings;
    private final UnaryCallSettings<InsertReservationHttpRequest, Operation> insertReservationSettings;
    private final PagedCallSettings<ListReservationsHttpRequest, ReservationList, ReservationClient.ListReservationsPagedResponse> listReservationsSettings;
    private final UnaryCallSettings<ResizeReservationHttpRequest, Operation> resizeReservationSettings;
    private final UnaryCallSettings<SetIamPolicyReservationHttpRequest, Policy> setIamPolicyReservationSettings;
    private final UnaryCallSettings<TestIamPermissionsReservationHttpRequest, TestPermissionsResponse> testIamPermissionsReservationSettings;
    private static final PagedListDescriptor<AggregatedListReservationsHttpRequest, ReservationAggregatedList, ReservationsScopedList> AGGREGATED_LIST_RESERVATIONS_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListReservationsHttpRequest, ReservationAggregatedList, ReservationsScopedList>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListReservationsHttpRequest injectToken(AggregatedListReservationsHttpRequest payload, String token) {
            return AggregatedListReservationsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public AggregatedListReservationsHttpRequest injectPageSize(AggregatedListReservationsHttpRequest payload, int pageSize) {
            return AggregatedListReservationsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListReservationsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(ReservationAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ReservationsScopedList> extractResources(ReservationAggregatedList payload) {
            return payload.getItemsMap() != null ? payload.getItemsMap().values() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListReservationsHttpRequest, ReservationList, Reservation> LIST_RESERVATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListReservationsHttpRequest, ReservationList, Reservation>(){

        public String emptyToken() {
            return "";
        }

        public ListReservationsHttpRequest injectToken(ListReservationsHttpRequest payload, String token) {
            return ListReservationsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListReservationsHttpRequest injectPageSize(ListReservationsHttpRequest payload, int pageSize) {
            return ListReservationsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListReservationsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(ReservationList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Reservation> extractResources(ReservationList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<AggregatedListReservationsHttpRequest, ReservationAggregatedList, ReservationClient.AggregatedListReservationsPagedResponse> AGGREGATED_LIST_RESERVATIONS_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListReservationsHttpRequest, ReservationAggregatedList, ReservationClient.AggregatedListReservationsPagedResponse>(){

        public ApiFuture<ReservationClient.AggregatedListReservationsPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListReservationsHttpRequest, ReservationAggregatedList> callable, AggregatedListReservationsHttpRequest request, ApiCallContext context, ApiFuture<ReservationAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_RESERVATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ReservationClient.AggregatedListReservationsPagedResponse.createAsync((PageContext<AggregatedListReservationsHttpRequest, ReservationAggregatedList, ReservationsScopedList>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListReservationsHttpRequest, ReservationList, ReservationClient.ListReservationsPagedResponse> LIST_RESERVATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListReservationsHttpRequest, ReservationList, ReservationClient.ListReservationsPagedResponse>(){

        public ApiFuture<ReservationClient.ListReservationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListReservationsHttpRequest, ReservationList> callable, ListReservationsHttpRequest request, ApiCallContext context, ApiFuture<ReservationList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_RESERVATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ReservationClient.ListReservationsPagedResponse.createAsync((PageContext<ListReservationsHttpRequest, ReservationList, Reservation>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListReservationsHttpRequest, ReservationAggregatedList, ReservationClient.AggregatedListReservationsPagedResponse> aggregatedListReservationsSettings() {
        return this.aggregatedListReservationsSettings;
    }

    public UnaryCallSettings<DeleteReservationHttpRequest, Operation> deleteReservationSettings() {
        return this.deleteReservationSettings;
    }

    public UnaryCallSettings<GetReservationHttpRequest, Reservation> getReservationSettings() {
        return this.getReservationSettings;
    }

    public UnaryCallSettings<GetIamPolicyReservationHttpRequest, Policy> getIamPolicyReservationSettings() {
        return this.getIamPolicyReservationSettings;
    }

    public UnaryCallSettings<InsertReservationHttpRequest, Operation> insertReservationSettings() {
        return this.insertReservationSettings;
    }

    public PagedCallSettings<ListReservationsHttpRequest, ReservationList, ReservationClient.ListReservationsPagedResponse> listReservationsSettings() {
        return this.listReservationsSettings;
    }

    public UnaryCallSettings<ResizeReservationHttpRequest, Operation> resizeReservationSettings() {
        return this.resizeReservationSettings;
    }

    public UnaryCallSettings<SetIamPolicyReservationHttpRequest, Policy> setIamPolicyReservationSettings() {
        return this.setIamPolicyReservationSettings;
    }

    public UnaryCallSettings<TestIamPermissionsReservationHttpRequest, TestPermissionsResponse> testIamPermissionsReservationSettings() {
        return this.testIamPermissionsReservationSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ReservationStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonReservationStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ReservationStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ReservationStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ReservationStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListReservationsSettings = settingsBuilder.aggregatedListReservationsSettings().build();
        this.deleteReservationSettings = settingsBuilder.deleteReservationSettings().build();
        this.getReservationSettings = settingsBuilder.getReservationSettings().build();
        this.getIamPolicyReservationSettings = settingsBuilder.getIamPolicyReservationSettings().build();
        this.insertReservationSettings = settingsBuilder.insertReservationSettings().build();
        this.listReservationsSettings = settingsBuilder.listReservationsSettings().build();
        this.resizeReservationSettings = settingsBuilder.resizeReservationSettings().build();
        this.setIamPolicyReservationSettings = settingsBuilder.setIamPolicyReservationSettings().build();
        this.testIamPermissionsReservationSettings = settingsBuilder.testIamPermissionsReservationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ReservationStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListReservationsHttpRequest, ReservationAggregatedList, ReservationClient.AggregatedListReservationsPagedResponse> aggregatedListReservationsSettings;
        private final UnaryCallSettings.Builder<DeleteReservationHttpRequest, Operation> deleteReservationSettings;
        private final UnaryCallSettings.Builder<GetReservationHttpRequest, Reservation> getReservationSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyReservationHttpRequest, Policy> getIamPolicyReservationSettings;
        private final UnaryCallSettings.Builder<InsertReservationHttpRequest, Operation> insertReservationSettings;
        private final PagedCallSettings.Builder<ListReservationsHttpRequest, ReservationList, ReservationClient.ListReservationsPagedResponse> listReservationsSettings;
        private final UnaryCallSettings.Builder<ResizeReservationHttpRequest, Operation> resizeReservationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyReservationHttpRequest, Policy> setIamPolicyReservationSettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsReservationHttpRequest, TestPermissionsResponse> testIamPermissionsReservationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListReservationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_RESERVATIONS_PAGE_STR_FACT);
            this.deleteReservationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getReservationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicyReservationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertReservationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listReservationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_RESERVATIONS_PAGE_STR_FACT);
            this.resizeReservationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicyReservationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsReservationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListReservationsSettings, this.deleteReservationSettings, this.getReservationSettings, this.getIamPolicyReservationSettings, this.insertReservationSettings, this.listReservationsSettings, this.resizeReservationSettings, this.setIamPolicyReservationSettings, this.testIamPermissionsReservationSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ReservationStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ReservationStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ReservationStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ReservationStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListReservationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteReservationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getReservationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getIamPolicyReservationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertReservationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listReservationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.resizeReservationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setIamPolicyReservationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.testIamPermissionsReservationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(ReservationStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListReservationsSettings = settings.aggregatedListReservationsSettings.toBuilder();
            this.deleteReservationSettings = settings.deleteReservationSettings.toBuilder();
            this.getReservationSettings = settings.getReservationSettings.toBuilder();
            this.getIamPolicyReservationSettings = settings.getIamPolicyReservationSettings.toBuilder();
            this.insertReservationSettings = settings.insertReservationSettings.toBuilder();
            this.listReservationsSettings = settings.listReservationsSettings.toBuilder();
            this.resizeReservationSettings = settings.resizeReservationSettings.toBuilder();
            this.setIamPolicyReservationSettings = settings.setIamPolicyReservationSettings.toBuilder();
            this.testIamPermissionsReservationSettings = settings.testIamPermissionsReservationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListReservationsSettings, this.deleteReservationSettings, this.getReservationSettings, this.getIamPolicyReservationSettings, this.insertReservationSettings, this.listReservationsSettings, this.resizeReservationSettings, this.setIamPolicyReservationSettings, this.testIamPermissionsReservationSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListReservationsHttpRequest, ReservationAggregatedList, ReservationClient.AggregatedListReservationsPagedResponse> aggregatedListReservationsSettings() {
            return this.aggregatedListReservationsSettings;
        }

        public UnaryCallSettings.Builder<DeleteReservationHttpRequest, Operation> deleteReservationSettings() {
            return this.deleteReservationSettings;
        }

        public UnaryCallSettings.Builder<GetReservationHttpRequest, Reservation> getReservationSettings() {
            return this.getReservationSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyReservationHttpRequest, Policy> getIamPolicyReservationSettings() {
            return this.getIamPolicyReservationSettings;
        }

        public UnaryCallSettings.Builder<InsertReservationHttpRequest, Operation> insertReservationSettings() {
            return this.insertReservationSettings;
        }

        public PagedCallSettings.Builder<ListReservationsHttpRequest, ReservationList, ReservationClient.ListReservationsPagedResponse> listReservationsSettings() {
            return this.listReservationsSettings;
        }

        public UnaryCallSettings.Builder<ResizeReservationHttpRequest, Operation> resizeReservationSettings() {
            return this.resizeReservationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyReservationHttpRequest, Policy> setIamPolicyReservationSettings() {
            return this.setIamPolicyReservationSettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsReservationHttpRequest, TestPermissionsResponse> testIamPermissionsReservationSettings() {
            return this.testIamPermissionsReservationSettings;
        }

        public ReservationStubSettings build() throws IOException {
            return new ReservationStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

