/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class ResourcePolicySnapshotSchedulePolicyRetentionPolicy
implements ApiMessage {
    private final Integer maxRetentionDays;
    private final String onSourceDiskDelete;
    private static final ResourcePolicySnapshotSchedulePolicyRetentionPolicy DEFAULT_INSTANCE = new ResourcePolicySnapshotSchedulePolicyRetentionPolicy();

    private ResourcePolicySnapshotSchedulePolicyRetentionPolicy() {
        this.maxRetentionDays = null;
        this.onSourceDiskDelete = null;
    }

    private ResourcePolicySnapshotSchedulePolicyRetentionPolicy(Integer maxRetentionDays, String onSourceDiskDelete) {
        this.maxRetentionDays = maxRetentionDays;
        this.onSourceDiskDelete = onSourceDiskDelete;
    }

    public Object getFieldValue(String fieldName) {
        if ("maxRetentionDays".equals(fieldName)) {
            return this.maxRetentionDays;
        }
        if ("onSourceDiskDelete".equals(fieldName)) {
            return this.onSourceDiskDelete;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Integer getMaxRetentionDays() {
        return this.maxRetentionDays;
    }

    public String getOnSourceDiskDelete() {
        return this.onSourceDiskDelete;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ResourcePolicySnapshotSchedulePolicyRetentionPolicy prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static ResourcePolicySnapshotSchedulePolicyRetentionPolicy getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "ResourcePolicySnapshotSchedulePolicyRetentionPolicy{maxRetentionDays=" + this.maxRetentionDays + ", onSourceDiskDelete=" + this.onSourceDiskDelete + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ResourcePolicySnapshotSchedulePolicyRetentionPolicy) {
            ResourcePolicySnapshotSchedulePolicyRetentionPolicy that = (ResourcePolicySnapshotSchedulePolicyRetentionPolicy)o;
            return Objects.equals(this.maxRetentionDays, that.getMaxRetentionDays()) && Objects.equals(this.onSourceDiskDelete, that.getOnSourceDiskDelete());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.maxRetentionDays, this.onSourceDiskDelete);
    }

    public static class Builder {
        private Integer maxRetentionDays;
        private String onSourceDiskDelete;

        Builder() {
        }

        public Builder mergeFrom(ResourcePolicySnapshotSchedulePolicyRetentionPolicy other) {
            if (other == ResourcePolicySnapshotSchedulePolicyRetentionPolicy.getDefaultInstance()) {
                return this;
            }
            if (other.getMaxRetentionDays() != null) {
                this.maxRetentionDays = other.maxRetentionDays;
            }
            if (other.getOnSourceDiskDelete() != null) {
                this.onSourceDiskDelete = other.onSourceDiskDelete;
            }
            return this;
        }

        Builder(ResourcePolicySnapshotSchedulePolicyRetentionPolicy source) {
            this.maxRetentionDays = source.maxRetentionDays;
            this.onSourceDiskDelete = source.onSourceDiskDelete;
        }

        public Integer getMaxRetentionDays() {
            return this.maxRetentionDays;
        }

        public Builder setMaxRetentionDays(Integer maxRetentionDays) {
            this.maxRetentionDays = maxRetentionDays;
            return this;
        }

        public String getOnSourceDiskDelete() {
            return this.onSourceDiskDelete;
        }

        public Builder setOnSourceDiskDelete(String onSourceDiskDelete) {
            this.onSourceDiskDelete = onSourceDiskDelete;
            return this;
        }

        public ResourcePolicySnapshotSchedulePolicyRetentionPolicy build() {
            return new ResourcePolicySnapshotSchedulePolicyRetentionPolicy(this.maxRetentionDays, this.onSourceDiskDelete);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setMaxRetentionDays(this.maxRetentionDays);
            newBuilder.setOnSourceDiskDelete(this.onSourceDiskDelete);
            return newBuilder;
        }
    }
}

