/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.Address;
import com.google.cloud.compute.v1.AddressAggregatedList;
import com.google.cloud.compute.v1.AddressClient;
import com.google.cloud.compute.v1.AddressList;
import com.google.cloud.compute.v1.AddressesScopedList;
import com.google.cloud.compute.v1.AggregatedListAddressesHttpRequest;
import com.google.cloud.compute.v1.DeleteAddressHttpRequest;
import com.google.cloud.compute.v1.GetAddressHttpRequest;
import com.google.cloud.compute.v1.InsertAddressHttpRequest;
import com.google.cloud.compute.v1.ListAddressesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.stub.AddressStub;
import com.google.cloud.compute.v1.stub.HttpJsonAddressStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class AddressStubSettings
extends StubSettings<AddressStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final PagedCallSettings<AggregatedListAddressesHttpRequest, AddressAggregatedList, AddressClient.AggregatedListAddressesPagedResponse> aggregatedListAddressesSettings;
    private final UnaryCallSettings<DeleteAddressHttpRequest, Operation> deleteAddressSettings;
    private final UnaryCallSettings<GetAddressHttpRequest, Address> getAddressSettings;
    private final UnaryCallSettings<InsertAddressHttpRequest, Operation> insertAddressSettings;
    private final PagedCallSettings<ListAddressesHttpRequest, AddressList, AddressClient.ListAddressesPagedResponse> listAddressesSettings;
    private static final PagedListDescriptor<AggregatedListAddressesHttpRequest, AddressAggregatedList, AddressesScopedList> AGGREGATED_LIST_ADDRESSES_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListAddressesHttpRequest, AddressAggregatedList, AddressesScopedList>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListAddressesHttpRequest injectToken(AggregatedListAddressesHttpRequest payload, String token) {
            return AggregatedListAddressesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public AggregatedListAddressesHttpRequest injectPageSize(AggregatedListAddressesHttpRequest payload, int pageSize) {
            return AggregatedListAddressesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListAddressesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(AddressAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AddressesScopedList> extractResources(AddressAggregatedList payload) {
            return payload.getItemsMap() != null ? payload.getItemsMap().values() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListAddressesHttpRequest, AddressList, Address> LIST_ADDRESSES_PAGE_STR_DESC = new PagedListDescriptor<ListAddressesHttpRequest, AddressList, Address>(){

        public String emptyToken() {
            return "";
        }

        public ListAddressesHttpRequest injectToken(ListAddressesHttpRequest payload, String token) {
            return ListAddressesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListAddressesHttpRequest injectPageSize(ListAddressesHttpRequest payload, int pageSize) {
            return ListAddressesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListAddressesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(AddressList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Address> extractResources(AddressList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<AggregatedListAddressesHttpRequest, AddressAggregatedList, AddressClient.AggregatedListAddressesPagedResponse> AGGREGATED_LIST_ADDRESSES_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListAddressesHttpRequest, AddressAggregatedList, AddressClient.AggregatedListAddressesPagedResponse>(){

        public ApiFuture<AddressClient.AggregatedListAddressesPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListAddressesHttpRequest, AddressAggregatedList> callable, AggregatedListAddressesHttpRequest request, ApiCallContext context, ApiFuture<AddressAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_ADDRESSES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AddressClient.AggregatedListAddressesPagedResponse.createAsync((PageContext<AggregatedListAddressesHttpRequest, AddressAggregatedList, AddressesScopedList>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAddressesHttpRequest, AddressList, AddressClient.ListAddressesPagedResponse> LIST_ADDRESSES_PAGE_STR_FACT = new PagedListResponseFactory<ListAddressesHttpRequest, AddressList, AddressClient.ListAddressesPagedResponse>(){

        public ApiFuture<AddressClient.ListAddressesPagedResponse> getFuturePagedResponse(UnaryCallable<ListAddressesHttpRequest, AddressList> callable, ListAddressesHttpRequest request, ApiCallContext context, ApiFuture<AddressList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ADDRESSES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AddressClient.ListAddressesPagedResponse.createAsync((PageContext<ListAddressesHttpRequest, AddressList, Address>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListAddressesHttpRequest, AddressAggregatedList, AddressClient.AggregatedListAddressesPagedResponse> aggregatedListAddressesSettings() {
        return this.aggregatedListAddressesSettings;
    }

    public UnaryCallSettings<DeleteAddressHttpRequest, Operation> deleteAddressSettings() {
        return this.deleteAddressSettings;
    }

    public UnaryCallSettings<GetAddressHttpRequest, Address> getAddressSettings() {
        return this.getAddressSettings;
    }

    public UnaryCallSettings<InsertAddressHttpRequest, Operation> insertAddressSettings() {
        return this.insertAddressSettings;
    }

    public PagedCallSettings<ListAddressesHttpRequest, AddressList, AddressClient.ListAddressesPagedResponse> listAddressesSettings() {
        return this.listAddressesSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AddressStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonAddressStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AddressStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AddressStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AddressStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListAddressesSettings = settingsBuilder.aggregatedListAddressesSettings().build();
        this.deleteAddressSettings = settingsBuilder.deleteAddressSettings().build();
        this.getAddressSettings = settingsBuilder.getAddressSettings().build();
        this.insertAddressSettings = settingsBuilder.insertAddressSettings().build();
        this.listAddressesSettings = settingsBuilder.listAddressesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AddressStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListAddressesHttpRequest, AddressAggregatedList, AddressClient.AggregatedListAddressesPagedResponse> aggregatedListAddressesSettings;
        private final UnaryCallSettings.Builder<DeleteAddressHttpRequest, Operation> deleteAddressSettings;
        private final UnaryCallSettings.Builder<GetAddressHttpRequest, Address> getAddressSettings;
        private final UnaryCallSettings.Builder<InsertAddressHttpRequest, Operation> insertAddressSettings;
        private final PagedCallSettings.Builder<ListAddressesHttpRequest, AddressList, AddressClient.ListAddressesPagedResponse> listAddressesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListAddressesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_ADDRESSES_PAGE_STR_FACT);
            this.deleteAddressSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getAddressSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertAddressSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listAddressesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ADDRESSES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListAddressesSettings, this.deleteAddressSettings, this.getAddressSettings, this.insertAddressSettings, this.listAddressesSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AddressStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AddressStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AddressStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(AddressStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListAddressesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteAddressSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getAddressSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertAddressSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listAddressesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(AddressStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListAddressesSettings = settings.aggregatedListAddressesSettings.toBuilder();
            this.deleteAddressSettings = settings.deleteAddressSettings.toBuilder();
            this.getAddressSettings = settings.getAddressSettings.toBuilder();
            this.insertAddressSettings = settings.insertAddressSettings.toBuilder();
            this.listAddressesSettings = settings.listAddressesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListAddressesSettings, this.deleteAddressSettings, this.getAddressSettings, this.insertAddressSettings, this.listAddressesSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListAddressesHttpRequest, AddressAggregatedList, AddressClient.AggregatedListAddressesPagedResponse> aggregatedListAddressesSettings() {
            return this.aggregatedListAddressesSettings;
        }

        public UnaryCallSettings.Builder<DeleteAddressHttpRequest, Operation> deleteAddressSettings() {
            return this.deleteAddressSettings;
        }

        public UnaryCallSettings.Builder<GetAddressHttpRequest, Address> getAddressSettings() {
            return this.getAddressSettings;
        }

        public UnaryCallSettings.Builder<InsertAddressHttpRequest, Operation> insertAddressSettings() {
            return this.insertAddressSettings;
        }

        public PagedCallSettings.Builder<ListAddressesHttpRequest, AddressList, AddressClient.ListAddressesPagedResponse> listAddressesSettings() {
            return this.listAddressesSettings;
        }

        public AddressStubSettings build() throws IOException {
            return new AddressStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

