/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.cloudsecuritycompliance.v1.stub;

import com.google.api.HttpRule;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.cloudsecuritycompliance.v1.CloudControlDeployment;
import com.google.cloud.cloudsecuritycompliance.v1.CreateFrameworkDeploymentRequest;
import com.google.cloud.cloudsecuritycompliance.v1.DeleteFrameworkDeploymentRequest;
import com.google.cloud.cloudsecuritycompliance.v1.DeploymentClient;
import com.google.cloud.cloudsecuritycompliance.v1.FrameworkDeployment;
import com.google.cloud.cloudsecuritycompliance.v1.GetCloudControlDeploymentRequest;
import com.google.cloud.cloudsecuritycompliance.v1.GetFrameworkDeploymentRequest;
import com.google.cloud.cloudsecuritycompliance.v1.ListCloudControlDeploymentsRequest;
import com.google.cloud.cloudsecuritycompliance.v1.ListCloudControlDeploymentsResponse;
import com.google.cloud.cloudsecuritycompliance.v1.ListFrameworkDeploymentsRequest;
import com.google.cloud.cloudsecuritycompliance.v1.ListFrameworkDeploymentsResponse;
import com.google.cloud.cloudsecuritycompliance.v1.OperationMetadata;
import com.google.cloud.cloudsecuritycompliance.v1.stub.DeploymentStub;
import com.google.cloud.cloudsecuritycompliance.v1.stub.DeploymentStubSettings;
import com.google.cloud.cloudsecuritycompliance.v1.stub.HttpJsonDeploymentCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpJsonDeploymentStub
extends DeploymentStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Empty.getDescriptor()).add(OperationMetadata.getDescriptor()).add(FrameworkDeployment.getDescriptor()).build();
    private static final ApiMethodDescriptor<CreateFrameworkDeploymentRequest, Operation> createFrameworkDeploymentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.cloudsecuritycompliance.v1.Deployment/CreateFrameworkDeployment").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=organizations/*/locations/*}/frameworkDeployments", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "frameworkDeploymentId", (Object)request.getFrameworkDeploymentId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("frameworkDeployment", (Message)request.getFrameworkDeployment(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteFrameworkDeploymentRequest, Operation> deleteFrameworkDeploymentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.cloudsecuritycompliance.v1.Deployment/DeleteFrameworkDeployment").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=organizations/*/locations/*/frameworkDeployments/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "etag", (Object)request.getEtag());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetFrameworkDeploymentRequest, FrameworkDeployment> getFrameworkDeploymentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.cloudsecuritycompliance.v1.Deployment/GetFrameworkDeployment").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=organizations/*/locations/*/frameworkDeployments/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)FrameworkDeployment.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListFrameworkDeploymentsRequest, ListFrameworkDeploymentsResponse> listFrameworkDeploymentsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.cloudsecuritycompliance.v1.Deployment/ListFrameworkDeployments").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=organizations/*/locations/*}/frameworkDeployments", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListFrameworkDeploymentsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetCloudControlDeploymentRequest, CloudControlDeployment> getCloudControlDeploymentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.cloudsecuritycompliance.v1.Deployment/GetCloudControlDeployment").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=organizations/*/locations/*/cloudControlDeployments/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CloudControlDeployment.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListCloudControlDeploymentsRequest, ListCloudControlDeploymentsResponse> listCloudControlDeploymentsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.cloudsecuritycompliance.v1.Deployment/ListCloudControlDeployments").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=organizations/*/locations/*}/cloudControlDeployments", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListCloudControlDeploymentsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/ListLocations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=organizations/*}/locations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListLocationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/GetLocation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=organizations/*/locations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Location.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateFrameworkDeploymentRequest, Operation> createFrameworkDeploymentCallable;
    private final OperationCallable<CreateFrameworkDeploymentRequest, FrameworkDeployment, OperationMetadata> createFrameworkDeploymentOperationCallable;
    private final UnaryCallable<DeleteFrameworkDeploymentRequest, Operation> deleteFrameworkDeploymentCallable;
    private final OperationCallable<DeleteFrameworkDeploymentRequest, Empty, OperationMetadata> deleteFrameworkDeploymentOperationCallable;
    private final UnaryCallable<GetFrameworkDeploymentRequest, FrameworkDeployment> getFrameworkDeploymentCallable;
    private final UnaryCallable<ListFrameworkDeploymentsRequest, ListFrameworkDeploymentsResponse> listFrameworkDeploymentsCallable;
    private final UnaryCallable<ListFrameworkDeploymentsRequest, DeploymentClient.ListFrameworkDeploymentsPagedResponse> listFrameworkDeploymentsPagedCallable;
    private final UnaryCallable<GetCloudControlDeploymentRequest, CloudControlDeployment> getCloudControlDeploymentCallable;
    private final UnaryCallable<ListCloudControlDeploymentsRequest, ListCloudControlDeploymentsResponse> listCloudControlDeploymentsCallable;
    private final UnaryCallable<ListCloudControlDeploymentsRequest, DeploymentClient.ListCloudControlDeploymentsPagedResponse> listCloudControlDeploymentsPagedCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, DeploymentClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonDeploymentStub create(DeploymentStubSettings settings) throws IOException {
        return new HttpJsonDeploymentStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonDeploymentStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonDeploymentStub(DeploymentStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonDeploymentStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonDeploymentStub(DeploymentStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonDeploymentStub(DeploymentStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonDeploymentCallableFactory());
    }

    protected HttpJsonDeploymentStub(DeploymentStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.CancelOperation", (Object)HttpRule.newBuilder().setPost("/v1/{name=organizations/*/locations/*/operations/*}:cancel").build()).put((Object)"google.longrunning.Operations.DeleteOperation", (Object)HttpRule.newBuilder().setDelete("/v1/{name=organizations/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1/{name=organizations/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v1/{name=organizations/*/locations/*}/operations").build()).build());
        HttpJsonCallSettings createFrameworkDeploymentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createFrameworkDeploymentMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteFrameworkDeploymentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteFrameworkDeploymentMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getFrameworkDeploymentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getFrameworkDeploymentMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listFrameworkDeploymentsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listFrameworkDeploymentsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getCloudControlDeploymentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getCloudControlDeploymentMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listCloudControlDeploymentsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listCloudControlDeploymentsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listLocationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getLocationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.createFrameworkDeploymentCallable = callableFactory.createUnaryCallable(createFrameworkDeploymentTransportSettings, settings.createFrameworkDeploymentSettings(), clientContext);
        this.createFrameworkDeploymentOperationCallable = callableFactory.createOperationCallable(createFrameworkDeploymentTransportSettings, settings.createFrameworkDeploymentOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteFrameworkDeploymentCallable = callableFactory.createUnaryCallable(deleteFrameworkDeploymentTransportSettings, settings.deleteFrameworkDeploymentSettings(), clientContext);
        this.deleteFrameworkDeploymentOperationCallable = callableFactory.createOperationCallable(deleteFrameworkDeploymentTransportSettings, settings.deleteFrameworkDeploymentOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getFrameworkDeploymentCallable = callableFactory.createUnaryCallable(getFrameworkDeploymentTransportSettings, settings.getFrameworkDeploymentSettings(), clientContext);
        this.listFrameworkDeploymentsCallable = callableFactory.createUnaryCallable(listFrameworkDeploymentsTransportSettings, settings.listFrameworkDeploymentsSettings(), clientContext);
        this.listFrameworkDeploymentsPagedCallable = callableFactory.createPagedCallable(listFrameworkDeploymentsTransportSettings, settings.listFrameworkDeploymentsSettings(), clientContext);
        this.getCloudControlDeploymentCallable = callableFactory.createUnaryCallable(getCloudControlDeploymentTransportSettings, settings.getCloudControlDeploymentSettings(), clientContext);
        this.listCloudControlDeploymentsCallable = callableFactory.createUnaryCallable(listCloudControlDeploymentsTransportSettings, settings.listCloudControlDeploymentsSettings(), clientContext);
        this.listCloudControlDeploymentsPagedCallable = callableFactory.createPagedCallable(listCloudControlDeploymentsTransportSettings, settings.listCloudControlDeploymentsSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createFrameworkDeploymentMethodDescriptor);
        methodDescriptors.add(deleteFrameworkDeploymentMethodDescriptor);
        methodDescriptors.add(getFrameworkDeploymentMethodDescriptor);
        methodDescriptors.add(listFrameworkDeploymentsMethodDescriptor);
        methodDescriptors.add(getCloudControlDeploymentMethodDescriptor);
        methodDescriptors.add(listCloudControlDeploymentsMethodDescriptor);
        methodDescriptors.add(listLocationsMethodDescriptor);
        methodDescriptors.add(getLocationMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<CreateFrameworkDeploymentRequest, Operation> createFrameworkDeploymentCallable() {
        return this.createFrameworkDeploymentCallable;
    }

    @Override
    public OperationCallable<CreateFrameworkDeploymentRequest, FrameworkDeployment, OperationMetadata> createFrameworkDeploymentOperationCallable() {
        return this.createFrameworkDeploymentOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteFrameworkDeploymentRequest, Operation> deleteFrameworkDeploymentCallable() {
        return this.deleteFrameworkDeploymentCallable;
    }

    @Override
    public OperationCallable<DeleteFrameworkDeploymentRequest, Empty, OperationMetadata> deleteFrameworkDeploymentOperationCallable() {
        return this.deleteFrameworkDeploymentOperationCallable;
    }

    @Override
    public UnaryCallable<GetFrameworkDeploymentRequest, FrameworkDeployment> getFrameworkDeploymentCallable() {
        return this.getFrameworkDeploymentCallable;
    }

    @Override
    public UnaryCallable<ListFrameworkDeploymentsRequest, ListFrameworkDeploymentsResponse> listFrameworkDeploymentsCallable() {
        return this.listFrameworkDeploymentsCallable;
    }

    @Override
    public UnaryCallable<ListFrameworkDeploymentsRequest, DeploymentClient.ListFrameworkDeploymentsPagedResponse> listFrameworkDeploymentsPagedCallable() {
        return this.listFrameworkDeploymentsPagedCallable;
    }

    @Override
    public UnaryCallable<GetCloudControlDeploymentRequest, CloudControlDeployment> getCloudControlDeploymentCallable() {
        return this.getCloudControlDeploymentCallable;
    }

    @Override
    public UnaryCallable<ListCloudControlDeploymentsRequest, ListCloudControlDeploymentsResponse> listCloudControlDeploymentsCallable() {
        return this.listCloudControlDeploymentsCallable;
    }

    @Override
    public UnaryCallable<ListCloudControlDeploymentsRequest, DeploymentClient.ListCloudControlDeploymentsPagedResponse> listCloudControlDeploymentsPagedCallable() {
        return this.listCloudControlDeploymentsPagedCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, DeploymentClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

