/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.cloudquotas.v1.stub;

import com.google.api.cloudquotas.v1.CloudQuotasClient;
import com.google.api.cloudquotas.v1.CreateQuotaPreferenceRequest;
import com.google.api.cloudquotas.v1.GetQuotaInfoRequest;
import com.google.api.cloudquotas.v1.GetQuotaPreferenceRequest;
import com.google.api.cloudquotas.v1.ListQuotaInfosRequest;
import com.google.api.cloudquotas.v1.ListQuotaInfosResponse;
import com.google.api.cloudquotas.v1.ListQuotaPreferencesRequest;
import com.google.api.cloudquotas.v1.ListQuotaPreferencesResponse;
import com.google.api.cloudquotas.v1.QuotaInfo;
import com.google.api.cloudquotas.v1.QuotaPreference;
import com.google.api.cloudquotas.v1.UpdateQuotaPreferenceRequest;
import com.google.api.cloudquotas.v1.stub.CloudQuotasStub;
import com.google.api.cloudquotas.v1.stub.GrpcCloudQuotasStub;
import com.google.api.cloudquotas.v1.stub.HttpJsonCloudQuotasStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class CloudQuotasStubSettings
extends StubSettings<CloudQuotasStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListQuotaInfosRequest, ListQuotaInfosResponse, CloudQuotasClient.ListQuotaInfosPagedResponse> listQuotaInfosSettings;
    private final UnaryCallSettings<GetQuotaInfoRequest, QuotaInfo> getQuotaInfoSettings;
    private final PagedCallSettings<ListQuotaPreferencesRequest, ListQuotaPreferencesResponse, CloudQuotasClient.ListQuotaPreferencesPagedResponse> listQuotaPreferencesSettings;
    private final UnaryCallSettings<GetQuotaPreferenceRequest, QuotaPreference> getQuotaPreferenceSettings;
    private final UnaryCallSettings<CreateQuotaPreferenceRequest, QuotaPreference> createQuotaPreferenceSettings;
    private final UnaryCallSettings<UpdateQuotaPreferenceRequest, QuotaPreference> updateQuotaPreferenceSettings;
    private static final PagedListDescriptor<ListQuotaInfosRequest, ListQuotaInfosResponse, QuotaInfo> LIST_QUOTA_INFOS_PAGE_STR_DESC = new PagedListDescriptor<ListQuotaInfosRequest, ListQuotaInfosResponse, QuotaInfo>(){

        public String emptyToken() {
            return "";
        }

        public ListQuotaInfosRequest injectToken(ListQuotaInfosRequest payload, String token) {
            return ListQuotaInfosRequest.newBuilder((ListQuotaInfosRequest)payload).setPageToken(token).build();
        }

        public ListQuotaInfosRequest injectPageSize(ListQuotaInfosRequest payload, int pageSize) {
            return ListQuotaInfosRequest.newBuilder((ListQuotaInfosRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListQuotaInfosRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListQuotaInfosResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<QuotaInfo> extractResources(ListQuotaInfosResponse payload) {
            return payload.getQuotaInfosList() == null ? ImmutableList.of() : payload.getQuotaInfosList();
        }
    };
    private static final PagedListDescriptor<ListQuotaPreferencesRequest, ListQuotaPreferencesResponse, QuotaPreference> LIST_QUOTA_PREFERENCES_PAGE_STR_DESC = new PagedListDescriptor<ListQuotaPreferencesRequest, ListQuotaPreferencesResponse, QuotaPreference>(){

        public String emptyToken() {
            return "";
        }

        public ListQuotaPreferencesRequest injectToken(ListQuotaPreferencesRequest payload, String token) {
            return ListQuotaPreferencesRequest.newBuilder((ListQuotaPreferencesRequest)payload).setPageToken(token).build();
        }

        public ListQuotaPreferencesRequest injectPageSize(ListQuotaPreferencesRequest payload, int pageSize) {
            return ListQuotaPreferencesRequest.newBuilder((ListQuotaPreferencesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListQuotaPreferencesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListQuotaPreferencesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<QuotaPreference> extractResources(ListQuotaPreferencesResponse payload) {
            return payload.getQuotaPreferencesList() == null ? ImmutableList.of() : payload.getQuotaPreferencesList();
        }
    };
    private static final PagedListResponseFactory<ListQuotaInfosRequest, ListQuotaInfosResponse, CloudQuotasClient.ListQuotaInfosPagedResponse> LIST_QUOTA_INFOS_PAGE_STR_FACT = new PagedListResponseFactory<ListQuotaInfosRequest, ListQuotaInfosResponse, CloudQuotasClient.ListQuotaInfosPagedResponse>(){

        public ApiFuture<CloudQuotasClient.ListQuotaInfosPagedResponse> getFuturePagedResponse(UnaryCallable<ListQuotaInfosRequest, ListQuotaInfosResponse> callable, ListQuotaInfosRequest request, ApiCallContext context, ApiFuture<ListQuotaInfosResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_QUOTA_INFOS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudQuotasClient.ListQuotaInfosPagedResponse.createAsync((PageContext<ListQuotaInfosRequest, ListQuotaInfosResponse, QuotaInfo>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListQuotaPreferencesRequest, ListQuotaPreferencesResponse, CloudQuotasClient.ListQuotaPreferencesPagedResponse> LIST_QUOTA_PREFERENCES_PAGE_STR_FACT = new PagedListResponseFactory<ListQuotaPreferencesRequest, ListQuotaPreferencesResponse, CloudQuotasClient.ListQuotaPreferencesPagedResponse>(){

        public ApiFuture<CloudQuotasClient.ListQuotaPreferencesPagedResponse> getFuturePagedResponse(UnaryCallable<ListQuotaPreferencesRequest, ListQuotaPreferencesResponse> callable, ListQuotaPreferencesRequest request, ApiCallContext context, ApiFuture<ListQuotaPreferencesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_QUOTA_PREFERENCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudQuotasClient.ListQuotaPreferencesPagedResponse.createAsync((PageContext<ListQuotaPreferencesRequest, ListQuotaPreferencesResponse, QuotaPreference>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListQuotaInfosRequest, ListQuotaInfosResponse, CloudQuotasClient.ListQuotaInfosPagedResponse> listQuotaInfosSettings() {
        return this.listQuotaInfosSettings;
    }

    public UnaryCallSettings<GetQuotaInfoRequest, QuotaInfo> getQuotaInfoSettings() {
        return this.getQuotaInfoSettings;
    }

    public PagedCallSettings<ListQuotaPreferencesRequest, ListQuotaPreferencesResponse, CloudQuotasClient.ListQuotaPreferencesPagedResponse> listQuotaPreferencesSettings() {
        return this.listQuotaPreferencesSettings;
    }

    public UnaryCallSettings<GetQuotaPreferenceRequest, QuotaPreference> getQuotaPreferenceSettings() {
        return this.getQuotaPreferenceSettings;
    }

    public UnaryCallSettings<CreateQuotaPreferenceRequest, QuotaPreference> createQuotaPreferenceSettings() {
        return this.createQuotaPreferenceSettings;
    }

    public UnaryCallSettings<UpdateQuotaPreferenceRequest, QuotaPreference> updateQuotaPreferenceSettings() {
        return this.updateQuotaPreferenceSettings;
    }

    public CloudQuotasStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCloudQuotasStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonCloudQuotasStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "cloudquotas";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "cloudquotas.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudquotas.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CloudQuotasStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CloudQuotasStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CloudQuotasStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return CloudQuotasStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CloudQuotasStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listQuotaInfosSettings = settingsBuilder.listQuotaInfosSettings().build();
        this.getQuotaInfoSettings = settingsBuilder.getQuotaInfoSettings().build();
        this.listQuotaPreferencesSettings = settingsBuilder.listQuotaPreferencesSettings().build();
        this.getQuotaPreferenceSettings = settingsBuilder.getQuotaPreferenceSettings().build();
        this.createQuotaPreferenceSettings = settingsBuilder.createQuotaPreferenceSettings().build();
        this.updateQuotaPreferenceSettings = settingsBuilder.updateQuotaPreferenceSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CloudQuotasStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListQuotaInfosRequest, ListQuotaInfosResponse, CloudQuotasClient.ListQuotaInfosPagedResponse> listQuotaInfosSettings;
        private final UnaryCallSettings.Builder<GetQuotaInfoRequest, QuotaInfo> getQuotaInfoSettings;
        private final PagedCallSettings.Builder<ListQuotaPreferencesRequest, ListQuotaPreferencesResponse, CloudQuotasClient.ListQuotaPreferencesPagedResponse> listQuotaPreferencesSettings;
        private final UnaryCallSettings.Builder<GetQuotaPreferenceRequest, QuotaPreference> getQuotaPreferenceSettings;
        private final UnaryCallSettings.Builder<CreateQuotaPreferenceRequest, QuotaPreference> createQuotaPreferenceSettings;
        private final UnaryCallSettings.Builder<UpdateQuotaPreferenceRequest, QuotaPreference> updateQuotaPreferenceSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listQuotaInfosSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_QUOTA_INFOS_PAGE_STR_FACT);
            this.getQuotaInfoSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listQuotaPreferencesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_QUOTA_PREFERENCES_PAGE_STR_FACT);
            this.getQuotaPreferenceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createQuotaPreferenceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateQuotaPreferenceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listQuotaInfosSettings, this.getQuotaInfoSettings, this.listQuotaPreferencesSettings, this.getQuotaPreferenceSettings, this.createQuotaPreferenceSettings, this.updateQuotaPreferenceSettings);
            Builder.initDefaults(this);
        }

        protected Builder(CloudQuotasStubSettings settings) {
            super((StubSettings)settings);
            this.listQuotaInfosSettings = settings.listQuotaInfosSettings.toBuilder();
            this.getQuotaInfoSettings = settings.getQuotaInfoSettings.toBuilder();
            this.listQuotaPreferencesSettings = settings.listQuotaPreferencesSettings.toBuilder();
            this.getQuotaPreferenceSettings = settings.getQuotaPreferenceSettings.toBuilder();
            this.createQuotaPreferenceSettings = settings.createQuotaPreferenceSettings.toBuilder();
            this.updateQuotaPreferenceSettings = settings.updateQuotaPreferenceSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listQuotaInfosSettings, this.getQuotaInfoSettings, this.listQuotaPreferencesSettings, this.getQuotaPreferenceSettings, this.createQuotaPreferenceSettings, this.updateQuotaPreferenceSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CloudQuotasStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CloudQuotasStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CloudQuotasStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CloudQuotasStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)CloudQuotasStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)CloudQuotasStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CloudQuotasStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CloudQuotasStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listQuotaInfosSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getQuotaInfoSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listQuotaPreferencesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getQuotaPreferenceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createQuotaPreferenceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateQuotaPreferenceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListQuotaInfosRequest, ListQuotaInfosResponse, CloudQuotasClient.ListQuotaInfosPagedResponse> listQuotaInfosSettings() {
            return this.listQuotaInfosSettings;
        }

        public UnaryCallSettings.Builder<GetQuotaInfoRequest, QuotaInfo> getQuotaInfoSettings() {
            return this.getQuotaInfoSettings;
        }

        public PagedCallSettings.Builder<ListQuotaPreferencesRequest, ListQuotaPreferencesResponse, CloudQuotasClient.ListQuotaPreferencesPagedResponse> listQuotaPreferencesSettings() {
            return this.listQuotaPreferencesSettings;
        }

        public UnaryCallSettings.Builder<GetQuotaPreferenceRequest, QuotaPreference> getQuotaPreferenceSettings() {
            return this.getQuotaPreferenceSettings;
        }

        public UnaryCallSettings.Builder<CreateQuotaPreferenceRequest, QuotaPreference> createQuotaPreferenceSettings() {
            return this.createQuotaPreferenceSettings;
        }

        public UnaryCallSettings.Builder<UpdateQuotaPreferenceRequest, QuotaPreference> updateQuotaPreferenceSettings() {
            return this.updateQuotaPreferenceSettings;
        }

        public CloudQuotasStubSettings build() throws IOException {
            return new CloudQuotasStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

