/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.chronicle.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.chronicle.v1.CreateWatchlistRequest;
import com.google.cloud.chronicle.v1.DeleteWatchlistRequest;
import com.google.cloud.chronicle.v1.EntityServiceSettings;
import com.google.cloud.chronicle.v1.GetWatchlistRequest;
import com.google.cloud.chronicle.v1.InstanceName;
import com.google.cloud.chronicle.v1.ListWatchlistsRequest;
import com.google.cloud.chronicle.v1.ListWatchlistsResponse;
import com.google.cloud.chronicle.v1.UpdateWatchlistRequest;
import com.google.cloud.chronicle.v1.Watchlist;
import com.google.cloud.chronicle.v1.WatchlistName;
import com.google.cloud.chronicle.v1.stub.EntityServiceStub;
import com.google.cloud.chronicle.v1.stub.EntityServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class EntityServiceClient
implements BackgroundResource {
    private final EntityServiceSettings settings;
    private final EntityServiceStub stub;

    public static final EntityServiceClient create() throws IOException {
        return EntityServiceClient.create(EntityServiceSettings.newBuilder().build());
    }

    public static final EntityServiceClient create(EntityServiceSettings settings) throws IOException {
        return new EntityServiceClient(settings);
    }

    public static final EntityServiceClient create(EntityServiceStub stub) {
        return new EntityServiceClient(stub);
    }

    protected EntityServiceClient(EntityServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((EntityServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected EntityServiceClient(EntityServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final EntityServiceSettings getSettings() {
        return this.settings;
    }

    public EntityServiceStub getStub() {
        return this.stub;
    }

    public final Watchlist getWatchlist(WatchlistName name) {
        GetWatchlistRequest request = GetWatchlistRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getWatchlist(request);
    }

    public final Watchlist getWatchlist(String name) {
        GetWatchlistRequest request = GetWatchlistRequest.newBuilder().setName(name).build();
        return this.getWatchlist(request);
    }

    public final Watchlist getWatchlist(GetWatchlistRequest request) {
        return (Watchlist)this.getWatchlistCallable().call((Object)request);
    }

    public final UnaryCallable<GetWatchlistRequest, Watchlist> getWatchlistCallable() {
        return this.stub.getWatchlistCallable();
    }

    public final ListWatchlistsPagedResponse listWatchlists(InstanceName parent) {
        ListWatchlistsRequest request = ListWatchlistsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listWatchlists(request);
    }

    public final ListWatchlistsPagedResponse listWatchlists(String parent) {
        ListWatchlistsRequest request = ListWatchlistsRequest.newBuilder().setParent(parent).build();
        return this.listWatchlists(request);
    }

    public final ListWatchlistsPagedResponse listWatchlists(ListWatchlistsRequest request) {
        return (ListWatchlistsPagedResponse)((Object)this.listWatchlistsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListWatchlistsRequest, ListWatchlistsPagedResponse> listWatchlistsPagedCallable() {
        return this.stub.listWatchlistsPagedCallable();
    }

    public final UnaryCallable<ListWatchlistsRequest, ListWatchlistsResponse> listWatchlistsCallable() {
        return this.stub.listWatchlistsCallable();
    }

    public final Watchlist createWatchlist(InstanceName parent, Watchlist watchlist, String watchlistId) {
        CreateWatchlistRequest request = CreateWatchlistRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setWatchlist(watchlist).setWatchlistId(watchlistId).build();
        return this.createWatchlist(request);
    }

    public final Watchlist createWatchlist(String parent, Watchlist watchlist, String watchlistId) {
        CreateWatchlistRequest request = CreateWatchlistRequest.newBuilder().setParent(parent).setWatchlist(watchlist).setWatchlistId(watchlistId).build();
        return this.createWatchlist(request);
    }

    public final Watchlist createWatchlist(CreateWatchlistRequest request) {
        return (Watchlist)this.createWatchlistCallable().call((Object)request);
    }

    public final UnaryCallable<CreateWatchlistRequest, Watchlist> createWatchlistCallable() {
        return this.stub.createWatchlistCallable();
    }

    public final Watchlist updateWatchlist(Watchlist watchlist, FieldMask updateMask) {
        UpdateWatchlistRequest request = UpdateWatchlistRequest.newBuilder().setWatchlist(watchlist).setUpdateMask(updateMask).build();
        return this.updateWatchlist(request);
    }

    public final Watchlist updateWatchlist(UpdateWatchlistRequest request) {
        return (Watchlist)this.updateWatchlistCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateWatchlistRequest, Watchlist> updateWatchlistCallable() {
        return this.stub.updateWatchlistCallable();
    }

    public final void deleteWatchlist(WatchlistName name, boolean force) {
        DeleteWatchlistRequest request = DeleteWatchlistRequest.newBuilder().setName(name == null ? null : name.toString()).setForce(force).build();
        this.deleteWatchlist(request);
    }

    public final void deleteWatchlist(String name, boolean force) {
        DeleteWatchlistRequest request = DeleteWatchlistRequest.newBuilder().setName(name).setForce(force).build();
        this.deleteWatchlist(request);
    }

    public final void deleteWatchlist(DeleteWatchlistRequest request) {
        this.deleteWatchlistCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteWatchlistRequest, Empty> deleteWatchlistCallable() {
        return this.stub.deleteWatchlistCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListWatchlistsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListWatchlistsRequest, ListWatchlistsResponse, Watchlist, ListWatchlistsPage, ListWatchlistsFixedSizeCollection> {
        private ListWatchlistsFixedSizeCollection(List<ListWatchlistsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListWatchlistsFixedSizeCollection createEmptyCollection() {
            return new ListWatchlistsFixedSizeCollection(null, 0);
        }

        protected ListWatchlistsFixedSizeCollection createCollection(List<ListWatchlistsPage> pages, int collectionSize) {
            return new ListWatchlistsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListWatchlistsPage
    extends AbstractPage<ListWatchlistsRequest, ListWatchlistsResponse, Watchlist, ListWatchlistsPage> {
        private ListWatchlistsPage(PageContext<ListWatchlistsRequest, ListWatchlistsResponse, Watchlist> context, ListWatchlistsResponse response) {
            super(context, (Object)response);
        }

        private static ListWatchlistsPage createEmptyPage() {
            return new ListWatchlistsPage(null, null);
        }

        protected ListWatchlistsPage createPage(PageContext<ListWatchlistsRequest, ListWatchlistsResponse, Watchlist> context, ListWatchlistsResponse response) {
            return new ListWatchlistsPage(context, response);
        }

        public ApiFuture<ListWatchlistsPage> createPageAsync(PageContext<ListWatchlistsRequest, ListWatchlistsResponse, Watchlist> context, ApiFuture<ListWatchlistsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListWatchlistsPagedResponse
    extends AbstractPagedListResponse<ListWatchlistsRequest, ListWatchlistsResponse, Watchlist, ListWatchlistsPage, ListWatchlistsFixedSizeCollection> {
        public static ApiFuture<ListWatchlistsPagedResponse> createAsync(PageContext<ListWatchlistsRequest, ListWatchlistsResponse, Watchlist> context, ApiFuture<ListWatchlistsResponse> futureResponse) {
            ApiFuture<ListWatchlistsPage> futurePage = ListWatchlistsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListWatchlistsPagedResponse((ListWatchlistsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListWatchlistsPagedResponse(ListWatchlistsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListWatchlistsFixedSizeCollection.createEmptyCollection());
        }
    }
}

