/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.chronicle.v1;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.chronicle.v1.GetInstanceRequest;
import com.google.cloud.chronicle.v1.Instance;
import com.google.cloud.chronicle.v1.InstanceName;
import com.google.cloud.chronicle.v1.InstanceServiceSettings;
import com.google.cloud.chronicle.v1.stub.InstanceServiceStub;
import com.google.cloud.chronicle.v1.stub.InstanceServiceStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class InstanceServiceClient
implements BackgroundResource {
    private final InstanceServiceSettings settings;
    private final InstanceServiceStub stub;

    public static final InstanceServiceClient create() throws IOException {
        return InstanceServiceClient.create(InstanceServiceSettings.newBuilder().build());
    }

    public static final InstanceServiceClient create(InstanceServiceSettings settings) throws IOException {
        return new InstanceServiceClient(settings);
    }

    public static final InstanceServiceClient create(InstanceServiceStub stub) {
        return new InstanceServiceClient(stub);
    }

    protected InstanceServiceClient(InstanceServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((InstanceServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected InstanceServiceClient(InstanceServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final InstanceServiceSettings getSettings() {
        return this.settings;
    }

    public InstanceServiceStub getStub() {
        return this.stub;
    }

    public final Instance getInstance(InstanceName name) {
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getInstance(request);
    }

    public final Instance getInstance(String name) {
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(name).build();
        return this.getInstance(request);
    }

    public final Instance getInstance(GetInstanceRequest request) {
        return (Instance)this.getInstanceCallable().call((Object)request);
    }

    public final UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable() {
        return this.stub.getInstanceCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

