/*
 * Decompiled with CFR 0.152.
 */
package com.google.chat.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.chat.v1.Attachment;
import com.google.chat.v1.ChatServiceClient;
import com.google.chat.v1.CompleteImportSpaceRequest;
import com.google.chat.v1.CompleteImportSpaceResponse;
import com.google.chat.v1.CreateMembershipRequest;
import com.google.chat.v1.CreateMessageRequest;
import com.google.chat.v1.CreateReactionRequest;
import com.google.chat.v1.CreateSpaceRequest;
import com.google.chat.v1.DeleteMembershipRequest;
import com.google.chat.v1.DeleteMessageRequest;
import com.google.chat.v1.DeleteReactionRequest;
import com.google.chat.v1.DeleteSpaceRequest;
import com.google.chat.v1.FindDirectMessageRequest;
import com.google.chat.v1.GetAttachmentRequest;
import com.google.chat.v1.GetMembershipRequest;
import com.google.chat.v1.GetMessageRequest;
import com.google.chat.v1.GetSpaceEventRequest;
import com.google.chat.v1.GetSpaceNotificationSettingRequest;
import com.google.chat.v1.GetSpaceReadStateRequest;
import com.google.chat.v1.GetSpaceRequest;
import com.google.chat.v1.GetThreadReadStateRequest;
import com.google.chat.v1.ListMembershipsRequest;
import com.google.chat.v1.ListMembershipsResponse;
import com.google.chat.v1.ListMessagesRequest;
import com.google.chat.v1.ListMessagesResponse;
import com.google.chat.v1.ListReactionsRequest;
import com.google.chat.v1.ListReactionsResponse;
import com.google.chat.v1.ListSpaceEventsRequest;
import com.google.chat.v1.ListSpaceEventsResponse;
import com.google.chat.v1.ListSpacesRequest;
import com.google.chat.v1.ListSpacesResponse;
import com.google.chat.v1.Membership;
import com.google.chat.v1.Message;
import com.google.chat.v1.Reaction;
import com.google.chat.v1.SearchSpacesRequest;
import com.google.chat.v1.SearchSpacesResponse;
import com.google.chat.v1.SetUpSpaceRequest;
import com.google.chat.v1.Space;
import com.google.chat.v1.SpaceEvent;
import com.google.chat.v1.SpaceNotificationSetting;
import com.google.chat.v1.SpaceReadState;
import com.google.chat.v1.ThreadReadState;
import com.google.chat.v1.UpdateMembershipRequest;
import com.google.chat.v1.UpdateMessageRequest;
import com.google.chat.v1.UpdateSpaceNotificationSettingRequest;
import com.google.chat.v1.UpdateSpaceReadStateRequest;
import com.google.chat.v1.UpdateSpaceRequest;
import com.google.chat.v1.UploadAttachmentRequest;
import com.google.chat.v1.UploadAttachmentResponse;
import com.google.chat.v1.stub.ChatServiceStub;
import com.google.chat.v1.stub.GrpcChatServiceStub;
import com.google.chat.v1.stub.HttpJsonChatServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ChatServiceStubSettings
extends StubSettings<ChatServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/chat.admin.delete").add((Object)"https://www.googleapis.com/auth/chat.admin.memberships").add((Object)"https://www.googleapis.com/auth/chat.admin.memberships.readonly").add((Object)"https://www.googleapis.com/auth/chat.admin.spaces").add((Object)"https://www.googleapis.com/auth/chat.admin.spaces.readonly").add((Object)"https://www.googleapis.com/auth/chat.bot").add((Object)"https://www.googleapis.com/auth/chat.delete").add((Object)"https://www.googleapis.com/auth/chat.import").add((Object)"https://www.googleapis.com/auth/chat.memberships").add((Object)"https://www.googleapis.com/auth/chat.memberships.app").add((Object)"https://www.googleapis.com/auth/chat.memberships.readonly").add((Object)"https://www.googleapis.com/auth/chat.messages").add((Object)"https://www.googleapis.com/auth/chat.messages.create").add((Object)"https://www.googleapis.com/auth/chat.messages.reactions").add((Object)"https://www.googleapis.com/auth/chat.messages.reactions.create").add((Object)"https://www.googleapis.com/auth/chat.messages.reactions.readonly").add((Object)"https://www.googleapis.com/auth/chat.messages.readonly").add((Object)"https://www.googleapis.com/auth/chat.spaces").add((Object)"https://www.googleapis.com/auth/chat.spaces.create").add((Object)"https://www.googleapis.com/auth/chat.spaces.readonly").add((Object)"https://www.googleapis.com/auth/chat.users.readstate").add((Object)"https://www.googleapis.com/auth/chat.users.readstate.readonly").add((Object)"https://www.googleapis.com/auth/chat.users.spacesettings").build();
    private final UnaryCallSettings<CreateMessageRequest, Message> createMessageSettings;
    private final PagedCallSettings<ListMessagesRequest, ListMessagesResponse, ChatServiceClient.ListMessagesPagedResponse> listMessagesSettings;
    private final PagedCallSettings<ListMembershipsRequest, ListMembershipsResponse, ChatServiceClient.ListMembershipsPagedResponse> listMembershipsSettings;
    private final UnaryCallSettings<GetMembershipRequest, Membership> getMembershipSettings;
    private final UnaryCallSettings<GetMessageRequest, Message> getMessageSettings;
    private final UnaryCallSettings<UpdateMessageRequest, Message> updateMessageSettings;
    private final UnaryCallSettings<DeleteMessageRequest, Empty> deleteMessageSettings;
    private final UnaryCallSettings<GetAttachmentRequest, Attachment> getAttachmentSettings;
    private final UnaryCallSettings<UploadAttachmentRequest, UploadAttachmentResponse> uploadAttachmentSettings;
    private final PagedCallSettings<ListSpacesRequest, ListSpacesResponse, ChatServiceClient.ListSpacesPagedResponse> listSpacesSettings;
    private final PagedCallSettings<SearchSpacesRequest, SearchSpacesResponse, ChatServiceClient.SearchSpacesPagedResponse> searchSpacesSettings;
    private final UnaryCallSettings<GetSpaceRequest, Space> getSpaceSettings;
    private final UnaryCallSettings<CreateSpaceRequest, Space> createSpaceSettings;
    private final UnaryCallSettings<SetUpSpaceRequest, Space> setUpSpaceSettings;
    private final UnaryCallSettings<UpdateSpaceRequest, Space> updateSpaceSettings;
    private final UnaryCallSettings<DeleteSpaceRequest, Empty> deleteSpaceSettings;
    private final UnaryCallSettings<CompleteImportSpaceRequest, CompleteImportSpaceResponse> completeImportSpaceSettings;
    private final UnaryCallSettings<FindDirectMessageRequest, Space> findDirectMessageSettings;
    private final UnaryCallSettings<CreateMembershipRequest, Membership> createMembershipSettings;
    private final UnaryCallSettings<UpdateMembershipRequest, Membership> updateMembershipSettings;
    private final UnaryCallSettings<DeleteMembershipRequest, Membership> deleteMembershipSettings;
    private final UnaryCallSettings<CreateReactionRequest, Reaction> createReactionSettings;
    private final PagedCallSettings<ListReactionsRequest, ListReactionsResponse, ChatServiceClient.ListReactionsPagedResponse> listReactionsSettings;
    private final UnaryCallSettings<DeleteReactionRequest, Empty> deleteReactionSettings;
    private final UnaryCallSettings<GetSpaceReadStateRequest, SpaceReadState> getSpaceReadStateSettings;
    private final UnaryCallSettings<UpdateSpaceReadStateRequest, SpaceReadState> updateSpaceReadStateSettings;
    private final UnaryCallSettings<GetThreadReadStateRequest, ThreadReadState> getThreadReadStateSettings;
    private final UnaryCallSettings<GetSpaceEventRequest, SpaceEvent> getSpaceEventSettings;
    private final PagedCallSettings<ListSpaceEventsRequest, ListSpaceEventsResponse, ChatServiceClient.ListSpaceEventsPagedResponse> listSpaceEventsSettings;
    private final UnaryCallSettings<GetSpaceNotificationSettingRequest, SpaceNotificationSetting> getSpaceNotificationSettingSettings;
    private final UnaryCallSettings<UpdateSpaceNotificationSettingRequest, SpaceNotificationSetting> updateSpaceNotificationSettingSettings;
    private static final PagedListDescriptor<ListMessagesRequest, ListMessagesResponse, Message> LIST_MESSAGES_PAGE_STR_DESC = new PagedListDescriptor<ListMessagesRequest, ListMessagesResponse, Message>(){

        public String emptyToken() {
            return "";
        }

        public ListMessagesRequest injectToken(ListMessagesRequest payload, String token) {
            return ListMessagesRequest.newBuilder((ListMessagesRequest)payload).setPageToken(token).build();
        }

        public ListMessagesRequest injectPageSize(ListMessagesRequest payload, int pageSize) {
            return ListMessagesRequest.newBuilder((ListMessagesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListMessagesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListMessagesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Message> extractResources(ListMessagesResponse payload) {
            return payload.getMessagesList();
        }
    };
    private static final PagedListDescriptor<ListMembershipsRequest, ListMembershipsResponse, Membership> LIST_MEMBERSHIPS_PAGE_STR_DESC = new PagedListDescriptor<ListMembershipsRequest, ListMembershipsResponse, Membership>(){

        public String emptyToken() {
            return "";
        }

        public ListMembershipsRequest injectToken(ListMembershipsRequest payload, String token) {
            return ListMembershipsRequest.newBuilder((ListMembershipsRequest)payload).setPageToken(token).build();
        }

        public ListMembershipsRequest injectPageSize(ListMembershipsRequest payload, int pageSize) {
            return ListMembershipsRequest.newBuilder((ListMembershipsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListMembershipsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListMembershipsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Membership> extractResources(ListMembershipsResponse payload) {
            return payload.getMembershipsList();
        }
    };
    private static final PagedListDescriptor<ListSpacesRequest, ListSpacesResponse, Space> LIST_SPACES_PAGE_STR_DESC = new PagedListDescriptor<ListSpacesRequest, ListSpacesResponse, Space>(){

        public String emptyToken() {
            return "";
        }

        public ListSpacesRequest injectToken(ListSpacesRequest payload, String token) {
            return ListSpacesRequest.newBuilder((ListSpacesRequest)payload).setPageToken(token).build();
        }

        public ListSpacesRequest injectPageSize(ListSpacesRequest payload, int pageSize) {
            return ListSpacesRequest.newBuilder((ListSpacesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSpacesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSpacesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Space> extractResources(ListSpacesResponse payload) {
            return payload.getSpacesList();
        }
    };
    private static final PagedListDescriptor<SearchSpacesRequest, SearchSpacesResponse, Space> SEARCH_SPACES_PAGE_STR_DESC = new PagedListDescriptor<SearchSpacesRequest, SearchSpacesResponse, Space>(){

        public String emptyToken() {
            return "";
        }

        public SearchSpacesRequest injectToken(SearchSpacesRequest payload, String token) {
            return SearchSpacesRequest.newBuilder((SearchSpacesRequest)payload).setPageToken(token).build();
        }

        public SearchSpacesRequest injectPageSize(SearchSpacesRequest payload, int pageSize) {
            return SearchSpacesRequest.newBuilder((SearchSpacesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchSpacesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchSpacesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Space> extractResources(SearchSpacesResponse payload) {
            return payload.getSpacesList();
        }
    };
    private static final PagedListDescriptor<ListReactionsRequest, ListReactionsResponse, Reaction> LIST_REACTIONS_PAGE_STR_DESC = new PagedListDescriptor<ListReactionsRequest, ListReactionsResponse, Reaction>(){

        public String emptyToken() {
            return "";
        }

        public ListReactionsRequest injectToken(ListReactionsRequest payload, String token) {
            return ListReactionsRequest.newBuilder((ListReactionsRequest)payload).setPageToken(token).build();
        }

        public ListReactionsRequest injectPageSize(ListReactionsRequest payload, int pageSize) {
            return ListReactionsRequest.newBuilder((ListReactionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListReactionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListReactionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Reaction> extractResources(ListReactionsResponse payload) {
            return payload.getReactionsList();
        }
    };
    private static final PagedListDescriptor<ListSpaceEventsRequest, ListSpaceEventsResponse, SpaceEvent> LIST_SPACE_EVENTS_PAGE_STR_DESC = new PagedListDescriptor<ListSpaceEventsRequest, ListSpaceEventsResponse, SpaceEvent>(){

        public String emptyToken() {
            return "";
        }

        public ListSpaceEventsRequest injectToken(ListSpaceEventsRequest payload, String token) {
            return ListSpaceEventsRequest.newBuilder((ListSpaceEventsRequest)payload).setPageToken(token).build();
        }

        public ListSpaceEventsRequest injectPageSize(ListSpaceEventsRequest payload, int pageSize) {
            return ListSpaceEventsRequest.newBuilder((ListSpaceEventsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSpaceEventsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSpaceEventsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<SpaceEvent> extractResources(ListSpaceEventsResponse payload) {
            return payload.getSpaceEventsList();
        }
    };
    private static final PagedListResponseFactory<ListMessagesRequest, ListMessagesResponse, ChatServiceClient.ListMessagesPagedResponse> LIST_MESSAGES_PAGE_STR_FACT = new PagedListResponseFactory<ListMessagesRequest, ListMessagesResponse, ChatServiceClient.ListMessagesPagedResponse>(){

        public ApiFuture<ChatServiceClient.ListMessagesPagedResponse> getFuturePagedResponse(UnaryCallable<ListMessagesRequest, ListMessagesResponse> callable, ListMessagesRequest request, ApiCallContext context, ApiFuture<ListMessagesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MESSAGES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ChatServiceClient.ListMessagesPagedResponse.createAsync((PageContext<ListMessagesRequest, ListMessagesResponse, Message>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListMembershipsRequest, ListMembershipsResponse, ChatServiceClient.ListMembershipsPagedResponse> LIST_MEMBERSHIPS_PAGE_STR_FACT = new PagedListResponseFactory<ListMembershipsRequest, ListMembershipsResponse, ChatServiceClient.ListMembershipsPagedResponse>(){

        public ApiFuture<ChatServiceClient.ListMembershipsPagedResponse> getFuturePagedResponse(UnaryCallable<ListMembershipsRequest, ListMembershipsResponse> callable, ListMembershipsRequest request, ApiCallContext context, ApiFuture<ListMembershipsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MEMBERSHIPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ChatServiceClient.ListMembershipsPagedResponse.createAsync((PageContext<ListMembershipsRequest, ListMembershipsResponse, Membership>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSpacesRequest, ListSpacesResponse, ChatServiceClient.ListSpacesPagedResponse> LIST_SPACES_PAGE_STR_FACT = new PagedListResponseFactory<ListSpacesRequest, ListSpacesResponse, ChatServiceClient.ListSpacesPagedResponse>(){

        public ApiFuture<ChatServiceClient.ListSpacesPagedResponse> getFuturePagedResponse(UnaryCallable<ListSpacesRequest, ListSpacesResponse> callable, ListSpacesRequest request, ApiCallContext context, ApiFuture<ListSpacesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SPACES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ChatServiceClient.ListSpacesPagedResponse.createAsync((PageContext<ListSpacesRequest, ListSpacesResponse, Space>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<SearchSpacesRequest, SearchSpacesResponse, ChatServiceClient.SearchSpacesPagedResponse> SEARCH_SPACES_PAGE_STR_FACT = new PagedListResponseFactory<SearchSpacesRequest, SearchSpacesResponse, ChatServiceClient.SearchSpacesPagedResponse>(){

        public ApiFuture<ChatServiceClient.SearchSpacesPagedResponse> getFuturePagedResponse(UnaryCallable<SearchSpacesRequest, SearchSpacesResponse> callable, SearchSpacesRequest request, ApiCallContext context, ApiFuture<SearchSpacesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_SPACES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ChatServiceClient.SearchSpacesPagedResponse.createAsync((PageContext<SearchSpacesRequest, SearchSpacesResponse, Space>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListReactionsRequest, ListReactionsResponse, ChatServiceClient.ListReactionsPagedResponse> LIST_REACTIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListReactionsRequest, ListReactionsResponse, ChatServiceClient.ListReactionsPagedResponse>(){

        public ApiFuture<ChatServiceClient.ListReactionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListReactionsRequest, ListReactionsResponse> callable, ListReactionsRequest request, ApiCallContext context, ApiFuture<ListReactionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_REACTIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ChatServiceClient.ListReactionsPagedResponse.createAsync((PageContext<ListReactionsRequest, ListReactionsResponse, Reaction>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSpaceEventsRequest, ListSpaceEventsResponse, ChatServiceClient.ListSpaceEventsPagedResponse> LIST_SPACE_EVENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListSpaceEventsRequest, ListSpaceEventsResponse, ChatServiceClient.ListSpaceEventsPagedResponse>(){

        public ApiFuture<ChatServiceClient.ListSpaceEventsPagedResponse> getFuturePagedResponse(UnaryCallable<ListSpaceEventsRequest, ListSpaceEventsResponse> callable, ListSpaceEventsRequest request, ApiCallContext context, ApiFuture<ListSpaceEventsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SPACE_EVENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ChatServiceClient.ListSpaceEventsPagedResponse.createAsync((PageContext<ListSpaceEventsRequest, ListSpaceEventsResponse, SpaceEvent>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateMessageRequest, Message> createMessageSettings() {
        return this.createMessageSettings;
    }

    public PagedCallSettings<ListMessagesRequest, ListMessagesResponse, ChatServiceClient.ListMessagesPagedResponse> listMessagesSettings() {
        return this.listMessagesSettings;
    }

    public PagedCallSettings<ListMembershipsRequest, ListMembershipsResponse, ChatServiceClient.ListMembershipsPagedResponse> listMembershipsSettings() {
        return this.listMembershipsSettings;
    }

    public UnaryCallSettings<GetMembershipRequest, Membership> getMembershipSettings() {
        return this.getMembershipSettings;
    }

    public UnaryCallSettings<GetMessageRequest, Message> getMessageSettings() {
        return this.getMessageSettings;
    }

    public UnaryCallSettings<UpdateMessageRequest, Message> updateMessageSettings() {
        return this.updateMessageSettings;
    }

    public UnaryCallSettings<DeleteMessageRequest, Empty> deleteMessageSettings() {
        return this.deleteMessageSettings;
    }

    public UnaryCallSettings<GetAttachmentRequest, Attachment> getAttachmentSettings() {
        return this.getAttachmentSettings;
    }

    public UnaryCallSettings<UploadAttachmentRequest, UploadAttachmentResponse> uploadAttachmentSettings() {
        return this.uploadAttachmentSettings;
    }

    public PagedCallSettings<ListSpacesRequest, ListSpacesResponse, ChatServiceClient.ListSpacesPagedResponse> listSpacesSettings() {
        return this.listSpacesSettings;
    }

    public PagedCallSettings<SearchSpacesRequest, SearchSpacesResponse, ChatServiceClient.SearchSpacesPagedResponse> searchSpacesSettings() {
        return this.searchSpacesSettings;
    }

    public UnaryCallSettings<GetSpaceRequest, Space> getSpaceSettings() {
        return this.getSpaceSettings;
    }

    public UnaryCallSettings<CreateSpaceRequest, Space> createSpaceSettings() {
        return this.createSpaceSettings;
    }

    public UnaryCallSettings<SetUpSpaceRequest, Space> setUpSpaceSettings() {
        return this.setUpSpaceSettings;
    }

    public UnaryCallSettings<UpdateSpaceRequest, Space> updateSpaceSettings() {
        return this.updateSpaceSettings;
    }

    public UnaryCallSettings<DeleteSpaceRequest, Empty> deleteSpaceSettings() {
        return this.deleteSpaceSettings;
    }

    public UnaryCallSettings<CompleteImportSpaceRequest, CompleteImportSpaceResponse> completeImportSpaceSettings() {
        return this.completeImportSpaceSettings;
    }

    public UnaryCallSettings<FindDirectMessageRequest, Space> findDirectMessageSettings() {
        return this.findDirectMessageSettings;
    }

    public UnaryCallSettings<CreateMembershipRequest, Membership> createMembershipSettings() {
        return this.createMembershipSettings;
    }

    public UnaryCallSettings<UpdateMembershipRequest, Membership> updateMembershipSettings() {
        return this.updateMembershipSettings;
    }

    public UnaryCallSettings<DeleteMembershipRequest, Membership> deleteMembershipSettings() {
        return this.deleteMembershipSettings;
    }

    public UnaryCallSettings<CreateReactionRequest, Reaction> createReactionSettings() {
        return this.createReactionSettings;
    }

    public PagedCallSettings<ListReactionsRequest, ListReactionsResponse, ChatServiceClient.ListReactionsPagedResponse> listReactionsSettings() {
        return this.listReactionsSettings;
    }

    public UnaryCallSettings<DeleteReactionRequest, Empty> deleteReactionSettings() {
        return this.deleteReactionSettings;
    }

    public UnaryCallSettings<GetSpaceReadStateRequest, SpaceReadState> getSpaceReadStateSettings() {
        return this.getSpaceReadStateSettings;
    }

    public UnaryCallSettings<UpdateSpaceReadStateRequest, SpaceReadState> updateSpaceReadStateSettings() {
        return this.updateSpaceReadStateSettings;
    }

    public UnaryCallSettings<GetThreadReadStateRequest, ThreadReadState> getThreadReadStateSettings() {
        return this.getThreadReadStateSettings;
    }

    public UnaryCallSettings<GetSpaceEventRequest, SpaceEvent> getSpaceEventSettings() {
        return this.getSpaceEventSettings;
    }

    public PagedCallSettings<ListSpaceEventsRequest, ListSpaceEventsResponse, ChatServiceClient.ListSpaceEventsPagedResponse> listSpaceEventsSettings() {
        return this.listSpaceEventsSettings;
    }

    public UnaryCallSettings<GetSpaceNotificationSettingRequest, SpaceNotificationSetting> getSpaceNotificationSettingSettings() {
        return this.getSpaceNotificationSettingSettings;
    }

    public UnaryCallSettings<UpdateSpaceNotificationSettingRequest, SpaceNotificationSetting> updateSpaceNotificationSettingSettings() {
        return this.updateSpaceNotificationSettingSettings;
    }

    public ChatServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcChatServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonChatServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "chat";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "chat.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "chat.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ChatServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ChatServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ChatServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ChatServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ChatServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createMessageSettings = settingsBuilder.createMessageSettings().build();
        this.listMessagesSettings = settingsBuilder.listMessagesSettings().build();
        this.listMembershipsSettings = settingsBuilder.listMembershipsSettings().build();
        this.getMembershipSettings = settingsBuilder.getMembershipSettings().build();
        this.getMessageSettings = settingsBuilder.getMessageSettings().build();
        this.updateMessageSettings = settingsBuilder.updateMessageSettings().build();
        this.deleteMessageSettings = settingsBuilder.deleteMessageSettings().build();
        this.getAttachmentSettings = settingsBuilder.getAttachmentSettings().build();
        this.uploadAttachmentSettings = settingsBuilder.uploadAttachmentSettings().build();
        this.listSpacesSettings = settingsBuilder.listSpacesSettings().build();
        this.searchSpacesSettings = settingsBuilder.searchSpacesSettings().build();
        this.getSpaceSettings = settingsBuilder.getSpaceSettings().build();
        this.createSpaceSettings = settingsBuilder.createSpaceSettings().build();
        this.setUpSpaceSettings = settingsBuilder.setUpSpaceSettings().build();
        this.updateSpaceSettings = settingsBuilder.updateSpaceSettings().build();
        this.deleteSpaceSettings = settingsBuilder.deleteSpaceSettings().build();
        this.completeImportSpaceSettings = settingsBuilder.completeImportSpaceSettings().build();
        this.findDirectMessageSettings = settingsBuilder.findDirectMessageSettings().build();
        this.createMembershipSettings = settingsBuilder.createMembershipSettings().build();
        this.updateMembershipSettings = settingsBuilder.updateMembershipSettings().build();
        this.deleteMembershipSettings = settingsBuilder.deleteMembershipSettings().build();
        this.createReactionSettings = settingsBuilder.createReactionSettings().build();
        this.listReactionsSettings = settingsBuilder.listReactionsSettings().build();
        this.deleteReactionSettings = settingsBuilder.deleteReactionSettings().build();
        this.getSpaceReadStateSettings = settingsBuilder.getSpaceReadStateSettings().build();
        this.updateSpaceReadStateSettings = settingsBuilder.updateSpaceReadStateSettings().build();
        this.getThreadReadStateSettings = settingsBuilder.getThreadReadStateSettings().build();
        this.getSpaceEventSettings = settingsBuilder.getSpaceEventSettings().build();
        this.listSpaceEventsSettings = settingsBuilder.listSpaceEventsSettings().build();
        this.getSpaceNotificationSettingSettings = settingsBuilder.getSpaceNotificationSettingSettings().build();
        this.updateSpaceNotificationSettingSettings = settingsBuilder.updateSpaceNotificationSettingSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ChatServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateMessageRequest, Message> createMessageSettings;
        private final PagedCallSettings.Builder<ListMessagesRequest, ListMessagesResponse, ChatServiceClient.ListMessagesPagedResponse> listMessagesSettings;
        private final PagedCallSettings.Builder<ListMembershipsRequest, ListMembershipsResponse, ChatServiceClient.ListMembershipsPagedResponse> listMembershipsSettings;
        private final UnaryCallSettings.Builder<GetMembershipRequest, Membership> getMembershipSettings;
        private final UnaryCallSettings.Builder<GetMessageRequest, Message> getMessageSettings;
        private final UnaryCallSettings.Builder<UpdateMessageRequest, Message> updateMessageSettings;
        private final UnaryCallSettings.Builder<DeleteMessageRequest, Empty> deleteMessageSettings;
        private final UnaryCallSettings.Builder<GetAttachmentRequest, Attachment> getAttachmentSettings;
        private final UnaryCallSettings.Builder<UploadAttachmentRequest, UploadAttachmentResponse> uploadAttachmentSettings;
        private final PagedCallSettings.Builder<ListSpacesRequest, ListSpacesResponse, ChatServiceClient.ListSpacesPagedResponse> listSpacesSettings;
        private final PagedCallSettings.Builder<SearchSpacesRequest, SearchSpacesResponse, ChatServiceClient.SearchSpacesPagedResponse> searchSpacesSettings;
        private final UnaryCallSettings.Builder<GetSpaceRequest, Space> getSpaceSettings;
        private final UnaryCallSettings.Builder<CreateSpaceRequest, Space> createSpaceSettings;
        private final UnaryCallSettings.Builder<SetUpSpaceRequest, Space> setUpSpaceSettings;
        private final UnaryCallSettings.Builder<UpdateSpaceRequest, Space> updateSpaceSettings;
        private final UnaryCallSettings.Builder<DeleteSpaceRequest, Empty> deleteSpaceSettings;
        private final UnaryCallSettings.Builder<CompleteImportSpaceRequest, CompleteImportSpaceResponse> completeImportSpaceSettings;
        private final UnaryCallSettings.Builder<FindDirectMessageRequest, Space> findDirectMessageSettings;
        private final UnaryCallSettings.Builder<CreateMembershipRequest, Membership> createMembershipSettings;
        private final UnaryCallSettings.Builder<UpdateMembershipRequest, Membership> updateMembershipSettings;
        private final UnaryCallSettings.Builder<DeleteMembershipRequest, Membership> deleteMembershipSettings;
        private final UnaryCallSettings.Builder<CreateReactionRequest, Reaction> createReactionSettings;
        private final PagedCallSettings.Builder<ListReactionsRequest, ListReactionsResponse, ChatServiceClient.ListReactionsPagedResponse> listReactionsSettings;
        private final UnaryCallSettings.Builder<DeleteReactionRequest, Empty> deleteReactionSettings;
        private final UnaryCallSettings.Builder<GetSpaceReadStateRequest, SpaceReadState> getSpaceReadStateSettings;
        private final UnaryCallSettings.Builder<UpdateSpaceReadStateRequest, SpaceReadState> updateSpaceReadStateSettings;
        private final UnaryCallSettings.Builder<GetThreadReadStateRequest, ThreadReadState> getThreadReadStateSettings;
        private final UnaryCallSettings.Builder<GetSpaceEventRequest, SpaceEvent> getSpaceEventSettings;
        private final PagedCallSettings.Builder<ListSpaceEventsRequest, ListSpaceEventsResponse, ChatServiceClient.ListSpaceEventsPagedResponse> listSpaceEventsSettings;
        private final UnaryCallSettings.Builder<GetSpaceNotificationSettingRequest, SpaceNotificationSetting> getSpaceNotificationSettingSettings;
        private final UnaryCallSettings.Builder<UpdateSpaceNotificationSettingRequest, SpaceNotificationSetting> updateSpaceNotificationSettingSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createMessageSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listMessagesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MESSAGES_PAGE_STR_FACT);
            this.listMembershipsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MEMBERSHIPS_PAGE_STR_FACT);
            this.getMembershipSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getMessageSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateMessageSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteMessageSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getAttachmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.uploadAttachmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSpacesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SPACES_PAGE_STR_FACT);
            this.searchSpacesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_SPACES_PAGE_STR_FACT);
            this.getSpaceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createSpaceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setUpSpaceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSpaceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSpaceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.completeImportSpaceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.findDirectMessageSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createMembershipSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateMembershipSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteMembershipSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createReactionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listReactionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_REACTIONS_PAGE_STR_FACT);
            this.deleteReactionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSpaceReadStateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSpaceReadStateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getThreadReadStateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSpaceEventSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSpaceEventsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SPACE_EVENTS_PAGE_STR_FACT);
            this.getSpaceNotificationSettingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSpaceNotificationSettingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createMessageSettings, this.listMessagesSettings, this.listMembershipsSettings, this.getMembershipSettings, this.getMessageSettings, this.updateMessageSettings, this.deleteMessageSettings, this.getAttachmentSettings, this.uploadAttachmentSettings, this.listSpacesSettings, this.searchSpacesSettings, this.getSpaceSettings, (Object[])new UnaryCallSettings.Builder[]{this.createSpaceSettings, this.setUpSpaceSettings, this.updateSpaceSettings, this.deleteSpaceSettings, this.completeImportSpaceSettings, this.findDirectMessageSettings, this.createMembershipSettings, this.updateMembershipSettings, this.deleteMembershipSettings, this.createReactionSettings, this.listReactionsSettings, this.deleteReactionSettings, this.getSpaceReadStateSettings, this.updateSpaceReadStateSettings, this.getThreadReadStateSettings, this.getSpaceEventSettings, this.listSpaceEventsSettings, this.getSpaceNotificationSettingSettings, this.updateSpaceNotificationSettingSettings});
            Builder.initDefaults(this);
        }

        protected Builder(ChatServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createMessageSettings = settings.createMessageSettings.toBuilder();
            this.listMessagesSettings = settings.listMessagesSettings.toBuilder();
            this.listMembershipsSettings = settings.listMembershipsSettings.toBuilder();
            this.getMembershipSettings = settings.getMembershipSettings.toBuilder();
            this.getMessageSettings = settings.getMessageSettings.toBuilder();
            this.updateMessageSettings = settings.updateMessageSettings.toBuilder();
            this.deleteMessageSettings = settings.deleteMessageSettings.toBuilder();
            this.getAttachmentSettings = settings.getAttachmentSettings.toBuilder();
            this.uploadAttachmentSettings = settings.uploadAttachmentSettings.toBuilder();
            this.listSpacesSettings = settings.listSpacesSettings.toBuilder();
            this.searchSpacesSettings = settings.searchSpacesSettings.toBuilder();
            this.getSpaceSettings = settings.getSpaceSettings.toBuilder();
            this.createSpaceSettings = settings.createSpaceSettings.toBuilder();
            this.setUpSpaceSettings = settings.setUpSpaceSettings.toBuilder();
            this.updateSpaceSettings = settings.updateSpaceSettings.toBuilder();
            this.deleteSpaceSettings = settings.deleteSpaceSettings.toBuilder();
            this.completeImportSpaceSettings = settings.completeImportSpaceSettings.toBuilder();
            this.findDirectMessageSettings = settings.findDirectMessageSettings.toBuilder();
            this.createMembershipSettings = settings.createMembershipSettings.toBuilder();
            this.updateMembershipSettings = settings.updateMembershipSettings.toBuilder();
            this.deleteMembershipSettings = settings.deleteMembershipSettings.toBuilder();
            this.createReactionSettings = settings.createReactionSettings.toBuilder();
            this.listReactionsSettings = settings.listReactionsSettings.toBuilder();
            this.deleteReactionSettings = settings.deleteReactionSettings.toBuilder();
            this.getSpaceReadStateSettings = settings.getSpaceReadStateSettings.toBuilder();
            this.updateSpaceReadStateSettings = settings.updateSpaceReadStateSettings.toBuilder();
            this.getThreadReadStateSettings = settings.getThreadReadStateSettings.toBuilder();
            this.getSpaceEventSettings = settings.getSpaceEventSettings.toBuilder();
            this.listSpaceEventsSettings = settings.listSpaceEventsSettings.toBuilder();
            this.getSpaceNotificationSettingSettings = settings.getSpaceNotificationSettingSettings.toBuilder();
            this.updateSpaceNotificationSettingSettings = settings.updateSpaceNotificationSettingSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createMessageSettings, this.listMessagesSettings, this.listMembershipsSettings, this.getMembershipSettings, this.getMessageSettings, this.updateMessageSettings, this.deleteMessageSettings, this.getAttachmentSettings, this.uploadAttachmentSettings, this.listSpacesSettings, this.searchSpacesSettings, this.getSpaceSettings, (Object[])new UnaryCallSettings.Builder[]{this.createSpaceSettings, this.setUpSpaceSettings, this.updateSpaceSettings, this.deleteSpaceSettings, this.completeImportSpaceSettings, this.findDirectMessageSettings, this.createMembershipSettings, this.updateMembershipSettings, this.deleteMembershipSettings, this.createReactionSettings, this.listReactionsSettings, this.deleteReactionSettings, this.getSpaceReadStateSettings, this.updateSpaceReadStateSettings, this.getThreadReadStateSettings, this.getSpaceEventSettings, this.listSpaceEventsSettings, this.getSpaceNotificationSettingSettings, this.updateSpaceNotificationSettingSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ChatServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ChatServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ChatServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ChatServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ChatServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ChatServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ChatServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ChatServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createMessageSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listMessagesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listMembershipsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getMembershipSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getMessageSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateMessageSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteMessageSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getAttachmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.uploadAttachmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listSpacesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.searchSpacesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getSpaceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createSpaceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.setUpSpaceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateSpaceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteSpaceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.completeImportSpaceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.findDirectMessageSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createMembershipSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateMembershipSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteMembershipSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createReactionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listReactionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteReactionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getSpaceReadStateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateSpaceReadStateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getThreadReadStateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getSpaceEventSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listSpaceEventsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getSpaceNotificationSettingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateSpaceNotificationSettingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateMessageRequest, Message> createMessageSettings() {
            return this.createMessageSettings;
        }

        public PagedCallSettings.Builder<ListMessagesRequest, ListMessagesResponse, ChatServiceClient.ListMessagesPagedResponse> listMessagesSettings() {
            return this.listMessagesSettings;
        }

        public PagedCallSettings.Builder<ListMembershipsRequest, ListMembershipsResponse, ChatServiceClient.ListMembershipsPagedResponse> listMembershipsSettings() {
            return this.listMembershipsSettings;
        }

        public UnaryCallSettings.Builder<GetMembershipRequest, Membership> getMembershipSettings() {
            return this.getMembershipSettings;
        }

        public UnaryCallSettings.Builder<GetMessageRequest, Message> getMessageSettings() {
            return this.getMessageSettings;
        }

        public UnaryCallSettings.Builder<UpdateMessageRequest, Message> updateMessageSettings() {
            return this.updateMessageSettings;
        }

        public UnaryCallSettings.Builder<DeleteMessageRequest, Empty> deleteMessageSettings() {
            return this.deleteMessageSettings;
        }

        public UnaryCallSettings.Builder<GetAttachmentRequest, Attachment> getAttachmentSettings() {
            return this.getAttachmentSettings;
        }

        public UnaryCallSettings.Builder<UploadAttachmentRequest, UploadAttachmentResponse> uploadAttachmentSettings() {
            return this.uploadAttachmentSettings;
        }

        public PagedCallSettings.Builder<ListSpacesRequest, ListSpacesResponse, ChatServiceClient.ListSpacesPagedResponse> listSpacesSettings() {
            return this.listSpacesSettings;
        }

        public PagedCallSettings.Builder<SearchSpacesRequest, SearchSpacesResponse, ChatServiceClient.SearchSpacesPagedResponse> searchSpacesSettings() {
            return this.searchSpacesSettings;
        }

        public UnaryCallSettings.Builder<GetSpaceRequest, Space> getSpaceSettings() {
            return this.getSpaceSettings;
        }

        public UnaryCallSettings.Builder<CreateSpaceRequest, Space> createSpaceSettings() {
            return this.createSpaceSettings;
        }

        public UnaryCallSettings.Builder<SetUpSpaceRequest, Space> setUpSpaceSettings() {
            return this.setUpSpaceSettings;
        }

        public UnaryCallSettings.Builder<UpdateSpaceRequest, Space> updateSpaceSettings() {
            return this.updateSpaceSettings;
        }

        public UnaryCallSettings.Builder<DeleteSpaceRequest, Empty> deleteSpaceSettings() {
            return this.deleteSpaceSettings;
        }

        public UnaryCallSettings.Builder<CompleteImportSpaceRequest, CompleteImportSpaceResponse> completeImportSpaceSettings() {
            return this.completeImportSpaceSettings;
        }

        public UnaryCallSettings.Builder<FindDirectMessageRequest, Space> findDirectMessageSettings() {
            return this.findDirectMessageSettings;
        }

        public UnaryCallSettings.Builder<CreateMembershipRequest, Membership> createMembershipSettings() {
            return this.createMembershipSettings;
        }

        public UnaryCallSettings.Builder<UpdateMembershipRequest, Membership> updateMembershipSettings() {
            return this.updateMembershipSettings;
        }

        public UnaryCallSettings.Builder<DeleteMembershipRequest, Membership> deleteMembershipSettings() {
            return this.deleteMembershipSettings;
        }

        public UnaryCallSettings.Builder<CreateReactionRequest, Reaction> createReactionSettings() {
            return this.createReactionSettings;
        }

        public PagedCallSettings.Builder<ListReactionsRequest, ListReactionsResponse, ChatServiceClient.ListReactionsPagedResponse> listReactionsSettings() {
            return this.listReactionsSettings;
        }

        public UnaryCallSettings.Builder<DeleteReactionRequest, Empty> deleteReactionSettings() {
            return this.deleteReactionSettings;
        }

        public UnaryCallSettings.Builder<GetSpaceReadStateRequest, SpaceReadState> getSpaceReadStateSettings() {
            return this.getSpaceReadStateSettings;
        }

        public UnaryCallSettings.Builder<UpdateSpaceReadStateRequest, SpaceReadState> updateSpaceReadStateSettings() {
            return this.updateSpaceReadStateSettings;
        }

        public UnaryCallSettings.Builder<GetThreadReadStateRequest, ThreadReadState> getThreadReadStateSettings() {
            return this.getThreadReadStateSettings;
        }

        public UnaryCallSettings.Builder<GetSpaceEventRequest, SpaceEvent> getSpaceEventSettings() {
            return this.getSpaceEventSettings;
        }

        public PagedCallSettings.Builder<ListSpaceEventsRequest, ListSpaceEventsResponse, ChatServiceClient.ListSpaceEventsPagedResponse> listSpaceEventsSettings() {
            return this.listSpaceEventsSettings;
        }

        public UnaryCallSettings.Builder<GetSpaceNotificationSettingRequest, SpaceNotificationSetting> getSpaceNotificationSettingSettings() {
            return this.getSpaceNotificationSettingSettings;
        }

        public UnaryCallSettings.Builder<UpdateSpaceNotificationSettingRequest, SpaceNotificationSetting> updateSpaceNotificationSettingSettings() {
            return this.updateSpaceNotificationSettingSettings;
        }

        public ChatServiceStubSettings build() throws IOException {
            return new ChatServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(30000L)).setTotalTimeoutDuration(Duration.ofMillis(30000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

