/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.channel.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.channel.v1.CloudChannelReportsServiceClient;
import com.google.cloud.channel.v1.FetchReportResultsRequest;
import com.google.cloud.channel.v1.FetchReportResultsResponse;
import com.google.cloud.channel.v1.ListReportsRequest;
import com.google.cloud.channel.v1.ListReportsResponse;
import com.google.cloud.channel.v1.OperationMetadata;
import com.google.cloud.channel.v1.Report;
import com.google.cloud.channel.v1.Row;
import com.google.cloud.channel.v1.RunReportJobRequest;
import com.google.cloud.channel.v1.RunReportJobResponse;
import com.google.cloud.channel.v1.stub.CloudChannelReportsServiceStub;
import com.google.cloud.channel.v1.stub.GrpcCloudChannelReportsServiceStub;
import com.google.cloud.channel.v1.stub.HttpJsonCloudChannelReportsServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@Deprecated
public class CloudChannelReportsServiceStubSettings
extends StubSettings<CloudChannelReportsServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/apps.reports.usage.readonly").build();
    private final UnaryCallSettings<RunReportJobRequest, Operation> runReportJobSettings;
    private final OperationCallSettings<RunReportJobRequest, RunReportJobResponse, OperationMetadata> runReportJobOperationSettings;
    private final PagedCallSettings<FetchReportResultsRequest, FetchReportResultsResponse, CloudChannelReportsServiceClient.FetchReportResultsPagedResponse> fetchReportResultsSettings;
    private final PagedCallSettings<ListReportsRequest, ListReportsResponse, CloudChannelReportsServiceClient.ListReportsPagedResponse> listReportsSettings;
    private static final PagedListDescriptor<FetchReportResultsRequest, FetchReportResultsResponse, Row> FETCH_REPORT_RESULTS_PAGE_STR_DESC = new PagedListDescriptor<FetchReportResultsRequest, FetchReportResultsResponse, Row>(){

        public String emptyToken() {
            return "";
        }

        public FetchReportResultsRequest injectToken(FetchReportResultsRequest payload, String token) {
            return FetchReportResultsRequest.newBuilder((FetchReportResultsRequest)payload).setPageToken(token).build();
        }

        public FetchReportResultsRequest injectPageSize(FetchReportResultsRequest payload, int pageSize) {
            return FetchReportResultsRequest.newBuilder((FetchReportResultsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(FetchReportResultsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(FetchReportResultsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Row> extractResources(FetchReportResultsResponse payload) {
            return payload.getRowsList() == null ? ImmutableList.of() : payload.getRowsList();
        }
    };
    private static final PagedListDescriptor<ListReportsRequest, ListReportsResponse, Report> LIST_REPORTS_PAGE_STR_DESC = new PagedListDescriptor<ListReportsRequest, ListReportsResponse, Report>(){

        public String emptyToken() {
            return "";
        }

        public ListReportsRequest injectToken(ListReportsRequest payload, String token) {
            return ListReportsRequest.newBuilder((ListReportsRequest)payload).setPageToken(token).build();
        }

        public ListReportsRequest injectPageSize(ListReportsRequest payload, int pageSize) {
            return ListReportsRequest.newBuilder((ListReportsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListReportsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListReportsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Report> extractResources(ListReportsResponse payload) {
            return payload.getReportsList() == null ? ImmutableList.of() : payload.getReportsList();
        }
    };
    private static final PagedListResponseFactory<FetchReportResultsRequest, FetchReportResultsResponse, CloudChannelReportsServiceClient.FetchReportResultsPagedResponse> FETCH_REPORT_RESULTS_PAGE_STR_FACT = new PagedListResponseFactory<FetchReportResultsRequest, FetchReportResultsResponse, CloudChannelReportsServiceClient.FetchReportResultsPagedResponse>(){

        public ApiFuture<CloudChannelReportsServiceClient.FetchReportResultsPagedResponse> getFuturePagedResponse(UnaryCallable<FetchReportResultsRequest, FetchReportResultsResponse> callable, FetchReportResultsRequest request, ApiCallContext context, ApiFuture<FetchReportResultsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)FETCH_REPORT_RESULTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudChannelReportsServiceClient.FetchReportResultsPagedResponse.createAsync((PageContext<FetchReportResultsRequest, FetchReportResultsResponse, Row>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListReportsRequest, ListReportsResponse, CloudChannelReportsServiceClient.ListReportsPagedResponse> LIST_REPORTS_PAGE_STR_FACT = new PagedListResponseFactory<ListReportsRequest, ListReportsResponse, CloudChannelReportsServiceClient.ListReportsPagedResponse>(){

        public ApiFuture<CloudChannelReportsServiceClient.ListReportsPagedResponse> getFuturePagedResponse(UnaryCallable<ListReportsRequest, ListReportsResponse> callable, ListReportsRequest request, ApiCallContext context, ApiFuture<ListReportsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_REPORTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudChannelReportsServiceClient.ListReportsPagedResponse.createAsync((PageContext<ListReportsRequest, ListReportsResponse, Report>)pageContext, futureResponse);
        }
    };

    @Deprecated
    public UnaryCallSettings<RunReportJobRequest, Operation> runReportJobSettings() {
        return this.runReportJobSettings;
    }

    public OperationCallSettings<RunReportJobRequest, RunReportJobResponse, OperationMetadata> runReportJobOperationSettings() {
        return this.runReportJobOperationSettings;
    }

    @Deprecated
    public PagedCallSettings<FetchReportResultsRequest, FetchReportResultsResponse, CloudChannelReportsServiceClient.FetchReportResultsPagedResponse> fetchReportResultsSettings() {
        return this.fetchReportResultsSettings;
    }

    @Deprecated
    public PagedCallSettings<ListReportsRequest, ListReportsResponse, CloudChannelReportsServiceClient.ListReportsPagedResponse> listReportsSettings() {
        return this.listReportsSettings;
    }

    public CloudChannelReportsServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCloudChannelReportsServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonCloudChannelReportsServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "cloudchannel";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "cloudchannel.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudchannel.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CloudChannelReportsServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CloudChannelReportsServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CloudChannelReportsServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return CloudChannelReportsServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CloudChannelReportsServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.runReportJobSettings = settingsBuilder.runReportJobSettings().build();
        this.runReportJobOperationSettings = settingsBuilder.runReportJobOperationSettings().build();
        this.fetchReportResultsSettings = settingsBuilder.fetchReportResultsSettings().build();
        this.listReportsSettings = settingsBuilder.listReportsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CloudChannelReportsServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<RunReportJobRequest, Operation> runReportJobSettings;
        private final OperationCallSettings.Builder<RunReportJobRequest, RunReportJobResponse, OperationMetadata> runReportJobOperationSettings;
        private final PagedCallSettings.Builder<FetchReportResultsRequest, FetchReportResultsResponse, CloudChannelReportsServiceClient.FetchReportResultsPagedResponse> fetchReportResultsSettings;
        private final PagedCallSettings.Builder<ListReportsRequest, ListReportsResponse, CloudChannelReportsServiceClient.ListReportsPagedResponse> listReportsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.runReportJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.runReportJobOperationSettings = OperationCallSettings.newBuilder();
            this.fetchReportResultsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)FETCH_REPORT_RESULTS_PAGE_STR_FACT);
            this.listReportsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_REPORTS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.runReportJobSettings, this.fetchReportResultsSettings, this.listReportsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(CloudChannelReportsServiceStubSettings settings) {
            super((StubSettings)settings);
            this.runReportJobSettings = settings.runReportJobSettings.toBuilder();
            this.runReportJobOperationSettings = settings.runReportJobOperationSettings.toBuilder();
            this.fetchReportResultsSettings = settings.fetchReportResultsSettings.toBuilder();
            this.listReportsSettings = settings.listReportsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.runReportJobSettings, this.fetchReportResultsSettings, this.listReportsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CloudChannelReportsServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CloudChannelReportsServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CloudChannelReportsServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(CloudChannelReportsServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(CloudChannelReportsServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)CloudChannelReportsServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)CloudChannelReportsServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CloudChannelReportsServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(CloudChannelReportsServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(CloudChannelReportsServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.runReportJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.fetchReportResultsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listReportsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.runReportJobOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(RunReportJobResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        @Deprecated
        public UnaryCallSettings.Builder<RunReportJobRequest, Operation> runReportJobSettings() {
            return this.runReportJobSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<RunReportJobRequest, RunReportJobResponse, OperationMetadata> runReportJobOperationSettings() {
            return this.runReportJobOperationSettings;
        }

        @Deprecated
        public PagedCallSettings.Builder<FetchReportResultsRequest, FetchReportResultsResponse, CloudChannelReportsServiceClient.FetchReportResultsPagedResponse> fetchReportResultsSettings() {
            return this.fetchReportResultsSettings;
        }

        @Deprecated
        public PagedCallSettings.Builder<ListReportsRequest, ListReportsResponse, CloudChannelReportsServiceClient.ListReportsPagedResponse> listReportsSettings() {
            return this.listReportsSettings;
        }

        public CloudChannelReportsServiceStubSettings build() throws IOException {
            return new CloudChannelReportsServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

