/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.devtools.cloudbuild.v1.stub;

import com.google.api.HttpRule;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.devtools.cloudbuild.v1.CloudBuildClient;
import com.google.cloud.devtools.cloudbuild.v1.stub.CloudBuildStub;
import com.google.cloud.devtools.cloudbuild.v1.stub.CloudBuildStubSettings;
import com.google.cloud.devtools.cloudbuild.v1.stub.HttpJsonCloudBuildCallableFactory;
import com.google.cloudbuild.v1.ApproveBuildRequest;
import com.google.cloudbuild.v1.Build;
import com.google.cloudbuild.v1.BuildOperationMetadata;
import com.google.cloudbuild.v1.BuildTrigger;
import com.google.cloudbuild.v1.CancelBuildRequest;
import com.google.cloudbuild.v1.CreateBuildRequest;
import com.google.cloudbuild.v1.CreateBuildTriggerRequest;
import com.google.cloudbuild.v1.CreateWorkerPoolOperationMetadata;
import com.google.cloudbuild.v1.CreateWorkerPoolRequest;
import com.google.cloudbuild.v1.DefaultServiceAccount;
import com.google.cloudbuild.v1.DeleteBuildTriggerRequest;
import com.google.cloudbuild.v1.DeleteWorkerPoolOperationMetadata;
import com.google.cloudbuild.v1.DeleteWorkerPoolRequest;
import com.google.cloudbuild.v1.GetBuildRequest;
import com.google.cloudbuild.v1.GetBuildTriggerRequest;
import com.google.cloudbuild.v1.GetDefaultServiceAccountRequest;
import com.google.cloudbuild.v1.GetWorkerPoolRequest;
import com.google.cloudbuild.v1.ListBuildTriggersRequest;
import com.google.cloudbuild.v1.ListBuildTriggersResponse;
import com.google.cloudbuild.v1.ListBuildsRequest;
import com.google.cloudbuild.v1.ListBuildsResponse;
import com.google.cloudbuild.v1.ListWorkerPoolsRequest;
import com.google.cloudbuild.v1.ListWorkerPoolsResponse;
import com.google.cloudbuild.v1.ReceiveTriggerWebhookRequest;
import com.google.cloudbuild.v1.ReceiveTriggerWebhookResponse;
import com.google.cloudbuild.v1.RetryBuildRequest;
import com.google.cloudbuild.v1.RunBuildTriggerRequest;
import com.google.cloudbuild.v1.UpdateBuildTriggerRequest;
import com.google.cloudbuild.v1.UpdateWorkerPoolOperationMetadata;
import com.google.cloudbuild.v1.UpdateWorkerPoolRequest;
import com.google.cloudbuild.v1.WorkerPool;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpJsonCloudBuildStub
extends CloudBuildStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Empty.getDescriptor()).add(DeleteWorkerPoolOperationMetadata.getDescriptor()).add(UpdateWorkerPoolOperationMetadata.getDescriptor()).add(Build.getDescriptor()).add(WorkerPool.getDescriptor()).add(CreateWorkerPoolOperationMetadata.getDescriptor()).add(BuildOperationMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<CreateBuildRequest, Operation> createBuildMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudbuild.v1.CloudBuild/CreateBuild").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}/builds", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{parent=projects/*/locations/*}/builds"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("build", (Message)request.getBuild(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetBuildRequest, Build> getBuildMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudbuild.v1.CloudBuild/GetBuild").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}/builds/{id}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "id", (Object)request.getId());
        serializer.putPathParam(fields, "name", (Object)request.getName());
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=projects/*/locations/*/builds/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Build.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListBuildsRequest, ListBuildsResponse> listBuildsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudbuild.v1.CloudBuild/ListBuilds").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}/builds", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{parent=projects/*/locations/*}/builds"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListBuildsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CancelBuildRequest, Build> cancelBuildMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudbuild.v1.CloudBuild/CancelBuild").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}/builds/{id}:cancel", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "id", (Object)request.getId());
        serializer.putPathParam(fields, "name", (Object)request.getName());
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=projects/*/locations/*/builds/*}:cancel"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearId().clearName().clearProjectId().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Build.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<RetryBuildRequest, Operation> retryBuildMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudbuild.v1.CloudBuild/RetryBuild").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}/builds/{id}:retry", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "id", (Object)request.getId());
        serializer.putPathParam(fields, "name", (Object)request.getName());
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=projects/*/locations/*/builds/*}:retry"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearId().clearName().clearProjectId().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ApproveBuildRequest, Operation> approveBuildMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudbuild.v1.CloudBuild/ApproveBuild").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/builds/*}:approve", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=projects/*/locations/*/builds/*}:approve"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<CreateBuildTriggerRequest, BuildTrigger> createBuildTriggerMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudbuild.v1.CloudBuild/CreateBuildTrigger").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}/triggers", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{parent=projects/*/locations/*}/triggers"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("trigger", (Message)request.getTrigger(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)BuildTrigger.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetBuildTriggerRequest, BuildTrigger> getBuildTriggerMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudbuild.v1.CloudBuild/GetBuildTrigger").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}/triggers/{triggerId}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        serializer.putPathParam(fields, "triggerId", (Object)request.getTriggerId());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=projects/*/locations/*/triggers/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)BuildTrigger.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListBuildTriggersRequest, ListBuildTriggersResponse> listBuildTriggersMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudbuild.v1.CloudBuild/ListBuildTriggers").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}/triggers", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{parent=projects/*/locations/*}/triggers"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListBuildTriggersResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteBuildTriggerRequest, Empty> deleteBuildTriggerMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudbuild.v1.CloudBuild/DeleteBuildTrigger").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}/triggers/{triggerId}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        serializer.putPathParam(fields, "triggerId", (Object)request.getTriggerId());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=projects/*/locations/*/triggers/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateBuildTriggerRequest, BuildTrigger> updateBuildTriggerMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudbuild.v1.CloudBuild/UpdateBuildTrigger").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}/triggers/{triggerId}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        serializer.putPathParam(fields, "trigger.resourceName", (Object)request.getTrigger().getResourceName());
        serializer.putPathParam(fields, "triggerId", (Object)request.getTriggerId());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{trigger.resourceName=projects/*/locations/*/triggers/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("trigger", (Message)request.getTrigger(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)BuildTrigger.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<RunBuildTriggerRequest, Operation> runBuildTriggerMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudbuild.v1.CloudBuild/RunBuildTrigger").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}/triggers/{triggerId}:run", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        serializer.putPathParam(fields, "triggerId", (Object)request.getTriggerId());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=projects/*/locations/*/triggers/*}:run"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("source", (Message)request.getSource(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ReceiveTriggerWebhookRequest, ReceiveTriggerWebhookResponse> receiveTriggerWebhookMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudbuild.v1.CloudBuild/ReceiveTriggerWebhook").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}/triggers/{trigger}:webhook", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        serializer.putPathParam(fields, "trigger", (Object)request.getTrigger());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=projects/*/locations/*/triggers/*}:webhook"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "secret", (Object)request.getSecret());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("body", (Message)request.getBody(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ReceiveTriggerWebhookResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateWorkerPoolRequest, Operation> createWorkerPoolMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudbuild.v1.CloudBuild/CreateWorkerPool").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/workerPools", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "workerPoolId", (Object)request.getWorkerPoolId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("workerPool", (Message)request.getWorkerPool(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetWorkerPoolRequest, WorkerPool> getWorkerPoolMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudbuild.v1.CloudBuild/GetWorkerPool").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/workerPools/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)WorkerPool.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteWorkerPoolRequest, Operation> deleteWorkerPoolMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudbuild.v1.CloudBuild/DeleteWorkerPool").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/workerPools/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "allowMissing", (Object)request.getAllowMissing());
        serializer.putQueryParam(fields, "etag", (Object)request.getEtag());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateWorkerPoolRequest, Operation> updateWorkerPoolMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudbuild.v1.CloudBuild/UpdateWorkerPool").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{workerPool.name=projects/*/locations/*/workerPools/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "workerPool.name", (Object)request.getWorkerPool().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("workerPool", (Message)request.getWorkerPool(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ListWorkerPoolsRequest, ListWorkerPoolsResponse> listWorkerPoolsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudbuild.v1.CloudBuild/ListWorkerPools").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/workerPools", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListWorkerPoolsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetDefaultServiceAccountRequest, DefaultServiceAccount> getDefaultServiceAccountMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudbuild.v1.CloudBuild/GetDefaultServiceAccount").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/defaultServiceAccount}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)DefaultServiceAccount.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateBuildRequest, Operation> createBuildCallable;
    private final OperationCallable<CreateBuildRequest, Build, BuildOperationMetadata> createBuildOperationCallable;
    private final UnaryCallable<GetBuildRequest, Build> getBuildCallable;
    private final UnaryCallable<ListBuildsRequest, ListBuildsResponse> listBuildsCallable;
    private final UnaryCallable<ListBuildsRequest, CloudBuildClient.ListBuildsPagedResponse> listBuildsPagedCallable;
    private final UnaryCallable<CancelBuildRequest, Build> cancelBuildCallable;
    private final UnaryCallable<RetryBuildRequest, Operation> retryBuildCallable;
    private final OperationCallable<RetryBuildRequest, Build, BuildOperationMetadata> retryBuildOperationCallable;
    private final UnaryCallable<ApproveBuildRequest, Operation> approveBuildCallable;
    private final OperationCallable<ApproveBuildRequest, Build, BuildOperationMetadata> approveBuildOperationCallable;
    private final UnaryCallable<CreateBuildTriggerRequest, BuildTrigger> createBuildTriggerCallable;
    private final UnaryCallable<GetBuildTriggerRequest, BuildTrigger> getBuildTriggerCallable;
    private final UnaryCallable<ListBuildTriggersRequest, ListBuildTriggersResponse> listBuildTriggersCallable;
    private final UnaryCallable<ListBuildTriggersRequest, CloudBuildClient.ListBuildTriggersPagedResponse> listBuildTriggersPagedCallable;
    private final UnaryCallable<DeleteBuildTriggerRequest, Empty> deleteBuildTriggerCallable;
    private final UnaryCallable<UpdateBuildTriggerRequest, BuildTrigger> updateBuildTriggerCallable;
    private final UnaryCallable<RunBuildTriggerRequest, Operation> runBuildTriggerCallable;
    private final OperationCallable<RunBuildTriggerRequest, Build, BuildOperationMetadata> runBuildTriggerOperationCallable;
    private final UnaryCallable<ReceiveTriggerWebhookRequest, ReceiveTriggerWebhookResponse> receiveTriggerWebhookCallable;
    private final UnaryCallable<CreateWorkerPoolRequest, Operation> createWorkerPoolCallable;
    private final OperationCallable<CreateWorkerPoolRequest, WorkerPool, CreateWorkerPoolOperationMetadata> createWorkerPoolOperationCallable;
    private final UnaryCallable<GetWorkerPoolRequest, WorkerPool> getWorkerPoolCallable;
    private final UnaryCallable<DeleteWorkerPoolRequest, Operation> deleteWorkerPoolCallable;
    private final OperationCallable<DeleteWorkerPoolRequest, Empty, DeleteWorkerPoolOperationMetadata> deleteWorkerPoolOperationCallable;
    private final UnaryCallable<UpdateWorkerPoolRequest, Operation> updateWorkerPoolCallable;
    private final OperationCallable<UpdateWorkerPoolRequest, WorkerPool, UpdateWorkerPoolOperationMetadata> updateWorkerPoolOperationCallable;
    private final UnaryCallable<ListWorkerPoolsRequest, ListWorkerPoolsResponse> listWorkerPoolsCallable;
    private final UnaryCallable<ListWorkerPoolsRequest, CloudBuildClient.ListWorkerPoolsPagedResponse> listWorkerPoolsPagedCallable;
    private final UnaryCallable<GetDefaultServiceAccountRequest, DefaultServiceAccount> getDefaultServiceAccountCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;
    private static final PathTemplate CREATE_BUILD_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}");
    private static final PathTemplate GET_BUILD_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}/builds/*");
    private static final PathTemplate LIST_BUILDS_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}");
    private static final PathTemplate CANCEL_BUILD_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}/builds/*");
    private static final PathTemplate RETRY_BUILD_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}/builds/*");
    private static final PathTemplate APPROVE_BUILD_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}/builds/*");
    private static final PathTemplate CREATE_BUILD_TRIGGER_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}");
    private static final PathTemplate GET_BUILD_TRIGGER_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}/triggers/*");
    private static final PathTemplate LIST_BUILD_TRIGGERS_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}");
    private static final PathTemplate DELETE_BUILD_TRIGGER_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}/triggers/*");
    private static final PathTemplate UPDATE_BUILD_TRIGGER_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}/triggers/*");
    private static final PathTemplate RUN_BUILD_TRIGGER_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}/triggers/*");
    private static final PathTemplate CREATE_WORKER_POOL_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}");
    private static final PathTemplate GET_WORKER_POOL_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}/workerPools/*");
    private static final PathTemplate DELETE_WORKER_POOL_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}/workerPools/*");
    private static final PathTemplate UPDATE_WORKER_POOL_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}/workerPools/*");
    private static final PathTemplate LIST_WORKER_POOLS_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}");
    private static final PathTemplate GET_DEFAULT_SERVICE_ACCOUNT_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}/defaultServiceAccount");

    public static final HttpJsonCloudBuildStub create(CloudBuildStubSettings settings) throws IOException {
        return new HttpJsonCloudBuildStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonCloudBuildStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonCloudBuildStub(CloudBuildStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonCloudBuildStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonCloudBuildStub(CloudBuildStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonCloudBuildStub(CloudBuildStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonCloudBuildCallableFactory());
    }

    protected HttpJsonCloudBuildStub(CloudBuildStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.CancelOperation", (Object)HttpRule.newBuilder().setPost("/v1/{name=operations/**}:cancel").addAdditionalBindings(HttpRule.newBuilder().setPost("/v1/{name=projects/*/locations/*/operations/*}:cancel").build()).build()).put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1/{name=operations/**}").addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/operations/*}").build()).build()).build());
        HttpJsonCallSettings createBuildTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createBuildMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getParent(), "location", CREATE_BUILD_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        HttpJsonCallSettings getBuildTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getBuildMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "location", GET_BUILD_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        HttpJsonCallSettings listBuildsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listBuildsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getParent(), "location", LIST_BUILDS_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        HttpJsonCallSettings cancelBuildTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(cancelBuildMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "location", CANCEL_BUILD_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        HttpJsonCallSettings retryBuildTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(retryBuildMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "location", RETRY_BUILD_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        HttpJsonCallSettings approveBuildTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(approveBuildMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "location", APPROVE_BUILD_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        HttpJsonCallSettings createBuildTriggerTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createBuildTriggerMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getParent(), "location", CREATE_BUILD_TRIGGER_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        HttpJsonCallSettings getBuildTriggerTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getBuildTriggerMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "location", GET_BUILD_TRIGGER_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        HttpJsonCallSettings listBuildTriggersTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listBuildTriggersMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getParent(), "location", LIST_BUILD_TRIGGERS_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteBuildTriggerTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteBuildTriggerMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "location", DELETE_BUILD_TRIGGER_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        HttpJsonCallSettings updateBuildTriggerTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateBuildTriggerMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            if (request.getTrigger() != null) {
                builder.add(request.getTrigger().getResourceName(), "location", UPDATE_BUILD_TRIGGER_0_PATH_TEMPLATE);
            }
            return builder.build();
        }).build();
        HttpJsonCallSettings runBuildTriggerTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(runBuildTriggerMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "location", RUN_BUILD_TRIGGER_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        HttpJsonCallSettings receiveTriggerWebhookTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(receiveTriggerWebhookMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            builder.add("project_id", String.valueOf(request.getProjectId()));
            builder.add("trigger", String.valueOf(request.getTrigger()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createWorkerPoolTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createWorkerPoolMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getParent(), "location", CREATE_WORKER_POOL_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        HttpJsonCallSettings getWorkerPoolTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getWorkerPoolMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "location", GET_WORKER_POOL_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteWorkerPoolTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteWorkerPoolMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "location", DELETE_WORKER_POOL_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        HttpJsonCallSettings updateWorkerPoolTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateWorkerPoolMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            if (request.getWorkerPool() != null) {
                builder.add(request.getWorkerPool().getName(), "location", UPDATE_WORKER_POOL_0_PATH_TEMPLATE);
            }
            return builder.build();
        }).build();
        HttpJsonCallSettings listWorkerPoolsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listWorkerPoolsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getParent(), "location", LIST_WORKER_POOLS_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        HttpJsonCallSettings getDefaultServiceAccountTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getDefaultServiceAccountMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "location", GET_DEFAULT_SERVICE_ACCOUNT_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        this.createBuildCallable = callableFactory.createUnaryCallable(createBuildTransportSettings, settings.createBuildSettings(), clientContext);
        this.createBuildOperationCallable = callableFactory.createOperationCallable(createBuildTransportSettings, settings.createBuildOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getBuildCallable = callableFactory.createUnaryCallable(getBuildTransportSettings, settings.getBuildSettings(), clientContext);
        this.listBuildsCallable = callableFactory.createUnaryCallable(listBuildsTransportSettings, settings.listBuildsSettings(), clientContext);
        this.listBuildsPagedCallable = callableFactory.createPagedCallable(listBuildsTransportSettings, settings.listBuildsSettings(), clientContext);
        this.cancelBuildCallable = callableFactory.createUnaryCallable(cancelBuildTransportSettings, settings.cancelBuildSettings(), clientContext);
        this.retryBuildCallable = callableFactory.createUnaryCallable(retryBuildTransportSettings, settings.retryBuildSettings(), clientContext);
        this.retryBuildOperationCallable = callableFactory.createOperationCallable(retryBuildTransportSettings, settings.retryBuildOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.approveBuildCallable = callableFactory.createUnaryCallable(approveBuildTransportSettings, settings.approveBuildSettings(), clientContext);
        this.approveBuildOperationCallable = callableFactory.createOperationCallable(approveBuildTransportSettings, settings.approveBuildOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.createBuildTriggerCallable = callableFactory.createUnaryCallable(createBuildTriggerTransportSettings, settings.createBuildTriggerSettings(), clientContext);
        this.getBuildTriggerCallable = callableFactory.createUnaryCallable(getBuildTriggerTransportSettings, settings.getBuildTriggerSettings(), clientContext);
        this.listBuildTriggersCallable = callableFactory.createUnaryCallable(listBuildTriggersTransportSettings, settings.listBuildTriggersSettings(), clientContext);
        this.listBuildTriggersPagedCallable = callableFactory.createPagedCallable(listBuildTriggersTransportSettings, settings.listBuildTriggersSettings(), clientContext);
        this.deleteBuildTriggerCallable = callableFactory.createUnaryCallable(deleteBuildTriggerTransportSettings, settings.deleteBuildTriggerSettings(), clientContext);
        this.updateBuildTriggerCallable = callableFactory.createUnaryCallable(updateBuildTriggerTransportSettings, settings.updateBuildTriggerSettings(), clientContext);
        this.runBuildTriggerCallable = callableFactory.createUnaryCallable(runBuildTriggerTransportSettings, settings.runBuildTriggerSettings(), clientContext);
        this.runBuildTriggerOperationCallable = callableFactory.createOperationCallable(runBuildTriggerTransportSettings, settings.runBuildTriggerOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.receiveTriggerWebhookCallable = callableFactory.createUnaryCallable(receiveTriggerWebhookTransportSettings, settings.receiveTriggerWebhookSettings(), clientContext);
        this.createWorkerPoolCallable = callableFactory.createUnaryCallable(createWorkerPoolTransportSettings, settings.createWorkerPoolSettings(), clientContext);
        this.createWorkerPoolOperationCallable = callableFactory.createOperationCallable(createWorkerPoolTransportSettings, settings.createWorkerPoolOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getWorkerPoolCallable = callableFactory.createUnaryCallable(getWorkerPoolTransportSettings, settings.getWorkerPoolSettings(), clientContext);
        this.deleteWorkerPoolCallable = callableFactory.createUnaryCallable(deleteWorkerPoolTransportSettings, settings.deleteWorkerPoolSettings(), clientContext);
        this.deleteWorkerPoolOperationCallable = callableFactory.createOperationCallable(deleteWorkerPoolTransportSettings, settings.deleteWorkerPoolOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateWorkerPoolCallable = callableFactory.createUnaryCallable(updateWorkerPoolTransportSettings, settings.updateWorkerPoolSettings(), clientContext);
        this.updateWorkerPoolOperationCallable = callableFactory.createOperationCallable(updateWorkerPoolTransportSettings, settings.updateWorkerPoolOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listWorkerPoolsCallable = callableFactory.createUnaryCallable(listWorkerPoolsTransportSettings, settings.listWorkerPoolsSettings(), clientContext);
        this.listWorkerPoolsPagedCallable = callableFactory.createPagedCallable(listWorkerPoolsTransportSettings, settings.listWorkerPoolsSettings(), clientContext);
        this.getDefaultServiceAccountCallable = callableFactory.createUnaryCallable(getDefaultServiceAccountTransportSettings, settings.getDefaultServiceAccountSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createBuildMethodDescriptor);
        methodDescriptors.add(getBuildMethodDescriptor);
        methodDescriptors.add(listBuildsMethodDescriptor);
        methodDescriptors.add(cancelBuildMethodDescriptor);
        methodDescriptors.add(retryBuildMethodDescriptor);
        methodDescriptors.add(approveBuildMethodDescriptor);
        methodDescriptors.add(createBuildTriggerMethodDescriptor);
        methodDescriptors.add(getBuildTriggerMethodDescriptor);
        methodDescriptors.add(listBuildTriggersMethodDescriptor);
        methodDescriptors.add(deleteBuildTriggerMethodDescriptor);
        methodDescriptors.add(updateBuildTriggerMethodDescriptor);
        methodDescriptors.add(runBuildTriggerMethodDescriptor);
        methodDescriptors.add(receiveTriggerWebhookMethodDescriptor);
        methodDescriptors.add(createWorkerPoolMethodDescriptor);
        methodDescriptors.add(getWorkerPoolMethodDescriptor);
        methodDescriptors.add(deleteWorkerPoolMethodDescriptor);
        methodDescriptors.add(updateWorkerPoolMethodDescriptor);
        methodDescriptors.add(listWorkerPoolsMethodDescriptor);
        methodDescriptors.add(getDefaultServiceAccountMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<CreateBuildRequest, Operation> createBuildCallable() {
        return this.createBuildCallable;
    }

    @Override
    public OperationCallable<CreateBuildRequest, Build, BuildOperationMetadata> createBuildOperationCallable() {
        return this.createBuildOperationCallable;
    }

    @Override
    public UnaryCallable<GetBuildRequest, Build> getBuildCallable() {
        return this.getBuildCallable;
    }

    @Override
    public UnaryCallable<ListBuildsRequest, ListBuildsResponse> listBuildsCallable() {
        return this.listBuildsCallable;
    }

    @Override
    public UnaryCallable<ListBuildsRequest, CloudBuildClient.ListBuildsPagedResponse> listBuildsPagedCallable() {
        return this.listBuildsPagedCallable;
    }

    @Override
    public UnaryCallable<CancelBuildRequest, Build> cancelBuildCallable() {
        return this.cancelBuildCallable;
    }

    @Override
    public UnaryCallable<RetryBuildRequest, Operation> retryBuildCallable() {
        return this.retryBuildCallable;
    }

    @Override
    public OperationCallable<RetryBuildRequest, Build, BuildOperationMetadata> retryBuildOperationCallable() {
        return this.retryBuildOperationCallable;
    }

    @Override
    public UnaryCallable<ApproveBuildRequest, Operation> approveBuildCallable() {
        return this.approveBuildCallable;
    }

    @Override
    public OperationCallable<ApproveBuildRequest, Build, BuildOperationMetadata> approveBuildOperationCallable() {
        return this.approveBuildOperationCallable;
    }

    @Override
    public UnaryCallable<CreateBuildTriggerRequest, BuildTrigger> createBuildTriggerCallable() {
        return this.createBuildTriggerCallable;
    }

    @Override
    public UnaryCallable<GetBuildTriggerRequest, BuildTrigger> getBuildTriggerCallable() {
        return this.getBuildTriggerCallable;
    }

    @Override
    public UnaryCallable<ListBuildTriggersRequest, ListBuildTriggersResponse> listBuildTriggersCallable() {
        return this.listBuildTriggersCallable;
    }

    @Override
    public UnaryCallable<ListBuildTriggersRequest, CloudBuildClient.ListBuildTriggersPagedResponse> listBuildTriggersPagedCallable() {
        return this.listBuildTriggersPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteBuildTriggerRequest, Empty> deleteBuildTriggerCallable() {
        return this.deleteBuildTriggerCallable;
    }

    @Override
    public UnaryCallable<UpdateBuildTriggerRequest, BuildTrigger> updateBuildTriggerCallable() {
        return this.updateBuildTriggerCallable;
    }

    @Override
    public UnaryCallable<RunBuildTriggerRequest, Operation> runBuildTriggerCallable() {
        return this.runBuildTriggerCallable;
    }

    @Override
    public OperationCallable<RunBuildTriggerRequest, Build, BuildOperationMetadata> runBuildTriggerOperationCallable() {
        return this.runBuildTriggerOperationCallable;
    }

    @Override
    public UnaryCallable<ReceiveTriggerWebhookRequest, ReceiveTriggerWebhookResponse> receiveTriggerWebhookCallable() {
        return this.receiveTriggerWebhookCallable;
    }

    @Override
    public UnaryCallable<CreateWorkerPoolRequest, Operation> createWorkerPoolCallable() {
        return this.createWorkerPoolCallable;
    }

    @Override
    public OperationCallable<CreateWorkerPoolRequest, WorkerPool, CreateWorkerPoolOperationMetadata> createWorkerPoolOperationCallable() {
        return this.createWorkerPoolOperationCallable;
    }

    @Override
    public UnaryCallable<GetWorkerPoolRequest, WorkerPool> getWorkerPoolCallable() {
        return this.getWorkerPoolCallable;
    }

    @Override
    public UnaryCallable<DeleteWorkerPoolRequest, Operation> deleteWorkerPoolCallable() {
        return this.deleteWorkerPoolCallable;
    }

    @Override
    public OperationCallable<DeleteWorkerPoolRequest, Empty, DeleteWorkerPoolOperationMetadata> deleteWorkerPoolOperationCallable() {
        return this.deleteWorkerPoolOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateWorkerPoolRequest, Operation> updateWorkerPoolCallable() {
        return this.updateWorkerPoolCallable;
    }

    @Override
    public OperationCallable<UpdateWorkerPoolRequest, WorkerPool, UpdateWorkerPoolOperationMetadata> updateWorkerPoolOperationCallable() {
        return this.updateWorkerPoolOperationCallable;
    }

    @Override
    public UnaryCallable<ListWorkerPoolsRequest, ListWorkerPoolsResponse> listWorkerPoolsCallable() {
        return this.listWorkerPoolsCallable;
    }

    @Override
    public UnaryCallable<ListWorkerPoolsRequest, CloudBuildClient.ListWorkerPoolsPagedResponse> listWorkerPoolsPagedCallable() {
        return this.listWorkerPoolsPagedCallable;
    }

    @Override
    public UnaryCallable<GetDefaultServiceAccountRequest, DefaultServiceAccount> getDefaultServiceAccountCallable() {
        return this.getDefaultServiceAccountCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

