/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.devtools.cloudbuild.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.devtools.cloudbuild.v2.RepositoryManagerClient;
import com.google.cloud.devtools.cloudbuild.v2.stub.GrpcRepositoryManagerCallableFactory;
import com.google.cloud.devtools.cloudbuild.v2.stub.RepositoryManagerStub;
import com.google.cloud.devtools.cloudbuild.v2.stub.RepositoryManagerStubSettings;
import com.google.cloudbuild.v2.BatchCreateRepositoriesRequest;
import com.google.cloudbuild.v2.BatchCreateRepositoriesResponse;
import com.google.cloudbuild.v2.Connection;
import com.google.cloudbuild.v2.CreateConnectionRequest;
import com.google.cloudbuild.v2.CreateRepositoryRequest;
import com.google.cloudbuild.v2.DeleteConnectionRequest;
import com.google.cloudbuild.v2.DeleteRepositoryRequest;
import com.google.cloudbuild.v2.FetchLinkableRepositoriesRequest;
import com.google.cloudbuild.v2.FetchLinkableRepositoriesResponse;
import com.google.cloudbuild.v2.FetchReadTokenRequest;
import com.google.cloudbuild.v2.FetchReadTokenResponse;
import com.google.cloudbuild.v2.FetchReadWriteTokenRequest;
import com.google.cloudbuild.v2.FetchReadWriteTokenResponse;
import com.google.cloudbuild.v2.GetConnectionRequest;
import com.google.cloudbuild.v2.GetRepositoryRequest;
import com.google.cloudbuild.v2.ListConnectionsRequest;
import com.google.cloudbuild.v2.ListConnectionsResponse;
import com.google.cloudbuild.v2.ListRepositoriesRequest;
import com.google.cloudbuild.v2.ListRepositoriesResponse;
import com.google.cloudbuild.v2.OperationMetadata;
import com.google.cloudbuild.v2.Repository;
import com.google.cloudbuild.v2.UpdateConnectionRequest;
import com.google.common.collect.ImmutableMap;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcRepositoryManagerStub
extends RepositoryManagerStub {
    private static final MethodDescriptor<CreateConnectionRequest, Operation> createConnectionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.cloudbuild.v2.RepositoryManager/CreateConnection").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateConnectionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetConnectionRequest, Connection> getConnectionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.cloudbuild.v2.RepositoryManager/GetConnection").setRequestMarshaller(ProtoUtils.marshaller((Message)GetConnectionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Connection.getDefaultInstance())).build();
    private static final MethodDescriptor<ListConnectionsRequest, ListConnectionsResponse> listConnectionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.cloudbuild.v2.RepositoryManager/ListConnections").setRequestMarshaller(ProtoUtils.marshaller((Message)ListConnectionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListConnectionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateConnectionRequest, Operation> updateConnectionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.cloudbuild.v2.RepositoryManager/UpdateConnection").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateConnectionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteConnectionRequest, Operation> deleteConnectionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.cloudbuild.v2.RepositoryManager/DeleteConnection").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteConnectionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateRepositoryRequest, Operation> createRepositoryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.cloudbuild.v2.RepositoryManager/CreateRepository").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateRepositoryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<BatchCreateRepositoriesRequest, Operation> batchCreateRepositoriesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.cloudbuild.v2.RepositoryManager/BatchCreateRepositories").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchCreateRepositoriesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetRepositoryRequest, Repository> getRepositoryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.cloudbuild.v2.RepositoryManager/GetRepository").setRequestMarshaller(ProtoUtils.marshaller((Message)GetRepositoryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Repository.getDefaultInstance())).build();
    private static final MethodDescriptor<ListRepositoriesRequest, ListRepositoriesResponse> listRepositoriesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.cloudbuild.v2.RepositoryManager/ListRepositories").setRequestMarshaller(ProtoUtils.marshaller((Message)ListRepositoriesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListRepositoriesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteRepositoryRequest, Operation> deleteRepositoryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.cloudbuild.v2.RepositoryManager/DeleteRepository").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteRepositoryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<FetchReadWriteTokenRequest, FetchReadWriteTokenResponse> fetchReadWriteTokenMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.cloudbuild.v2.RepositoryManager/FetchReadWriteToken").setRequestMarshaller(ProtoUtils.marshaller((Message)FetchReadWriteTokenRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)FetchReadWriteTokenResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<FetchReadTokenRequest, FetchReadTokenResponse> fetchReadTokenMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.cloudbuild.v2.RepositoryManager/FetchReadToken").setRequestMarshaller(ProtoUtils.marshaller((Message)FetchReadTokenRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)FetchReadTokenResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<FetchLinkableRepositoriesRequest, FetchLinkableRepositoriesResponse> fetchLinkableRepositoriesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.cloudbuild.v2.RepositoryManager/FetchLinkableRepositories").setRequestMarshaller(ProtoUtils.marshaller((Message)FetchLinkableRepositoriesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)FetchLinkableRepositoriesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).build();
    private final UnaryCallable<CreateConnectionRequest, Operation> createConnectionCallable;
    private final OperationCallable<CreateConnectionRequest, Connection, OperationMetadata> createConnectionOperationCallable;
    private final UnaryCallable<GetConnectionRequest, Connection> getConnectionCallable;
    private final UnaryCallable<ListConnectionsRequest, ListConnectionsResponse> listConnectionsCallable;
    private final UnaryCallable<ListConnectionsRequest, RepositoryManagerClient.ListConnectionsPagedResponse> listConnectionsPagedCallable;
    private final UnaryCallable<UpdateConnectionRequest, Operation> updateConnectionCallable;
    private final OperationCallable<UpdateConnectionRequest, Connection, OperationMetadata> updateConnectionOperationCallable;
    private final UnaryCallable<DeleteConnectionRequest, Operation> deleteConnectionCallable;
    private final OperationCallable<DeleteConnectionRequest, Empty, OperationMetadata> deleteConnectionOperationCallable;
    private final UnaryCallable<CreateRepositoryRequest, Operation> createRepositoryCallable;
    private final OperationCallable<CreateRepositoryRequest, Repository, OperationMetadata> createRepositoryOperationCallable;
    private final UnaryCallable<BatchCreateRepositoriesRequest, Operation> batchCreateRepositoriesCallable;
    private final OperationCallable<BatchCreateRepositoriesRequest, BatchCreateRepositoriesResponse, OperationMetadata> batchCreateRepositoriesOperationCallable;
    private final UnaryCallable<GetRepositoryRequest, Repository> getRepositoryCallable;
    private final UnaryCallable<ListRepositoriesRequest, ListRepositoriesResponse> listRepositoriesCallable;
    private final UnaryCallable<ListRepositoriesRequest, RepositoryManagerClient.ListRepositoriesPagedResponse> listRepositoriesPagedCallable;
    private final UnaryCallable<DeleteRepositoryRequest, Operation> deleteRepositoryCallable;
    private final OperationCallable<DeleteRepositoryRequest, Empty, OperationMetadata> deleteRepositoryOperationCallable;
    private final UnaryCallable<FetchReadWriteTokenRequest, FetchReadWriteTokenResponse> fetchReadWriteTokenCallable;
    private final UnaryCallable<FetchReadTokenRequest, FetchReadTokenResponse> fetchReadTokenCallable;
    private final UnaryCallable<FetchLinkableRepositoriesRequest, FetchLinkableRepositoriesResponse> fetchLinkableRepositoriesCallable;
    private final UnaryCallable<FetchLinkableRepositoriesRequest, RepositoryManagerClient.FetchLinkableRepositoriesPagedResponse> fetchLinkableRepositoriesPagedCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcRepositoryManagerStub create(RepositoryManagerStubSettings settings) throws IOException {
        return new GrpcRepositoryManagerStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcRepositoryManagerStub create(ClientContext clientContext) throws IOException {
        return new GrpcRepositoryManagerStub(RepositoryManagerStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcRepositoryManagerStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcRepositoryManagerStub(RepositoryManagerStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcRepositoryManagerStub(RepositoryManagerStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcRepositoryManagerCallableFactory());
    }

    protected GrpcRepositoryManagerStub(RepositoryManagerStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createConnectionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createConnectionMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getConnectionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getConnectionMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listConnectionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listConnectionsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings updateConnectionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateConnectionMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"connection.name", (Object)String.valueOf(request.getConnection().getName()));
            return params.build();
        }).build();
        GrpcCallSettings deleteConnectionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteConnectionMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings createRepositoryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createRepositoryMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings batchCreateRepositoriesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchCreateRepositoriesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getRepositoryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getRepositoryMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listRepositoriesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listRepositoriesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings deleteRepositoryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteRepositoryMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings fetchReadWriteTokenTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(fetchReadWriteTokenMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"repository", (Object)String.valueOf(request.getRepository()));
            return params.build();
        }).build();
        GrpcCallSettings fetchReadTokenTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(fetchReadTokenMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"repository", (Object)String.valueOf(request.getRepository()));
            return params.build();
        }).build();
        GrpcCallSettings fetchLinkableRepositoriesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(fetchLinkableRepositoriesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"connection", (Object)String.valueOf(request.getConnection()));
            return params.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
            return params.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
            return params.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
            return params.build();
        }).build();
        this.createConnectionCallable = callableFactory.createUnaryCallable(createConnectionTransportSettings, settings.createConnectionSettings(), clientContext);
        this.createConnectionOperationCallable = callableFactory.createOperationCallable(createConnectionTransportSettings, settings.createConnectionOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getConnectionCallable = callableFactory.createUnaryCallable(getConnectionTransportSettings, settings.getConnectionSettings(), clientContext);
        this.listConnectionsCallable = callableFactory.createUnaryCallable(listConnectionsTransportSettings, settings.listConnectionsSettings(), clientContext);
        this.listConnectionsPagedCallable = callableFactory.createPagedCallable(listConnectionsTransportSettings, settings.listConnectionsSettings(), clientContext);
        this.updateConnectionCallable = callableFactory.createUnaryCallable(updateConnectionTransportSettings, settings.updateConnectionSettings(), clientContext);
        this.updateConnectionOperationCallable = callableFactory.createOperationCallable(updateConnectionTransportSettings, settings.updateConnectionOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteConnectionCallable = callableFactory.createUnaryCallable(deleteConnectionTransportSettings, settings.deleteConnectionSettings(), clientContext);
        this.deleteConnectionOperationCallable = callableFactory.createOperationCallable(deleteConnectionTransportSettings, settings.deleteConnectionOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.createRepositoryCallable = callableFactory.createUnaryCallable(createRepositoryTransportSettings, settings.createRepositorySettings(), clientContext);
        this.createRepositoryOperationCallable = callableFactory.createOperationCallable(createRepositoryTransportSettings, settings.createRepositoryOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.batchCreateRepositoriesCallable = callableFactory.createUnaryCallable(batchCreateRepositoriesTransportSettings, settings.batchCreateRepositoriesSettings(), clientContext);
        this.batchCreateRepositoriesOperationCallable = callableFactory.createOperationCallable(batchCreateRepositoriesTransportSettings, settings.batchCreateRepositoriesOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getRepositoryCallable = callableFactory.createUnaryCallable(getRepositoryTransportSettings, settings.getRepositorySettings(), clientContext);
        this.listRepositoriesCallable = callableFactory.createUnaryCallable(listRepositoriesTransportSettings, settings.listRepositoriesSettings(), clientContext);
        this.listRepositoriesPagedCallable = callableFactory.createPagedCallable(listRepositoriesTransportSettings, settings.listRepositoriesSettings(), clientContext);
        this.deleteRepositoryCallable = callableFactory.createUnaryCallable(deleteRepositoryTransportSettings, settings.deleteRepositorySettings(), clientContext);
        this.deleteRepositoryOperationCallable = callableFactory.createOperationCallable(deleteRepositoryTransportSettings, settings.deleteRepositoryOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.fetchReadWriteTokenCallable = callableFactory.createUnaryCallable(fetchReadWriteTokenTransportSettings, settings.fetchReadWriteTokenSettings(), clientContext);
        this.fetchReadTokenCallable = callableFactory.createUnaryCallable(fetchReadTokenTransportSettings, settings.fetchReadTokenSettings(), clientContext);
        this.fetchLinkableRepositoriesCallable = callableFactory.createUnaryCallable(fetchLinkableRepositoriesTransportSettings, settings.fetchLinkableRepositoriesSettings(), clientContext);
        this.fetchLinkableRepositoriesPagedCallable = callableFactory.createPagedCallable(fetchLinkableRepositoriesTransportSettings, settings.fetchLinkableRepositoriesSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateConnectionRequest, Operation> createConnectionCallable() {
        return this.createConnectionCallable;
    }

    @Override
    public OperationCallable<CreateConnectionRequest, Connection, OperationMetadata> createConnectionOperationCallable() {
        return this.createConnectionOperationCallable;
    }

    @Override
    public UnaryCallable<GetConnectionRequest, Connection> getConnectionCallable() {
        return this.getConnectionCallable;
    }

    @Override
    public UnaryCallable<ListConnectionsRequest, ListConnectionsResponse> listConnectionsCallable() {
        return this.listConnectionsCallable;
    }

    @Override
    public UnaryCallable<ListConnectionsRequest, RepositoryManagerClient.ListConnectionsPagedResponse> listConnectionsPagedCallable() {
        return this.listConnectionsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateConnectionRequest, Operation> updateConnectionCallable() {
        return this.updateConnectionCallable;
    }

    @Override
    public OperationCallable<UpdateConnectionRequest, Connection, OperationMetadata> updateConnectionOperationCallable() {
        return this.updateConnectionOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteConnectionRequest, Operation> deleteConnectionCallable() {
        return this.deleteConnectionCallable;
    }

    @Override
    public OperationCallable<DeleteConnectionRequest, Empty, OperationMetadata> deleteConnectionOperationCallable() {
        return this.deleteConnectionOperationCallable;
    }

    @Override
    public UnaryCallable<CreateRepositoryRequest, Operation> createRepositoryCallable() {
        return this.createRepositoryCallable;
    }

    @Override
    public OperationCallable<CreateRepositoryRequest, Repository, OperationMetadata> createRepositoryOperationCallable() {
        return this.createRepositoryOperationCallable;
    }

    @Override
    public UnaryCallable<BatchCreateRepositoriesRequest, Operation> batchCreateRepositoriesCallable() {
        return this.batchCreateRepositoriesCallable;
    }

    @Override
    public OperationCallable<BatchCreateRepositoriesRequest, BatchCreateRepositoriesResponse, OperationMetadata> batchCreateRepositoriesOperationCallable() {
        return this.batchCreateRepositoriesOperationCallable;
    }

    @Override
    public UnaryCallable<GetRepositoryRequest, Repository> getRepositoryCallable() {
        return this.getRepositoryCallable;
    }

    @Override
    public UnaryCallable<ListRepositoriesRequest, ListRepositoriesResponse> listRepositoriesCallable() {
        return this.listRepositoriesCallable;
    }

    @Override
    public UnaryCallable<ListRepositoriesRequest, RepositoryManagerClient.ListRepositoriesPagedResponse> listRepositoriesPagedCallable() {
        return this.listRepositoriesPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteRepositoryRequest, Operation> deleteRepositoryCallable() {
        return this.deleteRepositoryCallable;
    }

    @Override
    public OperationCallable<DeleteRepositoryRequest, Empty, OperationMetadata> deleteRepositoryOperationCallable() {
        return this.deleteRepositoryOperationCallable;
    }

    @Override
    public UnaryCallable<FetchReadWriteTokenRequest, FetchReadWriteTokenResponse> fetchReadWriteTokenCallable() {
        return this.fetchReadWriteTokenCallable;
    }

    @Override
    public UnaryCallable<FetchReadTokenRequest, FetchReadTokenResponse> fetchReadTokenCallable() {
        return this.fetchReadTokenCallable;
    }

    @Override
    public UnaryCallable<FetchLinkableRepositoriesRequest, FetchLinkableRepositoriesResponse> fetchLinkableRepositoriesCallable() {
        return this.fetchLinkableRepositoriesCallable;
    }

    @Override
    public UnaryCallable<FetchLinkableRepositoriesRequest, RepositoryManagerClient.FetchLinkableRepositoriesPagedResponse> fetchLinkableRepositoriesPagedCallable() {
        return this.fetchLinkableRepositoriesPagedCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

