/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.devtools.cloudbuild.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.devtools.cloudbuild.v1.CloudBuildClient;
import com.google.cloud.devtools.cloudbuild.v1.stub.CloudBuildStub;
import com.google.cloud.devtools.cloudbuild.v1.stub.GrpcCloudBuildStub;
import com.google.cloudbuild.v1.Build;
import com.google.cloudbuild.v1.BuildTrigger;
import com.google.cloudbuild.v1.CancelBuildRequest;
import com.google.cloudbuild.v1.CreateBuildRequest;
import com.google.cloudbuild.v1.CreateBuildTriggerRequest;
import com.google.cloudbuild.v1.CreateWorkerPoolRequest;
import com.google.cloudbuild.v1.DeleteBuildTriggerRequest;
import com.google.cloudbuild.v1.DeleteWorkerPoolRequest;
import com.google.cloudbuild.v1.GetBuildRequest;
import com.google.cloudbuild.v1.GetBuildTriggerRequest;
import com.google.cloudbuild.v1.GetWorkerPoolRequest;
import com.google.cloudbuild.v1.ListBuildTriggersRequest;
import com.google.cloudbuild.v1.ListBuildTriggersResponse;
import com.google.cloudbuild.v1.ListBuildsRequest;
import com.google.cloudbuild.v1.ListBuildsResponse;
import com.google.cloudbuild.v1.ListWorkerPoolsRequest;
import com.google.cloudbuild.v1.ListWorkerPoolsResponse;
import com.google.cloudbuild.v1.RetryBuildRequest;
import com.google.cloudbuild.v1.RunBuildTriggerRequest;
import com.google.cloudbuild.v1.UpdateBuildTriggerRequest;
import com.google.cloudbuild.v1.UpdateWorkerPoolRequest;
import com.google.cloudbuild.v1.WorkerPool;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class CloudBuildStubSettings
extends StubSettings<CloudBuildStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateBuildRequest, Operation> createBuildSettings;
    private final UnaryCallSettings<GetBuildRequest, Build> getBuildSettings;
    private final PagedCallSettings<ListBuildsRequest, ListBuildsResponse, CloudBuildClient.ListBuildsPagedResponse> listBuildsSettings;
    private final UnaryCallSettings<CancelBuildRequest, Build> cancelBuildSettings;
    private final UnaryCallSettings<CreateBuildTriggerRequest, BuildTrigger> createBuildTriggerSettings;
    private final UnaryCallSettings<GetBuildTriggerRequest, BuildTrigger> getBuildTriggerSettings;
    private final UnaryCallSettings<ListBuildTriggersRequest, ListBuildTriggersResponse> listBuildTriggersSettings;
    private final UnaryCallSettings<DeleteBuildTriggerRequest, Empty> deleteBuildTriggerSettings;
    private final UnaryCallSettings<UpdateBuildTriggerRequest, BuildTrigger> updateBuildTriggerSettings;
    private final UnaryCallSettings<RunBuildTriggerRequest, Operation> runBuildTriggerSettings;
    private final UnaryCallSettings<RetryBuildRequest, Operation> retryBuildSettings;
    private final UnaryCallSettings<CreateWorkerPoolRequest, WorkerPool> createWorkerPoolSettings;
    private final UnaryCallSettings<GetWorkerPoolRequest, WorkerPool> getWorkerPoolSettings;
    private final UnaryCallSettings<DeleteWorkerPoolRequest, Empty> deleteWorkerPoolSettings;
    private final UnaryCallSettings<UpdateWorkerPoolRequest, WorkerPool> updateWorkerPoolSettings;
    private final UnaryCallSettings<ListWorkerPoolsRequest, ListWorkerPoolsResponse> listWorkerPoolsSettings;
    private static final PagedListDescriptor<ListBuildsRequest, ListBuildsResponse, Build> LIST_BUILDS_PAGE_STR_DESC = new PagedListDescriptor<ListBuildsRequest, ListBuildsResponse, Build>(){

        public String emptyToken() {
            return "";
        }

        public ListBuildsRequest injectToken(ListBuildsRequest payload, String token) {
            return ListBuildsRequest.newBuilder((ListBuildsRequest)payload).setPageToken(token).build();
        }

        public ListBuildsRequest injectPageSize(ListBuildsRequest payload, int pageSize) {
            return ListBuildsRequest.newBuilder((ListBuildsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListBuildsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListBuildsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Build> extractResources(ListBuildsResponse payload) {
            return payload.getBuildsList() != null ? payload.getBuildsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListBuildsRequest, ListBuildsResponse, CloudBuildClient.ListBuildsPagedResponse> LIST_BUILDS_PAGE_STR_FACT = new PagedListResponseFactory<ListBuildsRequest, ListBuildsResponse, CloudBuildClient.ListBuildsPagedResponse>(){

        public ApiFuture<CloudBuildClient.ListBuildsPagedResponse> getFuturePagedResponse(UnaryCallable<ListBuildsRequest, ListBuildsResponse> callable, ListBuildsRequest request, ApiCallContext context, ApiFuture<ListBuildsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_BUILDS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudBuildClient.ListBuildsPagedResponse.createAsync((PageContext<ListBuildsRequest, ListBuildsResponse, Build>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateBuildRequest, Operation> createBuildSettings() {
        return this.createBuildSettings;
    }

    public UnaryCallSettings<GetBuildRequest, Build> getBuildSettings() {
        return this.getBuildSettings;
    }

    public PagedCallSettings<ListBuildsRequest, ListBuildsResponse, CloudBuildClient.ListBuildsPagedResponse> listBuildsSettings() {
        return this.listBuildsSettings;
    }

    public UnaryCallSettings<CancelBuildRequest, Build> cancelBuildSettings() {
        return this.cancelBuildSettings;
    }

    public UnaryCallSettings<CreateBuildTriggerRequest, BuildTrigger> createBuildTriggerSettings() {
        return this.createBuildTriggerSettings;
    }

    public UnaryCallSettings<GetBuildTriggerRequest, BuildTrigger> getBuildTriggerSettings() {
        return this.getBuildTriggerSettings;
    }

    public UnaryCallSettings<ListBuildTriggersRequest, ListBuildTriggersResponse> listBuildTriggersSettings() {
        return this.listBuildTriggersSettings;
    }

    public UnaryCallSettings<DeleteBuildTriggerRequest, Empty> deleteBuildTriggerSettings() {
        return this.deleteBuildTriggerSettings;
    }

    public UnaryCallSettings<UpdateBuildTriggerRequest, BuildTrigger> updateBuildTriggerSettings() {
        return this.updateBuildTriggerSettings;
    }

    public UnaryCallSettings<RunBuildTriggerRequest, Operation> runBuildTriggerSettings() {
        return this.runBuildTriggerSettings;
    }

    public UnaryCallSettings<RetryBuildRequest, Operation> retryBuildSettings() {
        return this.retryBuildSettings;
    }

    public UnaryCallSettings<CreateWorkerPoolRequest, WorkerPool> createWorkerPoolSettings() {
        return this.createWorkerPoolSettings;
    }

    public UnaryCallSettings<GetWorkerPoolRequest, WorkerPool> getWorkerPoolSettings() {
        return this.getWorkerPoolSettings;
    }

    public UnaryCallSettings<DeleteWorkerPoolRequest, Empty> deleteWorkerPoolSettings() {
        return this.deleteWorkerPoolSettings;
    }

    public UnaryCallSettings<UpdateWorkerPoolRequest, WorkerPool> updateWorkerPoolSettings() {
        return this.updateWorkerPoolSettings;
    }

    public UnaryCallSettings<ListWorkerPoolsRequest, ListWorkerPoolsResponse> listWorkerPoolsSettings() {
        return this.listWorkerPoolsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CloudBuildStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCloudBuildStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "cloudbuild.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CloudBuildStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CloudBuildStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CloudBuildStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createBuildSettings = settingsBuilder.createBuildSettings().build();
        this.getBuildSettings = settingsBuilder.getBuildSettings().build();
        this.listBuildsSettings = settingsBuilder.listBuildsSettings().build();
        this.cancelBuildSettings = settingsBuilder.cancelBuildSettings().build();
        this.createBuildTriggerSettings = settingsBuilder.createBuildTriggerSettings().build();
        this.getBuildTriggerSettings = settingsBuilder.getBuildTriggerSettings().build();
        this.listBuildTriggersSettings = settingsBuilder.listBuildTriggersSettings().build();
        this.deleteBuildTriggerSettings = settingsBuilder.deleteBuildTriggerSettings().build();
        this.updateBuildTriggerSettings = settingsBuilder.updateBuildTriggerSettings().build();
        this.runBuildTriggerSettings = settingsBuilder.runBuildTriggerSettings().build();
        this.retryBuildSettings = settingsBuilder.retryBuildSettings().build();
        this.createWorkerPoolSettings = settingsBuilder.createWorkerPoolSettings().build();
        this.getWorkerPoolSettings = settingsBuilder.getWorkerPoolSettings().build();
        this.deleteWorkerPoolSettings = settingsBuilder.deleteWorkerPoolSettings().build();
        this.updateWorkerPoolSettings = settingsBuilder.updateWorkerPoolSettings().build();
        this.listWorkerPoolsSettings = settingsBuilder.listWorkerPoolsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CloudBuildStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateBuildRequest, Operation> createBuildSettings;
        private final UnaryCallSettings.Builder<GetBuildRequest, Build> getBuildSettings;
        private final PagedCallSettings.Builder<ListBuildsRequest, ListBuildsResponse, CloudBuildClient.ListBuildsPagedResponse> listBuildsSettings;
        private final UnaryCallSettings.Builder<CancelBuildRequest, Build> cancelBuildSettings;
        private final UnaryCallSettings.Builder<CreateBuildTriggerRequest, BuildTrigger> createBuildTriggerSettings;
        private final UnaryCallSettings.Builder<GetBuildTriggerRequest, BuildTrigger> getBuildTriggerSettings;
        private final UnaryCallSettings.Builder<ListBuildTriggersRequest, ListBuildTriggersResponse> listBuildTriggersSettings;
        private final UnaryCallSettings.Builder<DeleteBuildTriggerRequest, Empty> deleteBuildTriggerSettings;
        private final UnaryCallSettings.Builder<UpdateBuildTriggerRequest, BuildTrigger> updateBuildTriggerSettings;
        private final UnaryCallSettings.Builder<RunBuildTriggerRequest, Operation> runBuildTriggerSettings;
        private final UnaryCallSettings.Builder<RetryBuildRequest, Operation> retryBuildSettings;
        private final UnaryCallSettings.Builder<CreateWorkerPoolRequest, WorkerPool> createWorkerPoolSettings;
        private final UnaryCallSettings.Builder<GetWorkerPoolRequest, WorkerPool> getWorkerPoolSettings;
        private final UnaryCallSettings.Builder<DeleteWorkerPoolRequest, Empty> deleteWorkerPoolSettings;
        private final UnaryCallSettings.Builder<UpdateWorkerPoolRequest, WorkerPool> updateWorkerPoolSettings;
        private final UnaryCallSettings.Builder<ListWorkerPoolsRequest, ListWorkerPoolsResponse> listWorkerPoolsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createBuildSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getBuildSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listBuildsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_BUILDS_PAGE_STR_FACT);
            this.cancelBuildSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createBuildTriggerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getBuildTriggerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listBuildTriggersSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteBuildTriggerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateBuildTriggerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.runBuildTriggerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.retryBuildSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createWorkerPoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getWorkerPoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteWorkerPoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateWorkerPoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listWorkerPoolsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createBuildSettings, this.getBuildSettings, this.listBuildsSettings, this.cancelBuildSettings, this.createBuildTriggerSettings, this.getBuildTriggerSettings, this.listBuildTriggersSettings, this.deleteBuildTriggerSettings, this.updateBuildTriggerSettings, this.runBuildTriggerSettings, this.retryBuildSettings, this.createWorkerPoolSettings, (Object[])new UnaryCallSettings.Builder[]{this.getWorkerPoolSettings, this.deleteWorkerPoolSettings, this.updateWorkerPoolSettings, this.listWorkerPoolsSettings});
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CloudBuildStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CloudBuildStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CloudBuildStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(CloudBuildStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createBuildSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getBuildSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listBuildsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.cancelBuildSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createBuildTriggerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getBuildTriggerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listBuildTriggersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteBuildTriggerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateBuildTriggerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.runBuildTriggerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.retryBuildSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createWorkerPoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getWorkerPoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteWorkerPoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateWorkerPoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listWorkerPoolsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(CloudBuildStubSettings settings) {
            super((StubSettings)settings);
            this.createBuildSettings = settings.createBuildSettings.toBuilder();
            this.getBuildSettings = settings.getBuildSettings.toBuilder();
            this.listBuildsSettings = settings.listBuildsSettings.toBuilder();
            this.cancelBuildSettings = settings.cancelBuildSettings.toBuilder();
            this.createBuildTriggerSettings = settings.createBuildTriggerSettings.toBuilder();
            this.getBuildTriggerSettings = settings.getBuildTriggerSettings.toBuilder();
            this.listBuildTriggersSettings = settings.listBuildTriggersSettings.toBuilder();
            this.deleteBuildTriggerSettings = settings.deleteBuildTriggerSettings.toBuilder();
            this.updateBuildTriggerSettings = settings.updateBuildTriggerSettings.toBuilder();
            this.runBuildTriggerSettings = settings.runBuildTriggerSettings.toBuilder();
            this.retryBuildSettings = settings.retryBuildSettings.toBuilder();
            this.createWorkerPoolSettings = settings.createWorkerPoolSettings.toBuilder();
            this.getWorkerPoolSettings = settings.getWorkerPoolSettings.toBuilder();
            this.deleteWorkerPoolSettings = settings.deleteWorkerPoolSettings.toBuilder();
            this.updateWorkerPoolSettings = settings.updateWorkerPoolSettings.toBuilder();
            this.listWorkerPoolsSettings = settings.listWorkerPoolsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createBuildSettings, this.getBuildSettings, this.listBuildsSettings, this.cancelBuildSettings, this.createBuildTriggerSettings, this.getBuildTriggerSettings, this.listBuildTriggersSettings, this.deleteBuildTriggerSettings, this.updateBuildTriggerSettings, this.runBuildTriggerSettings, this.retryBuildSettings, this.createWorkerPoolSettings, (Object[])new UnaryCallSettings.Builder[]{this.getWorkerPoolSettings, this.deleteWorkerPoolSettings, this.updateWorkerPoolSettings, this.listWorkerPoolsSettings});
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateBuildRequest, Operation> createBuildSettings() {
            return this.createBuildSettings;
        }

        public UnaryCallSettings.Builder<GetBuildRequest, Build> getBuildSettings() {
            return this.getBuildSettings;
        }

        public PagedCallSettings.Builder<ListBuildsRequest, ListBuildsResponse, CloudBuildClient.ListBuildsPagedResponse> listBuildsSettings() {
            return this.listBuildsSettings;
        }

        public UnaryCallSettings.Builder<CancelBuildRequest, Build> cancelBuildSettings() {
            return this.cancelBuildSettings;
        }

        public UnaryCallSettings.Builder<CreateBuildTriggerRequest, BuildTrigger> createBuildTriggerSettings() {
            return this.createBuildTriggerSettings;
        }

        public UnaryCallSettings.Builder<GetBuildTriggerRequest, BuildTrigger> getBuildTriggerSettings() {
            return this.getBuildTriggerSettings;
        }

        public UnaryCallSettings.Builder<ListBuildTriggersRequest, ListBuildTriggersResponse> listBuildTriggersSettings() {
            return this.listBuildTriggersSettings;
        }

        public UnaryCallSettings.Builder<DeleteBuildTriggerRequest, Empty> deleteBuildTriggerSettings() {
            return this.deleteBuildTriggerSettings;
        }

        public UnaryCallSettings.Builder<UpdateBuildTriggerRequest, BuildTrigger> updateBuildTriggerSettings() {
            return this.updateBuildTriggerSettings;
        }

        public UnaryCallSettings.Builder<RunBuildTriggerRequest, Operation> runBuildTriggerSettings() {
            return this.runBuildTriggerSettings;
        }

        public UnaryCallSettings.Builder<RetryBuildRequest, Operation> retryBuildSettings() {
            return this.retryBuildSettings;
        }

        public UnaryCallSettings.Builder<CreateWorkerPoolRequest, WorkerPool> createWorkerPoolSettings() {
            return this.createWorkerPoolSettings;
        }

        public UnaryCallSettings.Builder<GetWorkerPoolRequest, WorkerPool> getWorkerPoolSettings() {
            return this.getWorkerPoolSettings;
        }

        public UnaryCallSettings.Builder<DeleteWorkerPoolRequest, Empty> deleteWorkerPoolSettings() {
            return this.deleteWorkerPoolSettings;
        }

        public UnaryCallSettings.Builder<UpdateWorkerPoolRequest, WorkerPool> updateWorkerPoolSettings() {
            return this.updateWorkerPoolSettings;
        }

        public UnaryCallSettings.Builder<ListWorkerPoolsRequest, ListWorkerPoolsResponse> listWorkerPoolsSettings() {
            return this.listWorkerPoolsSettings;
        }

        public CloudBuildStubSettings build() throws IOException {
            return new CloudBuildStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

