/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.billing.budgets.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.billing.budgets.v1.BillingAccountName;
import com.google.cloud.billing.budgets.v1.Budget;
import com.google.cloud.billing.budgets.v1.BudgetName;
import com.google.cloud.billing.budgets.v1.BudgetServiceSettings;
import com.google.cloud.billing.budgets.v1.CreateBudgetRequest;
import com.google.cloud.billing.budgets.v1.DeleteBudgetRequest;
import com.google.cloud.billing.budgets.v1.GetBudgetRequest;
import com.google.cloud.billing.budgets.v1.ListBudgetsRequest;
import com.google.cloud.billing.budgets.v1.ListBudgetsResponse;
import com.google.cloud.billing.budgets.v1.UpdateBudgetRequest;
import com.google.cloud.billing.budgets.v1.stub.BudgetServiceStub;
import com.google.cloud.billing.budgets.v1.stub.BudgetServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class BudgetServiceClient
implements BackgroundResource {
    private final BudgetServiceSettings settings;
    private final BudgetServiceStub stub;

    public static final BudgetServiceClient create() throws IOException {
        return BudgetServiceClient.create(BudgetServiceSettings.newBuilder().build());
    }

    public static final BudgetServiceClient create(BudgetServiceSettings settings) throws IOException {
        return new BudgetServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final BudgetServiceClient create(BudgetServiceStub stub) {
        return new BudgetServiceClient(stub);
    }

    protected BudgetServiceClient(BudgetServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BudgetServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected BudgetServiceClient(BudgetServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final BudgetServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public BudgetServiceStub getStub() {
        return this.stub;
    }

    public final Budget createBudget(BillingAccountName parent, Budget budget) {
        CreateBudgetRequest request = CreateBudgetRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setBudget(budget).build();
        return this.createBudget(request);
    }

    public final Budget createBudget(String parent, Budget budget) {
        CreateBudgetRequest request = CreateBudgetRequest.newBuilder().setParent(parent).setBudget(budget).build();
        return this.createBudget(request);
    }

    public final Budget createBudget(CreateBudgetRequest request) {
        return (Budget)this.createBudgetCallable().call((Object)request);
    }

    public final UnaryCallable<CreateBudgetRequest, Budget> createBudgetCallable() {
        return this.stub.createBudgetCallable();
    }

    public final Budget updateBudget(Budget budget, FieldMask updateMask) {
        UpdateBudgetRequest request = UpdateBudgetRequest.newBuilder().setBudget(budget).setUpdateMask(updateMask).build();
        return this.updateBudget(request);
    }

    public final Budget updateBudget(UpdateBudgetRequest request) {
        return (Budget)this.updateBudgetCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateBudgetRequest, Budget> updateBudgetCallable() {
        return this.stub.updateBudgetCallable();
    }

    public final Budget getBudget(BudgetName name) {
        GetBudgetRequest request = GetBudgetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getBudget(request);
    }

    public final Budget getBudget(String name) {
        GetBudgetRequest request = GetBudgetRequest.newBuilder().setName(name).build();
        return this.getBudget(request);
    }

    public final Budget getBudget(GetBudgetRequest request) {
        return (Budget)this.getBudgetCallable().call((Object)request);
    }

    public final UnaryCallable<GetBudgetRequest, Budget> getBudgetCallable() {
        return this.stub.getBudgetCallable();
    }

    public final ListBudgetsPagedResponse listBudgets(BillingAccountName parent) {
        ListBudgetsRequest request = ListBudgetsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listBudgets(request);
    }

    public final ListBudgetsPagedResponse listBudgets(String parent) {
        ListBudgetsRequest request = ListBudgetsRequest.newBuilder().setParent(parent).build();
        return this.listBudgets(request);
    }

    public final ListBudgetsPagedResponse listBudgets(ListBudgetsRequest request) {
        return (ListBudgetsPagedResponse)((Object)this.listBudgetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBudgetsRequest, ListBudgetsPagedResponse> listBudgetsPagedCallable() {
        return this.stub.listBudgetsPagedCallable();
    }

    public final UnaryCallable<ListBudgetsRequest, ListBudgetsResponse> listBudgetsCallable() {
        return this.stub.listBudgetsCallable();
    }

    public final void deleteBudget(BudgetName name) {
        DeleteBudgetRequest request = DeleteBudgetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteBudget(request);
    }

    public final void deleteBudget(String name) {
        DeleteBudgetRequest request = DeleteBudgetRequest.newBuilder().setName(name).build();
        this.deleteBudget(request);
    }

    public final void deleteBudget(DeleteBudgetRequest request) {
        this.deleteBudgetCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteBudgetRequest, Empty> deleteBudgetCallable() {
        return this.stub.deleteBudgetCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListBudgetsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBudgetsRequest, ListBudgetsResponse, Budget, ListBudgetsPage, ListBudgetsFixedSizeCollection> {
        private ListBudgetsFixedSizeCollection(List<ListBudgetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBudgetsFixedSizeCollection createEmptyCollection() {
            return new ListBudgetsFixedSizeCollection(null, 0);
        }

        protected ListBudgetsFixedSizeCollection createCollection(List<ListBudgetsPage> pages, int collectionSize) {
            return new ListBudgetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBudgetsPage
    extends AbstractPage<ListBudgetsRequest, ListBudgetsResponse, Budget, ListBudgetsPage> {
        private ListBudgetsPage(PageContext<ListBudgetsRequest, ListBudgetsResponse, Budget> context, ListBudgetsResponse response) {
            super(context, (Object)response);
        }

        private static ListBudgetsPage createEmptyPage() {
            return new ListBudgetsPage(null, null);
        }

        protected ListBudgetsPage createPage(PageContext<ListBudgetsRequest, ListBudgetsResponse, Budget> context, ListBudgetsResponse response) {
            return new ListBudgetsPage(context, response);
        }

        public ApiFuture<ListBudgetsPage> createPageAsync(PageContext<ListBudgetsRequest, ListBudgetsResponse, Budget> context, ApiFuture<ListBudgetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBudgetsPagedResponse
    extends AbstractPagedListResponse<ListBudgetsRequest, ListBudgetsResponse, Budget, ListBudgetsPage, ListBudgetsFixedSizeCollection> {
        public static ApiFuture<ListBudgetsPagedResponse> createAsync(PageContext<ListBudgetsRequest, ListBudgetsResponse, Budget> context, ApiFuture<ListBudgetsResponse> futureResponse) {
            ApiFuture<ListBudgetsPage> futurePage = ListBudgetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListBudgetsPagedResponse((ListBudgetsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListBudgetsPagedResponse(ListBudgetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBudgetsFixedSizeCollection.createEmptyCollection());
        }
    }
}

