/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.billing.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.billing.v1.CloudCatalogSettings;
import com.google.cloud.billing.v1.ListServicesRequest;
import com.google.cloud.billing.v1.ListServicesResponse;
import com.google.cloud.billing.v1.ListSkusRequest;
import com.google.cloud.billing.v1.ListSkusResponse;
import com.google.cloud.billing.v1.Service;
import com.google.cloud.billing.v1.ServiceName;
import com.google.cloud.billing.v1.Sku;
import com.google.cloud.billing.v1.stub.CloudCatalogStub;
import com.google.cloud.billing.v1.stub.CloudCatalogStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class CloudCatalogClient
implements BackgroundResource {
    private final CloudCatalogSettings settings;
    private final CloudCatalogStub stub;

    public static final CloudCatalogClient create() throws IOException {
        return CloudCatalogClient.create(CloudCatalogSettings.newBuilder().build());
    }

    public static final CloudCatalogClient create(CloudCatalogSettings settings) throws IOException {
        return new CloudCatalogClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final CloudCatalogClient create(CloudCatalogStub stub) {
        return new CloudCatalogClient(stub);
    }

    protected CloudCatalogClient(CloudCatalogSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CloudCatalogStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected CloudCatalogClient(CloudCatalogStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CloudCatalogSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CloudCatalogStub getStub() {
        return this.stub;
    }

    public final ListServicesPagedResponse listServices() {
        ListServicesRequest request = ListServicesRequest.newBuilder().build();
        return this.listServices(request);
    }

    public final ListServicesPagedResponse listServices(ListServicesRequest request) {
        return (ListServicesPagedResponse)((Object)this.listServicesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListServicesRequest, ListServicesPagedResponse> listServicesPagedCallable() {
        return this.stub.listServicesPagedCallable();
    }

    public final UnaryCallable<ListServicesRequest, ListServicesResponse> listServicesCallable() {
        return this.stub.listServicesCallable();
    }

    public final ListSkusPagedResponse listSkus(ServiceName parent) {
        ListSkusRequest request = ListSkusRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSkus(request);
    }

    public final ListSkusPagedResponse listSkus(String parent) {
        ListSkusRequest request = ListSkusRequest.newBuilder().setParent(parent).build();
        return this.listSkus(request);
    }

    public final ListSkusPagedResponse listSkus(ListSkusRequest request) {
        return (ListSkusPagedResponse)((Object)this.listSkusPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSkusRequest, ListSkusPagedResponse> listSkusPagedCallable() {
        return this.stub.listSkusPagedCallable();
    }

    public final UnaryCallable<ListSkusRequest, ListSkusResponse> listSkusCallable() {
        return this.stub.listSkusCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListSkusFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSkusRequest, ListSkusResponse, Sku, ListSkusPage, ListSkusFixedSizeCollection> {
        private ListSkusFixedSizeCollection(List<ListSkusPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSkusFixedSizeCollection createEmptyCollection() {
            return new ListSkusFixedSizeCollection(null, 0);
        }

        protected ListSkusFixedSizeCollection createCollection(List<ListSkusPage> pages, int collectionSize) {
            return new ListSkusFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSkusPage
    extends AbstractPage<ListSkusRequest, ListSkusResponse, Sku, ListSkusPage> {
        private ListSkusPage(PageContext<ListSkusRequest, ListSkusResponse, Sku> context, ListSkusResponse response) {
            super(context, (Object)response);
        }

        private static ListSkusPage createEmptyPage() {
            return new ListSkusPage(null, null);
        }

        protected ListSkusPage createPage(PageContext<ListSkusRequest, ListSkusResponse, Sku> context, ListSkusResponse response) {
            return new ListSkusPage(context, response);
        }

        public ApiFuture<ListSkusPage> createPageAsync(PageContext<ListSkusRequest, ListSkusResponse, Sku> context, ApiFuture<ListSkusResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSkusPagedResponse
    extends AbstractPagedListResponse<ListSkusRequest, ListSkusResponse, Sku, ListSkusPage, ListSkusFixedSizeCollection> {
        public static ApiFuture<ListSkusPagedResponse> createAsync(PageContext<ListSkusRequest, ListSkusResponse, Sku> context, ApiFuture<ListSkusResponse> futureResponse) {
            ApiFuture<ListSkusPage> futurePage = ListSkusPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSkusPagedResponse((ListSkusPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSkusPagedResponse(ListSkusPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSkusFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListServicesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListServicesRequest, ListServicesResponse, Service, ListServicesPage, ListServicesFixedSizeCollection> {
        private ListServicesFixedSizeCollection(List<ListServicesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListServicesFixedSizeCollection createEmptyCollection() {
            return new ListServicesFixedSizeCollection(null, 0);
        }

        protected ListServicesFixedSizeCollection createCollection(List<ListServicesPage> pages, int collectionSize) {
            return new ListServicesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListServicesPage
    extends AbstractPage<ListServicesRequest, ListServicesResponse, Service, ListServicesPage> {
        private ListServicesPage(PageContext<ListServicesRequest, ListServicesResponse, Service> context, ListServicesResponse response) {
            super(context, (Object)response);
        }

        private static ListServicesPage createEmptyPage() {
            return new ListServicesPage(null, null);
        }

        protected ListServicesPage createPage(PageContext<ListServicesRequest, ListServicesResponse, Service> context, ListServicesResponse response) {
            return new ListServicesPage(context, response);
        }

        public ApiFuture<ListServicesPage> createPageAsync(PageContext<ListServicesRequest, ListServicesResponse, Service> context, ApiFuture<ListServicesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListServicesPagedResponse
    extends AbstractPagedListResponse<ListServicesRequest, ListServicesResponse, Service, ListServicesPage, ListServicesFixedSizeCollection> {
        public static ApiFuture<ListServicesPagedResponse> createAsync(PageContext<ListServicesRequest, ListServicesResponse, Service> context, ApiFuture<ListServicesResponse> futureResponse) {
            ApiFuture<ListServicesPage> futurePage = ListServicesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListServicesPagedResponse((ListServicesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListServicesPagedResponse(ListServicesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListServicesFixedSizeCollection.createEmptyCollection());
        }
    }
}

