/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.billing.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.billing.v1.BillingAccount;
import com.google.cloud.billing.v1.CloudBillingClient;
import com.google.cloud.billing.v1.CreateBillingAccountRequest;
import com.google.cloud.billing.v1.GetBillingAccountRequest;
import com.google.cloud.billing.v1.GetProjectBillingInfoRequest;
import com.google.cloud.billing.v1.ListBillingAccountsRequest;
import com.google.cloud.billing.v1.ListBillingAccountsResponse;
import com.google.cloud.billing.v1.ListProjectBillingInfoRequest;
import com.google.cloud.billing.v1.ListProjectBillingInfoResponse;
import com.google.cloud.billing.v1.ProjectBillingInfo;
import com.google.cloud.billing.v1.UpdateBillingAccountRequest;
import com.google.cloud.billing.v1.UpdateProjectBillingInfoRequest;
import com.google.cloud.billing.v1.stub.CloudBillingStub;
import com.google.cloud.billing.v1.stub.GrpcCloudBillingStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class CloudBillingStubSettings
extends StubSettings<CloudBillingStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GetBillingAccountRequest, BillingAccount> getBillingAccountSettings;
    private final PagedCallSettings<ListBillingAccountsRequest, ListBillingAccountsResponse, CloudBillingClient.ListBillingAccountsPagedResponse> listBillingAccountsSettings;
    private final UnaryCallSettings<UpdateBillingAccountRequest, BillingAccount> updateBillingAccountSettings;
    private final UnaryCallSettings<CreateBillingAccountRequest, BillingAccount> createBillingAccountSettings;
    private final PagedCallSettings<ListProjectBillingInfoRequest, ListProjectBillingInfoResponse, CloudBillingClient.ListProjectBillingInfoPagedResponse> listProjectBillingInfoSettings;
    private final UnaryCallSettings<GetProjectBillingInfoRequest, ProjectBillingInfo> getProjectBillingInfoSettings;
    private final UnaryCallSettings<UpdateProjectBillingInfoRequest, ProjectBillingInfo> updateProjectBillingInfoSettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListBillingAccountsRequest, ListBillingAccountsResponse, BillingAccount> LIST_BILLING_ACCOUNTS_PAGE_STR_DESC = new PagedListDescriptor<ListBillingAccountsRequest, ListBillingAccountsResponse, BillingAccount>(){

        public String emptyToken() {
            return "";
        }

        public ListBillingAccountsRequest injectToken(ListBillingAccountsRequest payload, String token) {
            return ListBillingAccountsRequest.newBuilder((ListBillingAccountsRequest)payload).setPageToken(token).build();
        }

        public ListBillingAccountsRequest injectPageSize(ListBillingAccountsRequest payload, int pageSize) {
            return ListBillingAccountsRequest.newBuilder((ListBillingAccountsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListBillingAccountsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListBillingAccountsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<BillingAccount> extractResources(ListBillingAccountsResponse payload) {
            return payload.getBillingAccountsList() != null ? payload.getBillingAccountsList() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListProjectBillingInfoRequest, ListProjectBillingInfoResponse, ProjectBillingInfo> LIST_PROJECT_BILLING_INFO_PAGE_STR_DESC = new PagedListDescriptor<ListProjectBillingInfoRequest, ListProjectBillingInfoResponse, ProjectBillingInfo>(){

        public String emptyToken() {
            return "";
        }

        public ListProjectBillingInfoRequest injectToken(ListProjectBillingInfoRequest payload, String token) {
            return ListProjectBillingInfoRequest.newBuilder((ListProjectBillingInfoRequest)payload).setPageToken(token).build();
        }

        public ListProjectBillingInfoRequest injectPageSize(ListProjectBillingInfoRequest payload, int pageSize) {
            return ListProjectBillingInfoRequest.newBuilder((ListProjectBillingInfoRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListProjectBillingInfoRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListProjectBillingInfoResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ProjectBillingInfo> extractResources(ListProjectBillingInfoResponse payload) {
            return payload.getProjectBillingInfoList() != null ? payload.getProjectBillingInfoList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListBillingAccountsRequest, ListBillingAccountsResponse, CloudBillingClient.ListBillingAccountsPagedResponse> LIST_BILLING_ACCOUNTS_PAGE_STR_FACT = new PagedListResponseFactory<ListBillingAccountsRequest, ListBillingAccountsResponse, CloudBillingClient.ListBillingAccountsPagedResponse>(){

        public ApiFuture<CloudBillingClient.ListBillingAccountsPagedResponse> getFuturePagedResponse(UnaryCallable<ListBillingAccountsRequest, ListBillingAccountsResponse> callable, ListBillingAccountsRequest request, ApiCallContext context, ApiFuture<ListBillingAccountsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_BILLING_ACCOUNTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudBillingClient.ListBillingAccountsPagedResponse.createAsync((PageContext<ListBillingAccountsRequest, ListBillingAccountsResponse, BillingAccount>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListProjectBillingInfoRequest, ListProjectBillingInfoResponse, CloudBillingClient.ListProjectBillingInfoPagedResponse> LIST_PROJECT_BILLING_INFO_PAGE_STR_FACT = new PagedListResponseFactory<ListProjectBillingInfoRequest, ListProjectBillingInfoResponse, CloudBillingClient.ListProjectBillingInfoPagedResponse>(){

        public ApiFuture<CloudBillingClient.ListProjectBillingInfoPagedResponse> getFuturePagedResponse(UnaryCallable<ListProjectBillingInfoRequest, ListProjectBillingInfoResponse> callable, ListProjectBillingInfoRequest request, ApiCallContext context, ApiFuture<ListProjectBillingInfoResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PROJECT_BILLING_INFO_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudBillingClient.ListProjectBillingInfoPagedResponse.createAsync((PageContext<ListProjectBillingInfoRequest, ListProjectBillingInfoResponse, ProjectBillingInfo>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetBillingAccountRequest, BillingAccount> getBillingAccountSettings() {
        return this.getBillingAccountSettings;
    }

    public PagedCallSettings<ListBillingAccountsRequest, ListBillingAccountsResponse, CloudBillingClient.ListBillingAccountsPagedResponse> listBillingAccountsSettings() {
        return this.listBillingAccountsSettings;
    }

    public UnaryCallSettings<UpdateBillingAccountRequest, BillingAccount> updateBillingAccountSettings() {
        return this.updateBillingAccountSettings;
    }

    public UnaryCallSettings<CreateBillingAccountRequest, BillingAccount> createBillingAccountSettings() {
        return this.createBillingAccountSettings;
    }

    public PagedCallSettings<ListProjectBillingInfoRequest, ListProjectBillingInfoResponse, CloudBillingClient.ListProjectBillingInfoPagedResponse> listProjectBillingInfoSettings() {
        return this.listProjectBillingInfoSettings;
    }

    public UnaryCallSettings<GetProjectBillingInfoRequest, ProjectBillingInfo> getProjectBillingInfoSettings() {
        return this.getProjectBillingInfoSettings;
    }

    public UnaryCallSettings<UpdateProjectBillingInfoRequest, ProjectBillingInfo> updateProjectBillingInfoSettings() {
        return this.updateProjectBillingInfoSettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CloudBillingStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCloudBillingStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "cloudbilling.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CloudBillingStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CloudBillingStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CloudBillingStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getBillingAccountSettings = settingsBuilder.getBillingAccountSettings().build();
        this.listBillingAccountsSettings = settingsBuilder.listBillingAccountsSettings().build();
        this.updateBillingAccountSettings = settingsBuilder.updateBillingAccountSettings().build();
        this.createBillingAccountSettings = settingsBuilder.createBillingAccountSettings().build();
        this.listProjectBillingInfoSettings = settingsBuilder.listProjectBillingInfoSettings().build();
        this.getProjectBillingInfoSettings = settingsBuilder.getProjectBillingInfoSettings().build();
        this.updateProjectBillingInfoSettings = settingsBuilder.updateProjectBillingInfoSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CloudBillingStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetBillingAccountRequest, BillingAccount> getBillingAccountSettings;
        private final PagedCallSettings.Builder<ListBillingAccountsRequest, ListBillingAccountsResponse, CloudBillingClient.ListBillingAccountsPagedResponse> listBillingAccountsSettings;
        private final UnaryCallSettings.Builder<UpdateBillingAccountRequest, BillingAccount> updateBillingAccountSettings;
        private final UnaryCallSettings.Builder<CreateBillingAccountRequest, BillingAccount> createBillingAccountSettings;
        private final PagedCallSettings.Builder<ListProjectBillingInfoRequest, ListProjectBillingInfoResponse, CloudBillingClient.ListProjectBillingInfoPagedResponse> listProjectBillingInfoSettings;
        private final UnaryCallSettings.Builder<GetProjectBillingInfoRequest, ProjectBillingInfo> getProjectBillingInfoSettings;
        private final UnaryCallSettings.Builder<UpdateProjectBillingInfoRequest, ProjectBillingInfo> updateProjectBillingInfoSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getBillingAccountSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listBillingAccountsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_BILLING_ACCOUNTS_PAGE_STR_FACT);
            this.updateBillingAccountSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createBillingAccountSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listProjectBillingInfoSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PROJECT_BILLING_INFO_PAGE_STR_FACT);
            this.getProjectBillingInfoSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateProjectBillingInfoSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getBillingAccountSettings, this.listBillingAccountsSettings, this.updateBillingAccountSettings, this.createBillingAccountSettings, this.listProjectBillingInfoSettings, this.getProjectBillingInfoSettings, this.updateProjectBillingInfoSettings, this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CloudBillingStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CloudBillingStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CloudBillingStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(CloudBillingStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getBillingAccountSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listBillingAccountsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateBillingAccountSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createBillingAccountSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listProjectBillingInfoSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getProjectBillingInfoSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateProjectBillingInfoSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(CloudBillingStubSettings settings) {
            super((StubSettings)settings);
            this.getBillingAccountSettings = settings.getBillingAccountSettings.toBuilder();
            this.listBillingAccountsSettings = settings.listBillingAccountsSettings.toBuilder();
            this.updateBillingAccountSettings = settings.updateBillingAccountSettings.toBuilder();
            this.createBillingAccountSettings = settings.createBillingAccountSettings.toBuilder();
            this.listProjectBillingInfoSettings = settings.listProjectBillingInfoSettings.toBuilder();
            this.getProjectBillingInfoSettings = settings.getProjectBillingInfoSettings.toBuilder();
            this.updateProjectBillingInfoSettings = settings.updateProjectBillingInfoSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getBillingAccountSettings, this.listBillingAccountsSettings, this.updateBillingAccountSettings, this.createBillingAccountSettings, this.listProjectBillingInfoSettings, this.getProjectBillingInfoSettings, this.updateProjectBillingInfoSettings, this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetBillingAccountRequest, BillingAccount> getBillingAccountSettings() {
            return this.getBillingAccountSettings;
        }

        public PagedCallSettings.Builder<ListBillingAccountsRequest, ListBillingAccountsResponse, CloudBillingClient.ListBillingAccountsPagedResponse> listBillingAccountsSettings() {
            return this.listBillingAccountsSettings;
        }

        public UnaryCallSettings.Builder<UpdateBillingAccountRequest, BillingAccount> updateBillingAccountSettings() {
            return this.updateBillingAccountSettings;
        }

        public UnaryCallSettings.Builder<CreateBillingAccountRequest, BillingAccount> createBillingAccountSettings() {
            return this.createBillingAccountSettings;
        }

        public PagedCallSettings.Builder<ListProjectBillingInfoRequest, ListProjectBillingInfoResponse, CloudBillingClient.ListProjectBillingInfoPagedResponse> listProjectBillingInfoSettings() {
            return this.listProjectBillingInfoSettings;
        }

        public UnaryCallSettings.Builder<GetProjectBillingInfoRequest, ProjectBillingInfo> getProjectBillingInfoSettings() {
            return this.getProjectBillingInfoSettings;
        }

        public UnaryCallSettings.Builder<UpdateProjectBillingInfoRequest, ProjectBillingInfo> updateProjectBillingInfoSettings() {
            return this.updateProjectBillingInfoSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public CloudBillingStubSettings build() throws IOException {
            return new CloudBillingStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

