package com.google.cloud.bigtable.data.v2.internal;

import com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata;
import com.google.protobuf.ByteString;
import java.time.Instant;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_PrepareResponse extends PrepareResponse {

  private final ResultSetMetadata resultSetMetadata;

  private final ByteString preparedQuery;

  private final Instant validUntil;

  AutoValue_PrepareResponse(
      ResultSetMetadata resultSetMetadata,
      ByteString preparedQuery,
      Instant validUntil) {
    if (resultSetMetadata == null) {
      throw new NullPointerException("Null resultSetMetadata");
    }
    this.resultSetMetadata = resultSetMetadata;
    if (preparedQuery == null) {
      throw new NullPointerException("Null preparedQuery");
    }
    this.preparedQuery = preparedQuery;
    if (validUntil == null) {
      throw new NullPointerException("Null validUntil");
    }
    this.validUntil = validUntil;
  }

  @Override
  public ResultSetMetadata resultSetMetadata() {
    return resultSetMetadata;
  }

  @Override
  public ByteString preparedQuery() {
    return preparedQuery;
  }

  @Override
  public Instant validUntil() {
    return validUntil;
  }

  @Override
  public String toString() {
    return "PrepareResponse{"
        + "resultSetMetadata=" + resultSetMetadata + ", "
        + "preparedQuery=" + preparedQuery + ", "
        + "validUntil=" + validUntil
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof PrepareResponse) {
      PrepareResponse that = (PrepareResponse) o;
      return this.resultSetMetadata.equals(that.resultSetMetadata())
          && this.preparedQuery.equals(that.preparedQuery())
          && this.validUntil.equals(that.validUntil());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= resultSetMetadata.hashCode();
    h$ *= 1000003;
    h$ ^= preparedQuery.hashCode();
    h$ *= 1000003;
    h$ ^= validUntil.hashCode();
    return h$;
  }

}
