/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.api.core.InternalApi;
import com.google.auto.value.AutoValue;
import com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.cloud.bigtable.data.v2.models.AutoValue_MaterializedViewId;
import com.google.cloud.bigtable.data.v2.models.TargetId;
import com.google.common.base.Preconditions;

@AutoValue
public abstract class MaterializedViewId
implements TargetId {
    public static MaterializedViewId of(String materializedViewId) {
        Preconditions.checkNotNull((Object)materializedViewId, (Object)"materialized view id can't be null.");
        return new AutoValue_MaterializedViewId(materializedViewId);
    }

    abstract String getMaterializedViewId();

    @Override
    @InternalApi
    public String toResourceName(String projectId, String instanceId) {
        return NameUtil.formatMaterializedViewName(projectId, instanceId, this.getMaterializedViewId());
    }

    @Override
    @InternalApi
    public boolean scopedForAuthorizedView() {
        return false;
    }

    @Override
    @InternalApi
    public boolean scopedForMaterializedView() {
        return true;
    }
}

