/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.retrying.ExponentialRetryAlgorithm;
import com.google.api.gax.retrying.RetryAlgorithm;
import com.google.api.gax.retrying.RetryingExecutorWithContext;
import com.google.api.gax.retrying.ScheduledRetryingExecutor;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.BatchingCallSettings;
import com.google.api.gax.rpc.BatchingDescriptor;
import com.google.api.gax.rpc.Callables;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.tracing.SpanName;
import com.google.api.gax.tracing.TracedBatchingCallable;
import com.google.api.gax.tracing.TracedServerStreamingCallable;
import com.google.api.gax.tracing.TracedUnaryCallable;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.SampleRowKeysRequest;
import com.google.bigtable.v2.SampleRowKeysResponse;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.BulkMutation;
import com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.cloud.bigtable.data.v2.models.DefaultRowAdapter;
import com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.ReadModifyWriteRow;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowAdapter;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.stub.BigtableStubSettings;
import com.google.cloud.bigtable.data.v2.stub.CheckAndMutateRowCallable;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import com.google.cloud.bigtable.data.v2.stub.GrpcBigtableStub;
import com.google.cloud.bigtable.data.v2.stub.MutateRowCallable;
import com.google.cloud.bigtable.data.v2.stub.ReadModifyWriteRowCallable;
import com.google.cloud.bigtable.data.v2.stub.SampleRowKeysCallable;
import com.google.cloud.bigtable.data.v2.stub.mutaterows.BulkMutateRowsUserFacingCallable;
import com.google.cloud.bigtable.data.v2.stub.mutaterows.MutateRowsBatchingDescriptor;
import com.google.cloud.bigtable.data.v2.stub.mutaterows.MutateRowsRetryingCallable;
import com.google.cloud.bigtable.data.v2.stub.mutaterows.MutateRowsUserFacingCallable;
import com.google.cloud.bigtable.data.v2.stub.readrows.FilterMarkerRowsCallable;
import com.google.cloud.bigtable.data.v2.stub.readrows.ReadRowsResumptionStrategy;
import com.google.cloud.bigtable.data.v2.stub.readrows.ReadRowsRetryCompletedCallable;
import com.google.cloud.bigtable.data.v2.stub.readrows.ReadRowsUserCallable;
import com.google.cloud.bigtable.data.v2.stub.readrows.RowMergingCallable;
import com.google.cloud.bigtable.gaxx.retrying.ApiResultRetryAlgorithm;
import com.google.cloud.bigtable.gaxx.tracing.WrappedTracerFactory;
import java.io.IOException;
import java.util.List;
import org.threeten.bp.Duration;

@InternalApi
public class EnhancedBigtableStub
implements AutoCloseable {
    private static final String TRACING_OUTER_CLIENT_NAME = "Bigtable";
    private static final String TRACING_INNER_CLIENT_NAME = "BaseBigtable";
    private final EnhancedBigtableStubSettings settings;
    private final GrpcBigtableStub stub;
    private final ClientContext clientContext;
    private final RequestContext requestContext;
    private final ServerStreamingCallable<Query, Row> readRowsCallable;
    private final UnaryCallable<Query, Row> readRowCallable;
    private final UnaryCallable<String, List<KeyOffset>> sampleRowKeysCallable;
    private final UnaryCallable<RowMutation, Void> mutateRowCallable;
    private final UnaryCallable<BulkMutation, Void> bulkMutateRowsCallable;
    private final UnaryCallable<RowMutation, Void> bulkMutateRowsBatchingCallable;
    private final UnaryCallable<ConditionalRowMutation, Boolean> checkAndMutateRowCallable;
    private final UnaryCallable<ReadModifyWriteRow, Row> readModifyWriteRowCallable;

    public static EnhancedBigtableStub create(EnhancedBigtableStubSettings settings) throws IOException {
        BigtableStubSettings.Builder baseSettingsBuilder = (BigtableStubSettings.Builder)((BigtableStubSettings.Builder)((BigtableStubSettings.Builder)((BigtableStubSettings.Builder)((BigtableStubSettings.Builder)((BigtableStubSettings.Builder)((BigtableStubSettings.Builder)BigtableStubSettings.newBuilder().setTransportChannelProvider(settings.getTransportChannelProvider())).setEndpoint(settings.getEndpoint())).setCredentialsProvider(settings.getCredentialsProvider())).setHeaderProvider(settings.getHeaderProvider())).setStreamWatchdogProvider(settings.getStreamWatchdogProvider())).setStreamWatchdogCheckInterval(settings.getStreamWatchdogCheckInterval())).setTracerFactory(new WrappedTracerFactory(settings.getTracerFactory(), TRACING_INNER_CLIENT_NAME));
        baseSettingsBuilder.readRowsSettings().setSimpleTimeoutNoRetries(Duration.ofHours((long)2L)).setRetryableCodes(settings.readRowsSettings().getRetryableCodes()).setIdleTimeout(Duration.ZERO);
        baseSettingsBuilder.sampleRowKeysSettings().setSimpleTimeoutNoRetries(settings.sampleRowKeysSettings().getRetrySettings().getTotalTimeout()).setRetryableCodes(settings.sampleRowKeysSettings().getRetryableCodes());
        baseSettingsBuilder.mutateRowSettings().setRetryableCodes(settings.mutateRowSettings().getRetryableCodes()).setRetrySettings(settings.mutateRowSettings().getRetrySettings());
        baseSettingsBuilder.mutateRowsSettings().setSimpleTimeoutNoRetries(Duration.ofMinutes((long)10L)).setRetryableCodes(settings.bulkMutateRowsSettings().getRetryableCodes()).setIdleTimeout(Duration.ZERO);
        baseSettingsBuilder.checkAndMutateRowSettings().setRetryableCodes(settings.checkAndMutateRowSettings().getRetryableCodes()).setRetrySettings(settings.checkAndMutateRowSettings().getRetrySettings());
        baseSettingsBuilder.readModifyWriteRowSettings().setRetryableCodes(settings.readModifyWriteRowSettings().getRetryableCodes()).setRetrySettings(settings.readModifyWriteRowSettings().getRetrySettings());
        BigtableStubSettings baseSettings = baseSettingsBuilder.build();
        ClientContext clientContext = ClientContext.create((StubSettings)baseSettings);
        GrpcBigtableStub stub = new GrpcBigtableStub(baseSettings, clientContext);
        clientContext = clientContext.toBuilder().setTracerFactory(settings.getTracerFactory()).build();
        return new EnhancedBigtableStub(settings, clientContext, stub);
    }

    @InternalApi(value="Visible for testing")
    EnhancedBigtableStub(EnhancedBigtableStubSettings settings, ClientContext clientContext, GrpcBigtableStub stub) {
        this.settings = settings;
        this.clientContext = clientContext;
        this.stub = stub;
        this.requestContext = RequestContext.create(settings.getProjectId(), settings.getInstanceId(), settings.getAppProfileId());
        this.readRowsCallable = this.createReadRowsCallable(new DefaultRowAdapter());
        this.readRowCallable = this.createReadRowCallable(new DefaultRowAdapter());
        this.sampleRowKeysCallable = this.createSampleRowKeysCallable();
        this.mutateRowCallable = this.createMutateRowCallable();
        this.bulkMutateRowsCallable = this.createBulkMutateRowsCallable();
        this.bulkMutateRowsBatchingCallable = this.createBulkMutateRowsBatchingCallable();
        this.checkAndMutateRowCallable = this.createCheckAndMutateRowCallable();
        this.readModifyWriteRowCallable = this.createReadModifyWriteRowCallable();
    }

    public <RowT> ServerStreamingCallable<Query, RowT> createReadRowsCallable(RowAdapter<RowT> rowAdapter) {
        return this.createReadRowsCallable(this.settings.readRowsSettings(), rowAdapter);
    }

    public <RowT> UnaryCallable<Query, RowT> createReadRowCallable(RowAdapter<RowT> rowAdapter) {
        return this.createReadRowsCallable((ServerStreamingCallSettings<Query, Row>)ServerStreamingCallSettings.newBuilder().setRetryableCodes(this.settings.readRowSettings().getRetryableCodes()).setRetrySettings(this.settings.readRowSettings().getRetrySettings()).setIdleTimeout(this.settings.readRowSettings().getRetrySettings().getTotalTimeout()).build(), rowAdapter).first();
    }

    private <RowT> ServerStreamingCallable<Query, RowT> createReadRowsCallable(ServerStreamingCallSettings<Query, Row> readRowsSettings, RowAdapter<RowT> rowAdapter) {
        RowMergingCallable<RowT> merging = new RowMergingCallable<RowT>(this.stub.readRowsCallable(), rowAdapter);
        ServerStreamingCallSettings innerSettings = ServerStreamingCallSettings.newBuilder().setResumptionStrategy(new ReadRowsResumptionStrategy<RowT>(rowAdapter)).setRetryableCodes(readRowsSettings.getRetryableCodes()).setRetrySettings(readRowsSettings.getRetrySettings()).setIdleTimeout(readRowsSettings.getIdleTimeout()).build();
        ReadRowsRetryCompletedCallable retrying1 = new ReadRowsRetryCompletedCallable(merging);
        ServerStreamingCallable retrying2 = Callables.retrying(retrying1, (ServerStreamingCallSettings)innerSettings, (ClientContext)this.clientContext);
        FilterMarkerRowsCallable<RowT> filtering = new FilterMarkerRowsCallable<RowT>(retrying2, rowAdapter);
        return this.createUserFacingServerStreamingCallable("ReadRows", new ReadRowsUserCallable(filtering, this.requestContext));
    }

    private UnaryCallable<String, List<KeyOffset>> createSampleRowKeysCallable() {
        UnaryCallable spoolable = this.stub.sampleRowKeysCallable().all();
        UnaryCallable retryable = Callables.retrying((UnaryCallable)spoolable, this.settings.sampleRowKeysSettings(), (ClientContext)this.clientContext);
        return this.createUserFacingUnaryCallable("SampleRowKeys", new SampleRowKeysCallable((UnaryCallable<SampleRowKeysRequest, List<SampleRowKeysResponse>>)retryable, this.requestContext));
    }

    private UnaryCallable<RowMutation, Void> createMutateRowCallable() {
        return this.createUserFacingUnaryCallable("MutateRow", new MutateRowCallable(this.stub.mutateRowCallable(), this.requestContext));
    }

    private UnaryCallable<BulkMutation, Void> createBulkMutateRowsCallable() {
        UnaryCallable<MutateRowsRequest, Void> baseCallable = this.createMutateRowsBaseCallable();
        return this.createUserFacingUnaryCallable("BulkMutateRows", new BulkMutateRowsUserFacingCallable(baseCallable, this.requestContext));
    }

    private UnaryCallable<RowMutation, Void> createBulkMutateRowsBatchingCallable() {
        UnaryCallable<MutateRowsRequest, Void> baseCallable = this.createMutateRowsBaseCallable();
        BatchingCallSettings.Builder batchingCallSettings = BatchingCallSettings.newBuilder((BatchingDescriptor)new MutateRowsBatchingDescriptor()).setBatchingSettings(this.settings.bulkMutateRowsSettings().getBatchingSettings());
        TracedBatchingCallable traced = new TracedBatchingCallable(baseCallable, this.clientContext.getTracerFactory(), SpanName.of((String)TRACING_OUTER_CLIENT_NAME, (String)"BulkMutateRows"), batchingCallSettings.getBatchingDescriptor());
        UnaryCallable batching = Callables.batching((UnaryCallable)traced, (BatchingCallSettings)batchingCallSettings.build(), (ClientContext)this.clientContext);
        MutateRowsUserFacingCallable userFacing = new MutateRowsUserFacingCallable((UnaryCallable<MutateRowsRequest, Void>)batching, this.requestContext);
        return userFacing.withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    private UnaryCallable<MutateRowsRequest, Void> createMutateRowsBaseCallable() {
        RetryAlgorithm retryAlgorithm = new RetryAlgorithm(new ApiResultRetryAlgorithm(), (TimedRetryAlgorithm)new ExponentialRetryAlgorithm(this.settings.bulkMutateRowsSettings().getRetrySettings(), this.clientContext.getClock()));
        ScheduledRetryingExecutor retryingExecutor = new ScheduledRetryingExecutor(retryAlgorithm, this.clientContext.getExecutor());
        return new MutateRowsRetryingCallable(this.clientContext.getDefaultCallContext(), this.stub.mutateRowsCallable(), (RetryingExecutorWithContext<Void>)retryingExecutor, this.settings.bulkMutateRowsSettings().getRetryableCodes());
    }

    private UnaryCallable<ConditionalRowMutation, Boolean> createCheckAndMutateRowCallable() {
        return this.createUserFacingUnaryCallable("CheckAndMutateRow", new CheckAndMutateRowCallable(this.stub.checkAndMutateRowCallable(), this.requestContext));
    }

    private UnaryCallable<ReadModifyWriteRow, Row> createReadModifyWriteRowCallable() {
        return this.createUserFacingUnaryCallable("ReadModifyWriteRow", new ReadModifyWriteRowCallable(this.stub.readModifyWriteRowCallable(), this.requestContext));
    }

    private <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createUserFacingUnaryCallable(String methodName, UnaryCallable<RequestT, ResponseT> inner) {
        TracedUnaryCallable traced = new TracedUnaryCallable(inner, this.clientContext.getTracerFactory(), SpanName.of((String)TRACING_OUTER_CLIENT_NAME, (String)methodName));
        return traced.withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    private <RequestT, ResponseT> ServerStreamingCallable<RequestT, ResponseT> createUserFacingServerStreamingCallable(String methodName, ServerStreamingCallable<RequestT, ResponseT> inner) {
        TracedServerStreamingCallable traced = new TracedServerStreamingCallable(inner, this.clientContext.getTracerFactory(), SpanName.of((String)TRACING_OUTER_CLIENT_NAME, (String)methodName));
        return traced.withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    public ServerStreamingCallable<Query, Row> readRowsCallable() {
        return this.readRowsCallable;
    }

    public UnaryCallable<Query, Row> readRowCallable() {
        return this.readRowCallable;
    }

    public UnaryCallable<String, List<KeyOffset>> sampleRowKeysCallable() {
        return this.sampleRowKeysCallable;
    }

    public UnaryCallable<RowMutation, Void> mutateRowCallable() {
        return this.mutateRowCallable;
    }

    public UnaryCallable<BulkMutation, Void> bulkMutateRowsCallable() {
        return this.bulkMutateRowsCallable;
    }

    public UnaryCallable<RowMutation, Void> bulkMutateRowsBatchingCallable() {
        return this.bulkMutateRowsBatchingCallable;
    }

    public UnaryCallable<ConditionalRowMutation, Boolean> checkAndMutateRowCallable() {
        return this.checkAndMutateRowCallable;
    }

    public UnaryCallable<ReadModifyWriteRow, Row> readModifyWriteRowCallable() {
        return this.readModifyWriteRowCallable;
    }

    @Override
    public void close() throws Exception {
        this.stub.close();
    }
}

