/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.cloud.bigquery.storage.v1.AnnotationsProto;
import com.google.cloud.bigquery.storage.v1.BigQuerySchemaUtil;
import com.google.cloud.bigquery.storage.v1.TableFieldSchema;
import com.google.cloud.bigquery.storage.v1.TableSchema;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class BQTableSchemaToProtoDescriptor {
    private static final Logger LOG = Logger.getLogger(BQTableSchemaToProtoDescriptor.class.getName());
    private static Map<TableFieldSchema.Mode, DescriptorProtos.FieldDescriptorProto.Label> DEFAULT_BQ_TABLE_SCHEMA_MODE_MAP = ImmutableMap.of((Object)TableFieldSchema.Mode.NULLABLE, (Object)DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL, (Object)TableFieldSchema.Mode.REPEATED, (Object)DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED, (Object)TableFieldSchema.Mode.REQUIRED, (Object)DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED);
    private static Map<TableFieldSchema.Type, DescriptorProtos.FieldDescriptorProto.Type> DEFAULT_BQ_TABLE_SCHEMA_TYPE_MAP = new ImmutableMap.Builder().put((Object)TableFieldSchema.Type.BOOL, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL).put((Object)TableFieldSchema.Type.BYTES, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES).put((Object)TableFieldSchema.Type.DATE, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32).put((Object)TableFieldSchema.Type.DATETIME, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)TableFieldSchema.Type.DOUBLE, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE).put((Object)TableFieldSchema.Type.GEOGRAPHY, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).put((Object)TableFieldSchema.Type.INT64, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)TableFieldSchema.Type.NUMERIC, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES).put((Object)TableFieldSchema.Type.BIGNUMERIC, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES).put((Object)TableFieldSchema.Type.STRING, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).put((Object)TableFieldSchema.Type.STRUCT, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE).put((Object)TableFieldSchema.Type.TIME, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)TableFieldSchema.Type.TIMESTAMP, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)TableFieldSchema.Type.JSON, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).put((Object)TableFieldSchema.Type.INTERVAL, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).put((Object)TableFieldSchema.Type.RANGE, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE).build();

    public static Descriptors.Descriptor convertBQTableSchemaToProtoDescriptor(TableSchema BQTableSchema) throws Descriptors.DescriptorValidationException {
        Preconditions.checkNotNull((Object)BQTableSchema, (Object)"BQTableSchema is null.");
        return BQTableSchemaToProtoDescriptor.convertBQTableSchemaToProtoDescriptorImpl(BQTableSchema, "root", new HashMap<ImmutableList<TableFieldSchema>, Descriptors.Descriptor>());
    }

    private static Descriptors.Descriptor convertBQTableSchemaToProtoDescriptorImpl(TableSchema BQTableSchema, String scope, HashMap<ImmutableList<TableFieldSchema>, Descriptors.Descriptor> dependencyMap) throws Descriptors.DescriptorValidationException, IllegalArgumentException {
        ArrayList<Descriptors.FileDescriptor> dependenciesList = new ArrayList<Descriptors.FileDescriptor>();
        ArrayList<DescriptorProtos.FieldDescriptorProto> fields = new ArrayList<DescriptorProtos.FieldDescriptorProto>();
        int index = 1;
        block7: for (TableFieldSchema BQTableField : BQTableSchema.getFieldsList()) {
            String scopeName = BigQuerySchemaUtil.isProtoCompatible(BQTableField.getName()) ? BQTableField.getName() : BigQuerySchemaUtil.generatePlaceholderFieldName(BQTableField.getName());
            String currentScope = scope + "__" + scopeName;
            switch (BQTableField.getType()) {
                case STRUCT: {
                    Descriptors.Descriptor descriptor;
                    ImmutableList fieldList = ImmutableList.copyOf((Collection)BQTableField.getFieldsList());
                    if (dependencyMap.containsKey(fieldList)) {
                        descriptor = dependencyMap.get(fieldList);
                        dependenciesList.add(descriptor.getFile());
                        fields.add(BQTableSchemaToProtoDescriptor.convertBQTableFieldToProtoField(BQTableField, index++, descriptor.getName()));
                        continue block7;
                    }
                    descriptor = BQTableSchemaToProtoDescriptor.convertBQTableSchemaToProtoDescriptorImpl(TableSchema.newBuilder().addAllFields((Iterable)fieldList).build(), currentScope, dependencyMap);
                    dependenciesList.add(descriptor.getFile());
                    dependencyMap.put((ImmutableList<TableFieldSchema>)fieldList, descriptor);
                    fields.add(BQTableSchemaToProtoDescriptor.convertBQTableFieldToProtoField(BQTableField, index++, currentScope));
                    continue block7;
                }
                case RANGE: {
                    Descriptors.Descriptor descriptor;
                    switch (BQTableField.getRangeElementType().getType()) {
                        case DATE: 
                        case DATETIME: 
                        case TIMESTAMP: {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(String.format("Error: %s of type RANGE requires range element type (DATE, DATETIME, TIMESTAMP)", currentScope));
                        }
                    }
                    ImmutableList rangeFields = ImmutableList.of((Object)TableFieldSchema.newBuilder().setType(BQTableField.getRangeElementType().getType()).setName("start").setMode(TableFieldSchema.Mode.NULLABLE).setTimestampPrecision(BQTableField.getTimestampPrecision()).build(), (Object)TableFieldSchema.newBuilder().setType(BQTableField.getRangeElementType().getType()).setName("end").setMode(TableFieldSchema.Mode.NULLABLE).setTimestampPrecision(BQTableField.getTimestampPrecision()).build());
                    if (dependencyMap.containsKey(rangeFields)) {
                        descriptor = dependencyMap.get(rangeFields);
                        dependenciesList.add(descriptor.getFile());
                        fields.add(BQTableSchemaToProtoDescriptor.convertBQTableFieldToProtoField(BQTableField, index++, descriptor.getName()));
                        continue block7;
                    }
                    descriptor = BQTableSchemaToProtoDescriptor.convertBQTableSchemaToProtoDescriptorImpl(TableSchema.newBuilder().addAllFields((Iterable)rangeFields).build(), currentScope, dependencyMap);
                    dependenciesList.add(descriptor.getFile());
                    dependencyMap.put((ImmutableList<TableFieldSchema>)rangeFields, descriptor);
                    fields.add(BQTableSchemaToProtoDescriptor.convertBQTableFieldToProtoField(BQTableField, index++, currentScope));
                    continue block7;
                }
            }
            fields.add(BQTableSchemaToProtoDescriptor.convertBQTableFieldToProtoField(BQTableField, index++, currentScope));
        }
        Descriptors.FileDescriptor[] dependenciesArray = new Descriptors.FileDescriptor[dependenciesList.size()];
        dependenciesArray = dependenciesList.toArray(dependenciesArray);
        DescriptorProtos.DescriptorProto descriptorProto = DescriptorProtos.DescriptorProto.newBuilder().setName(scope).addAllField(fields).build();
        DescriptorProtos.FileDescriptorProto fileDescriptorProto = DescriptorProtos.FileDescriptorProto.newBuilder().addMessageType(descriptorProto).build();
        Descriptors.FileDescriptor fileDescriptor = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fileDescriptorProto, (Descriptors.FileDescriptor[])dependenciesArray);
        Descriptors.Descriptor descriptor = fileDescriptor.findMessageTypeByName(scope);
        return descriptor;
    }

    static DescriptorProtos.FieldDescriptorProto convertBQTableFieldToProtoField(TableFieldSchema BQTableField, int index, String scope) {
        TableFieldSchema.Mode mode = BQTableField.getMode();
        String fieldName = BQTableField.getName().toLowerCase();
        DescriptorProtos.FieldDescriptorProto.Builder fieldDescriptor = DescriptorProtos.FieldDescriptorProto.newBuilder().setName(fieldName).setNumber(index).setLabel(DEFAULT_BQ_TABLE_SCHEMA_MODE_MAP.get(mode));
        switch (BQTableField.getType()) {
            case STRUCT: {
                fieldDescriptor.setTypeName(scope);
                break;
            }
            case RANGE: {
                fieldDescriptor.setType(DEFAULT_BQ_TABLE_SCHEMA_TYPE_MAP.get(BQTableField.getType()));
                fieldDescriptor.setTypeName(scope);
                break;
            }
            case TIMESTAMP: {
                long timestampPrecision = BQTableField.getTimestampPrecision().getValue();
                if (timestampPrecision == 12L) {
                    fieldDescriptor.setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING);
                    break;
                }
                if (timestampPrecision != 6L && timestampPrecision != 0L) {
                    LOG.warning("BigQuery Timestamp field " + BQTableField.getName() + " has timestamp precision that is not 6 or 12. Defaulting to microsecond precision and mapping to INT64 protobuf type.");
                }
                fieldDescriptor.setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64);
                break;
            }
            default: {
                fieldDescriptor.setType(DEFAULT_BQ_TABLE_SCHEMA_TYPE_MAP.get(BQTableField.getType()));
            }
        }
        if (!BigQuerySchemaUtil.isProtoCompatible(fieldName)) {
            fieldDescriptor.setName(BigQuerySchemaUtil.generatePlaceholderFieldName(fieldName));
            DescriptorProtos.FieldOptions.Builder fieldOptionBuilder = DescriptorProtos.FieldOptions.newBuilder();
            fieldOptionBuilder.setField(AnnotationsProto.columnName.getDescriptor(), (Object)fieldName);
            fieldDescriptor.setOptions((DescriptorProtos.FieldOptions)fieldOptionBuilder.build());
        }
        return fieldDescriptor.build();
    }
}

