/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1alpha2;

import com.google.cloud.bigquery.storage.v1alpha2.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1alpha2.BigQueryWriteSettings;
import com.google.cloud.bigquery.storage.v1alpha2.JsonStreamWriter;
import com.google.cloud.bigquery.storage.v1alpha2.Storage;
import com.google.cloud.bigquery.storage.v1alpha2.Stream;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.protobuf.Descriptors;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsonWriterCache {
    private static final Logger LOG = Logger.getLogger(JsonWriterCache.class.getName());
    private static String tablePatternString = "(projects/[^/]+/datasets/[^/]+/tables/[^/]+)";
    private static Pattern tablePattern = Pattern.compile(tablePatternString);
    private static JsonWriterCache instance;
    private Cache<String, JsonStreamWriter> jsonWriterCache;
    private static final int MAX_TABLE_ENTRY = 100;
    private static final int MAX_WRITERS_PER_TABLE = 1;
    private final BigQueryWriteClient stub;

    private JsonWriterCache(BigQueryWriteClient stub, int maxTableEntry) {
        this.stub = stub;
        this.jsonWriterCache = CacheBuilder.newBuilder().maximumSize((long)maxTableEntry).build();
    }

    public static JsonWriterCache getInstance() throws IOException {
        if (instance == null) {
            BigQueryWriteSettings stubSettings = BigQueryWriteSettings.newBuilder().build();
            BigQueryWriteClient stub = BigQueryWriteClient.create(stubSettings);
            instance = new JsonWriterCache(stub, 100);
        }
        return instance;
    }

    @VisibleForTesting
    public static JsonWriterCache getTestInstance(BigQueryWriteClient stub, int maxTableEntry) {
        Preconditions.checkNotNull((Object)stub, (Object)"Stub is null.");
        return new JsonWriterCache(stub, maxTableEntry);
    }

    private Stream.WriteStream CreateNewWriteStream(String tableName) {
        Stream.WriteStream stream = Stream.WriteStream.newBuilder().setType(Stream.WriteStream.Type.COMMITTED).build();
        stream = this.stub.createWriteStream(Storage.CreateWriteStreamRequest.newBuilder().setParent(tableName).setWriteStream(stream).build());
        LOG.info("Created write stream:" + stream.getName());
        return stream;
    }

    JsonStreamWriter CreateNewWriter(Stream.WriteStream writeStream) throws IllegalArgumentException, IOException, InterruptedException, Descriptors.DescriptorValidationException {
        return JsonStreamWriter.newBuilder(writeStream.getName(), writeStream.getTableSchema()).setChannelProvider(this.stub.getSettings().getTransportChannelProvider()).setCredentialsProvider(this.stub.getSettings().getCredentialsProvider()).setExecutorProvider(this.stub.getSettings().getExecutorProvider()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonStreamWriter getTableWriter(String tableName) throws IllegalArgumentException, IOException, InterruptedException, Descriptors.DescriptorValidationException {
        Preconditions.checkNotNull((Object)tableName, (Object)"TableName is null.");
        Matcher matcher = tablePattern.matcher(tableName);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid table name: " + tableName);
        }
        Stream.WriteStream writeStream = null;
        JsonStreamWriter writer = null;
        JsonWriterCache jsonWriterCache = this;
        synchronized (jsonWriterCache) {
            writer = (JsonStreamWriter)this.jsonWriterCache.getIfPresent((Object)tableName);
            if (writer != null) {
                if (!writer.expired().booleanValue()) {
                    return writer;
                }
                writer.close();
            }
            writeStream = this.CreateNewWriteStream(tableName);
            writer = this.CreateNewWriter(writeStream);
            this.jsonWriterCache.put((Object)tableName, (Object)writer);
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        JsonWriterCache jsonWriterCache = this;
        synchronized (jsonWriterCache) {
            ConcurrentMap map = this.jsonWriterCache.asMap();
            for (String key : map.keySet()) {
                JsonStreamWriter entry = (JsonStreamWriter)this.jsonWriterCache.getIfPresent((Object)key);
                entry.close();
            }
            this.jsonWriterCache.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public long cachedTableCount() {
        Cache<String, JsonStreamWriter> cache = this.jsonWriterCache;
        synchronized (cache) {
            return this.jsonWriterCache.size();
        }
    }
}

