/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1alpha2;

import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import io.grpc.Status;
import java.util.HashSet;
import java.util.Set;

public class ProtoSchemaConverter {
    private static ProtoBufProto.ProtoSchema convertInternal(Descriptors.Descriptor input, Set<String> visitedTypes, Set<String> enumTypes, Set<String> structTypes, DescriptorProtos.DescriptorProto.Builder rootProtoSchema) {
        DescriptorProtos.DescriptorProto.Builder resultProto = DescriptorProtos.DescriptorProto.newBuilder();
        if (rootProtoSchema == null) {
            rootProtoSchema = resultProto;
        }
        String protoName = input.getFullName();
        protoName = protoName.replace('.', '_');
        resultProto.setName(protoName);
        HashSet<String> localEnumTypes = new HashSet<String>();
        visitedTypes.add(input.getFullName());
        for (int i = 0; i < input.getFields().size(); ++i) {
            Descriptors.FieldDescriptor inputField = (Descriptors.FieldDescriptor)input.getFields().get(i);
            DescriptorProtos.FieldDescriptorProto.Builder resultField = inputField.toProto().toBuilder();
            if (inputField.getType() == Descriptors.FieldDescriptor.Type.GROUP || inputField.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
                String msgFullName = inputField.getMessageType().getFullName();
                if (structTypes.contains(msgFullName = msgFullName.replace('.', '_'))) {
                    resultField.setTypeName(msgFullName);
                } else {
                    if (visitedTypes.contains(msgFullName)) {
                        throw new InvalidArgumentException("Recursive type is not supported:" + inputField.getMessageType().getFullName(), null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.INVALID_ARGUMENT), false);
                    }
                    visitedTypes.add(msgFullName);
                    rootProtoSchema.addNestedType(ProtoSchemaConverter.convertInternal(inputField.getMessageType(), visitedTypes, enumTypes, structTypes, rootProtoSchema).getProtoDescriptor());
                    visitedTypes.remove(msgFullName);
                    resultField.setTypeName(rootProtoSchema.getNestedType(rootProtoSchema.getNestedTypeCount() - 1).getName());
                }
            }
            if (inputField.getType() == Descriptors.FieldDescriptor.Type.ENUM) {
                String enumFullName = inputField.getEnumType().getFullName();
                if (enumFullName.startsWith(input.getFullName())) {
                    String enumName = inputField.getEnumType().getName();
                    if (localEnumTypes.contains(enumName)) {
                        resultField.setTypeName(enumName);
                    } else {
                        resultProto.addEnumType(inputField.getEnumType().toProto());
                        resultField.setTypeName(enumName);
                        localEnumTypes.add(enumName);
                    }
                } else if (enumTypes.contains(enumFullName = enumFullName.replace('.', '_'))) {
                    resultField.setTypeName(enumFullName);
                } else {
                    DescriptorProtos.EnumDescriptorProto enumType = inputField.getEnumType().toProto().toBuilder().setName(enumFullName).build();
                    resultProto.addEnumType(enumType);
                    resultField.setTypeName(enumFullName);
                    enumTypes.add(enumFullName);
                }
            }
            resultProto.addField(resultField);
        }
        structTypes.add(protoName);
        return ProtoBufProto.ProtoSchema.newBuilder().setProtoDescriptor(resultProto.build()).build();
    }

    public static ProtoBufProto.ProtoSchema convert(Descriptors.Descriptor descriptor) {
        HashSet<String> visitedTypes = new HashSet<String>();
        HashSet<String> enumTypes = new HashSet<String>();
        HashSet<String> structTypes = new HashSet<String>();
        return ProtoSchemaConverter.convertInternal(descriptor, visitedTypes, enumTypes, structTypes, null);
    }
}

