/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1alpha2.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.storage.v1alpha2.Storage;
import com.google.cloud.bigquery.storage.v1alpha2.Stream;
import com.google.cloud.bigquery.storage.v1alpha2.stub.BigQueryWriteStub;
import com.google.cloud.bigquery.storage.v1alpha2.stub.BigQueryWriteStubSettings;
import com.google.cloud.bigquery.storage.v1alpha2.stub.GrpcBigQueryWriteCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class GrpcBigQueryWriteStub
extends BigQueryWriteStub {
    private static final MethodDescriptor<Storage.CreateWriteStreamRequest, Stream.WriteStream> createWriteStreamMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.storage.v1alpha2.BigQueryWrite/CreateWriteStream").setRequestMarshaller(ProtoUtils.marshaller((Message)Storage.CreateWriteStreamRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Stream.WriteStream.getDefaultInstance())).build();
    private static final MethodDescriptor<Storage.AppendRowsRequest, Storage.AppendRowsResponse> appendRowsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName("google.cloud.bigquery.storage.v1alpha2.BigQueryWrite/AppendRows").setRequestMarshaller(ProtoUtils.marshaller((Message)Storage.AppendRowsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Storage.AppendRowsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<Storage.GetWriteStreamRequest, Stream.WriteStream> getWriteStreamMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.storage.v1alpha2.BigQueryWrite/GetWriteStream").setRequestMarshaller(ProtoUtils.marshaller((Message)Storage.GetWriteStreamRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Stream.WriteStream.getDefaultInstance())).build();
    private static final MethodDescriptor<Storage.FinalizeWriteStreamRequest, Storage.FinalizeWriteStreamResponse> finalizeWriteStreamMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.storage.v1alpha2.BigQueryWrite/FinalizeWriteStream").setRequestMarshaller(ProtoUtils.marshaller((Message)Storage.FinalizeWriteStreamRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Storage.FinalizeWriteStreamResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<Storage.BatchCommitWriteStreamsRequest, Storage.BatchCommitWriteStreamsResponse> batchCommitWriteStreamsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.storage.v1alpha2.BigQueryWrite/BatchCommitWriteStreams").setRequestMarshaller(ProtoUtils.marshaller((Message)Storage.BatchCommitWriteStreamsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Storage.BatchCommitWriteStreamsResponse.getDefaultInstance())).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<Storage.CreateWriteStreamRequest, Stream.WriteStream> createWriteStreamCallable;
    private final BidiStreamingCallable<Storage.AppendRowsRequest, Storage.AppendRowsResponse> appendRowsCallable;
    private final UnaryCallable<Storage.GetWriteStreamRequest, Stream.WriteStream> getWriteStreamCallable;
    private final UnaryCallable<Storage.FinalizeWriteStreamRequest, Storage.FinalizeWriteStreamResponse> finalizeWriteStreamCallable;
    private final UnaryCallable<Storage.BatchCommitWriteStreamsRequest, Storage.BatchCommitWriteStreamsResponse> batchCommitWriteStreamsCallable;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcBigQueryWriteStub create(BigQueryWriteStubSettings settings) throws IOException {
        return new GrpcBigQueryWriteStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcBigQueryWriteStub create(ClientContext clientContext) throws IOException {
        return new GrpcBigQueryWriteStub(BigQueryWriteStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcBigQueryWriteStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcBigQueryWriteStub(BigQueryWriteStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcBigQueryWriteStub(BigQueryWriteStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcBigQueryWriteCallableFactory());
    }

    protected GrpcBigQueryWriteStub(BigQueryWriteStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        GrpcCallSettings createWriteStreamTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createWriteStreamMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<Storage.CreateWriteStreamRequest>(){

            public Map<String, String> extract(Storage.CreateWriteStreamRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings appendRowsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(appendRowsMethodDescriptor).build();
        GrpcCallSettings getWriteStreamTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getWriteStreamMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<Storage.GetWriteStreamRequest>(){

            public Map<String, String> extract(Storage.GetWriteStreamRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings finalizeWriteStreamTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(finalizeWriteStreamMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<Storage.FinalizeWriteStreamRequest>(){

            public Map<String, String> extract(Storage.FinalizeWriteStreamRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings batchCommitWriteStreamsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchCommitWriteStreamsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<Storage.BatchCommitWriteStreamsRequest>(){

            public Map<String, String> extract(Storage.BatchCommitWriteStreamsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        this.createWriteStreamCallable = callableFactory.createUnaryCallable(createWriteStreamTransportSettings, settings.createWriteStreamSettings(), clientContext);
        this.appendRowsCallable = callableFactory.createBidiStreamingCallable(appendRowsTransportSettings, settings.appendRowsSettings(), clientContext);
        this.getWriteStreamCallable = callableFactory.createUnaryCallable(getWriteStreamTransportSettings, settings.getWriteStreamSettings(), clientContext);
        this.finalizeWriteStreamCallable = callableFactory.createUnaryCallable(finalizeWriteStreamTransportSettings, settings.finalizeWriteStreamSettings(), clientContext);
        this.batchCommitWriteStreamsCallable = callableFactory.createUnaryCallable(batchCommitWriteStreamsTransportSettings, settings.batchCommitWriteStreamsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    public UnaryCallable<Storage.CreateWriteStreamRequest, Stream.WriteStream> createWriteStreamCallable() {
        return this.createWriteStreamCallable;
    }

    @Override
    public BidiStreamingCallable<Storage.AppendRowsRequest, Storage.AppendRowsResponse> appendRowsCallable() {
        return this.appendRowsCallable;
    }

    @Override
    public UnaryCallable<Storage.GetWriteStreamRequest, Stream.WriteStream> getWriteStreamCallable() {
        return this.getWriteStreamCallable;
    }

    @Override
    public UnaryCallable<Storage.FinalizeWriteStreamRequest, Storage.FinalizeWriteStreamResponse> finalizeWriteStreamCallable() {
        return this.finalizeWriteStreamCallable;
    }

    @Override
    public UnaryCallable<Storage.BatchCommitWriteStreamsRequest, Storage.BatchCommitWriteStreamsResponse> batchCommitWriteStreamsCallable() {
        return this.batchCommitWriteStreamsCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

