/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.datatransfer.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.datatransfer.v1.CheckValidCredsRequest;
import com.google.cloud.bigquery.datatransfer.v1.CheckValidCredsResponse;
import com.google.cloud.bigquery.datatransfer.v1.CreateTransferConfigRequest;
import com.google.cloud.bigquery.datatransfer.v1.DataSource;
import com.google.cloud.bigquery.datatransfer.v1.DataSourceName;
import com.google.cloud.bigquery.datatransfer.v1.DataTransferServiceSettings;
import com.google.cloud.bigquery.datatransfer.v1.DeleteTransferConfigRequest;
import com.google.cloud.bigquery.datatransfer.v1.DeleteTransferRunRequest;
import com.google.cloud.bigquery.datatransfer.v1.GetDataSourceRequest;
import com.google.cloud.bigquery.datatransfer.v1.GetTransferConfigRequest;
import com.google.cloud.bigquery.datatransfer.v1.GetTransferRunRequest;
import com.google.cloud.bigquery.datatransfer.v1.ListDataSourcesRequest;
import com.google.cloud.bigquery.datatransfer.v1.ListDataSourcesResponse;
import com.google.cloud.bigquery.datatransfer.v1.ListTransferConfigsRequest;
import com.google.cloud.bigquery.datatransfer.v1.ListTransferConfigsResponse;
import com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest;
import com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsResponse;
import com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest;
import com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsResponse;
import com.google.cloud.bigquery.datatransfer.v1.LocationName;
import com.google.cloud.bigquery.datatransfer.v1.ProjectName;
import com.google.cloud.bigquery.datatransfer.v1.RunName;
import com.google.cloud.bigquery.datatransfer.v1.ScheduleTransferRunsRequest;
import com.google.cloud.bigquery.datatransfer.v1.ScheduleTransferRunsResponse;
import com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest;
import com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsResponse;
import com.google.cloud.bigquery.datatransfer.v1.TransferConfig;
import com.google.cloud.bigquery.datatransfer.v1.TransferConfigName;
import com.google.cloud.bigquery.datatransfer.v1.TransferMessage;
import com.google.cloud.bigquery.datatransfer.v1.TransferRun;
import com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest;
import com.google.cloud.bigquery.datatransfer.v1.stub.DataTransferServiceStub;
import com.google.cloud.bigquery.datatransfer.v1.stub.DataTransferServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class DataTransferServiceClient
implements BackgroundResource {
    private final DataTransferServiceSettings settings;
    private final DataTransferServiceStub stub;

    public static final DataTransferServiceClient create() throws IOException {
        return DataTransferServiceClient.create(DataTransferServiceSettings.newBuilder().build());
    }

    public static final DataTransferServiceClient create(DataTransferServiceSettings settings) throws IOException {
        return new DataTransferServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final DataTransferServiceClient create(DataTransferServiceStub stub) {
        return new DataTransferServiceClient(stub);
    }

    protected DataTransferServiceClient(DataTransferServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DataTransferServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected DataTransferServiceClient(DataTransferServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DataTransferServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DataTransferServiceStub getStub() {
        return this.stub;
    }

    public final void deleteTransferConfig(TransferConfigName name) {
        DeleteTransferConfigRequest request = DeleteTransferConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteTransferConfig(request);
    }

    public final void deleteTransferConfig(String name) {
        DeleteTransferConfigRequest request = DeleteTransferConfigRequest.newBuilder().setName(name).build();
        this.deleteTransferConfig(request);
    }

    public final void deleteTransferConfig(DeleteTransferConfigRequest request) {
        this.deleteTransferConfigCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteTransferConfigRequest, Empty> deleteTransferConfigCallable() {
        return this.stub.deleteTransferConfigCallable();
    }

    public final void deleteTransferRun(RunName name) {
        DeleteTransferRunRequest request = DeleteTransferRunRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteTransferRun(request);
    }

    public final void deleteTransferRun(String name) {
        DeleteTransferRunRequest request = DeleteTransferRunRequest.newBuilder().setName(name).build();
        this.deleteTransferRun(request);
    }

    public final void deleteTransferRun(DeleteTransferRunRequest request) {
        this.deleteTransferRunCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteTransferRunRequest, Empty> deleteTransferRunCallable() {
        return this.stub.deleteTransferRunCallable();
    }

    public final CheckValidCredsResponse checkValidCreds(DataSourceName name) {
        CheckValidCredsRequest request = CheckValidCredsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.checkValidCreds(request);
    }

    public final CheckValidCredsResponse checkValidCreds(String name) {
        CheckValidCredsRequest request = CheckValidCredsRequest.newBuilder().setName(name).build();
        return this.checkValidCreds(request);
    }

    public final CheckValidCredsResponse checkValidCreds(CheckValidCredsRequest request) {
        return (CheckValidCredsResponse)this.checkValidCredsCallable().call((Object)request);
    }

    public final UnaryCallable<CheckValidCredsRequest, CheckValidCredsResponse> checkValidCredsCallable() {
        return this.stub.checkValidCredsCallable();
    }

    public final DataSource getDataSource(DataSourceName name) {
        GetDataSourceRequest request = GetDataSourceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDataSource(request);
    }

    public final DataSource getDataSource(String name) {
        GetDataSourceRequest request = GetDataSourceRequest.newBuilder().setName(name).build();
        return this.getDataSource(request);
    }

    public final DataSource getDataSource(GetDataSourceRequest request) {
        return (DataSource)this.getDataSourceCallable().call((Object)request);
    }

    public final UnaryCallable<GetDataSourceRequest, DataSource> getDataSourceCallable() {
        return this.stub.getDataSourceCallable();
    }

    public final ListDataSourcesPagedResponse listDataSources(ProjectName parent) {
        ListDataSourcesRequest request = ListDataSourcesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDataSources(request);
    }

    public final ListDataSourcesPagedResponse listDataSources(LocationName parent) {
        ListDataSourcesRequest request = ListDataSourcesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDataSources(request);
    }

    public final ListDataSourcesPagedResponse listDataSources(String parent) {
        ListDataSourcesRequest request = ListDataSourcesRequest.newBuilder().setParent(parent).build();
        return this.listDataSources(request);
    }

    public final ListDataSourcesPagedResponse listDataSources(ListDataSourcesRequest request) {
        return (ListDataSourcesPagedResponse)((Object)this.listDataSourcesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDataSourcesRequest, ListDataSourcesPagedResponse> listDataSourcesPagedCallable() {
        return this.stub.listDataSourcesPagedCallable();
    }

    public final UnaryCallable<ListDataSourcesRequest, ListDataSourcesResponse> listDataSourcesCallable() {
        return this.stub.listDataSourcesCallable();
    }

    public final TransferConfig createTransferConfig(ProjectName parent, TransferConfig transferConfig) {
        CreateTransferConfigRequest request = CreateTransferConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTransferConfig(transferConfig).build();
        return this.createTransferConfig(request);
    }

    public final TransferConfig createTransferConfig(LocationName parent, TransferConfig transferConfig) {
        CreateTransferConfigRequest request = CreateTransferConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTransferConfig(transferConfig).build();
        return this.createTransferConfig(request);
    }

    public final TransferConfig createTransferConfig(String parent, TransferConfig transferConfig) {
        CreateTransferConfigRequest request = CreateTransferConfigRequest.newBuilder().setParent(parent).setTransferConfig(transferConfig).build();
        return this.createTransferConfig(request);
    }

    public final TransferConfig createTransferConfig(CreateTransferConfigRequest request) {
        return (TransferConfig)this.createTransferConfigCallable().call((Object)request);
    }

    public final UnaryCallable<CreateTransferConfigRequest, TransferConfig> createTransferConfigCallable() {
        return this.stub.createTransferConfigCallable();
    }

    public final TransferConfig updateTransferConfig(TransferConfig transferConfig, FieldMask updateMask) {
        UpdateTransferConfigRequest request = UpdateTransferConfigRequest.newBuilder().setTransferConfig(transferConfig).setUpdateMask(updateMask).build();
        return this.updateTransferConfig(request);
    }

    public final TransferConfig updateTransferConfig(UpdateTransferConfigRequest request) {
        return (TransferConfig)this.updateTransferConfigCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateTransferConfigRequest, TransferConfig> updateTransferConfigCallable() {
        return this.stub.updateTransferConfigCallable();
    }

    public final TransferConfig getTransferConfig(TransferConfigName name) {
        GetTransferConfigRequest request = GetTransferConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTransferConfig(request);
    }

    public final TransferConfig getTransferConfig(String name) {
        GetTransferConfigRequest request = GetTransferConfigRequest.newBuilder().setName(name).build();
        return this.getTransferConfig(request);
    }

    public final TransferConfig getTransferConfig(GetTransferConfigRequest request) {
        return (TransferConfig)this.getTransferConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetTransferConfigRequest, TransferConfig> getTransferConfigCallable() {
        return this.stub.getTransferConfigCallable();
    }

    public final ListTransferConfigsPagedResponse listTransferConfigs(ProjectName parent) {
        ListTransferConfigsRequest request = ListTransferConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTransferConfigs(request);
    }

    public final ListTransferConfigsPagedResponse listTransferConfigs(LocationName parent) {
        ListTransferConfigsRequest request = ListTransferConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTransferConfigs(request);
    }

    public final ListTransferConfigsPagedResponse listTransferConfigs(String parent) {
        ListTransferConfigsRequest request = ListTransferConfigsRequest.newBuilder().setParent(parent).build();
        return this.listTransferConfigs(request);
    }

    public final ListTransferConfigsPagedResponse listTransferConfigs(ListTransferConfigsRequest request) {
        return (ListTransferConfigsPagedResponse)((Object)this.listTransferConfigsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTransferConfigsRequest, ListTransferConfigsPagedResponse> listTransferConfigsPagedCallable() {
        return this.stub.listTransferConfigsPagedCallable();
    }

    public final UnaryCallable<ListTransferConfigsRequest, ListTransferConfigsResponse> listTransferConfigsCallable() {
        return this.stub.listTransferConfigsCallable();
    }

    public final ScheduleTransferRunsResponse scheduleTransferRuns(TransferConfigName parent, Timestamp startTime, Timestamp endTime) {
        ScheduleTransferRunsRequest request = ScheduleTransferRunsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setStartTime(startTime).setEndTime(endTime).build();
        return this.scheduleTransferRuns(request);
    }

    public final ScheduleTransferRunsResponse scheduleTransferRuns(String parent, Timestamp startTime, Timestamp endTime) {
        ScheduleTransferRunsRequest request = ScheduleTransferRunsRequest.newBuilder().setParent(parent).setStartTime(startTime).setEndTime(endTime).build();
        return this.scheduleTransferRuns(request);
    }

    public final ScheduleTransferRunsResponse scheduleTransferRuns(ScheduleTransferRunsRequest request) {
        return (ScheduleTransferRunsResponse)this.scheduleTransferRunsCallable().call((Object)request);
    }

    public final UnaryCallable<ScheduleTransferRunsRequest, ScheduleTransferRunsResponse> scheduleTransferRunsCallable() {
        return this.stub.scheduleTransferRunsCallable();
    }

    public final StartManualTransferRunsResponse startManualTransferRuns(StartManualTransferRunsRequest request) {
        return (StartManualTransferRunsResponse)this.startManualTransferRunsCallable().call((Object)request);
    }

    public final UnaryCallable<StartManualTransferRunsRequest, StartManualTransferRunsResponse> startManualTransferRunsCallable() {
        return this.stub.startManualTransferRunsCallable();
    }

    public final TransferRun getTransferRun(RunName name) {
        GetTransferRunRequest request = GetTransferRunRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTransferRun(request);
    }

    public final TransferRun getTransferRun(String name) {
        GetTransferRunRequest request = GetTransferRunRequest.newBuilder().setName(name).build();
        return this.getTransferRun(request);
    }

    public final TransferRun getTransferRun(GetTransferRunRequest request) {
        return (TransferRun)this.getTransferRunCallable().call((Object)request);
    }

    public final UnaryCallable<GetTransferRunRequest, TransferRun> getTransferRunCallable() {
        return this.stub.getTransferRunCallable();
    }

    public final ListTransferRunsPagedResponse listTransferRuns(TransferConfigName parent) {
        ListTransferRunsRequest request = ListTransferRunsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTransferRuns(request);
    }

    public final ListTransferRunsPagedResponse listTransferRuns(String parent) {
        ListTransferRunsRequest request = ListTransferRunsRequest.newBuilder().setParent(parent).build();
        return this.listTransferRuns(request);
    }

    public final ListTransferRunsPagedResponse listTransferRuns(ListTransferRunsRequest request) {
        return (ListTransferRunsPagedResponse)((Object)this.listTransferRunsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTransferRunsRequest, ListTransferRunsPagedResponse> listTransferRunsPagedCallable() {
        return this.stub.listTransferRunsPagedCallable();
    }

    public final UnaryCallable<ListTransferRunsRequest, ListTransferRunsResponse> listTransferRunsCallable() {
        return this.stub.listTransferRunsCallable();
    }

    public final ListTransferLogsPagedResponse listTransferLogs(RunName parent) {
        ListTransferLogsRequest request = ListTransferLogsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTransferLogs(request);
    }

    public final ListTransferLogsPagedResponse listTransferLogs(String parent) {
        ListTransferLogsRequest request = ListTransferLogsRequest.newBuilder().setParent(parent).build();
        return this.listTransferLogs(request);
    }

    public final ListTransferLogsPagedResponse listTransferLogs(ListTransferLogsRequest request) {
        return (ListTransferLogsPagedResponse)((Object)this.listTransferLogsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTransferLogsRequest, ListTransferLogsPagedResponse> listTransferLogsPagedCallable() {
        return this.stub.listTransferLogsPagedCallable();
    }

    public final UnaryCallable<ListTransferLogsRequest, ListTransferLogsResponse> listTransferLogsCallable() {
        return this.stub.listTransferLogsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListTransferLogsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTransferLogsRequest, ListTransferLogsResponse, TransferMessage, ListTransferLogsPage, ListTransferLogsFixedSizeCollection> {
        private ListTransferLogsFixedSizeCollection(List<ListTransferLogsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTransferLogsFixedSizeCollection createEmptyCollection() {
            return new ListTransferLogsFixedSizeCollection(null, 0);
        }

        protected ListTransferLogsFixedSizeCollection createCollection(List<ListTransferLogsPage> pages, int collectionSize) {
            return new ListTransferLogsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTransferLogsPage
    extends AbstractPage<ListTransferLogsRequest, ListTransferLogsResponse, TransferMessage, ListTransferLogsPage> {
        private ListTransferLogsPage(PageContext<ListTransferLogsRequest, ListTransferLogsResponse, TransferMessage> context, ListTransferLogsResponse response) {
            super(context, (Object)response);
        }

        private static ListTransferLogsPage createEmptyPage() {
            return new ListTransferLogsPage(null, null);
        }

        protected ListTransferLogsPage createPage(PageContext<ListTransferLogsRequest, ListTransferLogsResponse, TransferMessage> context, ListTransferLogsResponse response) {
            return new ListTransferLogsPage(context, response);
        }

        public ApiFuture<ListTransferLogsPage> createPageAsync(PageContext<ListTransferLogsRequest, ListTransferLogsResponse, TransferMessage> context, ApiFuture<ListTransferLogsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTransferLogsPagedResponse
    extends AbstractPagedListResponse<ListTransferLogsRequest, ListTransferLogsResponse, TransferMessage, ListTransferLogsPage, ListTransferLogsFixedSizeCollection> {
        public static ApiFuture<ListTransferLogsPagedResponse> createAsync(PageContext<ListTransferLogsRequest, ListTransferLogsResponse, TransferMessage> context, ApiFuture<ListTransferLogsResponse> futureResponse) {
            ApiFuture<ListTransferLogsPage> futurePage = ListTransferLogsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListTransferLogsPage, ListTransferLogsPagedResponse>(){

                public ListTransferLogsPagedResponse apply(ListTransferLogsPage input) {
                    return new ListTransferLogsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListTransferLogsPagedResponse(ListTransferLogsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTransferLogsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListTransferRunsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTransferRunsRequest, ListTransferRunsResponse, TransferRun, ListTransferRunsPage, ListTransferRunsFixedSizeCollection> {
        private ListTransferRunsFixedSizeCollection(List<ListTransferRunsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTransferRunsFixedSizeCollection createEmptyCollection() {
            return new ListTransferRunsFixedSizeCollection(null, 0);
        }

        protected ListTransferRunsFixedSizeCollection createCollection(List<ListTransferRunsPage> pages, int collectionSize) {
            return new ListTransferRunsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTransferRunsPage
    extends AbstractPage<ListTransferRunsRequest, ListTransferRunsResponse, TransferRun, ListTransferRunsPage> {
        private ListTransferRunsPage(PageContext<ListTransferRunsRequest, ListTransferRunsResponse, TransferRun> context, ListTransferRunsResponse response) {
            super(context, (Object)response);
        }

        private static ListTransferRunsPage createEmptyPage() {
            return new ListTransferRunsPage(null, null);
        }

        protected ListTransferRunsPage createPage(PageContext<ListTransferRunsRequest, ListTransferRunsResponse, TransferRun> context, ListTransferRunsResponse response) {
            return new ListTransferRunsPage(context, response);
        }

        public ApiFuture<ListTransferRunsPage> createPageAsync(PageContext<ListTransferRunsRequest, ListTransferRunsResponse, TransferRun> context, ApiFuture<ListTransferRunsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTransferRunsPagedResponse
    extends AbstractPagedListResponse<ListTransferRunsRequest, ListTransferRunsResponse, TransferRun, ListTransferRunsPage, ListTransferRunsFixedSizeCollection> {
        public static ApiFuture<ListTransferRunsPagedResponse> createAsync(PageContext<ListTransferRunsRequest, ListTransferRunsResponse, TransferRun> context, ApiFuture<ListTransferRunsResponse> futureResponse) {
            ApiFuture<ListTransferRunsPage> futurePage = ListTransferRunsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListTransferRunsPage, ListTransferRunsPagedResponse>(){

                public ListTransferRunsPagedResponse apply(ListTransferRunsPage input) {
                    return new ListTransferRunsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListTransferRunsPagedResponse(ListTransferRunsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTransferRunsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListTransferConfigsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTransferConfigsRequest, ListTransferConfigsResponse, TransferConfig, ListTransferConfigsPage, ListTransferConfigsFixedSizeCollection> {
        private ListTransferConfigsFixedSizeCollection(List<ListTransferConfigsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTransferConfigsFixedSizeCollection createEmptyCollection() {
            return new ListTransferConfigsFixedSizeCollection(null, 0);
        }

        protected ListTransferConfigsFixedSizeCollection createCollection(List<ListTransferConfigsPage> pages, int collectionSize) {
            return new ListTransferConfigsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTransferConfigsPage
    extends AbstractPage<ListTransferConfigsRequest, ListTransferConfigsResponse, TransferConfig, ListTransferConfigsPage> {
        private ListTransferConfigsPage(PageContext<ListTransferConfigsRequest, ListTransferConfigsResponse, TransferConfig> context, ListTransferConfigsResponse response) {
            super(context, (Object)response);
        }

        private static ListTransferConfigsPage createEmptyPage() {
            return new ListTransferConfigsPage(null, null);
        }

        protected ListTransferConfigsPage createPage(PageContext<ListTransferConfigsRequest, ListTransferConfigsResponse, TransferConfig> context, ListTransferConfigsResponse response) {
            return new ListTransferConfigsPage(context, response);
        }

        public ApiFuture<ListTransferConfigsPage> createPageAsync(PageContext<ListTransferConfigsRequest, ListTransferConfigsResponse, TransferConfig> context, ApiFuture<ListTransferConfigsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTransferConfigsPagedResponse
    extends AbstractPagedListResponse<ListTransferConfigsRequest, ListTransferConfigsResponse, TransferConfig, ListTransferConfigsPage, ListTransferConfigsFixedSizeCollection> {
        public static ApiFuture<ListTransferConfigsPagedResponse> createAsync(PageContext<ListTransferConfigsRequest, ListTransferConfigsResponse, TransferConfig> context, ApiFuture<ListTransferConfigsResponse> futureResponse) {
            ApiFuture<ListTransferConfigsPage> futurePage = ListTransferConfigsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListTransferConfigsPage, ListTransferConfigsPagedResponse>(){

                public ListTransferConfigsPagedResponse apply(ListTransferConfigsPage input) {
                    return new ListTransferConfigsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListTransferConfigsPagedResponse(ListTransferConfigsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTransferConfigsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDataSourcesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDataSourcesRequest, ListDataSourcesResponse, DataSource, ListDataSourcesPage, ListDataSourcesFixedSizeCollection> {
        private ListDataSourcesFixedSizeCollection(List<ListDataSourcesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDataSourcesFixedSizeCollection createEmptyCollection() {
            return new ListDataSourcesFixedSizeCollection(null, 0);
        }

        protected ListDataSourcesFixedSizeCollection createCollection(List<ListDataSourcesPage> pages, int collectionSize) {
            return new ListDataSourcesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDataSourcesPage
    extends AbstractPage<ListDataSourcesRequest, ListDataSourcesResponse, DataSource, ListDataSourcesPage> {
        private ListDataSourcesPage(PageContext<ListDataSourcesRequest, ListDataSourcesResponse, DataSource> context, ListDataSourcesResponse response) {
            super(context, (Object)response);
        }

        private static ListDataSourcesPage createEmptyPage() {
            return new ListDataSourcesPage(null, null);
        }

        protected ListDataSourcesPage createPage(PageContext<ListDataSourcesRequest, ListDataSourcesResponse, DataSource> context, ListDataSourcesResponse response) {
            return new ListDataSourcesPage(context, response);
        }

        public ApiFuture<ListDataSourcesPage> createPageAsync(PageContext<ListDataSourcesRequest, ListDataSourcesResponse, DataSource> context, ApiFuture<ListDataSourcesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDataSourcesPagedResponse
    extends AbstractPagedListResponse<ListDataSourcesRequest, ListDataSourcesResponse, DataSource, ListDataSourcesPage, ListDataSourcesFixedSizeCollection> {
        public static ApiFuture<ListDataSourcesPagedResponse> createAsync(PageContext<ListDataSourcesRequest, ListDataSourcesResponse, DataSource> context, ApiFuture<ListDataSourcesResponse> futureResponse) {
            ApiFuture<ListDataSourcesPage> futurePage = ListDataSourcesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListDataSourcesPage, ListDataSourcesPagedResponse>(){

                public ListDataSourcesPagedResponse apply(ListDataSourcesPage input) {
                    return new ListDataSourcesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListDataSourcesPagedResponse(ListDataSourcesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDataSourcesFixedSizeCollection.createEmptyCollection());
        }
    }
}

