/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connection.v1beta1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.bigquery.connection.v1beta1.ConnectionName;
import com.google.cloud.bigquery.connection.v1beta1.ConnectionProto;
import com.google.cloud.bigquery.connection.v1beta1.ConnectionServiceSettings;
import com.google.cloud.bigquery.connection.v1beta1.LocationName;
import com.google.cloud.bigquery.connection.v1beta1.stub.ConnectionServiceStub;
import com.google.cloud.bigquery.connection.v1beta1.stub.ConnectionServiceStubSettings;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.GetPolicyOptions;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.UInt32Value;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ConnectionServiceClient
implements BackgroundResource {
    private final ConnectionServiceSettings settings;
    private final ConnectionServiceStub stub;

    public static final ConnectionServiceClient create() throws IOException {
        return ConnectionServiceClient.create(ConnectionServiceSettings.newBuilder().build());
    }

    public static final ConnectionServiceClient create(ConnectionServiceSettings settings) throws IOException {
        return new ConnectionServiceClient(settings);
    }

    public static final ConnectionServiceClient create(ConnectionServiceStub stub) {
        return new ConnectionServiceClient(stub);
    }

    protected ConnectionServiceClient(ConnectionServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ConnectionServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected ConnectionServiceClient(ConnectionServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ConnectionServiceSettings getSettings() {
        return this.settings;
    }

    public ConnectionServiceStub getStub() {
        return this.stub;
    }

    public final ConnectionProto.Connection createConnection(LocationName parent, ConnectionProto.Connection connection, String connectionId) {
        ConnectionProto.CreateConnectionRequest request = ConnectionProto.CreateConnectionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setConnection(connection).setConnectionId(connectionId).build();
        return this.createConnection(request);
    }

    public final ConnectionProto.Connection createConnection(String parent, ConnectionProto.Connection connection, String connectionId) {
        ConnectionProto.CreateConnectionRequest request = ConnectionProto.CreateConnectionRequest.newBuilder().setParent(parent).setConnection(connection).setConnectionId(connectionId).build();
        return this.createConnection(request);
    }

    public final ConnectionProto.Connection createConnection(ConnectionProto.CreateConnectionRequest request) {
        return (ConnectionProto.Connection)this.createConnectionCallable().call((Object)request);
    }

    public final UnaryCallable<ConnectionProto.CreateConnectionRequest, ConnectionProto.Connection> createConnectionCallable() {
        return this.stub.createConnectionCallable();
    }

    public final ConnectionProto.Connection getConnection(ConnectionName name) {
        ConnectionProto.GetConnectionRequest request = ConnectionProto.GetConnectionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getConnection(request);
    }

    public final ConnectionProto.Connection getConnection(String name) {
        ConnectionProto.GetConnectionRequest request = ConnectionProto.GetConnectionRequest.newBuilder().setName(name).build();
        return this.getConnection(request);
    }

    public final ConnectionProto.Connection getConnection(ConnectionProto.GetConnectionRequest request) {
        return (ConnectionProto.Connection)this.getConnectionCallable().call((Object)request);
    }

    public final UnaryCallable<ConnectionProto.GetConnectionRequest, ConnectionProto.Connection> getConnectionCallable() {
        return this.stub.getConnectionCallable();
    }

    public final ConnectionProto.ListConnectionsResponse listConnections(LocationName parent, UInt32Value maxResults) {
        ConnectionProto.ListConnectionsRequest request = ConnectionProto.ListConnectionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setMaxResults(maxResults).build();
        return this.listConnections(request);
    }

    public final ConnectionProto.ListConnectionsResponse listConnections(String parent, UInt32Value maxResults) {
        ConnectionProto.ListConnectionsRequest request = ConnectionProto.ListConnectionsRequest.newBuilder().setParent(parent).setMaxResults(maxResults).build();
        return this.listConnections(request);
    }

    public final ConnectionProto.ListConnectionsResponse listConnections(ConnectionProto.ListConnectionsRequest request) {
        return (ConnectionProto.ListConnectionsResponse)this.listConnectionsCallable().call((Object)request);
    }

    public final UnaryCallable<ConnectionProto.ListConnectionsRequest, ConnectionProto.ListConnectionsResponse> listConnectionsCallable() {
        return this.stub.listConnectionsCallable();
    }

    public final ConnectionProto.Connection updateConnection(ConnectionName name, ConnectionProto.Connection connection, FieldMask updateMask) {
        ConnectionProto.UpdateConnectionRequest request = ConnectionProto.UpdateConnectionRequest.newBuilder().setName(name == null ? null : name.toString()).setConnection(connection).setUpdateMask(updateMask).build();
        return this.updateConnection(request);
    }

    public final ConnectionProto.Connection updateConnection(String name, ConnectionProto.Connection connection, FieldMask updateMask) {
        ConnectionProto.UpdateConnectionRequest request = ConnectionProto.UpdateConnectionRequest.newBuilder().setName(name).setConnection(connection).setUpdateMask(updateMask).build();
        return this.updateConnection(request);
    }

    public final ConnectionProto.Connection updateConnection(ConnectionProto.UpdateConnectionRequest request) {
        return (ConnectionProto.Connection)this.updateConnectionCallable().call((Object)request);
    }

    public final UnaryCallable<ConnectionProto.UpdateConnectionRequest, ConnectionProto.Connection> updateConnectionCallable() {
        return this.stub.updateConnectionCallable();
    }

    public final void updateConnectionCredential(String name, ConnectionProto.ConnectionCredential credential) {
        ConnectionProto.UpdateConnectionCredentialRequest request = ConnectionProto.UpdateConnectionCredentialRequest.newBuilder().setName(name).setCredential(credential).build();
        this.updateConnectionCredential(request);
    }

    public final void updateConnectionCredential(ConnectionProto.UpdateConnectionCredentialRequest request) {
        this.updateConnectionCredentialCallable().call((Object)request);
    }

    public final UnaryCallable<ConnectionProto.UpdateConnectionCredentialRequest, Empty> updateConnectionCredentialCallable() {
        return this.stub.updateConnectionCredentialCallable();
    }

    public final void deleteConnection(ConnectionName name) {
        ConnectionProto.DeleteConnectionRequest request = ConnectionProto.DeleteConnectionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteConnection(request);
    }

    public final void deleteConnection(String name) {
        ConnectionProto.DeleteConnectionRequest request = ConnectionProto.DeleteConnectionRequest.newBuilder().setName(name).build();
        this.deleteConnection(request);
    }

    public final void deleteConnection(ConnectionProto.DeleteConnectionRequest request) {
        this.deleteConnectionCallable().call((Object)request);
    }

    public final UnaryCallable<ConnectionProto.DeleteConnectionRequest, Empty> deleteConnectionCallable() {
        return this.stub.deleteConnectionCallable();
    }

    public final Policy getIamPolicy(ResourceName resource, GetPolicyOptions options) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setOptions(options).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(String resource, GetPolicyOptions options) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).setOptions(options).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final Policy setIamPolicy(ResourceName resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(String resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(ResourceName resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource == null ? null : resource.toString()).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

