/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigqueryconnection.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.bigquery.connection.v1.Connection;
import com.google.cloud.bigquery.connection.v1.ConnectionName;
import com.google.cloud.bigquery.connection.v1.CreateConnectionRequest;
import com.google.cloud.bigquery.connection.v1.DeleteConnectionRequest;
import com.google.cloud.bigquery.connection.v1.GetConnectionRequest;
import com.google.cloud.bigquery.connection.v1.ListConnectionsRequest;
import com.google.cloud.bigquery.connection.v1.ListConnectionsResponse;
import com.google.cloud.bigquery.connection.v1.LocationName;
import com.google.cloud.bigquery.connection.v1.UpdateConnectionRequest;
import com.google.cloud.bigqueryconnection.v1.ConnectionServiceSettings;
import com.google.cloud.bigqueryconnection.v1.stub.ConnectionServiceStub;
import com.google.cloud.bigqueryconnection.v1.stub.ConnectionServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.GetPolicyOptions;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ConnectionServiceClient
implements BackgroundResource {
    private final ConnectionServiceSettings settings;
    private final ConnectionServiceStub stub;

    public static final ConnectionServiceClient create() throws IOException {
        return ConnectionServiceClient.create(ConnectionServiceSettings.newBuilder().build());
    }

    public static final ConnectionServiceClient create(ConnectionServiceSettings settings) throws IOException {
        return new ConnectionServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ConnectionServiceClient create(ConnectionServiceStub stub) {
        return new ConnectionServiceClient(stub);
    }

    protected ConnectionServiceClient(ConnectionServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ConnectionServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ConnectionServiceClient(ConnectionServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ConnectionServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ConnectionServiceStub getStub() {
        return this.stub;
    }

    public final Connection createConnection(LocationName parent, Connection connection, String connectionId) {
        CreateConnectionRequest request = CreateConnectionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setConnection(connection).setConnectionId(connectionId).build();
        return this.createConnection(request);
    }

    public final Connection createConnection(String parent, Connection connection, String connectionId) {
        CreateConnectionRequest request = CreateConnectionRequest.newBuilder().setParent(parent).setConnection(connection).setConnectionId(connectionId).build();
        return this.createConnection(request);
    }

    public final Connection createConnection(CreateConnectionRequest request) {
        return (Connection)this.createConnectionCallable().call((Object)request);
    }

    public final UnaryCallable<CreateConnectionRequest, Connection> createConnectionCallable() {
        return this.stub.createConnectionCallable();
    }

    public final Connection getConnection(ConnectionName name) {
        GetConnectionRequest request = GetConnectionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getConnection(request);
    }

    public final Connection getConnection(String name) {
        GetConnectionRequest request = GetConnectionRequest.newBuilder().setName(name).build();
        return this.getConnection(request);
    }

    public final Connection getConnection(GetConnectionRequest request) {
        return (Connection)this.getConnectionCallable().call((Object)request);
    }

    public final UnaryCallable<GetConnectionRequest, Connection> getConnectionCallable() {
        return this.stub.getConnectionCallable();
    }

    public final ListConnectionsPagedResponse listConnections(ListConnectionsRequest request) {
        return (ListConnectionsPagedResponse)((Object)this.listConnectionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListConnectionsRequest, ListConnectionsPagedResponse> listConnectionsPagedCallable() {
        return this.stub.listConnectionsPagedCallable();
    }

    public final UnaryCallable<ListConnectionsRequest, ListConnectionsResponse> listConnectionsCallable() {
        return this.stub.listConnectionsCallable();
    }

    public final Connection updateConnection(ConnectionName name, Connection connection, FieldMask updateMask) {
        UpdateConnectionRequest request = UpdateConnectionRequest.newBuilder().setName(name == null ? null : name.toString()).setConnection(connection).setUpdateMask(updateMask).build();
        return this.updateConnection(request);
    }

    public final Connection updateConnection(String name, Connection connection, FieldMask updateMask) {
        UpdateConnectionRequest request = UpdateConnectionRequest.newBuilder().setName(name).setConnection(connection).setUpdateMask(updateMask).build();
        return this.updateConnection(request);
    }

    public final Connection updateConnection(UpdateConnectionRequest request) {
        return (Connection)this.updateConnectionCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateConnectionRequest, Connection> updateConnectionCallable() {
        return this.stub.updateConnectionCallable();
    }

    public final void deleteConnection(ConnectionName name) {
        DeleteConnectionRequest request = DeleteConnectionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteConnection(request);
    }

    public final void deleteConnection(String name) {
        DeleteConnectionRequest request = DeleteConnectionRequest.newBuilder().setName(name).build();
        this.deleteConnection(request);
    }

    public final void deleteConnection(DeleteConnectionRequest request) {
        this.deleteConnectionCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteConnectionRequest, Empty> deleteConnectionCallable() {
        return this.stub.deleteConnectionCallable();
    }

    public final Policy getIamPolicy(ResourceName resource, GetPolicyOptions options) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setOptions(options).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(String resource, GetPolicyOptions options) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).setOptions(options).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final Policy setIamPolicy(ResourceName resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(String resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(ResourceName resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource == null ? null : resource.toString()).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListConnectionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListConnectionsRequest, ListConnectionsResponse, Connection, ListConnectionsPage, ListConnectionsFixedSizeCollection> {
        private ListConnectionsFixedSizeCollection(List<ListConnectionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListConnectionsFixedSizeCollection createEmptyCollection() {
            return new ListConnectionsFixedSizeCollection(null, 0);
        }

        protected ListConnectionsFixedSizeCollection createCollection(List<ListConnectionsPage> pages, int collectionSize) {
            return new ListConnectionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListConnectionsPage
    extends AbstractPage<ListConnectionsRequest, ListConnectionsResponse, Connection, ListConnectionsPage> {
        private ListConnectionsPage(PageContext<ListConnectionsRequest, ListConnectionsResponse, Connection> context, ListConnectionsResponse response) {
            super(context, (Object)response);
        }

        private static ListConnectionsPage createEmptyPage() {
            return new ListConnectionsPage(null, null);
        }

        protected ListConnectionsPage createPage(PageContext<ListConnectionsRequest, ListConnectionsResponse, Connection> context, ListConnectionsResponse response) {
            return new ListConnectionsPage(context, response);
        }

        public ApiFuture<ListConnectionsPage> createPageAsync(PageContext<ListConnectionsRequest, ListConnectionsResponse, Connection> context, ApiFuture<ListConnectionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListConnectionsPagedResponse
    extends AbstractPagedListResponse<ListConnectionsRequest, ListConnectionsResponse, Connection, ListConnectionsPage, ListConnectionsFixedSizeCollection> {
        public static ApiFuture<ListConnectionsPagedResponse> createAsync(PageContext<ListConnectionsRequest, ListConnectionsResponse, Connection> context, ApiFuture<ListConnectionsResponse> futureResponse) {
            ApiFuture<ListConnectionsPage> futurePage = ListConnectionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListConnectionsPage, ListConnectionsPagedResponse>(){

                public ListConnectionsPagedResponse apply(ListConnectionsPage input) {
                    return new ListConnectionsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListConnectionsPagedResponse(ListConnectionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListConnectionsFixedSizeCollection.createEmptyCollection());
        }
    }
}

