/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.core.ApiFunction;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.DatasetAccessEntry;
import com.google.cloud.StringEnumType;
import com.google.cloud.StringEnumValue;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.RoutineId;
import com.google.cloud.bigquery.TableId;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public final class Acl
implements Serializable {
    private static final long serialVersionUID = 8357269726277191556L;
    private final Entity entity;
    private final Role role;

    private Acl(Entity entity, Role role) {
        this.entity = (Entity)Preconditions.checkNotNull((Object)entity);
        this.role = role;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public Role getRole() {
        return this.role;
    }

    public static Acl of(Entity entity, Role role) {
        return new Acl(entity, role);
    }

    public static Acl of(DatasetAclEntity datasetAclEntity) {
        return new Acl(datasetAclEntity, null);
    }

    public static Acl of(View view) {
        return new Acl(view, null);
    }

    public static Acl of(Routine routine) {
        return new Acl(routine, null);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.entity, this.role});
    }

    public String toString() {
        return this.toPb().toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Acl other = (Acl)obj;
        return Objects.equals(this.entity, other.entity) && Objects.equals((Object)this.role, (Object)other.role);
    }

    Dataset.Access toPb() {
        Dataset.Access accessPb = this.entity.toPb();
        if (this.role != null) {
            accessPb.setRole(this.role.name());
        }
        return accessPb;
    }

    static Acl fromPb(Dataset.Access access) {
        return Acl.of(Entity.fromPb(access), access.getRole() != null ? Role.valueOf(access.getRole()) : null);
    }

    public static final class IamMember
    extends Entity {
        private static final long serialVersionUID = 3562909264454016939L;
        private final String iamMember;

        public IamMember(String iamMember) {
            super(Entity.Type.IAM_MEMBER);
            this.iamMember = iamMember;
        }

        public String getIamMember() {
            return this.iamMember;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            IamMember iam = (IamMember)obj;
            return Objects.equals((Object)this.getType(), (Object)iam.getType()) && Objects.equals(this.iamMember, iam.iamMember);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getType(), this.iamMember});
        }

        public String toString() {
            return this.toPb().toString();
        }

        @Override
        Dataset.Access toPb() {
            return new Dataset.Access().setIamMember(this.iamMember);
        }
    }

    public static final class Routine
    extends Entity {
        private static final long serialVersionUID = -8392885851733136262L;
        private final RoutineId id;

        public Routine(RoutineId id) {
            super(Entity.Type.ROUTINE);
            this.id = id;
        }

        public RoutineId getId() {
            return this.id;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Routine routine = (Routine)obj;
            return Objects.equals((Object)this.getType(), (Object)routine.getType()) && Objects.equals(this.id, routine.id);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getType(), this.id});
        }

        public String toString() {
            return this.toPb().toString();
        }

        @Override
        Dataset.Access toPb() {
            return new Dataset.Access().setRoutine(this.id.toPb());
        }
    }

    public static final class View
    extends Entity {
        private static final long serialVersionUID = -6851072781269419383L;
        private final TableId id;

        public View(TableId id) {
            super(Entity.Type.VIEW);
            this.id = id;
        }

        public TableId getId() {
            return this.id;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            View view = (View)obj;
            return Objects.equals((Object)this.getType(), (Object)view.getType()) && Objects.equals(this.id, view.id);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getType(), this.id});
        }

        public String toString() {
            return this.toPb().toString();
        }

        @Override
        Dataset.Access toPb() {
            return new Dataset.Access().setView(this.id.toPb());
        }
    }

    public static final class User
    extends Entity {
        private static final long serialVersionUID = -4942821351073996141L;
        private final String email;

        public User(String email) {
            super(Entity.Type.USER);
            this.email = email;
        }

        public String getEmail() {
            return this.email;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            User user = (User)obj;
            return Objects.equals((Object)this.getType(), (Object)user.getType()) && Objects.equals(this.email, user.email);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getType(), this.email});
        }

        public String toString() {
            return this.toPb().toString();
        }

        @Override
        Dataset.Access toPb() {
            return new Dataset.Access().setUserByEmail(this.email);
        }
    }

    public static final class Group
    extends Entity {
        private static final String PROJECT_OWNERS = "projectOwners";
        private static final String PROJECT_READERS = "projectReaders";
        private static final String PROJECT_WRITERS = "projectWriters";
        private static final String ALL_AUTHENTICATED_USERS = "allAuthenticatedUsers";
        private static final long serialVersionUID = 5146829352398103029L;
        private final String identifier;

        public Group(String identifier) {
            super(Entity.Type.GROUP);
            this.identifier = identifier;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Group group = (Group)obj;
            return Objects.equals((Object)this.getType(), (Object)group.getType()) && Objects.equals(this.identifier, group.identifier);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getType(), this.identifier});
        }

        public String toString() {
            return this.toPb().toString();
        }

        @Override
        Dataset.Access toPb() {
            switch (this.identifier) {
                case "projectOwners": {
                    return new Dataset.Access().setSpecialGroup(PROJECT_OWNERS);
                }
                case "projectReaders": {
                    return new Dataset.Access().setSpecialGroup(PROJECT_READERS);
                }
                case "projectWriters": {
                    return new Dataset.Access().setSpecialGroup(PROJECT_WRITERS);
                }
                case "allAuthenticatedUsers": {
                    return new Dataset.Access().setSpecialGroup(ALL_AUTHENTICATED_USERS);
                }
            }
            return new Dataset.Access().setGroupByEmail(this.identifier);
        }

        public static Group ofProjectOwners() {
            return new Group(PROJECT_OWNERS);
        }

        public static Group ofProjectReaders() {
            return new Group(PROJECT_READERS);
        }

        public static Group ofProjectWriters() {
            return new Group(PROJECT_WRITERS);
        }

        public static Group ofAllAuthenticatedUsers() {
            return new Group(ALL_AUTHENTICATED_USERS);
        }
    }

    public static final class Domain
    extends Entity {
        private static final long serialVersionUID = -3033025857280447253L;
        private final String domain;

        public Domain(String domain) {
            super(Entity.Type.DOMAIN);
            this.domain = domain;
        }

        public String getDomain() {
            return this.domain;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Domain domainEntity = (Domain)obj;
            return Objects.equals((Object)this.getType(), (Object)domainEntity.getType()) && Objects.equals(this.domain, domainEntity.getDomain());
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getType(), this.domain});
        }

        public String toString() {
            return this.toPb().toString();
        }

        @Override
        Dataset.Access toPb() {
            return new Dataset.Access().setDomain(this.domain);
        }
    }

    public static final class DatasetAclEntity
    extends Entity {
        private static final long serialVersionUID = -8392885851733136526L;
        private final DatasetId id;
        private final List<String> targetTypes;

        public DatasetAclEntity(DatasetId id, List<String> targetTypes) {
            super(Entity.Type.DATASET);
            this.id = id;
            this.targetTypes = targetTypes;
        }

        public DatasetId getId() {
            return this.id;
        }

        public List<String> getTargetTypes() {
            return this.targetTypes;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DatasetAclEntity datasetAclEntity = (DatasetAclEntity)obj;
            return Objects.equals((Object)this.getType(), (Object)datasetAclEntity.getType()) && Objects.equals(this.id, datasetAclEntity.id);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getType(), this.id});
        }

        public String toString() {
            return this.toPb().toString();
        }

        @Override
        Dataset.Access toPb() {
            return new Dataset.Access().setDataset(new DatasetAccessEntry().setDataset(this.id.toPb()).setTargetTypes(this.targetTypes));
        }
    }

    public static abstract class Entity
    implements Serializable {
        private static final long serialVersionUID = 8111776788607959944L;
        private final Type type;

        Entity(Type type) {
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }

        abstract Dataset.Access toPb();

        static Entity fromPb(Dataset.Access access) {
            if (access.getDataset() != null) {
                return new DatasetAclEntity(DatasetId.fromPb(access.getDataset().getDataset()), access.getDataset().getTargetTypes());
            }
            if (access.getDomain() != null) {
                return new Domain(access.getDomain());
            }
            if (access.getGroupByEmail() != null) {
                return new Group(access.getGroupByEmail());
            }
            if (access.getSpecialGroup() != null) {
                return new Group(access.getSpecialGroup());
            }
            if (access.getUserByEmail() != null) {
                return new User(access.getUserByEmail());
            }
            if (access.getView() != null) {
                return new View(TableId.fromPb(access.getView()));
            }
            if (access.getIamMember() != null) {
                return new IamMember(access.getIamMember());
            }
            if (access.getRoutine() != null) {
                return new Routine(RoutineId.fromPb(access.getRoutine()));
            }
            throw new BigQueryException(0, "Unrecognized access configuration");
        }

        public static enum Type {
            DOMAIN,
            GROUP,
            USER,
            VIEW,
            IAM_MEMBER,
            ROUTINE,
            DATASET;

        }
    }

    public static final class Role
    extends StringEnumValue {
        private static final long serialVersionUID = -1992679397135956912L;
        private static final ApiFunction<String, Role> CONSTRUCTOR = new ApiFunction<String, Role>(){

            public Role apply(String constant) {
                return new Role(constant);
            }
        };
        private static final StringEnumType<Role> type = new StringEnumType(Role.class, CONSTRUCTOR);
        public static final Role READER = (Role)((Object)type.createAndRegister("READER"));
        public static final Role WRITER = (Role)((Object)type.createAndRegister("WRITER"));
        public static final Role OWNER = (Role)((Object)type.createAndRegister("OWNER"));

        private Role(String constant) {
            super(constant);
        }

        public static Role valueOfStrict(String constant) {
            return (Role)((Object)type.valueOfStrict(constant));
        }

        public static Role valueOf(String constant) {
            return (Role)((Object)type.valueOf(constant));
        }

        public static Role[] values() {
            return (Role[])type.values();
        }
    }
}

