/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.core.ApiClock;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.paging.Page;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.services.bigquery.model.ErrorProto;
import com.google.api.services.bigquery.model.GetQueryResultsResponse;
import com.google.api.services.bigquery.model.QueryRequest;
import com.google.api.services.bigquery.model.TableDataInsertAllRequest;
import com.google.api.services.bigquery.model.TableDataInsertAllResponse;
import com.google.api.services.bigquery.model.TableDataList;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.api.services.bigquery.model.TestIamPermissionsResponse;
import com.google.cloud.BaseService;
import com.google.cloud.PageImpl;
import com.google.cloud.Policy;
import com.google.cloud.RetryHelper;
import com.google.cloud.ServiceOptions;
import com.google.cloud.Tuple;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryBaseService;
import com.google.cloud.bigquery.BigQueryError;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.BigQueryRetryConfig;
import com.google.cloud.bigquery.BigQueryRetryHelper;
import com.google.cloud.bigquery.Connection;
import com.google.cloud.bigquery.ConnectionImpl;
import com.google.cloud.bigquery.ConnectionSettings;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.InsertAllRequest;
import com.google.cloud.bigquery.InsertAllResponse;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobException;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.JobStatistics;
import com.google.cloud.bigquery.JobStatus;
import com.google.cloud.bigquery.Model;
import com.google.cloud.bigquery.ModelId;
import com.google.cloud.bigquery.ModelInfo;
import com.google.cloud.bigquery.Option;
import com.google.cloud.bigquery.PolicyHelper;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.QueryRequestInfo;
import com.google.cloud.bigquery.QueryResponse;
import com.google.cloud.bigquery.Routine;
import com.google.cloud.bigquery.RoutineId;
import com.google.cloud.bigquery.RoutineInfo;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDataWriteChannel;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.TableResult;
import com.google.cloud.bigquery.WriteChannelConfiguration;
import com.google.cloud.bigquery.spi.v2.BigQueryRpc;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.threeten.bp.Instant;
import org.threeten.bp.temporal.ChronoUnit;
import org.threeten.bp.temporal.TemporalUnit;

final class BigQueryImpl
extends BaseService<BigQueryOptions>
implements BigQuery {
    private final BigQueryRpc bigQueryRpc;
    private static final BigQueryRetryConfig DEFAULT_RETRY_CONFIG = BigQueryRetryConfig.newBuilder().retryOnMessage("Exceeded rate limits:").retryOnMessage("Job exceeded rate limits:").retryOnRegEx(".*exceed.*rate.*limit.*").build();

    BigQueryImpl(BigQueryOptions options) {
        super((ServiceOptions)options);
        this.bigQueryRpc = options.getBigQueryRpcV2();
    }

    @Override
    public Dataset create(DatasetInfo datasetInfo, BigQuery.DatasetOption ... options) {
        final com.google.api.services.bigquery.model.Dataset datasetPb = datasetInfo.setProjectId(Strings.isNullOrEmpty((String)datasetInfo.getDatasetId().getProject()) ? ((BigQueryOptions)this.getOptions()).getProjectId() : datasetInfo.getDatasetId().getProject()).toPb();
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        try {
            return Dataset.fromPb(this, (com.google.api.services.bigquery.model.Dataset)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.bigquery.model.Dataset>(){

                @Override
                public com.google.api.services.bigquery.model.Dataset call() {
                    return BigQueryImpl.this.bigQueryRpc.create(datasetPb, optionsMap);
                }
            }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public Table create(TableInfo tableInfo, BigQuery.TableOption ... options) {
        final com.google.api.services.bigquery.model.Table tablePb = tableInfo.setProjectId(Strings.isNullOrEmpty((String)tableInfo.getTableId().getProject()) ? ((BigQueryOptions)this.getOptions()).getProjectId() : tableInfo.getTableId().getProject()).toPb();
        this.handleExternalTableSchema(tablePb);
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        try {
            return Table.fromPb(this, (com.google.api.services.bigquery.model.Table)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.bigquery.model.Table>(){

                @Override
                public com.google.api.services.bigquery.model.Table call() {
                    return BigQueryImpl.this.bigQueryRpc.create(tablePb, optionsMap);
                }
            }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    private void handleExternalTableSchema(com.google.api.services.bigquery.model.Table tablePb) {
        if (tablePb.getExternalDataConfiguration() != null) {
            tablePb.setSchema(tablePb.getExternalDataConfiguration().getSchema());
            tablePb.getExternalDataConfiguration().setSchema(null);
        }
    }

    @Override
    public Routine create(RoutineInfo routineInfo, BigQuery.RoutineOption ... options) {
        final com.google.api.services.bigquery.model.Routine routinePb = routineInfo.setProjectId(Strings.isNullOrEmpty((String)routineInfo.getRoutineId().getProject()) ? ((BigQueryOptions)this.getOptions()).getProjectId() : routineInfo.getRoutineId().getProject()).toPb();
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        try {
            return Routine.fromPb(this, (com.google.api.services.bigquery.model.Routine)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.bigquery.model.Routine>(){

                @Override
                public com.google.api.services.bigquery.model.Routine call() {
                    return BigQueryImpl.this.bigQueryRpc.create(routinePb, optionsMap);
                }
            }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public Job create(JobInfo jobInfo, BigQuery.JobOption ... options) {
        Supplier<JobId> idProvider = new Supplier<JobId>(){

            public JobId get() {
                return JobId.of();
            }
        };
        return this.create(jobInfo, idProvider, options);
    }

    @Override
    @BetaApi
    public Connection createConnection(@NonNull ConnectionSettings connectionSettings) throws BigQueryException {
        return new ConnectionImpl(connectionSettings, (BigQueryOptions)this.getOptions(), this.bigQueryRpc, DEFAULT_RETRY_CONFIG);
    }

    @Override
    @BetaApi
    public Connection createConnection() throws BigQueryException {
        ConnectionSettings defaultConnectionSettings = ConnectionSettings.newBuilder().build();
        return new ConnectionImpl(defaultConnectionSettings, (BigQueryOptions)this.getOptions(), this.bigQueryRpc, DEFAULT_RETRY_CONFIG);
    }

    @InternalApi(value="visible for testing")
    Job create(final JobInfo jobInfo, final Supplier<JobId> idProvider, BigQuery.JobOption ... options) {
        final boolean idRandom = jobInfo.getJobId() == null;
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        final JobId[] finalJobId = new JobId[1];
        try {
            try {
                return Job.fromPb(this, BigQueryRetryHelper.runWithRetries(new Callable<com.google.api.services.bigquery.model.Job>(){

                    @Override
                    public com.google.api.services.bigquery.model.Job call() {
                        if (idRandom) {
                            JobInfo recreatedJobInfo = jobInfo.toBuilder().setJobId((JobId)idProvider.get()).build();
                            com.google.api.services.bigquery.model.Job newJobPb = recreatedJobInfo.setProjectId(((BigQueryOptions)BigQueryImpl.this.getOptions()).getProjectId()).toPb();
                            finalJobId[0] = recreatedJobInfo.getJobId();
                            return BigQueryImpl.this.bigQueryRpc.create(newJobPb, optionsMap);
                        }
                        com.google.api.services.bigquery.model.Job jobPb = jobInfo.setProjectId(((BigQueryOptions)BigQueryImpl.this.getOptions()).getProjectId()).toPb();
                        return BigQueryImpl.this.bigQueryRpc.create(jobPb, optionsMap);
                    }
                }, ((BigQueryOptions)this.getOptions()).getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, ((BigQueryOptions)this.getOptions()).getClock(), DEFAULT_RETRY_CONFIG));
            }
            catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
                throw BigQueryException.translateAndThrow(e);
            }
        }
        catch (BigQueryException e) {
            Job job;
            BigQueryException createException = e;
            if (!idRandom) {
                long jobMinStaleTime;
                long jobMaxStaleTime;
                Job job2;
                long jobCreationTime;
                Pattern pattern;
                Matcher matcher;
                if (createException instanceof BigQueryException && createException.getCause() != null && (matcher = (pattern = Pattern.compile(".*Already.*Exists:.*Job.*", 2)).matcher(createException.getCause().getMessage())).find() && (jobCreationTime = ((JobStatistics)(job2 = this.getJob(jobInfo.getJobId(), BigQuery.JobOption.fields(BigQuery.JobField.STATISTICS))).getStatistics()).getCreationTime().longValue()) >= (jobMaxStaleTime = Instant.ofEpochMilli((long)(jobMinStaleTime = System.currentTimeMillis())).minus(1L, (TemporalUnit)ChronoUnit.DAYS).toEpochMilli()) && jobCreationTime <= jobMinStaleTime) {
                    return job2;
                }
                throw createException;
            }
            try {
                job = this.getJob(finalJobId[0], new BigQuery.JobOption[0]);
            }
            catch (BigQueryException e2) {
                throw createException;
            }
            if (job == null) {
                throw createException;
            }
            return job;
        }
    }

    @Override
    public Dataset getDataset(String datasetId, BigQuery.DatasetOption ... options) {
        return this.getDataset(DatasetId.of(datasetId), options);
    }

    @Override
    public Dataset getDataset(DatasetId datasetId, BigQuery.DatasetOption ... options) {
        final DatasetId completeDatasetId = datasetId.setProjectId(((BigQueryOptions)this.getOptions()).getProjectId());
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        try {
            com.google.api.services.bigquery.model.Dataset answer = (com.google.api.services.bigquery.model.Dataset)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.bigquery.model.Dataset>(){

                @Override
                public com.google.api.services.bigquery.model.Dataset call() {
                    return BigQueryImpl.this.bigQueryRpc.getDataset(completeDatasetId.getProject(), completeDatasetId.getDataset(), optionsMap);
                }
            }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock());
            if (((BigQueryOptions)this.getOptions()).getThrowNotFound() && answer == null) {
                throw new BigQueryException(404, "Dataset not found");
            }
            return answer == null ? null : Dataset.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public Page<Dataset> listDatasets(BigQuery.DatasetListOption ... options) {
        return this.listDatasets(((BigQueryOptions)this.getOptions()).getProjectId(), options);
    }

    @Override
    public Page<Dataset> listDatasets(String projectId, BigQuery.DatasetListOption ... options) {
        return BigQueryImpl.listDatasets(projectId, (BigQueryOptions)this.getOptions(), BigQueryImpl.optionMap(options));
    }

    private static Page<Dataset> listDatasets(final String projectId, final BigQueryOptions serviceOptions, final Map<BigQueryRpc.Option, ?> optionsMap) {
        try {
            Tuple result = (Tuple)RetryHelper.runWithRetries((Callable)new Callable<Tuple<String, Iterable<com.google.api.services.bigquery.model.Dataset>>>(){

                @Override
                public Tuple<String, Iterable<com.google.api.services.bigquery.model.Dataset>> call() {
                    return serviceOptions.getBigQueryRpcV2().listDatasets(projectId, optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            String cursor = (String)result.x();
            return new PageImpl((PageImpl.NextPageFetcher)new DatasetPageFetcher(projectId, serviceOptions, cursor, optionsMap), cursor, Iterables.transform((Iterable)((Iterable)result.y()), (Function)new Function<com.google.api.services.bigquery.model.Dataset, Dataset>(){

                public Dataset apply(com.google.api.services.bigquery.model.Dataset dataset) {
                    return Dataset.fromPb((BigQuery)serviceOptions.getService(), dataset);
                }
            }));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public boolean delete(String datasetId, BigQuery.DatasetDeleteOption ... options) {
        return this.delete(DatasetId.of(datasetId), options);
    }

    @Override
    public boolean delete(DatasetId datasetId, BigQuery.DatasetDeleteOption ... options) {
        final DatasetId completeDatasetId = datasetId.setProjectId(((BigQueryOptions)this.getOptions()).getProjectId());
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        try {
            return (Boolean)RetryHelper.runWithRetries((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return BigQueryImpl.this.bigQueryRpc.deleteDataset(completeDatasetId.getProject(), completeDatasetId.getDataset(), optionsMap);
                }
            }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public boolean delete(String datasetId, String tableId) {
        return this.delete(TableId.of(datasetId, tableId));
    }

    @Override
    public boolean delete(TableId tableId) {
        final TableId completeTableId = tableId.setProjectId(Strings.isNullOrEmpty((String)tableId.getProject()) ? ((BigQueryOptions)this.getOptions()).getProjectId() : tableId.getProject());
        try {
            return (Boolean)RetryHelper.runWithRetries((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return BigQueryImpl.this.bigQueryRpc.deleteTable(completeTableId.getProject(), completeTableId.getDataset(), completeTableId.getTable());
                }
            }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public boolean delete(ModelId modelId) {
        final ModelId completeModelId = modelId.setProjectId(Strings.isNullOrEmpty((String)modelId.getProject()) ? ((BigQueryOptions)this.getOptions()).getProjectId() : modelId.getProject());
        try {
            return (Boolean)RetryHelper.runWithRetries((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return BigQueryImpl.this.bigQueryRpc.deleteModel(completeModelId.getProject(), completeModelId.getDataset(), completeModelId.getModel());
                }
            }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public boolean delete(RoutineId routineId) {
        final RoutineId completeRoutineId = routineId.setProjectId(Strings.isNullOrEmpty((String)routineId.getProject()) ? ((BigQueryOptions)this.getOptions()).getProjectId() : routineId.getProject());
        try {
            return (Boolean)RetryHelper.runWithRetries((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return BigQueryImpl.this.bigQueryRpc.deleteRoutine(completeRoutineId.getProject(), completeRoutineId.getDataset(), completeRoutineId.getRoutine());
                }
            }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public boolean delete(JobId jobId) {
        final JobId completeJobId = jobId.setProjectId(Strings.isNullOrEmpty((String)jobId.getProject()) ? ((BigQueryOptions)this.getOptions()).getProjectId() : jobId.getProject());
        try {
            return (Boolean)RetryHelper.runWithRetries((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return BigQueryImpl.this.bigQueryRpc.deleteJob(completeJobId.getProject(), completeJobId.getJob(), completeJobId.getLocation());
                }
            }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public Dataset update(DatasetInfo datasetInfo, BigQuery.DatasetOption ... options) {
        final com.google.api.services.bigquery.model.Dataset datasetPb = datasetInfo.setProjectId(((BigQueryOptions)this.getOptions()).getProjectId()).toPb();
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        try {
            return Dataset.fromPb(this, (com.google.api.services.bigquery.model.Dataset)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.bigquery.model.Dataset>(){

                @Override
                public com.google.api.services.bigquery.model.Dataset call() {
                    return BigQueryImpl.this.bigQueryRpc.patch(datasetPb, optionsMap);
                }
            }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public Table update(TableInfo tableInfo, BigQuery.TableOption ... options) {
        final com.google.api.services.bigquery.model.Table tablePb = tableInfo.setProjectId(Strings.isNullOrEmpty((String)tableInfo.getTableId().getProject()) ? ((BigQueryOptions)this.getOptions()).getProjectId() : tableInfo.getTableId().getProject()).toPb();
        this.handleExternalTableSchema(tablePb);
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        try {
            return Table.fromPb(this, (com.google.api.services.bigquery.model.Table)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.bigquery.model.Table>(){

                @Override
                public com.google.api.services.bigquery.model.Table call() {
                    return BigQueryImpl.this.bigQueryRpc.patch(tablePb, optionsMap);
                }
            }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public Model update(ModelInfo modelInfo, BigQuery.ModelOption ... options) {
        final com.google.api.services.bigquery.model.Model modelPb = modelInfo.setProjectId(Strings.isNullOrEmpty((String)modelInfo.getModelId().getProject()) ? ((BigQueryOptions)this.getOptions()).getProjectId() : modelInfo.getModelId().getProject()).toPb();
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        try {
            return Model.fromPb(this, (com.google.api.services.bigquery.model.Model)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.bigquery.model.Model>(){

                @Override
                public com.google.api.services.bigquery.model.Model call() {
                    return BigQueryImpl.this.bigQueryRpc.patch(modelPb, optionsMap);
                }
            }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public Routine update(RoutineInfo routineInfo, BigQuery.RoutineOption ... options) {
        final com.google.api.services.bigquery.model.Routine routinePb = routineInfo.setProjectId(Strings.isNullOrEmpty((String)routineInfo.getRoutineId().getProject()) ? ((BigQueryOptions)this.getOptions()).getProjectId() : routineInfo.getRoutineId().getProject()).toPb();
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        try {
            return Routine.fromPb(this, (com.google.api.services.bigquery.model.Routine)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.bigquery.model.Routine>(){

                @Override
                public com.google.api.services.bigquery.model.Routine call() {
                    return BigQueryImpl.this.bigQueryRpc.update(routinePb, optionsMap);
                }
            }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public Table getTable(String datasetId, String tableId, BigQuery.TableOption ... options) {
        return this.getTable(TableId.of(datasetId, tableId), options);
    }

    @Override
    public Table getTable(TableId tableId, BigQuery.TableOption ... options) {
        final TableId completeTableId = tableId.setProjectId(Strings.isNullOrEmpty((String)tableId.getProject()) ? ((BigQueryOptions)this.getOptions()).getProjectId() : tableId.getProject());
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        try {
            com.google.api.services.bigquery.model.Table answer = (com.google.api.services.bigquery.model.Table)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.bigquery.model.Table>(){

                @Override
                public com.google.api.services.bigquery.model.Table call() {
                    return BigQueryImpl.this.bigQueryRpc.getTable(completeTableId.getProject(), completeTableId.getDataset(), completeTableId.getTable(), optionsMap);
                }
            }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock());
            if (((BigQueryOptions)this.getOptions()).getThrowNotFound() && answer == null) {
                throw new BigQueryException(404, "Table not found");
            }
            return answer == null ? null : Table.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public Model getModel(String datasetId, String modelId, BigQuery.ModelOption ... options) {
        return this.getModel(ModelId.of(datasetId, modelId), options);
    }

    @Override
    public Model getModel(ModelId modelId, BigQuery.ModelOption ... options) {
        final ModelId completeModelId = modelId.setProjectId(Strings.isNullOrEmpty((String)modelId.getProject()) ? ((BigQueryOptions)this.getOptions()).getProjectId() : modelId.getProject());
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        try {
            com.google.api.services.bigquery.model.Model answer = (com.google.api.services.bigquery.model.Model)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.bigquery.model.Model>(){

                @Override
                public com.google.api.services.bigquery.model.Model call() {
                    return BigQueryImpl.this.bigQueryRpc.getModel(completeModelId.getProject(), completeModelId.getDataset(), completeModelId.getModel(), optionsMap);
                }
            }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock());
            if (((BigQueryOptions)this.getOptions()).getThrowNotFound() && answer == null) {
                throw new BigQueryException(404, "Model not found");
            }
            return answer == null ? null : Model.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public Routine getRoutine(String datasetId, String routineId, BigQuery.RoutineOption ... options) {
        return this.getRoutine(RoutineId.of(datasetId, routineId), options);
    }

    @Override
    public Routine getRoutine(RoutineId routineId, BigQuery.RoutineOption ... options) {
        final RoutineId completeRoutineId = routineId.setProjectId(Strings.isNullOrEmpty((String)routineId.getProject()) ? ((BigQueryOptions)this.getOptions()).getProjectId() : routineId.getProject());
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        try {
            com.google.api.services.bigquery.model.Routine answer = (com.google.api.services.bigquery.model.Routine)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.bigquery.model.Routine>(){

                @Override
                public com.google.api.services.bigquery.model.Routine call() {
                    return BigQueryImpl.this.bigQueryRpc.getRoutine(completeRoutineId.getProject(), completeRoutineId.getDataset(), completeRoutineId.getRoutine(), optionsMap);
                }
            }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock());
            if (((BigQueryOptions)this.getOptions()).getThrowNotFound() && answer == null) {
                throw new BigQueryException(404, "Routine not found");
            }
            return answer == null ? null : Routine.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public Page<Table> listTables(String datasetId, BigQuery.TableListOption ... options) {
        return BigQueryImpl.listTables(DatasetId.of(((BigQueryOptions)this.getOptions()).getProjectId(), datasetId), (BigQueryOptions)this.getOptions(), BigQueryImpl.optionMap(options));
    }

    @Override
    public Page<Table> listTables(DatasetId datasetId, BigQuery.TableListOption ... options) {
        DatasetId completeDatasetId = datasetId.setProjectId(((BigQueryOptions)this.getOptions()).getProjectId());
        return BigQueryImpl.listTables(completeDatasetId, (BigQueryOptions)this.getOptions(), BigQueryImpl.optionMap(options));
    }

    @Override
    public Page<Model> listModels(String datasetId, BigQuery.ModelListOption ... options) {
        return BigQueryImpl.listModels(DatasetId.of(((BigQueryOptions)this.getOptions()).getProjectId(), datasetId), (BigQueryOptions)this.getOptions(), BigQueryImpl.optionMap(options));
    }

    @Override
    public Page<Model> listModels(DatasetId datasetId, BigQuery.ModelListOption ... options) {
        DatasetId completeDatasetId = datasetId.setProjectId(((BigQueryOptions)this.getOptions()).getProjectId());
        return BigQueryImpl.listModels(completeDatasetId, (BigQueryOptions)this.getOptions(), BigQueryImpl.optionMap(options));
    }

    @Override
    public Page<Routine> listRoutines(String datasetId, BigQuery.RoutineListOption ... options) {
        return BigQueryImpl.listRoutines(DatasetId.of(((BigQueryOptions)this.getOptions()).getProjectId(), datasetId), (BigQueryOptions)this.getOptions(), BigQueryImpl.optionMap(options));
    }

    @Override
    public Page<Routine> listRoutines(DatasetId datasetId, BigQuery.RoutineListOption ... options) {
        DatasetId completeDatasetId = datasetId.setProjectId(((BigQueryOptions)this.getOptions()).getProjectId());
        return BigQueryImpl.listRoutines(completeDatasetId, (BigQueryOptions)this.getOptions(), BigQueryImpl.optionMap(options));
    }

    @Override
    public List<String> listPartitions(TableId tableId) {
        ArrayList<String> partitions = new ArrayList<String>();
        String partitionsTable = tableId.getTable() + "$__PARTITIONS_SUMMARY__";
        TableId metaTableId = tableId.getProject() == null ? TableId.of(tableId.getDataset(), partitionsTable) : TableId.of(tableId.getProject(), tableId.getDataset(), partitionsTable);
        Table metaTable = this.getTable(metaTableId, new BigQuery.TableOption[0]);
        Schema metaSchema = ((TableDefinition)metaTable.getDefinition()).getSchema();
        String partition_id = null;
        for (Field field : metaSchema.getFields()) {
            if (!field.getName().equals("partition_id")) continue;
            partition_id = field.getName();
            break;
        }
        TableResult result = metaTable.list(metaSchema, new BigQuery.TableDataListOption[0]);
        for (FieldValueList list : result.iterateAll()) {
            partitions.add(list.get(partition_id).getStringValue());
        }
        return partitions;
    }

    private static Page<Table> listTables(final DatasetId datasetId, final BigQueryOptions serviceOptions, final Map<BigQueryRpc.Option, ?> optionsMap) {
        try {
            Tuple result = (Tuple)RetryHelper.runWithRetries((Callable)new Callable<Tuple<String, Iterable<com.google.api.services.bigquery.model.Table>>>(){

                @Override
                public Tuple<String, Iterable<com.google.api.services.bigquery.model.Table>> call() {
                    return serviceOptions.getBigQueryRpcV2().listTables(datasetId.getProject(), datasetId.getDataset(), optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            String cursor = (String)result.x();
            Iterable tables = Iterables.transform((Iterable)((Iterable)result.y()), (Function)new Function<com.google.api.services.bigquery.model.Table, Table>(){

                public Table apply(com.google.api.services.bigquery.model.Table table) {
                    return Table.fromPb((BigQuery)serviceOptions.getService(), table);
                }
            });
            return new PageImpl((PageImpl.NextPageFetcher)new TablePageFetcher(datasetId, serviceOptions, cursor, optionsMap), cursor, tables);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    private static Page<Model> listModels(final DatasetId datasetId, final BigQueryOptions serviceOptions, final Map<BigQueryRpc.Option, ?> optionsMap) {
        try {
            Tuple result = (Tuple)RetryHelper.runWithRetries((Callable)new Callable<Tuple<String, Iterable<com.google.api.services.bigquery.model.Model>>>(){

                @Override
                public Tuple<String, Iterable<com.google.api.services.bigquery.model.Model>> call() {
                    return serviceOptions.getBigQueryRpcV2().listModels(datasetId.getProject(), datasetId.getDataset(), optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            String cursor = (String)result.x();
            Iterable models = Iterables.transform((Iterable)((Iterable)result.y()), (Function)new Function<com.google.api.services.bigquery.model.Model, Model>(){

                public Model apply(com.google.api.services.bigquery.model.Model model) {
                    return Model.fromPb((BigQuery)serviceOptions.getService(), model);
                }
            });
            return new PageImpl((PageImpl.NextPageFetcher)new ModelPageFetcher(datasetId, serviceOptions, cursor, optionsMap), cursor, models);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    private static Page<Routine> listRoutines(final DatasetId datasetId, final BigQueryOptions serviceOptions, final Map<BigQueryRpc.Option, ?> optionsMap) {
        try {
            Tuple result = (Tuple)RetryHelper.runWithRetries((Callable)new Callable<Tuple<String, Iterable<com.google.api.services.bigquery.model.Routine>>>(){

                @Override
                public Tuple<String, Iterable<com.google.api.services.bigquery.model.Routine>> call() {
                    return serviceOptions.getBigQueryRpcV2().listRoutines(datasetId.getProject(), datasetId.getDataset(), optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            String cursor = (String)result.x();
            Iterable routines = Iterables.transform((Iterable)((Iterable)result.y()), (Function)new Function<com.google.api.services.bigquery.model.Routine, Routine>(){

                public Routine apply(com.google.api.services.bigquery.model.Routine routinePb) {
                    return Routine.fromPb((BigQuery)serviceOptions.getService(), routinePb);
                }
            });
            return new PageImpl((PageImpl.NextPageFetcher)new RoutinePageFetcher(datasetId, serviceOptions, cursor, optionsMap), cursor, routines);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public InsertAllResponse insertAll(InsertAllRequest request) {
        TableDataInsertAllResponse responsePb;
        final TableId tableId = request.getTable().setProjectId(Strings.isNullOrEmpty((String)request.getTable().getProject()) ? ((BigQueryOptions)this.getOptions()).getProjectId() : request.getTable().getProject());
        final TableDataInsertAllRequest requestPb = new TableDataInsertAllRequest();
        requestPb.setIgnoreUnknownValues(request.ignoreUnknownValues());
        requestPb.setSkipInvalidRows(request.skipInvalidRows());
        requestPb.setTemplateSuffix(request.getTemplateSuffix());
        final boolean[] allInsertIdsSet = new boolean[]{true};
        ImmutableList rowsPb = FluentIterable.from(request.getRows()).transform((Function)new Function<InsertAllRequest.RowToInsert, TableDataInsertAllRequest.Rows>(){

            public TableDataInsertAllRequest.Rows apply(InsertAllRequest.RowToInsert rowToInsert) {
                allInsertIdsSet[0] = allInsertIdsSet[0] & rowToInsert.getId() != null;
                return new TableDataInsertAllRequest.Rows().setInsertId(rowToInsert.getId()).setJson(rowToInsert.getContent());
            }
        }).toList();
        requestPb.setRows((List)rowsPb);
        if (allInsertIdsSet[0]) {
            try {
                responsePb = (TableDataInsertAllResponse)RetryHelper.runWithRetries((Callable)new Callable<TableDataInsertAllResponse>(){

                    @Override
                    public TableDataInsertAllResponse call() throws Exception {
                        return BigQueryImpl.this.bigQueryRpc.insertAll(tableId.getProject(), tableId.getDataset(), tableId.getTable(), requestPb);
                    }
                }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock());
            }
            catch (RetryHelper.RetryHelperException e) {
                throw BigQueryException.translateAndThrow(e);
            }
        } else {
            responsePb = this.bigQueryRpc.insertAll(tableId.getProject(), tableId.getDataset(), tableId.getTable(), requestPb);
        }
        return InsertAllResponse.fromPb(responsePb);
    }

    @Override
    public TableResult listTableData(String datasetId, String tableId, BigQuery.TableDataListOption ... options) {
        return this.listTableData(TableId.of(datasetId, tableId), options);
    }

    @Override
    public TableResult listTableData(TableId tableId, BigQuery.TableDataListOption ... options) {
        return this.listTableData(tableId, (Schema)null, options);
    }

    @Override
    public TableResult listTableData(String datasetId, String tableId, Schema schema, BigQuery.TableDataListOption ... options) {
        return this.listTableData(TableId.of(datasetId, tableId), schema, options);
    }

    @Override
    public TableResult listTableData(TableId tableId, Schema schema, BigQuery.TableDataListOption ... options) {
        Tuple<? extends Page<FieldValueList>, Long> data = BigQueryImpl.listTableData(tableId, schema, (BigQueryOptions)this.getOptions(), BigQueryImpl.optionMap(options));
        return new TableResult(schema, (Long)data.y(), (Page<FieldValueList>)((Page)data.x()), null);
    }

    private static Tuple<? extends Page<FieldValueList>, Long> listTableData(TableId tableId, Schema schema, final BigQueryOptions serviceOptions, final Map<BigQueryRpc.Option, ?> optionsMap) {
        try {
            final TableId completeTableId = tableId.setProjectId(Strings.isNullOrEmpty((String)tableId.getProject()) ? serviceOptions.getProjectId() : tableId.getProject());
            TableDataList result = (TableDataList)RetryHelper.runWithRetries((Callable)new Callable<TableDataList>(){

                @Override
                public TableDataList call() {
                    return serviceOptions.getBigQueryRpcV2().listTableData(completeTableId.getProject(), completeTableId.getDataset(), completeTableId.getTable(), optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            String cursor = result.getPageToken();
            Map<BigQueryRpc.Option, ?> pageOptionMap = Strings.isNullOrEmpty((String)cursor) ? optionsMap : BigQueryImpl.optionMap(BigQuery.TableDataListOption.startIndex(0L));
            return Tuple.of((Object)new PageImpl((PageImpl.NextPageFetcher)new TableDataPageFetcher(tableId, schema, serviceOptions, cursor, pageOptionMap), cursor, BigQueryImpl.transformTableData(result.getRows(), schema)), (Object)result.getTotalRows());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    private static Iterable<FieldValueList> transformTableData(Iterable<TableRow> tableDataPb, final Schema schema) {
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)(tableDataPb != null ? tableDataPb : ImmutableList.of()), (Function)new Function<TableRow, FieldValueList>(){
            FieldList fields;
            {
                this.fields = schema != null ? schema.getFields() : null;
            }

            public FieldValueList apply(TableRow rowPb) {
                return FieldValueList.fromPb(rowPb.getF(), this.fields);
            }
        }));
    }

    @Override
    public Job getJob(String jobId, BigQuery.JobOption ... options) {
        return this.getJob(JobId.of(jobId), options);
    }

    @Override
    public Job getJob(JobId jobId, BigQuery.JobOption ... options) {
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        final JobId completeJobId = jobId.setProjectId(((BigQueryOptions)this.getOptions()).getProjectId()).setLocation(jobId.getLocation() == null && ((BigQueryOptions)this.getOptions()).getLocation() != null ? ((BigQueryOptions)this.getOptions()).getLocation() : jobId.getLocation());
        try {
            com.google.api.services.bigquery.model.Job answer = (com.google.api.services.bigquery.model.Job)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.bigquery.model.Job>(){

                @Override
                public com.google.api.services.bigquery.model.Job call() {
                    return BigQueryImpl.this.bigQueryRpc.getJob(completeJobId.getProject(), completeJobId.getJob(), completeJobId.getLocation(), optionsMap);
                }
            }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock());
            if (((BigQueryOptions)this.getOptions()).getThrowNotFound() && answer == null) {
                throw new BigQueryException(404, "Job not found");
            }
            return answer == null ? null : Job.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public Page<Job> listJobs(BigQuery.JobListOption ... options) {
        return BigQueryImpl.listJobs((BigQueryOptions)this.getOptions(), BigQueryImpl.optionMap(options));
    }

    private static Page<Job> listJobs(final BigQueryOptions serviceOptions, final Map<BigQueryRpc.Option, ?> optionsMap) {
        Tuple result = (Tuple)RetryHelper.runWithRetries((Callable)new Callable<Tuple<String, Iterable<com.google.api.services.bigquery.model.Job>>>(){

            @Override
            public Tuple<String, Iterable<com.google.api.services.bigquery.model.Job>> call() {
                return serviceOptions.getBigQueryRpcV2().listJobs(serviceOptions.getProjectId(), optionsMap);
            }
        }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
        String cursor = (String)result.x();
        Iterable jobs = Iterables.transform((Iterable)((Iterable)result.y()), (Function)new Function<com.google.api.services.bigquery.model.Job, Job>(){

            public Job apply(com.google.api.services.bigquery.model.Job job) {
                return Job.fromPb((BigQuery)serviceOptions.getService(), job);
            }
        });
        return new PageImpl((PageImpl.NextPageFetcher)new JobPageFetcher(serviceOptions, cursor, optionsMap), cursor, jobs);
    }

    @Override
    public boolean cancel(String jobId) {
        return this.cancel(JobId.of(jobId));
    }

    @Override
    public boolean cancel(JobId jobId) {
        final JobId completeJobId = jobId.setProjectId(((BigQueryOptions)this.getOptions()).getProjectId()).setLocation(jobId.getLocation() == null && ((BigQueryOptions)this.getOptions()).getLocation() != null ? ((BigQueryOptions)this.getOptions()).getLocation() : jobId.getLocation());
        try {
            return (Boolean)RetryHelper.runWithRetries((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return BigQueryImpl.this.bigQueryRpc.cancel(completeJobId.getProject(), completeJobId.getJob(), completeJobId.getLocation());
                }
            }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public TableResult query(QueryJobConfiguration configuration, BigQuery.JobOption ... options) throws InterruptedException, JobException {
        QueryRequestInfo requestInfo;
        Job.checkNotDryRun(configuration, "query");
        if (((BigQueryOptions)this.getOptions()).isQueryPreviewEnabled()) {
            configuration = configuration.toBuilder().setJobCreationMode(QueryJobConfiguration.JobCreationMode.JOB_CREATION_OPTIONAL).build();
        }
        if ((requestInfo = new QueryRequestInfo(configuration)).isFastQuerySupported(null)) {
            String projectId = ((BigQueryOptions)this.getOptions()).getProjectId();
            QueryRequest content = requestInfo.toPb();
            if (((BigQueryOptions)this.getOptions()).getLocation() != null) {
                content.setLocation(((BigQueryOptions)this.getOptions()).getLocation());
            }
            return this.queryRpc(projectId, content, options);
        }
        return this.create(JobInfo.of(configuration), options).getQueryResults(new BigQuery.QueryResultsOption[0]);
    }

    private TableResult queryRpc(final String projectId, final QueryRequest content, BigQuery.JobOption ... options) throws InterruptedException {
        long numRows;
        Schema schema;
        com.google.api.services.bigquery.model.QueryResponse results;
        try {
            results = BigQueryRetryHelper.runWithRetries(new Callable<com.google.api.services.bigquery.model.QueryResponse>(){

                @Override
                public com.google.api.services.bigquery.model.QueryResponse call() {
                    return BigQueryImpl.this.bigQueryRpc.queryRpc(projectId, content);
                }
            }, ((BigQueryOptions)this.getOptions()).getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, ((BigQueryOptions)this.getOptions()).getClock(), DEFAULT_RETRY_CONFIG);
        }
        catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
        if (results.getErrors() != null) {
            List bigQueryErrors = Lists.transform((List)results.getErrors(), BigQueryError.FROM_PB_FUNCTION);
            throw new BigQueryException(bigQueryErrors);
        }
        if (results.getJobComplete().booleanValue() && results.getSchema() != null) {
            schema = Schema.fromPb(results.getSchema());
            numRows = results.getNumDmlAffectedRows() == null && results.getTotalRows() == null ? 0L : (results.getNumDmlAffectedRows() != null ? results.getNumDmlAffectedRows().longValue() : results.getTotalRows().longValue());
        } else {
            JobId jobId = JobId.fromPb(results.getJobReference());
            Job job = this.getJob(jobId, options);
            return job.getQueryResults(new BigQuery.QueryResultsOption[0]);
        }
        if (results.getPageToken() != null) {
            JobId jobId = JobId.fromPb(results.getJobReference());
            String cursor = results.getPageToken();
            return new TableResult(schema, numRows, (Page<FieldValueList>)new PageImpl((PageImpl.NextPageFetcher)new QueryPageFetcher(jobId, schema, (BigQueryOptions)this.getOptions(), cursor, BigQueryImpl.optionMap(options)), cursor, BigQueryImpl.transformTableData(results.getRows(), schema)), jobId, results.getQueryId());
        }
        return new TableResult(schema, numRows, (Page<FieldValueList>)new PageImpl((PageImpl.NextPageFetcher)new TableDataPageFetcher(null, schema, (BigQueryOptions)this.getOptions(), null, BigQueryImpl.optionMap(options)), null, BigQueryImpl.transformTableData(results.getRows(), schema)), results.getJobReference() != null ? JobId.fromPb(results.getJobReference()) : null, results.getQueryId());
    }

    @Override
    public TableResult query(QueryJobConfiguration configuration, JobId jobId, BigQuery.JobOption ... options) throws InterruptedException, JobException {
        Job.checkNotDryRun(configuration, "query");
        QueryRequestInfo requestInfo = new QueryRequestInfo(configuration);
        if (requestInfo.isFastQuerySupported(jobId)) {
            String projectId = jobId.getProject() != null ? jobId.getProject() : ((BigQueryOptions)this.getOptions()).getProjectId();
            QueryRequest content = requestInfo.toPb();
            if (jobId.getLocation() != null) {
                content.setLocation(jobId.getLocation());
            } else if (((BigQueryOptions)this.getOptions()).getLocation() != null) {
                content.setLocation(((BigQueryOptions)this.getOptions()).getLocation());
            }
            return this.queryRpc(projectId, content, options);
        }
        return this.create(JobInfo.of(jobId, configuration), options).getQueryResults(new BigQuery.QueryResultsOption[0]);
    }

    @Override
    public QueryResponse getQueryResults(JobId jobId, BigQuery.QueryResultsOption ... options) {
        Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        return BigQueryImpl.getQueryResults(jobId, (BigQueryOptions)this.getOptions(), optionsMap);
    }

    private static QueryResponse getQueryResults(JobId jobId, final BigQueryOptions serviceOptions, final Map<BigQueryRpc.Option, ?> optionsMap) {
        final JobId completeJobId = jobId.setProjectId(serviceOptions.getProjectId()).setLocation(jobId.getLocation() == null && serviceOptions.getLocation() != null ? serviceOptions.getLocation() : jobId.getLocation());
        try {
            GetQueryResultsResponse results = BigQueryRetryHelper.runWithRetries(new Callable<GetQueryResultsResponse>(){

                @Override
                public GetQueryResultsResponse call() {
                    return serviceOptions.getBigQueryRpcV2().getQueryResults(completeJobId.getProject(), completeJobId.getJob(), completeJobId.getLocation(), optionsMap);
                }
            }, serviceOptions.getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, serviceOptions.getClock(), DEFAULT_RETRY_CONFIG);
            TableSchema schemaPb = results.getSchema();
            ImmutableList.Builder errors = ImmutableList.builder();
            if (results.getErrors() != null) {
                for (ErrorProto error : results.getErrors()) {
                    errors.add((Object)BigQueryError.fromPb(error));
                }
            }
            return QueryResponse.newBuilder().setCompleted(results.getJobComplete()).setSchema(schemaPb == null ? null : Schema.fromPb(schemaPb)).setTotalRows(results.getTotalRows() == null ? 0L : results.getTotalRows().longValue()).setErrors((ImmutableList<BigQueryError>)errors.build()).build();
        }
        catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public TableDataWriteChannel writer(WriteChannelConfiguration writeChannelConfiguration) {
        return this.writer(JobId.of(), writeChannelConfiguration);
    }

    @Override
    public TableDataWriteChannel writer(JobId jobId, WriteChannelConfiguration writeChannelConfiguration) {
        return new TableDataWriteChannel((BigQueryOptions)this.getOptions(), jobId.setProjectId(((BigQueryOptions)this.getOptions()).getProjectId()), writeChannelConfiguration.setProjectId(((BigQueryOptions)this.getOptions()).getProjectId()));
    }

    @Override
    public Policy getIamPolicy(TableId tableId, BigQuery.IAMOption ... options) {
        final TableId completeTableId = tableId.setProjectId(Strings.isNullOrEmpty((String)tableId.getProject()) ? ((BigQueryOptions)this.getOptions()).getProjectId() : tableId.getProject());
        try {
            final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
            return PolicyHelper.convertFromApiPolicy((com.google.api.services.bigquery.model.Policy)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.bigquery.model.Policy>(){

                @Override
                public com.google.api.services.bigquery.model.Policy call() {
                    return BigQueryImpl.this.bigQueryRpc.getIamPolicy(completeTableId.getIAMResourceName(), optionsMap);
                }
            }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public Policy setIamPolicy(TableId tableId, final Policy policy, BigQuery.IAMOption ... options) {
        final TableId completeTableId = tableId.setProjectId(Strings.isNullOrEmpty((String)tableId.getProject()) ? ((BigQueryOptions)this.getOptions()).getProjectId() : tableId.getProject());
        try {
            final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
            return PolicyHelper.convertFromApiPolicy((com.google.api.services.bigquery.model.Policy)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.bigquery.model.Policy>(){

                @Override
                public com.google.api.services.bigquery.model.Policy call() {
                    return BigQueryImpl.this.bigQueryRpc.setIamPolicy(completeTableId.getIAMResourceName(), PolicyHelper.convertToApiPolicy(policy), optionsMap);
                }
            }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public List<String> testIamPermissions(TableId tableId, final List<String> permissions, BigQuery.IAMOption ... options) {
        final TableId completeTableId = tableId.setProjectId(Strings.isNullOrEmpty((String)tableId.getProject()) ? ((BigQueryOptions)this.getOptions()).getProjectId() : tableId.getProject());
        try {
            final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
            TestIamPermissionsResponse response = (TestIamPermissionsResponse)RetryHelper.runWithRetries((Callable)new Callable<TestIamPermissionsResponse>(){

                @Override
                public TestIamPermissionsResponse call() {
                    return BigQueryImpl.this.bigQueryRpc.testIamPermissions(completeTableId.getIAMResourceName(), permissions, optionsMap);
                }
            }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock());
            return response.getPermissions() == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)response.getPermissions());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @VisibleForTesting
    static Map<BigQueryRpc.Option, ?> optionMap(Option ... options) {
        EnumMap optionMap = Maps.newEnumMap(BigQueryRpc.Option.class);
        for (Option option : options) {
            Object prev = optionMap.put(option.getRpcOption(), option.getValue());
            Preconditions.checkArgument((prev == null ? 1 : 0) != 0, (String)"Duplicate option %s", (Object)option);
        }
        return optionMap;
    }

    private static class DatasetPageFetcher
    implements PageImpl.NextPageFetcher<Dataset> {
        private static final long serialVersionUID = -3057564042439021278L;
        private final Map<BigQueryRpc.Option, ?> requestOptions;
        private final BigQueryOptions serviceOptions;
        private final String projectId;

        DatasetPageFetcher(String projectId, BigQueryOptions serviceOptions, String cursor, Map<BigQueryRpc.Option, ?> optionMap) {
            this.projectId = projectId;
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)BigQueryRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
        }

        public Page<Dataset> getNextPage() {
            return BigQueryImpl.listDatasets(this.projectId, this.serviceOptions, this.requestOptions);
        }
    }

    private static class TablePageFetcher
    implements PageImpl.NextPageFetcher<Table> {
        private static final long serialVersionUID = 8611248840504201187L;
        private final Map<BigQueryRpc.Option, ?> requestOptions;
        private final BigQueryOptions serviceOptions;
        private final DatasetId datasetId;

        TablePageFetcher(DatasetId datasetId, BigQueryOptions serviceOptions, String cursor, Map<BigQueryRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)BigQueryRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
            this.datasetId = datasetId;
        }

        public Page<Table> getNextPage() {
            return BigQueryImpl.listTables(this.datasetId, this.serviceOptions, this.requestOptions);
        }
    }

    private static class ModelPageFetcher
    implements PageImpl.NextPageFetcher<Model> {
        private static final long serialVersionUID = 8611248811504201187L;
        private final Map<BigQueryRpc.Option, ?> requestOptions;
        private final BigQueryOptions serviceOptions;
        private final DatasetId datasetId;

        ModelPageFetcher(DatasetId datasetId, BigQueryOptions serviceOptions, String cursor, Map<BigQueryRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)BigQueryRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
            this.datasetId = datasetId;
        }

        public Page<Model> getNextPage() {
            return BigQueryImpl.listModels(this.datasetId, this.serviceOptions, this.requestOptions);
        }
    }

    private static class RoutinePageFetcher
    implements PageImpl.NextPageFetcher<Routine> {
        private static final long serialVersionUID = 8611242311504201187L;
        private final Map<BigQueryRpc.Option, ?> requestOptions;
        private final BigQueryOptions serviceOptions;
        private final DatasetId datasetId;

        RoutinePageFetcher(DatasetId datasetId, BigQueryOptions serviceOptions, String cursor, Map<BigQueryRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)BigQueryRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
            this.datasetId = datasetId;
        }

        public Page<Routine> getNextPage() {
            return BigQueryImpl.listRoutines(this.datasetId, this.serviceOptions, this.requestOptions);
        }
    }

    private static class TableDataPageFetcher
    implements PageImpl.NextPageFetcher<FieldValueList> {
        private static final long serialVersionUID = -8501991114794410114L;
        private final Map<BigQueryRpc.Option, ?> requestOptions;
        private final BigQueryOptions serviceOptions;
        private final TableId table;
        private final Schema schema;

        TableDataPageFetcher(TableId table, Schema schema, BigQueryOptions serviceOptions, String cursor, Map<BigQueryRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)BigQueryRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
            this.table = table;
            this.schema = schema;
        }

        public Page<FieldValueList> getNextPage() {
            return (Page)BigQueryImpl.listTableData(this.table, this.schema, this.serviceOptions, this.requestOptions).x();
        }
    }

    private static class JobPageFetcher
    implements PageImpl.NextPageFetcher<Job> {
        private static final long serialVersionUID = 8536533282558245472L;
        private final Map<BigQueryRpc.Option, ?> requestOptions;
        private final BigQueryOptions serviceOptions;

        JobPageFetcher(BigQueryOptions serviceOptions, String cursor, Map<BigQueryRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)BigQueryRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
        }

        public Page<Job> getNextPage() {
            return BigQueryImpl.listJobs(this.serviceOptions, this.requestOptions);
        }
    }

    private class QueryPageFetcher
    extends Thread
    implements PageImpl.NextPageFetcher<FieldValueList> {
        private static final long serialVersionUID = -8501991114794410114L;
        private final Map<BigQueryRpc.Option, ?> requestOptions;
        private final BigQueryOptions serviceOptions;
        private Job job;
        private final TableId table;
        private final Schema schema;

        QueryPageFetcher(JobId jobId, Schema schema, BigQueryOptions serviceOptions, String cursor, Map<BigQueryRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)BigQueryRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
            this.job = BigQueryImpl.this.getJob(jobId, new BigQuery.JobOption[0]);
            this.table = ((QueryJobConfiguration)this.job.getConfiguration()).getDestinationTable();
            this.schema = schema;
        }

        public Page<FieldValueList> getNextPage() {
            while (!JobStatus.State.DONE.equals((Object)this.job.getStatus().getState())) {
                try {
                    QueryPageFetcher.sleep(5000L);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex.getMessage());
                }
                this.job = this.job.reload(new BigQuery.JobOption[0]);
            }
            return (Page)BigQueryImpl.listTableData(this.table, this.schema, this.serviceOptions, this.requestOptions).x();
        }
    }
}

