/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.ResultRetryAlgorithmWithContext;
import com.google.api.gax.retrying.RetryAlgorithm;
import com.google.api.gax.retrying.RetryingContext;
import com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.retrying.TimedRetryAlgorithmWithContext;
import com.google.cloud.bigquery.BigQueryRetryConfig;
import com.google.common.base.Preconditions;
import com.google.common.collect.UnmodifiableIterator;
import java.util.concurrent.CancellationException;

public class BigQueryRetryAlgorithm<ResponseT>
extends RetryAlgorithm<ResponseT> {
    private final BigQueryRetryConfig bigQueryRetryConfig;
    private final ResultRetryAlgorithm<ResponseT> resultAlgorithm;
    private final TimedRetryAlgorithm timedAlgorithm;
    private final ResultRetryAlgorithmWithContext<ResponseT> resultAlgorithmWithContext;
    private final TimedRetryAlgorithmWithContext timedAlgorithmWithContext;

    public BigQueryRetryAlgorithm(ResultRetryAlgorithm<ResponseT> resultAlgorithm, TimedRetryAlgorithm timedAlgorithm, BigQueryRetryConfig bigQueryRetryConfig) {
        super(resultAlgorithm, timedAlgorithm);
        this.bigQueryRetryConfig = (BigQueryRetryConfig)Preconditions.checkNotNull((Object)bigQueryRetryConfig);
        this.resultAlgorithm = (ResultRetryAlgorithm)Preconditions.checkNotNull(resultAlgorithm);
        this.timedAlgorithm = (TimedRetryAlgorithm)Preconditions.checkNotNull((Object)timedAlgorithm);
        this.resultAlgorithmWithContext = null;
        this.timedAlgorithmWithContext = null;
    }

    public boolean shouldRetry(RetryingContext context, Throwable previousThrowable, ResponseT previousResponse, TimedAttemptSettings nextAttemptSettings) throws CancellationException {
        return (this.shouldRetryBasedOnResult(context, previousThrowable, previousResponse) || this.shouldRetryBasedOnBigQueryRetryConfig(previousThrowable, this.bigQueryRetryConfig)) && this.shouldRetryBasedOnTiming(context, nextAttemptSettings);
    }

    private boolean shouldRetryBasedOnBigQueryRetryConfig(Throwable previousThrowable, BigQueryRetryConfig bigQueryRetryConfig) {
        String errorDesc;
        if (previousThrowable != null && (errorDesc = previousThrowable.getMessage()) != null) {
            UnmodifiableIterator retriableMessages = bigQueryRetryConfig.getRetriableErrorMessages().iterator();
            while (retriableMessages.hasNext()) {
                if (!errorDesc.contains((CharSequence)retriableMessages.next())) continue;
                return true;
            }
        }
        return false;
    }

    boolean shouldRetryBasedOnResult(RetryingContext context, Throwable previousThrowable, ResponseT previousResponse) {
        if (this.resultAlgorithmWithContext != null && context != null) {
            return this.resultAlgorithmWithContext.shouldRetry(context, previousThrowable, previousResponse);
        }
        return this.getResultAlgorithm().shouldRetry(previousThrowable, previousResponse);
    }

    private boolean shouldRetryBasedOnTiming(RetryingContext context, TimedAttemptSettings nextAttemptSettings) {
        if (nextAttemptSettings == null) {
            return false;
        }
        if (this.timedAlgorithmWithContext != null && context != null) {
            return this.timedAlgorithmWithContext.shouldRetry(context, nextAttemptSettings);
        }
        return this.getTimedAlgorithm().shouldRetry(nextAttemptSettings);
    }

    public TimedAttemptSettings createNextAttempt(RetryingContext context, Throwable previousThrowable, ResponseT previousResponse, TimedAttemptSettings previousSettings) {
        if (!this.shouldRetryBasedOnResult(context, previousThrowable, previousResponse) && !this.shouldRetryBasedOnBigQueryRetryConfig(previousThrowable, this.bigQueryRetryConfig)) {
            return null;
        }
        TimedAttemptSettings newSettings = this.createNextAttemptBasedOnResult(context, previousThrowable, previousResponse, previousSettings);
        if (newSettings == null) {
            newSettings = this.createNextAttemptBasedOnTiming(context, previousSettings);
        }
        return newSettings;
    }

    private TimedAttemptSettings createNextAttemptBasedOnResult(RetryingContext context, Throwable previousThrowable, ResponseT previousResponse, TimedAttemptSettings previousSettings) {
        if (this.resultAlgorithmWithContext != null && context != null) {
            return this.resultAlgorithmWithContext.createNextAttempt(context, previousThrowable, previousResponse, previousSettings);
        }
        return this.getResultAlgorithm().createNextAttempt(previousThrowable, previousResponse, previousSettings);
    }

    private TimedAttemptSettings createNextAttemptBasedOnTiming(RetryingContext context, TimedAttemptSettings previousSettings) {
        if (this.timedAlgorithmWithContext != null && context != null) {
            return this.timedAlgorithmWithContext.createNextAttempt(context, previousSettings);
        }
        return this.getTimedAlgorithm().createNextAttempt(previousSettings);
    }
}

