/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.auto.value.AutoValue;
import com.google.cloud.bigquery.AutoValue_BigtableColumnFamily;
import com.google.cloud.bigquery.BigtableColumn;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;

@AutoValue
public abstract class BigtableColumnFamily
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final Function<com.google.api.services.bigquery.model.BigtableColumnFamily, BigtableColumnFamily> FROM_PB_FUNCTION = new Function<com.google.api.services.bigquery.model.BigtableColumnFamily, BigtableColumnFamily>(){

        public BigtableColumnFamily apply(com.google.api.services.bigquery.model.BigtableColumnFamily pb) {
            return BigtableColumnFamily.fromPb(pb);
        }
    };
    static final Function<BigtableColumnFamily, com.google.api.services.bigquery.model.BigtableColumnFamily> TO_PB_FUNCTION = new Function<BigtableColumnFamily, com.google.api.services.bigquery.model.BigtableColumnFamily>(){

        public com.google.api.services.bigquery.model.BigtableColumnFamily apply(BigtableColumnFamily columnFamily) {
            return columnFamily.toPb();
        }
    };

    public abstract String getFamilyID();

    public abstract List<BigtableColumn> getColumns();

    public abstract String getEncoding();

    public abstract Boolean getOnlyReadLatest();

    public abstract String getType();

    static Builder newBuilder() {
        return new AutoValue_BigtableColumnFamily.Builder();
    }

    static BigtableColumnFamily fromPb(com.google.api.services.bigquery.model.BigtableColumnFamily columnFamily) {
        Builder builder = BigtableColumnFamily.newBuilder();
        builder.setFamilyID(columnFamily.getFamilyId());
        builder.setColumns(Lists.transform((List)columnFamily.getColumns(), BigtableColumn.FROM_PB_FUNCTION));
        builder.setEncoding(columnFamily.getEncoding());
        builder.setOnlyReadLatest(columnFamily.getOnlyReadLatest());
        builder.setType(columnFamily.getType());
        return builder.build();
    }

    com.google.api.services.bigquery.model.BigtableColumnFamily toPb() {
        com.google.api.services.bigquery.model.BigtableColumnFamily colFamilyPb = new com.google.api.services.bigquery.model.BigtableColumnFamily().setFamilyId(this.getFamilyID()).setEncoding(this.getEncoding()).setOnlyReadLatest(this.getOnlyReadLatest()).setType(this.getType());
        if (this.getColumns() != null) {
            colFamilyPb.setColumns(Lists.transform(this.getColumns(), BigtableColumn.TO_PB_FUNCTION));
        }
        return colFamilyPb;
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setFamilyID(String var1);

        public abstract Builder setColumns(List<BigtableColumn> var1);

        public abstract Builder setEncoding(String var1);

        public abstract Builder setOnlyReadLatest(Boolean var1);

        public abstract Builder setType(String var1);

        public abstract BigtableColumnFamily build();
    }
}

