/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.Streamingbuffer;
import com.google.api.services.bigquery.model.Table;
import com.google.cloud.bigquery.AutoValue_StandardTableDefinition;
import com.google.cloud.bigquery.Clustering;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;
import javax.annotation.Nullable;

public abstract class StandardTableDefinition
extends TableDefinition {
    private static final long serialVersionUID = 2113445776046717900L;

    @Nullable
    public abstract Long getNumBytes();

    @Nullable
    public abstract Long getNumRows();

    @Nullable
    public abstract String getLocation();

    @Nullable
    public abstract StreamingBuffer getStreamingBuffer();

    @Nullable
    public abstract TimePartitioning getTimePartitioning();

    @Nullable
    public abstract Clustering getClustering();

    public static Builder newBuilder() {
        return new AutoValue_StandardTableDefinition.Builder().setType(TableDefinition.Type.TABLE);
    }

    public static StandardTableDefinition of(Schema schema) {
        return StandardTableDefinition.newBuilder().setSchema(schema).build();
    }

    @Override
    public abstract Builder toBuilder();

    @Override
    Table toPb() {
        Table tablePb = super.toPb();
        if (this.getNumRows() != null) {
            tablePb.setNumRows(BigInteger.valueOf(this.getNumRows()));
        }
        tablePb.setNumBytes(this.getNumBytes());
        tablePb.setLocation(this.getLocation());
        if (this.getStreamingBuffer() != null) {
            tablePb.setStreamingBuffer(this.getStreamingBuffer().toPb());
        }
        if (this.getTimePartitioning() != null) {
            tablePb.setTimePartitioning(this.getTimePartitioning().toPb());
        }
        if (this.getClustering() != null) {
            tablePb.setClustering(this.getClustering().toPb());
        }
        return tablePb;
    }

    static StandardTableDefinition fromPb(Table tablePb) {
        Builder builder = (Builder)StandardTableDefinition.newBuilder().table(tablePb);
        if (tablePb.getNumRows() != null) {
            builder.setNumRows(tablePb.getNumRows().longValue());
        }
        if (tablePb.getStreamingBuffer() != null) {
            builder.setStreamingBuffer(StreamingBuffer.fromPb(tablePb.getStreamingBuffer()));
        }
        if (tablePb.getTimePartitioning() != null) {
            builder.setTimePartitioning(TimePartitioning.fromPb(tablePb.getTimePartitioning()));
        }
        if (tablePb.getClustering() != null) {
            builder.setClustering(Clustering.fromPb(tablePb.getClustering()));
        }
        return builder.setNumBytes(tablePb.getNumBytes()).setLocation(tablePb.getLocation()).build();
    }

    public static abstract class Builder
    extends TableDefinition.Builder<StandardTableDefinition, Builder> {
        public abstract Builder setNumBytes(Long var1);

        public abstract Builder setNumRows(Long var1);

        public abstract Builder setLocation(String var1);

        public abstract Builder setStreamingBuffer(StreamingBuffer var1);

        @Override
        public abstract Builder setType(TableDefinition.Type var1);

        @Override
        public abstract Builder setSchema(Schema var1);

        public abstract Builder setTimePartitioning(TimePartitioning var1);

        public abstract Builder setClustering(Clustering var1);

        @Override
        public abstract StandardTableDefinition build();
    }

    public static class StreamingBuffer
    implements Serializable {
        private static final long serialVersionUID = 822027055549277843L;
        private final long estimatedRows;
        private final long estimatedBytes;
        private final Long oldestEntryTime;

        StreamingBuffer(long estimatedRows, long estimatedBytes, Long oldestEntryTime) {
            this.estimatedRows = estimatedRows;
            this.estimatedBytes = estimatedBytes;
            this.oldestEntryTime = oldestEntryTime;
        }

        public long getEstimatedRows() {
            return this.estimatedRows;
        }

        public long getEstimatedBytes() {
            return this.estimatedBytes;
        }

        public Long getOldestEntryTime() {
            return this.oldestEntryTime;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("estimatedRows", this.estimatedRows).add("estimatedBytes", this.estimatedBytes).add("oldestEntryTime", (Object)this.oldestEntryTime).toString();
        }

        public int hashCode() {
            return Objects.hash(this.estimatedRows, this.estimatedBytes, this.oldestEntryTime);
        }

        public boolean equals(Object obj) {
            return obj instanceof StreamingBuffer && Objects.equals(this.toPb(), ((StreamingBuffer)obj).toPb());
        }

        Streamingbuffer toPb() {
            return new Streamingbuffer().setEstimatedBytes(BigInteger.valueOf(this.estimatedBytes)).setEstimatedRows(BigInteger.valueOf(this.estimatedRows)).setOldestEntryTime(BigInteger.valueOf(this.oldestEntryTime));
        }

        static StreamingBuffer fromPb(Streamingbuffer streamingBufferPb) {
            Long oldestEntryTime = null;
            if (streamingBufferPb.getOldestEntryTime() != null) {
                oldestEntryTime = streamingBufferPb.getOldestEntryTime().longValue();
            }
            return new StreamingBuffer(streamingBufferPb.getEstimatedRows().longValue(), streamingBufferPb.getEstimatedBytes().longValue(), oldestEntryTime);
        }
    }
}

