/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.UserDefinedFunctionResource;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;

public abstract class UserDefinedFunction
implements Serializable {
    static final Function<UserDefinedFunctionResource, UserDefinedFunction> FROM_PB_FUNCTION = new Function<UserDefinedFunctionResource, UserDefinedFunction>(){

        public UserDefinedFunction apply(UserDefinedFunctionResource userDefinedFunctionPb) {
            return UserDefinedFunction.fromPb(userDefinedFunctionPb);
        }
    };
    static final Function<UserDefinedFunction, UserDefinedFunctionResource> TO_PB_FUNCTION = new Function<UserDefinedFunction, UserDefinedFunctionResource>(){

        public UserDefinedFunctionResource apply(UserDefinedFunction userDefinedFunction) {
            return userDefinedFunction.toPb();
        }
    };
    private static final long serialVersionUID = 8704260561787440287L;
    private final Type type;
    private final String content;

    UserDefinedFunction(Type type, String content) {
        this.type = type;
        this.content = content;
    }

    public Type type() {
        return this.type;
    }

    public String content() {
        return this.content;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.content});
    }

    public boolean equals(Object obj) {
        return obj instanceof UserDefinedFunction && Objects.equals(this.toPb(), ((UserDefinedFunction)obj).toPb());
    }

    public abstract UserDefinedFunctionResource toPb();

    public static UserDefinedFunction inline(String functionDefinition) {
        return new InlineFunction(functionDefinition);
    }

    public static UserDefinedFunction fromUri(String functionDefinition) {
        return new UriFunction(functionDefinition);
    }

    static UserDefinedFunction fromPb(UserDefinedFunctionResource pb) {
        if (pb.getInlineCode() != null) {
            return new InlineFunction(pb.getInlineCode());
        }
        if (pb.getResourceUri() != null) {
            return new UriFunction(pb.getResourceUri());
        }
        throw new IllegalArgumentException("Invalid user-defined function");
    }

    static final class UriFunction
    extends UserDefinedFunction {
        private static final long serialVersionUID = 4660331691852223839L;

        UriFunction(String functionUri) {
            super(Type.FROM_URI, functionUri);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("functionUri", (Object)this.content()).toString();
        }

        @Override
        public UserDefinedFunctionResource toPb() {
            return new UserDefinedFunctionResource().setResourceUri(this.content());
        }
    }

    static final class InlineFunction
    extends UserDefinedFunction {
        private static final long serialVersionUID = 1083672109192091686L;

        InlineFunction(String inlineCode) {
            super(Type.INLINE, inlineCode);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("inlineCode", (Object)this.content()).toString();
        }

        @Override
        public UserDefinedFunctionResource toPb() {
            return new UserDefinedFunctionResource().setInlineCode(this.content());
        }
    }

    public static enum Type {
        INLINE,
        FROM_URI;

    }
}

