/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;

public final class TimePartitioning
implements Serializable {
    private static final long serialVersionUID = -8565064035346940951L;
    private final Type type;
    private final Long expirationMs;

    private TimePartitioning(Type type, Long expirationMs) {
        this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        this.expirationMs = expirationMs;
    }

    public Type type() {
        return this.type;
    }

    public Long expirationMs() {
        return this.expirationMs;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("expirationMs", (Object)this.expirationMs).toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.expirationMs});
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof TimePartitioning && Objects.equals(this.toPb(), ((TimePartitioning)obj).toPb());
    }

    public static TimePartitioning of(Type type) {
        return new TimePartitioning(type, null);
    }

    public static TimePartitioning of(Type type, long expirationMs) {
        return new TimePartitioning(type, expirationMs);
    }

    com.google.api.services.bigquery.model.TimePartitioning toPb() {
        com.google.api.services.bigquery.model.TimePartitioning partitioningPb = new com.google.api.services.bigquery.model.TimePartitioning();
        partitioningPb.setType(this.type.name());
        partitioningPb.setExpirationMs(this.expirationMs);
        return partitioningPb;
    }

    static TimePartitioning fromPb(com.google.api.services.bigquery.model.TimePartitioning partitioningPb) {
        return new TimePartitioning(Type.valueOf(partitioningPb.getType()), partitioningPb.getExpirationMs());
    }

    public static enum Type {
        DAY;

    }
}

