/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.Page;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.CopyJobConfiguration;
import com.google.cloud.bigquery.ExtractJobConfiguration;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.InsertAllRequest;
import com.google.cloud.bigquery.InsertAllResponse;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.LoadJobConfiguration;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Objects;

public class Table
extends TableInfo {
    private static final long serialVersionUID = 5744556727066570096L;
    private final BigQueryOptions options;
    private transient BigQuery bigquery;

    Table(BigQuery bigquery, TableInfo.BuilderImpl infoBuilder) {
        super(infoBuilder);
        this.bigquery = (BigQuery)Preconditions.checkNotNull((Object)bigquery);
        this.options = (BigQueryOptions)bigquery.options();
    }

    public boolean exists() {
        return this.bigquery.getTable(this.tableId(), BigQuery.TableOption.fields(new BigQuery.TableField[0])) != null;
    }

    public Table reload(BigQuery.TableOption ... options) {
        return this.bigquery.getTable(this.tableId(), options);
    }

    public Table update(BigQuery.TableOption ... options) {
        return this.bigquery.update(this, options);
    }

    public boolean delete() {
        return this.bigquery.delete(this.tableId());
    }

    public InsertAllResponse insert(Iterable<InsertAllRequest.RowToInsert> rows) throws BigQueryException {
        return this.bigquery.insertAll(InsertAllRequest.of(this.tableId(), rows));
    }

    public InsertAllResponse insert(Iterable<InsertAllRequest.RowToInsert> rows, boolean skipInvalidRows, boolean ignoreUnknownValues) throws BigQueryException {
        InsertAllRequest request = InsertAllRequest.builder(this.tableId(), rows).skipInvalidRows(skipInvalidRows).ignoreUnknownValues(ignoreUnknownValues).build();
        return this.bigquery.insertAll(request);
    }

    public Page<List<FieldValue>> list(BigQuery.TableDataListOption ... options) throws BigQueryException {
        return this.bigquery.listTableData(this.tableId(), options);
    }

    public Job copy(String destinationDataset, String destinationTable, BigQuery.JobOption ... options) throws BigQueryException {
        return this.copy(TableId.of(destinationDataset, destinationTable), options);
    }

    public Job copy(TableId destinationTable, BigQuery.JobOption ... options) throws BigQueryException {
        CopyJobConfiguration configuration = CopyJobConfiguration.of(destinationTable, this.tableId());
        return this.bigquery.create(JobInfo.of(configuration), options);
    }

    public Job extract(String format, String destinationUri, BigQuery.JobOption ... options) throws BigQueryException {
        return this.extract(format, (List<String>)ImmutableList.of((Object)destinationUri), options);
    }

    public Job extract(String format, List<String> destinationUris, BigQuery.JobOption ... options) throws BigQueryException {
        ExtractJobConfiguration extractConfiguration = ExtractJobConfiguration.of(this.tableId(), destinationUris, format);
        return this.bigquery.create(JobInfo.of(extractConfiguration), options);
    }

    public Job load(FormatOptions format, String sourceUri, BigQuery.JobOption ... options) throws BigQueryException {
        return this.load(format, (List<String>)ImmutableList.of((Object)sourceUri), options);
    }

    public Job load(FormatOptions format, List<String> sourceUris, BigQuery.JobOption ... options) throws BigQueryException {
        LoadJobConfiguration loadConfig = LoadJobConfiguration.of(this.tableId(), sourceUris, format);
        return this.bigquery.create(JobInfo.of(loadConfig), options);
    }

    public BigQuery bigquery() {
        return this.bigquery;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Table.class)) {
            return false;
        }
        Table other = (Table)obj;
        return Objects.equals(this.toPb(), other.toPb()) && Objects.equals((Object)this.options, (Object)other.options);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.options});
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.bigquery = (BigQuery)this.options.service();
    }

    static Table fromPb(BigQuery bigquery, com.google.api.services.bigquery.model.Table tablePb) {
        return new Table(bigquery, new TableInfo.BuilderImpl(tablePb));
    }

    public static class Builder
    extends TableInfo.Builder {
        private final BigQuery bigquery;
        private final TableInfo.BuilderImpl infoBuilder;

        Builder(BigQuery bigquery, TableId tableId, TableDefinition defintion) {
            this.bigquery = bigquery;
            this.infoBuilder = new TableInfo.BuilderImpl();
            this.infoBuilder.tableId(tableId).definition(defintion);
        }

        Builder(Table table) {
            this.bigquery = table.bigquery;
            this.infoBuilder = new TableInfo.BuilderImpl(table);
        }

        @Override
        Builder creationTime(Long creationTime) {
            this.infoBuilder.creationTime(creationTime);
            return this;
        }

        @Override
        public Builder description(String description) {
            this.infoBuilder.description(description);
            return this;
        }

        @Override
        Builder etag(String etag) {
            this.infoBuilder.etag(etag);
            return this;
        }

        @Override
        public Builder expirationTime(Long expirationTime) {
            this.infoBuilder.expirationTime(expirationTime);
            return this;
        }

        @Override
        public Builder friendlyName(String friendlyName) {
            this.infoBuilder.friendlyName(friendlyName);
            return this;
        }

        @Override
        Builder generatedId(String generatedId) {
            this.infoBuilder.generatedId(generatedId);
            return this;
        }

        @Override
        Builder lastModifiedTime(Long lastModifiedTime) {
            this.infoBuilder.lastModifiedTime(lastModifiedTime);
            return this;
        }

        @Override
        Builder selfLink(String selfLink) {
            this.infoBuilder.selfLink(selfLink);
            return this;
        }

        @Override
        public Builder tableId(TableId tableId) {
            this.infoBuilder.tableId(tableId);
            return this;
        }

        @Override
        public Builder definition(TableDefinition definition) {
            this.infoBuilder.definition(definition);
            return this;
        }

        @Override
        public Table build() {
            return new Table(this.bigquery, this.infoBuilder);
        }
    }
}

