/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.JobStatistics2;
import com.google.api.services.bigquery.model.JobStatistics3;
import com.google.api.services.bigquery.model.JobStatistics4;
import com.google.cloud.bigquery.QueryStage;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public abstract class JobStatistics
implements Serializable {
    private static final long serialVersionUID = 1433024714741660399L;
    private final Long creationTime;
    private final Long endTime;
    private final Long startTime;

    protected JobStatistics(Builder builder) {
        this.creationTime = builder.creationTime;
        this.endTime = builder.endTime;
        this.startTime = builder.startTime;
    }

    public Long creationTime() {
        return this.creationTime;
    }

    public Long endTime() {
        return this.endTime;
    }

    public Long startTime() {
        return this.startTime;
    }

    MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((Object)this).add("creationTime", (Object)this.creationTime).add("endTime", (Object)this.endTime).add("startTime", (Object)this.startTime);
    }

    public String toString() {
        return this.toStringHelper().toString();
    }

    final int baseHashCode() {
        return Objects.hash(this.creationTime, this.endTime, this.startTime);
    }

    final boolean baseEquals(JobStatistics jobStatistics) {
        return Objects.equals(this.toPb(), jobStatistics.toPb());
    }

    com.google.api.services.bigquery.model.JobStatistics toPb() {
        com.google.api.services.bigquery.model.JobStatistics statistics = new com.google.api.services.bigquery.model.JobStatistics();
        statistics.setCreationTime(this.creationTime);
        statistics.setEndTime(this.endTime);
        statistics.setStartTime(this.startTime);
        return statistics;
    }

    static <T extends JobStatistics> T fromPb(com.google.api.services.bigquery.model.JobStatistics statisticPb) {
        if (statisticPb.getLoad() != null) {
            return (T)LoadStatistics.fromPb(statisticPb);
        }
        if (statisticPb.getExtract() != null) {
            return (T)ExtractStatistics.fromPb(statisticPb);
        }
        if (statisticPb.getQuery() != null) {
            return (T)QueryStatistics.fromPb(statisticPb);
        }
        return (T)CopyStatistics.fromPb(statisticPb);
    }

    static abstract class Builder<T extends JobStatistics, B extends Builder<T, B>> {
        private Long creationTime;
        private Long endTime;
        private Long startTime;

        protected Builder() {
        }

        protected Builder(com.google.api.services.bigquery.model.JobStatistics statisticsPb) {
            this.creationTime = statisticsPb.getCreationTime();
            this.endTime = statisticsPb.getEndTime();
            this.startTime = statisticsPb.getStartTime();
        }

        protected B self() {
            return (B)this;
        }

        B creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this.self();
        }

        B endTime(Long endTime) {
            this.endTime = endTime;
            return this.self();
        }

        B startTime(Long startTime) {
            this.startTime = startTime;
            return this.self();
        }

        abstract T build();
    }

    public static class QueryStatistics
    extends JobStatistics {
        private static final long serialVersionUID = 7539354109226732353L;
        private final Integer billingTier;
        private final Boolean cacheHit;
        private final Long totalBytesBilled;
        private final Long totalBytesProcessed;
        private final List<QueryStage> queryPlan;

        private QueryStatistics(Builder builder) {
            super(builder);
            this.billingTier = builder.billingTier;
            this.cacheHit = builder.cacheHit;
            this.totalBytesBilled = builder.totalBytesBilled;
            this.totalBytesProcessed = builder.totalBytesProcessed;
            this.queryPlan = builder.queryPlan;
        }

        public Integer billingTier() {
            return this.billingTier;
        }

        public Boolean cacheHit() {
            return this.cacheHit;
        }

        public Long totalBytesBilled() {
            return this.totalBytesBilled;
        }

        public Long totalBytesProcessed() {
            return this.totalBytesProcessed;
        }

        public List<QueryStage> queryPlan() {
            return this.queryPlan;
        }

        @Override
        MoreObjects.ToStringHelper toStringHelper() {
            return super.toStringHelper().add("billingTier", (Object)this.billingTier).add("cacheHit", (Object)this.cacheHit).add("totalBytesBilled", (Object)this.totalBytesBilled).add("totalBytesProcessed", (Object)this.totalBytesProcessed).add("queryPlan", this.queryPlan);
        }

        public final boolean equals(Object obj) {
            return obj == this || obj != null && obj.getClass().equals(QueryStatistics.class) && this.baseEquals((QueryStatistics)obj);
        }

        public final int hashCode() {
            return Objects.hash(this.baseHashCode(), this.billingTier, this.cacheHit, this.totalBytesBilled, this.totalBytesProcessed, this.queryPlan);
        }

        @Override
        com.google.api.services.bigquery.model.JobStatistics toPb() {
            JobStatistics2 queryStatisticsPb = new JobStatistics2();
            queryStatisticsPb.setBillingTier(this.billingTier);
            queryStatisticsPb.setCacheHit(this.cacheHit);
            queryStatisticsPb.setTotalBytesBilled(this.totalBytesBilled);
            queryStatisticsPb.setTotalBytesProcessed(this.totalBytesProcessed);
            if (this.queryPlan != null) {
                queryStatisticsPb.setQueryPlan(Lists.transform(this.queryPlan, QueryStage.TO_PB_FUNCTION));
            }
            return super.toPb().setQuery(queryStatisticsPb);
        }

        static Builder builder() {
            return new Builder();
        }

        static QueryStatistics fromPb(com.google.api.services.bigquery.model.JobStatistics statisticPb) {
            return new Builder(statisticPb).build();
        }

        static final class Builder
        extends com.google.cloud.bigquery.JobStatistics$Builder<QueryStatistics, Builder> {
            private Integer billingTier;
            private Boolean cacheHit;
            private Long totalBytesBilled;
            private Long totalBytesProcessed;
            private List<QueryStage> queryPlan;

            private Builder() {
            }

            private Builder(com.google.api.services.bigquery.model.JobStatistics statisticsPb) {
                super(statisticsPb);
                this.billingTier = statisticsPb.getQuery().getBillingTier();
                this.cacheHit = statisticsPb.getQuery().getCacheHit();
                this.totalBytesBilled = statisticsPb.getQuery().getTotalBytesBilled();
                this.totalBytesProcessed = statisticsPb.getQuery().getTotalBytesProcessed();
                if (statisticsPb.getQuery().getQueryPlan() != null) {
                    this.queryPlan = Lists.transform((List)statisticsPb.getQuery().getQueryPlan(), QueryStage.FROM_PB_FUNCTION);
                }
            }

            Builder billingTier(Integer billingTier) {
                this.billingTier = billingTier;
                return (Builder)this.self();
            }

            Builder cacheHit(Boolean cacheHit) {
                this.cacheHit = cacheHit;
                return (Builder)this.self();
            }

            Builder totalBytesBilled(Long totalBytesBilled) {
                this.totalBytesBilled = totalBytesBilled;
                return (Builder)this.self();
            }

            Builder totalBytesProcessed(Long totalBytesProcessed) {
                this.totalBytesProcessed = totalBytesProcessed;
                return (Builder)this.self();
            }

            Builder queryPlan(List<QueryStage> queryPlan) {
                this.queryPlan = queryPlan;
                return (Builder)this.self();
            }

            @Override
            QueryStatistics build() {
                return new QueryStatistics(this);
            }
        }
    }

    public static class LoadStatistics
    extends JobStatistics {
        private static final long serialVersionUID = -707369246536309215L;
        private final Long inputBytes;
        private final Long inputFiles;
        private final Long outputBytes;
        private final Long outputRows;

        private LoadStatistics(Builder builder) {
            super(builder);
            this.inputBytes = builder.inputBytes;
            this.inputFiles = builder.inputFiles;
            this.outputBytes = builder.outputBytes;
            this.outputRows = builder.outputRows;
        }

        public Long inputBytes() {
            return this.inputBytes;
        }

        public Long inputFiles() {
            return this.inputFiles;
        }

        public Long outputBytes() {
            return this.outputBytes;
        }

        public Long outputRows() {
            return this.outputRows;
        }

        @Override
        MoreObjects.ToStringHelper toStringHelper() {
            return super.toStringHelper().add("inputBytes", (Object)this.inputBytes).add("inputFiles", (Object)this.inputFiles).add("outputBytes", (Object)this.outputBytes).add("outputRows", (Object)this.outputRows);
        }

        public final boolean equals(Object obj) {
            return obj == this || obj != null && obj.getClass().equals(LoadStatistics.class) && this.baseEquals((LoadStatistics)obj);
        }

        public final int hashCode() {
            return Objects.hash(this.baseHashCode(), this.inputBytes, this.inputFiles, this.outputBytes, this.outputRows);
        }

        @Override
        com.google.api.services.bigquery.model.JobStatistics toPb() {
            JobStatistics3 loadStatisticsPb = new JobStatistics3();
            loadStatisticsPb.setInputFileBytes(this.inputBytes);
            loadStatisticsPb.setInputFiles(this.inputFiles);
            loadStatisticsPb.setOutputBytes(this.outputBytes);
            loadStatisticsPb.setOutputRows(this.outputRows);
            return super.toPb().setLoad(loadStatisticsPb);
        }

        static Builder builder() {
            return new Builder();
        }

        static LoadStatistics fromPb(com.google.api.services.bigquery.model.JobStatistics statisticPb) {
            return new Builder(statisticPb).build();
        }

        static final class Builder
        extends com.google.cloud.bigquery.JobStatistics$Builder<LoadStatistics, Builder> {
            private Long inputBytes;
            private Long inputFiles;
            private Long outputBytes;
            private Long outputRows;

            private Builder() {
            }

            private Builder(com.google.api.services.bigquery.model.JobStatistics statisticsPb) {
                super(statisticsPb);
                this.inputBytes = statisticsPb.getLoad().getInputFileBytes();
                this.inputFiles = statisticsPb.getLoad().getInputFiles();
                this.outputBytes = statisticsPb.getLoad().getOutputBytes();
                this.outputRows = statisticsPb.getLoad().getOutputRows();
            }

            Builder inputBytes(Long inputBytes) {
                this.inputBytes = inputBytes;
                return (Builder)this.self();
            }

            Builder inputFiles(Long inputFiles) {
                this.inputFiles = inputFiles;
                return (Builder)this.self();
            }

            Builder outputBytes(Long outputBytes) {
                this.outputBytes = outputBytes;
                return (Builder)this.self();
            }

            Builder outputRows(Long outputRows) {
                this.outputRows = outputRows;
                return (Builder)this.self();
            }

            @Override
            LoadStatistics build() {
                return new LoadStatistics(this);
            }
        }
    }

    public static class ExtractStatistics
    extends JobStatistics {
        private static final long serialVersionUID = -1566598819212767373L;
        private final List<Long> destinationUriFileCounts;

        private ExtractStatistics(Builder builder) {
            super(builder);
            this.destinationUriFileCounts = builder.destinationUriFileCounts;
        }

        public List<Long> destinationUriFileCounts() {
            return this.destinationUriFileCounts;
        }

        @Override
        MoreObjects.ToStringHelper toStringHelper() {
            return super.toStringHelper().add("destinationUriFileCounts", this.destinationUriFileCounts);
        }

        public final boolean equals(Object obj) {
            return obj == this || obj != null && obj.getClass().equals(ExtractStatistics.class) && this.baseEquals((ExtractStatistics)obj);
        }

        public final int hashCode() {
            return Objects.hash(this.baseHashCode(), this.destinationUriFileCounts);
        }

        @Override
        com.google.api.services.bigquery.model.JobStatistics toPb() {
            com.google.api.services.bigquery.model.JobStatistics statisticsPb = super.toPb();
            return statisticsPb.setExtract(new JobStatistics4().setDestinationUriFileCounts(this.destinationUriFileCounts));
        }

        static Builder builder() {
            return new Builder();
        }

        static ExtractStatistics fromPb(com.google.api.services.bigquery.model.JobStatistics statisticPb) {
            return new Builder(statisticPb).build();
        }

        static final class Builder
        extends com.google.cloud.bigquery.JobStatistics$Builder<ExtractStatistics, Builder> {
            private List<Long> destinationUriFileCounts;

            private Builder() {
            }

            private Builder(com.google.api.services.bigquery.model.JobStatistics statisticsPb) {
                super(statisticsPb);
                this.destinationUriFileCounts = statisticsPb.getExtract().getDestinationUriFileCounts();
            }

            Builder destinationUriFileCounts(List<Long> destinationUriFileCounts) {
                this.destinationUriFileCounts = destinationUriFileCounts;
                return (Builder)this.self();
            }

            @Override
            ExtractStatistics build() {
                return new ExtractStatistics(this);
            }
        }
    }

    public static class CopyStatistics
    extends JobStatistics {
        private static final long serialVersionUID = 8218325588441660938L;

        private CopyStatistics(Builder builder) {
            super(builder);
        }

        public final boolean equals(Object obj) {
            return obj == this || obj != null && obj.getClass().equals(CopyStatistics.class) && this.baseEquals((CopyStatistics)obj);
        }

        public final int hashCode() {
            return this.baseHashCode();
        }

        static Builder builder() {
            return new Builder();
        }

        static CopyStatistics fromPb(com.google.api.services.bigquery.model.JobStatistics statisticPb) {
            return new Builder(statisticPb).build();
        }

        static final class Builder
        extends com.google.cloud.bigquery.JobStatistics$Builder<CopyStatistics, Builder> {
            private Builder() {
            }

            private Builder(com.google.api.services.bigquery.model.JobStatistics statisticsPb) {
                super(statisticsPb);
            }

            @Override
            CopyStatistics build() {
                return new CopyStatistics(this);
            }
        }
    }
}

