/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.client.util.Data;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class Field
implements Serializable {
    static final Function<TableFieldSchema, Field> FROM_PB_FUNCTION = new Function<TableFieldSchema, Field>(){

        public Field apply(TableFieldSchema pb) {
            return Field.fromPb(pb);
        }
    };
    static final Function<Field, TableFieldSchema> TO_PB_FUNCTION = new Function<Field, TableFieldSchema>(){

        public TableFieldSchema apply(Field field) {
            return field.toPb();
        }
    };
    private static final long serialVersionUID = -8154262932305199256L;
    private final String name;
    private final Type type;
    private final String mode;
    private final String description;

    private Field(Builder builder) {
        this.name = (String)Preconditions.checkNotNull((Object)builder.name);
        this.type = (Type)Preconditions.checkNotNull((Object)builder.type);
        this.mode = builder.mode;
        this.description = builder.description;
    }

    public String name() {
        return this.name;
    }

    public Type type() {
        return this.type;
    }

    public Mode mode() {
        return this.mode != null ? Mode.valueOf(this.mode) : null;
    }

    public String description() {
        return Data.isNull((Object)this.description) ? null : this.description;
    }

    public List<Field> fields() {
        return this.type.fields();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("value", (Object)this.type).add("mode", (Object)this.mode).add("description", (Object)this.description).toString();
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.mode, this.description);
    }

    public boolean equals(Object obj) {
        return obj instanceof Field && Objects.equals(this.toPb(), ((Field)obj).toPb());
    }

    TableFieldSchema toPb() {
        TableFieldSchema fieldSchemaPb = new TableFieldSchema();
        fieldSchemaPb.setName(this.name);
        fieldSchemaPb.setType(this.type.value().name());
        if (this.mode != null) {
            fieldSchemaPb.setMode(this.mode);
        }
        if (this.description != null) {
            fieldSchemaPb.setDescription(this.description);
        }
        if (this.fields() != null) {
            List fieldsPb = Lists.transform(this.fields(), TO_PB_FUNCTION);
            fieldSchemaPb.setFields(fieldsPb);
        }
        return fieldSchemaPb;
    }

    public static Field of(String name, Type type) {
        return Field.builder(name, type).build();
    }

    public static Builder builder(String name, Type type) {
        return new Builder().name(name).type(type);
    }

    static Field fromPb(TableFieldSchema fieldSchemaPb) {
        Builder fieldBuilder = new Builder();
        fieldBuilder.name(fieldSchemaPb.getName());
        Type.Value enumValue = Type.Value.valueOf(fieldSchemaPb.getType());
        if (fieldSchemaPb.getMode() != null) {
            fieldBuilder.mode(Mode.valueOf(fieldSchemaPb.getMode()));
        }
        if (fieldSchemaPb.getDescription() != null) {
            fieldBuilder.description(fieldSchemaPb.getDescription());
        }
        if (fieldSchemaPb.getFields() != null) {
            fieldBuilder.type(Type.record(Lists.transform((List)fieldSchemaPb.getFields(), FROM_PB_FUNCTION)));
        } else {
            fieldBuilder.type(new Type(enumValue));
        }
        return fieldBuilder.build();
    }

    public static final class Builder {
        private String name;
        private Type type;
        private String mode;
        private String description;

        private Builder() {
        }

        private Builder(Field field) {
            this.name = field.name;
            this.type = field.type;
            this.mode = field.mode;
            this.description = field.description;
        }

        public Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            return this;
        }

        public Builder type(Type type) {
            this.type = (Type)Preconditions.checkNotNull((Object)type);
            return this;
        }

        public Builder mode(Mode mode) {
            this.mode = mode != null ? mode.name() : (String)Data.nullOf(String.class);
            return this;
        }

        public Builder description(String description) {
            this.description = (String)MoreObjects.firstNonNull((Object)description, (Object)Data.nullOf(String.class));
            return this;
        }

        public Field build() {
            return new Field(this);
        }
    }

    public static enum Mode {
        NULLABLE,
        REQUIRED,
        REPEATED;

    }

    public static class Type
    implements Serializable {
        private static final long serialVersionUID = 2841484762609576959L;
        private final Value value;
        private final List<Field> fields;

        private Type(Value value) {
            this.value = (Value)((Object)Preconditions.checkNotNull((Object)((Object)value)));
            this.fields = null;
        }

        private Type(Value value, List<Field> fields) {
            Preconditions.checkArgument((fields.size() > 0 ? 1 : 0) != 0, (Object)"Record must have at least one field");
            this.value = value;
            this.fields = fields;
        }

        public Value value() {
            return this.value;
        }

        public List<Field> fields() {
            return this.fields;
        }

        public static Type bytes() {
            return new Type(Value.BYTES);
        }

        public static Type string() {
            return new Type(Value.STRING);
        }

        public static Type integer() {
            return new Type(Value.INTEGER);
        }

        public static Type floatingPoint() {
            return new Type(Value.FLOAT);
        }

        public static Type bool() {
            return new Type(Value.BOOLEAN);
        }

        public static Type timestamp() {
            return new Type(Value.TIMESTAMP);
        }

        public static Type record(Field ... fields) {
            return new Type(Value.RECORD, (List<Field>)ImmutableList.copyOf((Object[])fields));
        }

        public static Type record(List<Field> fields) {
            return new Type(Value.RECORD, (List<Field>)ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(fields))));
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).add("fields", this.fields).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.value, this.fields});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Type)) {
                return false;
            }
            Type other = (Type)obj;
            return Objects.equals((Object)this.value, (Object)other.value) && Objects.equals(this.fields, other.fields);
        }

        public static enum Value {
            BYTES,
            STRING,
            INTEGER,
            FLOAT,
            BOOLEAN,
            TIMESTAMP,
            RECORD;

        }
    }
}

