/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.HttpServiceOptions;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryFactory;
import com.google.cloud.bigquery.BigQueryImpl;
import com.google.cloud.bigquery.spi.BigQueryRpc;
import com.google.cloud.bigquery.spi.BigQueryRpcFactory;
import com.google.cloud.bigquery.spi.DefaultBigQueryRpc;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class BigQueryOptions
extends HttpServiceOptions<BigQuery, BigQueryRpc, BigQueryOptions> {
    private static final String BIGQUERY_SCOPE = "https://www.googleapis.com/auth/bigquery";
    private static final Set<String> SCOPES = ImmutableSet.of((Object)"https://www.googleapis.com/auth/bigquery");
    private static final long serialVersionUID = -8592198255032667206L;

    private BigQueryOptions(Builder builder) {
        super(BigQueryFactory.class, BigQueryRpcFactory.class, (HttpServiceOptions.Builder)builder);
    }

    protected BigQueryFactory defaultServiceFactory() {
        return DefaultBigqueryFactory.INSTANCE;
    }

    protected BigQueryRpcFactory defaultRpcFactory() {
        return DefaultBigQueryRpcFactory.INSTANCE;
    }

    protected Set<String> scopes() {
        return SCOPES;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public int hashCode() {
        return this.baseHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BigQueryOptions)) {
            return false;
        }
        BigQueryOptions other = (BigQueryOptions)((Object)obj);
        return this.baseEquals(other);
    }

    public static BigQueryOptions defaultInstance() {
        return BigQueryOptions.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends HttpServiceOptions.Builder<BigQuery, BigQueryRpc, BigQueryOptions, Builder> {
        private Builder() {
        }

        private Builder(BigQueryOptions options) {
            super((HttpServiceOptions)options);
        }

        public BigQueryOptions build() {
            return new BigQueryOptions(this);
        }
    }

    public static class DefaultBigQueryRpcFactory
    implements BigQueryRpcFactory {
        private static final BigQueryRpcFactory INSTANCE = new DefaultBigQueryRpcFactory();

        public BigQueryRpc create(BigQueryOptions options) {
            return new DefaultBigQueryRpc(options);
        }
    }

    public static class DefaultBigqueryFactory
    implements BigQueryFactory {
        private static final BigQueryFactory INSTANCE = new DefaultBigqueryFactory();

        public BigQuery create(BigQueryOptions options) {
            return new BigQueryImpl(options);
        }
    }
}

