/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.biglake.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.biglake.v1.CreateIcebergCatalogRequest;
import com.google.cloud.biglake.v1.FailoverIcebergCatalogRequest;
import com.google.cloud.biglake.v1.FailoverIcebergCatalogResponse;
import com.google.cloud.biglake.v1.GetIcebergCatalogRequest;
import com.google.cloud.biglake.v1.IcebergCatalog;
import com.google.cloud.biglake.v1.IcebergCatalogServiceClient;
import com.google.cloud.biglake.v1.ListIcebergCatalogsRequest;
import com.google.cloud.biglake.v1.ListIcebergCatalogsResponse;
import com.google.cloud.biglake.v1.UpdateIcebergCatalogRequest;
import com.google.cloud.biglake.v1.stub.GrpcIcebergCatalogServiceStub;
import com.google.cloud.biglake.v1.stub.HttpJsonIcebergCatalogServiceStub;
import com.google.cloud.biglake.v1.stub.IcebergCatalogServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class IcebergCatalogServiceStubSettings
extends StubSettings<IcebergCatalogServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/bigquery").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GetIcebergCatalogRequest, IcebergCatalog> getIcebergCatalogSettings;
    private final PagedCallSettings<ListIcebergCatalogsRequest, ListIcebergCatalogsResponse, IcebergCatalogServiceClient.ListIcebergCatalogsPagedResponse> listIcebergCatalogsSettings;
    private final UnaryCallSettings<UpdateIcebergCatalogRequest, IcebergCatalog> updateIcebergCatalogSettings;
    private final UnaryCallSettings<CreateIcebergCatalogRequest, IcebergCatalog> createIcebergCatalogSettings;
    private final UnaryCallSettings<FailoverIcebergCatalogRequest, FailoverIcebergCatalogResponse> failoverIcebergCatalogSettings;
    private static final PagedListDescriptor<ListIcebergCatalogsRequest, ListIcebergCatalogsResponse, IcebergCatalog> LIST_ICEBERG_CATALOGS_PAGE_STR_DESC = new PagedListDescriptor<ListIcebergCatalogsRequest, ListIcebergCatalogsResponse, IcebergCatalog>(){

        public String emptyToken() {
            return "";
        }

        public ListIcebergCatalogsRequest injectToken(ListIcebergCatalogsRequest payload, String token) {
            return ListIcebergCatalogsRequest.newBuilder((ListIcebergCatalogsRequest)payload).setPageToken(token).build();
        }

        public ListIcebergCatalogsRequest injectPageSize(ListIcebergCatalogsRequest payload, int pageSize) {
            return ListIcebergCatalogsRequest.newBuilder((ListIcebergCatalogsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListIcebergCatalogsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListIcebergCatalogsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<IcebergCatalog> extractResources(ListIcebergCatalogsResponse payload) {
            return payload.getIcebergCatalogsList();
        }
    };
    private static final PagedListResponseFactory<ListIcebergCatalogsRequest, ListIcebergCatalogsResponse, IcebergCatalogServiceClient.ListIcebergCatalogsPagedResponse> LIST_ICEBERG_CATALOGS_PAGE_STR_FACT = new PagedListResponseFactory<ListIcebergCatalogsRequest, ListIcebergCatalogsResponse, IcebergCatalogServiceClient.ListIcebergCatalogsPagedResponse>(){

        public ApiFuture<IcebergCatalogServiceClient.ListIcebergCatalogsPagedResponse> getFuturePagedResponse(UnaryCallable<ListIcebergCatalogsRequest, ListIcebergCatalogsResponse> callable, ListIcebergCatalogsRequest request, ApiCallContext context, ApiFuture<ListIcebergCatalogsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ICEBERG_CATALOGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return IcebergCatalogServiceClient.ListIcebergCatalogsPagedResponse.createAsync((PageContext<ListIcebergCatalogsRequest, ListIcebergCatalogsResponse, IcebergCatalog>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetIcebergCatalogRequest, IcebergCatalog> getIcebergCatalogSettings() {
        return this.getIcebergCatalogSettings;
    }

    public PagedCallSettings<ListIcebergCatalogsRequest, ListIcebergCatalogsResponse, IcebergCatalogServiceClient.ListIcebergCatalogsPagedResponse> listIcebergCatalogsSettings() {
        return this.listIcebergCatalogsSettings;
    }

    public UnaryCallSettings<UpdateIcebergCatalogRequest, IcebergCatalog> updateIcebergCatalogSettings() {
        return this.updateIcebergCatalogSettings;
    }

    public UnaryCallSettings<CreateIcebergCatalogRequest, IcebergCatalog> createIcebergCatalogSettings() {
        return this.createIcebergCatalogSettings;
    }

    public UnaryCallSettings<FailoverIcebergCatalogRequest, FailoverIcebergCatalogResponse> failoverIcebergCatalogSettings() {
        return this.failoverIcebergCatalogSettings;
    }

    public IcebergCatalogServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcIcebergCatalogServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonIcebergCatalogServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "biglake";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "biglake.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "biglake.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return IcebergCatalogServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(IcebergCatalogServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(IcebergCatalogServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return IcebergCatalogServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected IcebergCatalogServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getIcebergCatalogSettings = settingsBuilder.getIcebergCatalogSettings().build();
        this.listIcebergCatalogsSettings = settingsBuilder.listIcebergCatalogsSettings().build();
        this.updateIcebergCatalogSettings = settingsBuilder.updateIcebergCatalogSettings().build();
        this.createIcebergCatalogSettings = settingsBuilder.createIcebergCatalogSettings().build();
        this.failoverIcebergCatalogSettings = settingsBuilder.failoverIcebergCatalogSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<IcebergCatalogServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetIcebergCatalogRequest, IcebergCatalog> getIcebergCatalogSettings;
        private final PagedCallSettings.Builder<ListIcebergCatalogsRequest, ListIcebergCatalogsResponse, IcebergCatalogServiceClient.ListIcebergCatalogsPagedResponse> listIcebergCatalogsSettings;
        private final UnaryCallSettings.Builder<UpdateIcebergCatalogRequest, IcebergCatalog> updateIcebergCatalogSettings;
        private final UnaryCallSettings.Builder<CreateIcebergCatalogRequest, IcebergCatalog> createIcebergCatalogSettings;
        private final UnaryCallSettings.Builder<FailoverIcebergCatalogRequest, FailoverIcebergCatalogResponse> failoverIcebergCatalogSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getIcebergCatalogSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listIcebergCatalogsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ICEBERG_CATALOGS_PAGE_STR_FACT);
            this.updateIcebergCatalogSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createIcebergCatalogSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.failoverIcebergCatalogSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getIcebergCatalogSettings, this.listIcebergCatalogsSettings, this.updateIcebergCatalogSettings, this.createIcebergCatalogSettings, this.failoverIcebergCatalogSettings);
            Builder.initDefaults(this);
        }

        protected Builder(IcebergCatalogServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getIcebergCatalogSettings = settings.getIcebergCatalogSettings.toBuilder();
            this.listIcebergCatalogsSettings = settings.listIcebergCatalogsSettings.toBuilder();
            this.updateIcebergCatalogSettings = settings.updateIcebergCatalogSettings.toBuilder();
            this.createIcebergCatalogSettings = settings.createIcebergCatalogSettings.toBuilder();
            this.failoverIcebergCatalogSettings = settings.failoverIcebergCatalogSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getIcebergCatalogSettings, this.listIcebergCatalogsSettings, this.updateIcebergCatalogSettings, this.createIcebergCatalogSettings, this.failoverIcebergCatalogSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(IcebergCatalogServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)IcebergCatalogServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)IcebergCatalogServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(IcebergCatalogServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)IcebergCatalogServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)IcebergCatalogServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)IcebergCatalogServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(IcebergCatalogServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getIcebergCatalogSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listIcebergCatalogsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateIcebergCatalogSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createIcebergCatalogSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.failoverIcebergCatalogSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetIcebergCatalogRequest, IcebergCatalog> getIcebergCatalogSettings() {
            return this.getIcebergCatalogSettings;
        }

        public PagedCallSettings.Builder<ListIcebergCatalogsRequest, ListIcebergCatalogsResponse, IcebergCatalogServiceClient.ListIcebergCatalogsPagedResponse> listIcebergCatalogsSettings() {
            return this.listIcebergCatalogsSettings;
        }

        public UnaryCallSettings.Builder<UpdateIcebergCatalogRequest, IcebergCatalog> updateIcebergCatalogSettings() {
            return this.updateIcebergCatalogSettings;
        }

        public UnaryCallSettings.Builder<CreateIcebergCatalogRequest, IcebergCatalog> createIcebergCatalogSettings() {
            return this.createIcebergCatalogSettings;
        }

        public UnaryCallSettings.Builder<FailoverIcebergCatalogRequest, FailoverIcebergCatalogResponse> failoverIcebergCatalogSettings() {
            return this.failoverIcebergCatalogSettings;
        }

        public IcebergCatalogServiceStubSettings build() throws IOException {
            return new IcebergCatalogServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

