/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.biglake.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.biglake.v1.CatalogName;
import com.google.cloud.biglake.v1.CreateIcebergCatalogRequest;
import com.google.cloud.biglake.v1.FailoverIcebergCatalogRequest;
import com.google.cloud.biglake.v1.FailoverIcebergCatalogResponse;
import com.google.cloud.biglake.v1.GetIcebergCatalogRequest;
import com.google.cloud.biglake.v1.IcebergCatalog;
import com.google.cloud.biglake.v1.IcebergCatalogServiceSettings;
import com.google.cloud.biglake.v1.ListIcebergCatalogsRequest;
import com.google.cloud.biglake.v1.ListIcebergCatalogsResponse;
import com.google.cloud.biglake.v1.ProjectName;
import com.google.cloud.biglake.v1.UpdateIcebergCatalogRequest;
import com.google.cloud.biglake.v1.stub.IcebergCatalogServiceStub;
import com.google.cloud.biglake.v1.stub.IcebergCatalogServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class IcebergCatalogServiceClient
implements BackgroundResource {
    private final IcebergCatalogServiceSettings settings;
    private final IcebergCatalogServiceStub stub;

    public static final IcebergCatalogServiceClient create() throws IOException {
        return IcebergCatalogServiceClient.create(IcebergCatalogServiceSettings.newBuilder().build());
    }

    public static final IcebergCatalogServiceClient create(IcebergCatalogServiceSettings settings) throws IOException {
        return new IcebergCatalogServiceClient(settings);
    }

    public static final IcebergCatalogServiceClient create(IcebergCatalogServiceStub stub) {
        return new IcebergCatalogServiceClient(stub);
    }

    protected IcebergCatalogServiceClient(IcebergCatalogServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((IcebergCatalogServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected IcebergCatalogServiceClient(IcebergCatalogServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final IcebergCatalogServiceSettings getSettings() {
        return this.settings;
    }

    public IcebergCatalogServiceStub getStub() {
        return this.stub;
    }

    public final IcebergCatalog getIcebergCatalog(CatalogName name) {
        GetIcebergCatalogRequest request = GetIcebergCatalogRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getIcebergCatalog(request);
    }

    public final IcebergCatalog getIcebergCatalog(String name) {
        GetIcebergCatalogRequest request = GetIcebergCatalogRequest.newBuilder().setName(name).build();
        return this.getIcebergCatalog(request);
    }

    public final IcebergCatalog getIcebergCatalog(GetIcebergCatalogRequest request) {
        return (IcebergCatalog)this.getIcebergCatalogCallable().call((Object)request);
    }

    public final UnaryCallable<GetIcebergCatalogRequest, IcebergCatalog> getIcebergCatalogCallable() {
        return this.stub.getIcebergCatalogCallable();
    }

    public final ListIcebergCatalogsPagedResponse listIcebergCatalogs(ProjectName parent) {
        ListIcebergCatalogsRequest request = ListIcebergCatalogsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listIcebergCatalogs(request);
    }

    public final ListIcebergCatalogsPagedResponse listIcebergCatalogs(String parent) {
        ListIcebergCatalogsRequest request = ListIcebergCatalogsRequest.newBuilder().setParent(parent).build();
        return this.listIcebergCatalogs(request);
    }

    public final ListIcebergCatalogsPagedResponse listIcebergCatalogs(ListIcebergCatalogsRequest request) {
        return (ListIcebergCatalogsPagedResponse)((Object)this.listIcebergCatalogsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListIcebergCatalogsRequest, ListIcebergCatalogsPagedResponse> listIcebergCatalogsPagedCallable() {
        return this.stub.listIcebergCatalogsPagedCallable();
    }

    public final UnaryCallable<ListIcebergCatalogsRequest, ListIcebergCatalogsResponse> listIcebergCatalogsCallable() {
        return this.stub.listIcebergCatalogsCallable();
    }

    public final IcebergCatalog updateIcebergCatalog(IcebergCatalog icebergCatalog, FieldMask updateMask) {
        UpdateIcebergCatalogRequest request = UpdateIcebergCatalogRequest.newBuilder().setIcebergCatalog(icebergCatalog).setUpdateMask(updateMask).build();
        return this.updateIcebergCatalog(request);
    }

    public final IcebergCatalog updateIcebergCatalog(UpdateIcebergCatalogRequest request) {
        return (IcebergCatalog)this.updateIcebergCatalogCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateIcebergCatalogRequest, IcebergCatalog> updateIcebergCatalogCallable() {
        return this.stub.updateIcebergCatalogCallable();
    }

    public final IcebergCatalog createIcebergCatalog(ProjectName parent, IcebergCatalog icebergCatalog, String icebergCatalogId) {
        CreateIcebergCatalogRequest request = CreateIcebergCatalogRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setIcebergCatalog(icebergCatalog).setIcebergCatalogId(icebergCatalogId).build();
        return this.createIcebergCatalog(request);
    }

    public final IcebergCatalog createIcebergCatalog(String parent, IcebergCatalog icebergCatalog, String icebergCatalogId) {
        CreateIcebergCatalogRequest request = CreateIcebergCatalogRequest.newBuilder().setParent(parent).setIcebergCatalog(icebergCatalog).setIcebergCatalogId(icebergCatalogId).build();
        return this.createIcebergCatalog(request);
    }

    public final IcebergCatalog createIcebergCatalog(CreateIcebergCatalogRequest request) {
        return (IcebergCatalog)this.createIcebergCatalogCallable().call((Object)request);
    }

    public final UnaryCallable<CreateIcebergCatalogRequest, IcebergCatalog> createIcebergCatalogCallable() {
        return this.stub.createIcebergCatalogCallable();
    }

    public final FailoverIcebergCatalogResponse failoverIcebergCatalog(String name, String primaryReplica) {
        FailoverIcebergCatalogRequest request = FailoverIcebergCatalogRequest.newBuilder().setName(name).setPrimaryReplica(primaryReplica).build();
        return this.failoverIcebergCatalog(request);
    }

    public final FailoverIcebergCatalogResponse failoverIcebergCatalog(FailoverIcebergCatalogRequest request) {
        return (FailoverIcebergCatalogResponse)this.failoverIcebergCatalogCallable().call((Object)request);
    }

    public final UnaryCallable<FailoverIcebergCatalogRequest, FailoverIcebergCatalogResponse> failoverIcebergCatalogCallable() {
        return this.stub.failoverIcebergCatalogCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListIcebergCatalogsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListIcebergCatalogsRequest, ListIcebergCatalogsResponse, IcebergCatalog, ListIcebergCatalogsPage, ListIcebergCatalogsFixedSizeCollection> {
        private ListIcebergCatalogsFixedSizeCollection(List<ListIcebergCatalogsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListIcebergCatalogsFixedSizeCollection createEmptyCollection() {
            return new ListIcebergCatalogsFixedSizeCollection(null, 0);
        }

        protected ListIcebergCatalogsFixedSizeCollection createCollection(List<ListIcebergCatalogsPage> pages, int collectionSize) {
            return new ListIcebergCatalogsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListIcebergCatalogsPage
    extends AbstractPage<ListIcebergCatalogsRequest, ListIcebergCatalogsResponse, IcebergCatalog, ListIcebergCatalogsPage> {
        private ListIcebergCatalogsPage(PageContext<ListIcebergCatalogsRequest, ListIcebergCatalogsResponse, IcebergCatalog> context, ListIcebergCatalogsResponse response) {
            super(context, (Object)response);
        }

        private static ListIcebergCatalogsPage createEmptyPage() {
            return new ListIcebergCatalogsPage(null, null);
        }

        protected ListIcebergCatalogsPage createPage(PageContext<ListIcebergCatalogsRequest, ListIcebergCatalogsResponse, IcebergCatalog> context, ListIcebergCatalogsResponse response) {
            return new ListIcebergCatalogsPage(context, response);
        }

        public ApiFuture<ListIcebergCatalogsPage> createPageAsync(PageContext<ListIcebergCatalogsRequest, ListIcebergCatalogsResponse, IcebergCatalog> context, ApiFuture<ListIcebergCatalogsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListIcebergCatalogsPagedResponse
    extends AbstractPagedListResponse<ListIcebergCatalogsRequest, ListIcebergCatalogsResponse, IcebergCatalog, ListIcebergCatalogsPage, ListIcebergCatalogsFixedSizeCollection> {
        public static ApiFuture<ListIcebergCatalogsPagedResponse> createAsync(PageContext<ListIcebergCatalogsRequest, ListIcebergCatalogsResponse, IcebergCatalog> context, ApiFuture<ListIcebergCatalogsResponse> futureResponse) {
            ApiFuture<ListIcebergCatalogsPage> futurePage = ListIcebergCatalogsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListIcebergCatalogsPagedResponse((ListIcebergCatalogsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListIcebergCatalogsPagedResponse(ListIcebergCatalogsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListIcebergCatalogsFixedSizeCollection.createEmptyCollection());
        }
    }
}

