/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.biglake.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.biglake.v1.Catalog;
import com.google.cloud.bigquery.biglake.v1.CatalogName;
import com.google.cloud.bigquery.biglake.v1.CreateCatalogRequest;
import com.google.cloud.bigquery.biglake.v1.CreateDatabaseRequest;
import com.google.cloud.bigquery.biglake.v1.CreateTableRequest;
import com.google.cloud.bigquery.biglake.v1.Database;
import com.google.cloud.bigquery.biglake.v1.DatabaseName;
import com.google.cloud.bigquery.biglake.v1.DeleteCatalogRequest;
import com.google.cloud.bigquery.biglake.v1.DeleteDatabaseRequest;
import com.google.cloud.bigquery.biglake.v1.DeleteTableRequest;
import com.google.cloud.bigquery.biglake.v1.GetCatalogRequest;
import com.google.cloud.bigquery.biglake.v1.GetDatabaseRequest;
import com.google.cloud.bigquery.biglake.v1.GetTableRequest;
import com.google.cloud.bigquery.biglake.v1.ListCatalogsRequest;
import com.google.cloud.bigquery.biglake.v1.ListCatalogsResponse;
import com.google.cloud.bigquery.biglake.v1.ListDatabasesRequest;
import com.google.cloud.bigquery.biglake.v1.ListDatabasesResponse;
import com.google.cloud.bigquery.biglake.v1.ListTablesRequest;
import com.google.cloud.bigquery.biglake.v1.ListTablesResponse;
import com.google.cloud.bigquery.biglake.v1.LocationName;
import com.google.cloud.bigquery.biglake.v1.MetastoreServiceSettings;
import com.google.cloud.bigquery.biglake.v1.RenameTableRequest;
import com.google.cloud.bigquery.biglake.v1.Table;
import com.google.cloud.bigquery.biglake.v1.TableName;
import com.google.cloud.bigquery.biglake.v1.UpdateDatabaseRequest;
import com.google.cloud.bigquery.biglake.v1.UpdateTableRequest;
import com.google.cloud.bigquery.biglake.v1.stub.MetastoreServiceStub;
import com.google.cloud.bigquery.biglake.v1.stub.MetastoreServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class MetastoreServiceClient
implements BackgroundResource {
    private final MetastoreServiceSettings settings;
    private final MetastoreServiceStub stub;

    public static final MetastoreServiceClient create() throws IOException {
        return MetastoreServiceClient.create(MetastoreServiceSettings.newBuilder().build());
    }

    public static final MetastoreServiceClient create(MetastoreServiceSettings settings) throws IOException {
        return new MetastoreServiceClient(settings);
    }

    public static final MetastoreServiceClient create(MetastoreServiceStub stub) {
        return new MetastoreServiceClient(stub);
    }

    protected MetastoreServiceClient(MetastoreServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((MetastoreServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected MetastoreServiceClient(MetastoreServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final MetastoreServiceSettings getSettings() {
        return this.settings;
    }

    public MetastoreServiceStub getStub() {
        return this.stub;
    }

    public final Catalog createCatalog(LocationName parent, Catalog catalog, String catalogId) {
        CreateCatalogRequest request = CreateCatalogRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCatalog(catalog).setCatalogId(catalogId).build();
        return this.createCatalog(request);
    }

    public final Catalog createCatalog(String parent, Catalog catalog, String catalogId) {
        CreateCatalogRequest request = CreateCatalogRequest.newBuilder().setParent(parent).setCatalog(catalog).setCatalogId(catalogId).build();
        return this.createCatalog(request);
    }

    public final Catalog createCatalog(CreateCatalogRequest request) {
        return (Catalog)this.createCatalogCallable().call((Object)request);
    }

    public final UnaryCallable<CreateCatalogRequest, Catalog> createCatalogCallable() {
        return this.stub.createCatalogCallable();
    }

    public final Catalog deleteCatalog(CatalogName name) {
        DeleteCatalogRequest request = DeleteCatalogRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteCatalog(request);
    }

    public final Catalog deleteCatalog(String name) {
        DeleteCatalogRequest request = DeleteCatalogRequest.newBuilder().setName(name).build();
        return this.deleteCatalog(request);
    }

    public final Catalog deleteCatalog(DeleteCatalogRequest request) {
        return (Catalog)this.deleteCatalogCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteCatalogRequest, Catalog> deleteCatalogCallable() {
        return this.stub.deleteCatalogCallable();
    }

    public final Catalog getCatalog(CatalogName name) {
        GetCatalogRequest request = GetCatalogRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCatalog(request);
    }

    public final Catalog getCatalog(String name) {
        GetCatalogRequest request = GetCatalogRequest.newBuilder().setName(name).build();
        return this.getCatalog(request);
    }

    public final Catalog getCatalog(GetCatalogRequest request) {
        return (Catalog)this.getCatalogCallable().call((Object)request);
    }

    public final UnaryCallable<GetCatalogRequest, Catalog> getCatalogCallable() {
        return this.stub.getCatalogCallable();
    }

    public final ListCatalogsPagedResponse listCatalogs(LocationName parent) {
        ListCatalogsRequest request = ListCatalogsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCatalogs(request);
    }

    public final ListCatalogsPagedResponse listCatalogs(String parent) {
        ListCatalogsRequest request = ListCatalogsRequest.newBuilder().setParent(parent).build();
        return this.listCatalogs(request);
    }

    public final ListCatalogsPagedResponse listCatalogs(ListCatalogsRequest request) {
        return (ListCatalogsPagedResponse)((Object)this.listCatalogsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCatalogsRequest, ListCatalogsPagedResponse> listCatalogsPagedCallable() {
        return this.stub.listCatalogsPagedCallable();
    }

    public final UnaryCallable<ListCatalogsRequest, ListCatalogsResponse> listCatalogsCallable() {
        return this.stub.listCatalogsCallable();
    }

    public final Database createDatabase(CatalogName parent, Database database, String databaseId) {
        CreateDatabaseRequest request = CreateDatabaseRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDatabase(database).setDatabaseId(databaseId).build();
        return this.createDatabase(request);
    }

    public final Database createDatabase(String parent, Database database, String databaseId) {
        CreateDatabaseRequest request = CreateDatabaseRequest.newBuilder().setParent(parent).setDatabase(database).setDatabaseId(databaseId).build();
        return this.createDatabase(request);
    }

    public final Database createDatabase(CreateDatabaseRequest request) {
        return (Database)this.createDatabaseCallable().call((Object)request);
    }

    public final UnaryCallable<CreateDatabaseRequest, Database> createDatabaseCallable() {
        return this.stub.createDatabaseCallable();
    }

    public final Database deleteDatabase(DatabaseName name) {
        DeleteDatabaseRequest request = DeleteDatabaseRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteDatabase(request);
    }

    public final Database deleteDatabase(String name) {
        DeleteDatabaseRequest request = DeleteDatabaseRequest.newBuilder().setName(name).build();
        return this.deleteDatabase(request);
    }

    public final Database deleteDatabase(DeleteDatabaseRequest request) {
        return (Database)this.deleteDatabaseCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteDatabaseRequest, Database> deleteDatabaseCallable() {
        return this.stub.deleteDatabaseCallable();
    }

    public final Database updateDatabase(Database database, FieldMask updateMask) {
        UpdateDatabaseRequest request = UpdateDatabaseRequest.newBuilder().setDatabase(database).setUpdateMask(updateMask).build();
        return this.updateDatabase(request);
    }

    public final Database updateDatabase(UpdateDatabaseRequest request) {
        return (Database)this.updateDatabaseCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateDatabaseRequest, Database> updateDatabaseCallable() {
        return this.stub.updateDatabaseCallable();
    }

    public final Database getDatabase(DatabaseName name) {
        GetDatabaseRequest request = GetDatabaseRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDatabase(request);
    }

    public final Database getDatabase(String name) {
        GetDatabaseRequest request = GetDatabaseRequest.newBuilder().setName(name).build();
        return this.getDatabase(request);
    }

    public final Database getDatabase(GetDatabaseRequest request) {
        return (Database)this.getDatabaseCallable().call((Object)request);
    }

    public final UnaryCallable<GetDatabaseRequest, Database> getDatabaseCallable() {
        return this.stub.getDatabaseCallable();
    }

    public final ListDatabasesPagedResponse listDatabases(CatalogName parent) {
        ListDatabasesRequest request = ListDatabasesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDatabases(request);
    }

    public final ListDatabasesPagedResponse listDatabases(String parent) {
        ListDatabasesRequest request = ListDatabasesRequest.newBuilder().setParent(parent).build();
        return this.listDatabases(request);
    }

    public final ListDatabasesPagedResponse listDatabases(ListDatabasesRequest request) {
        return (ListDatabasesPagedResponse)((Object)this.listDatabasesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDatabasesRequest, ListDatabasesPagedResponse> listDatabasesPagedCallable() {
        return this.stub.listDatabasesPagedCallable();
    }

    public final UnaryCallable<ListDatabasesRequest, ListDatabasesResponse> listDatabasesCallable() {
        return this.stub.listDatabasesCallable();
    }

    public final Table createTable(DatabaseName parent, Table table, String tableId) {
        CreateTableRequest request = CreateTableRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTable(table).setTableId(tableId).build();
        return this.createTable(request);
    }

    public final Table createTable(String parent, Table table, String tableId) {
        CreateTableRequest request = CreateTableRequest.newBuilder().setParent(parent).setTable(table).setTableId(tableId).build();
        return this.createTable(request);
    }

    public final Table createTable(CreateTableRequest request) {
        return (Table)this.createTableCallable().call((Object)request);
    }

    public final UnaryCallable<CreateTableRequest, Table> createTableCallable() {
        return this.stub.createTableCallable();
    }

    public final Table deleteTable(TableName name) {
        DeleteTableRequest request = DeleteTableRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteTable(request);
    }

    public final Table deleteTable(String name) {
        DeleteTableRequest request = DeleteTableRequest.newBuilder().setName(name).build();
        return this.deleteTable(request);
    }

    public final Table deleteTable(DeleteTableRequest request) {
        return (Table)this.deleteTableCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteTableRequest, Table> deleteTableCallable() {
        return this.stub.deleteTableCallable();
    }

    public final Table updateTable(Table table, FieldMask updateMask) {
        UpdateTableRequest request = UpdateTableRequest.newBuilder().setTable(table).setUpdateMask(updateMask).build();
        return this.updateTable(request);
    }

    public final Table updateTable(UpdateTableRequest request) {
        return (Table)this.updateTableCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateTableRequest, Table> updateTableCallable() {
        return this.stub.updateTableCallable();
    }

    public final Table renameTable(TableName name, TableName newName) {
        RenameTableRequest request = RenameTableRequest.newBuilder().setName(name == null ? null : name.toString()).setNewName(newName == null ? null : newName.toString()).build();
        return this.renameTable(request);
    }

    public final Table renameTable(TableName name, String newName) {
        RenameTableRequest request = RenameTableRequest.newBuilder().setName(name == null ? null : name.toString()).setNewName(newName).build();
        return this.renameTable(request);
    }

    public final Table renameTable(String name, TableName newName) {
        RenameTableRequest request = RenameTableRequest.newBuilder().setName(name).setNewName(newName == null ? null : newName.toString()).build();
        return this.renameTable(request);
    }

    public final Table renameTable(String name, String newName) {
        RenameTableRequest request = RenameTableRequest.newBuilder().setName(name).setNewName(newName).build();
        return this.renameTable(request);
    }

    public final Table renameTable(RenameTableRequest request) {
        return (Table)this.renameTableCallable().call((Object)request);
    }

    public final UnaryCallable<RenameTableRequest, Table> renameTableCallable() {
        return this.stub.renameTableCallable();
    }

    public final Table getTable(TableName name) {
        GetTableRequest request = GetTableRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTable(request);
    }

    public final Table getTable(String name) {
        GetTableRequest request = GetTableRequest.newBuilder().setName(name).build();
        return this.getTable(request);
    }

    public final Table getTable(GetTableRequest request) {
        return (Table)this.getTableCallable().call((Object)request);
    }

    public final UnaryCallable<GetTableRequest, Table> getTableCallable() {
        return this.stub.getTableCallable();
    }

    public final ListTablesPagedResponse listTables(DatabaseName parent) {
        ListTablesRequest request = ListTablesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTables(request);
    }

    public final ListTablesPagedResponse listTables(String parent) {
        ListTablesRequest request = ListTablesRequest.newBuilder().setParent(parent).build();
        return this.listTables(request);
    }

    public final ListTablesPagedResponse listTables(ListTablesRequest request) {
        return (ListTablesPagedResponse)((Object)this.listTablesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTablesRequest, ListTablesPagedResponse> listTablesPagedCallable() {
        return this.stub.listTablesPagedCallable();
    }

    public final UnaryCallable<ListTablesRequest, ListTablesResponse> listTablesCallable() {
        return this.stub.listTablesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListTablesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTablesRequest, ListTablesResponse, Table, ListTablesPage, ListTablesFixedSizeCollection> {
        private ListTablesFixedSizeCollection(List<ListTablesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTablesFixedSizeCollection createEmptyCollection() {
            return new ListTablesFixedSizeCollection(null, 0);
        }

        protected ListTablesFixedSizeCollection createCollection(List<ListTablesPage> pages, int collectionSize) {
            return new ListTablesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTablesPage
    extends AbstractPage<ListTablesRequest, ListTablesResponse, Table, ListTablesPage> {
        private ListTablesPage(PageContext<ListTablesRequest, ListTablesResponse, Table> context, ListTablesResponse response) {
            super(context, (Object)response);
        }

        private static ListTablesPage createEmptyPage() {
            return new ListTablesPage(null, null);
        }

        protected ListTablesPage createPage(PageContext<ListTablesRequest, ListTablesResponse, Table> context, ListTablesResponse response) {
            return new ListTablesPage(context, response);
        }

        public ApiFuture<ListTablesPage> createPageAsync(PageContext<ListTablesRequest, ListTablesResponse, Table> context, ApiFuture<ListTablesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTablesPagedResponse
    extends AbstractPagedListResponse<ListTablesRequest, ListTablesResponse, Table, ListTablesPage, ListTablesFixedSizeCollection> {
        public static ApiFuture<ListTablesPagedResponse> createAsync(PageContext<ListTablesRequest, ListTablesResponse, Table> context, ApiFuture<ListTablesResponse> futureResponse) {
            ApiFuture<ListTablesPage> futurePage = ListTablesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTablesPagedResponse((ListTablesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTablesPagedResponse(ListTablesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTablesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDatabasesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDatabasesRequest, ListDatabasesResponse, Database, ListDatabasesPage, ListDatabasesFixedSizeCollection> {
        private ListDatabasesFixedSizeCollection(List<ListDatabasesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDatabasesFixedSizeCollection createEmptyCollection() {
            return new ListDatabasesFixedSizeCollection(null, 0);
        }

        protected ListDatabasesFixedSizeCollection createCollection(List<ListDatabasesPage> pages, int collectionSize) {
            return new ListDatabasesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDatabasesPage
    extends AbstractPage<ListDatabasesRequest, ListDatabasesResponse, Database, ListDatabasesPage> {
        private ListDatabasesPage(PageContext<ListDatabasesRequest, ListDatabasesResponse, Database> context, ListDatabasesResponse response) {
            super(context, (Object)response);
        }

        private static ListDatabasesPage createEmptyPage() {
            return new ListDatabasesPage(null, null);
        }

        protected ListDatabasesPage createPage(PageContext<ListDatabasesRequest, ListDatabasesResponse, Database> context, ListDatabasesResponse response) {
            return new ListDatabasesPage(context, response);
        }

        public ApiFuture<ListDatabasesPage> createPageAsync(PageContext<ListDatabasesRequest, ListDatabasesResponse, Database> context, ApiFuture<ListDatabasesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDatabasesPagedResponse
    extends AbstractPagedListResponse<ListDatabasesRequest, ListDatabasesResponse, Database, ListDatabasesPage, ListDatabasesFixedSizeCollection> {
        public static ApiFuture<ListDatabasesPagedResponse> createAsync(PageContext<ListDatabasesRequest, ListDatabasesResponse, Database> context, ApiFuture<ListDatabasesResponse> futureResponse) {
            ApiFuture<ListDatabasesPage> futurePage = ListDatabasesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDatabasesPagedResponse((ListDatabasesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDatabasesPagedResponse(ListDatabasesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDatabasesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCatalogsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCatalogsRequest, ListCatalogsResponse, Catalog, ListCatalogsPage, ListCatalogsFixedSizeCollection> {
        private ListCatalogsFixedSizeCollection(List<ListCatalogsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCatalogsFixedSizeCollection createEmptyCollection() {
            return new ListCatalogsFixedSizeCollection(null, 0);
        }

        protected ListCatalogsFixedSizeCollection createCollection(List<ListCatalogsPage> pages, int collectionSize) {
            return new ListCatalogsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCatalogsPage
    extends AbstractPage<ListCatalogsRequest, ListCatalogsResponse, Catalog, ListCatalogsPage> {
        private ListCatalogsPage(PageContext<ListCatalogsRequest, ListCatalogsResponse, Catalog> context, ListCatalogsResponse response) {
            super(context, (Object)response);
        }

        private static ListCatalogsPage createEmptyPage() {
            return new ListCatalogsPage(null, null);
        }

        protected ListCatalogsPage createPage(PageContext<ListCatalogsRequest, ListCatalogsResponse, Catalog> context, ListCatalogsResponse response) {
            return new ListCatalogsPage(context, response);
        }

        public ApiFuture<ListCatalogsPage> createPageAsync(PageContext<ListCatalogsRequest, ListCatalogsResponse, Catalog> context, ApiFuture<ListCatalogsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCatalogsPagedResponse
    extends AbstractPagedListResponse<ListCatalogsRequest, ListCatalogsResponse, Catalog, ListCatalogsPage, ListCatalogsFixedSizeCollection> {
        public static ApiFuture<ListCatalogsPagedResponse> createAsync(PageContext<ListCatalogsRequest, ListCatalogsResponse, Catalog> context, ApiFuture<ListCatalogsResponse> futureResponse) {
            ApiFuture<ListCatalogsPage> futurePage = ListCatalogsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCatalogsPagedResponse((ListCatalogsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCatalogsPagedResponse(ListCatalogsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCatalogsFixedSizeCollection.createEmptyCollection());
        }
    }
}

