/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.beyondcorp.appconnections.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.beyondcorp.appconnections.v1.AppConnection;
import com.google.cloud.beyondcorp.appconnections.v1.AppConnectionOperationMetadata;
import com.google.cloud.beyondcorp.appconnections.v1.AppConnectionsServiceClient;
import com.google.cloud.beyondcorp.appconnections.v1.CreateAppConnectionRequest;
import com.google.cloud.beyondcorp.appconnections.v1.DeleteAppConnectionRequest;
import com.google.cloud.beyondcorp.appconnections.v1.GetAppConnectionRequest;
import com.google.cloud.beyondcorp.appconnections.v1.ListAppConnectionsRequest;
import com.google.cloud.beyondcorp.appconnections.v1.ListAppConnectionsResponse;
import com.google.cloud.beyondcorp.appconnections.v1.ResolveAppConnectionsRequest;
import com.google.cloud.beyondcorp.appconnections.v1.ResolveAppConnectionsResponse;
import com.google.cloud.beyondcorp.appconnections.v1.UpdateAppConnectionRequest;
import com.google.cloud.beyondcorp.appconnections.v1.stub.AppConnectionsServiceStub;
import com.google.cloud.beyondcorp.appconnections.v1.stub.GrpcAppConnectionsServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class AppConnectionsServiceStubSettings
extends StubSettings<AppConnectionsServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListAppConnectionsRequest, ListAppConnectionsResponse, AppConnectionsServiceClient.ListAppConnectionsPagedResponse> listAppConnectionsSettings;
    private final UnaryCallSettings<GetAppConnectionRequest, AppConnection> getAppConnectionSettings;
    private final UnaryCallSettings<CreateAppConnectionRequest, Operation> createAppConnectionSettings;
    private final OperationCallSettings<CreateAppConnectionRequest, AppConnection, AppConnectionOperationMetadata> createAppConnectionOperationSettings;
    private final UnaryCallSettings<UpdateAppConnectionRequest, Operation> updateAppConnectionSettings;
    private final OperationCallSettings<UpdateAppConnectionRequest, AppConnection, AppConnectionOperationMetadata> updateAppConnectionOperationSettings;
    private final UnaryCallSettings<DeleteAppConnectionRequest, Operation> deleteAppConnectionSettings;
    private final OperationCallSettings<DeleteAppConnectionRequest, Empty, AppConnectionOperationMetadata> deleteAppConnectionOperationSettings;
    private final PagedCallSettings<ResolveAppConnectionsRequest, ResolveAppConnectionsResponse, AppConnectionsServiceClient.ResolveAppConnectionsPagedResponse> resolveAppConnectionsSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, AppConnectionsServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListAppConnectionsRequest, ListAppConnectionsResponse, AppConnection> LIST_APP_CONNECTIONS_PAGE_STR_DESC = new PagedListDescriptor<ListAppConnectionsRequest, ListAppConnectionsResponse, AppConnection>(){

        public String emptyToken() {
            return "";
        }

        public ListAppConnectionsRequest injectToken(ListAppConnectionsRequest payload, String token) {
            return ListAppConnectionsRequest.newBuilder((ListAppConnectionsRequest)payload).setPageToken(token).build();
        }

        public ListAppConnectionsRequest injectPageSize(ListAppConnectionsRequest payload, int pageSize) {
            return ListAppConnectionsRequest.newBuilder((ListAppConnectionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAppConnectionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAppConnectionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AppConnection> extractResources(ListAppConnectionsResponse payload) {
            return payload.getAppConnectionsList();
        }
    };
    private static final PagedListDescriptor<ResolveAppConnectionsRequest, ResolveAppConnectionsResponse, ResolveAppConnectionsResponse.AppConnectionDetails> RESOLVE_APP_CONNECTIONS_PAGE_STR_DESC = new PagedListDescriptor<ResolveAppConnectionsRequest, ResolveAppConnectionsResponse, ResolveAppConnectionsResponse.AppConnectionDetails>(){

        public String emptyToken() {
            return "";
        }

        public ResolveAppConnectionsRequest injectToken(ResolveAppConnectionsRequest payload, String token) {
            return ResolveAppConnectionsRequest.newBuilder((ResolveAppConnectionsRequest)payload).setPageToken(token).build();
        }

        public ResolveAppConnectionsRequest injectPageSize(ResolveAppConnectionsRequest payload, int pageSize) {
            return ResolveAppConnectionsRequest.newBuilder((ResolveAppConnectionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ResolveAppConnectionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ResolveAppConnectionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ResolveAppConnectionsResponse.AppConnectionDetails> extractResources(ResolveAppConnectionsResponse payload) {
            return payload.getAppConnectionDetailsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListAppConnectionsRequest, ListAppConnectionsResponse, AppConnectionsServiceClient.ListAppConnectionsPagedResponse> LIST_APP_CONNECTIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListAppConnectionsRequest, ListAppConnectionsResponse, AppConnectionsServiceClient.ListAppConnectionsPagedResponse>(){

        public ApiFuture<AppConnectionsServiceClient.ListAppConnectionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListAppConnectionsRequest, ListAppConnectionsResponse> callable, ListAppConnectionsRequest request, ApiCallContext context, ApiFuture<ListAppConnectionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_APP_CONNECTIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AppConnectionsServiceClient.ListAppConnectionsPagedResponse.createAsync((PageContext<ListAppConnectionsRequest, ListAppConnectionsResponse, AppConnection>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ResolveAppConnectionsRequest, ResolveAppConnectionsResponse, AppConnectionsServiceClient.ResolveAppConnectionsPagedResponse> RESOLVE_APP_CONNECTIONS_PAGE_STR_FACT = new PagedListResponseFactory<ResolveAppConnectionsRequest, ResolveAppConnectionsResponse, AppConnectionsServiceClient.ResolveAppConnectionsPagedResponse>(){

        public ApiFuture<AppConnectionsServiceClient.ResolveAppConnectionsPagedResponse> getFuturePagedResponse(UnaryCallable<ResolveAppConnectionsRequest, ResolveAppConnectionsResponse> callable, ResolveAppConnectionsRequest request, ApiCallContext context, ApiFuture<ResolveAppConnectionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)RESOLVE_APP_CONNECTIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AppConnectionsServiceClient.ResolveAppConnectionsPagedResponse.createAsync((PageContext<ResolveAppConnectionsRequest, ResolveAppConnectionsResponse, ResolveAppConnectionsResponse.AppConnectionDetails>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, AppConnectionsServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, AppConnectionsServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<AppConnectionsServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AppConnectionsServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListAppConnectionsRequest, ListAppConnectionsResponse, AppConnectionsServiceClient.ListAppConnectionsPagedResponse> listAppConnectionsSettings() {
        return this.listAppConnectionsSettings;
    }

    public UnaryCallSettings<GetAppConnectionRequest, AppConnection> getAppConnectionSettings() {
        return this.getAppConnectionSettings;
    }

    public UnaryCallSettings<CreateAppConnectionRequest, Operation> createAppConnectionSettings() {
        return this.createAppConnectionSettings;
    }

    public OperationCallSettings<CreateAppConnectionRequest, AppConnection, AppConnectionOperationMetadata> createAppConnectionOperationSettings() {
        return this.createAppConnectionOperationSettings;
    }

    public UnaryCallSettings<UpdateAppConnectionRequest, Operation> updateAppConnectionSettings() {
        return this.updateAppConnectionSettings;
    }

    public OperationCallSettings<UpdateAppConnectionRequest, AppConnection, AppConnectionOperationMetadata> updateAppConnectionOperationSettings() {
        return this.updateAppConnectionOperationSettings;
    }

    public UnaryCallSettings<DeleteAppConnectionRequest, Operation> deleteAppConnectionSettings() {
        return this.deleteAppConnectionSettings;
    }

    public OperationCallSettings<DeleteAppConnectionRequest, Empty, AppConnectionOperationMetadata> deleteAppConnectionOperationSettings() {
        return this.deleteAppConnectionOperationSettings;
    }

    public PagedCallSettings<ResolveAppConnectionsRequest, ResolveAppConnectionsResponse, AppConnectionsServiceClient.ResolveAppConnectionsPagedResponse> resolveAppConnectionsSettings() {
        return this.resolveAppConnectionsSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, AppConnectionsServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public AppConnectionsServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAppConnectionsServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "beyondcorp";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "beyondcorp.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "beyondcorp.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AppConnectionsServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AppConnectionsServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AppConnectionsServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listAppConnectionsSettings = settingsBuilder.listAppConnectionsSettings().build();
        this.getAppConnectionSettings = settingsBuilder.getAppConnectionSettings().build();
        this.createAppConnectionSettings = settingsBuilder.createAppConnectionSettings().build();
        this.createAppConnectionOperationSettings = settingsBuilder.createAppConnectionOperationSettings().build();
        this.updateAppConnectionSettings = settingsBuilder.updateAppConnectionSettings().build();
        this.updateAppConnectionOperationSettings = settingsBuilder.updateAppConnectionOperationSettings().build();
        this.deleteAppConnectionSettings = settingsBuilder.deleteAppConnectionSettings().build();
        this.deleteAppConnectionOperationSettings = settingsBuilder.deleteAppConnectionOperationSettings().build();
        this.resolveAppConnectionsSettings = settingsBuilder.resolveAppConnectionsSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AppConnectionsServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListAppConnectionsRequest, ListAppConnectionsResponse, AppConnectionsServiceClient.ListAppConnectionsPagedResponse> listAppConnectionsSettings;
        private final UnaryCallSettings.Builder<GetAppConnectionRequest, AppConnection> getAppConnectionSettings;
        private final UnaryCallSettings.Builder<CreateAppConnectionRequest, Operation> createAppConnectionSettings;
        private final OperationCallSettings.Builder<CreateAppConnectionRequest, AppConnection, AppConnectionOperationMetadata> createAppConnectionOperationSettings;
        private final UnaryCallSettings.Builder<UpdateAppConnectionRequest, Operation> updateAppConnectionSettings;
        private final OperationCallSettings.Builder<UpdateAppConnectionRequest, AppConnection, AppConnectionOperationMetadata> updateAppConnectionOperationSettings;
        private final UnaryCallSettings.Builder<DeleteAppConnectionRequest, Operation> deleteAppConnectionSettings;
        private final OperationCallSettings.Builder<DeleteAppConnectionRequest, Empty, AppConnectionOperationMetadata> deleteAppConnectionOperationSettings;
        private final PagedCallSettings.Builder<ResolveAppConnectionsRequest, ResolveAppConnectionsResponse, AppConnectionsServiceClient.ResolveAppConnectionsPagedResponse> resolveAppConnectionsSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, AppConnectionsServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listAppConnectionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_APP_CONNECTIONS_PAGE_STR_FACT);
            this.getAppConnectionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAppConnectionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAppConnectionOperationSettings = OperationCallSettings.newBuilder();
            this.updateAppConnectionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAppConnectionOperationSettings = OperationCallSettings.newBuilder();
            this.deleteAppConnectionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteAppConnectionOperationSettings = OperationCallSettings.newBuilder();
            this.resolveAppConnectionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)RESOLVE_APP_CONNECTIONS_PAGE_STR_FACT);
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listAppConnectionsSettings, this.getAppConnectionSettings, this.createAppConnectionSettings, this.updateAppConnectionSettings, this.deleteAppConnectionSettings, this.resolveAppConnectionsSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(AppConnectionsServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listAppConnectionsSettings = settings.listAppConnectionsSettings.toBuilder();
            this.getAppConnectionSettings = settings.getAppConnectionSettings.toBuilder();
            this.createAppConnectionSettings = settings.createAppConnectionSettings.toBuilder();
            this.createAppConnectionOperationSettings = settings.createAppConnectionOperationSettings.toBuilder();
            this.updateAppConnectionSettings = settings.updateAppConnectionSettings.toBuilder();
            this.updateAppConnectionOperationSettings = settings.updateAppConnectionOperationSettings.toBuilder();
            this.deleteAppConnectionSettings = settings.deleteAppConnectionSettings.toBuilder();
            this.deleteAppConnectionOperationSettings = settings.deleteAppConnectionOperationSettings.toBuilder();
            this.resolveAppConnectionsSettings = settings.resolveAppConnectionsSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listAppConnectionsSettings, this.getAppConnectionSettings, this.createAppConnectionSettings, this.updateAppConnectionSettings, this.deleteAppConnectionSettings, this.resolveAppConnectionsSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AppConnectionsServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AppConnectionsServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AppConnectionsServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AppConnectionsServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listAppConnectionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getAppConnectionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createAppConnectionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateAppConnectionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteAppConnectionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.resolveAppConnectionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createAppConnectionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AppConnection.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(AppConnectionOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateAppConnectionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AppConnection.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(AppConnectionOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteAppConnectionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(AppConnectionOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListAppConnectionsRequest, ListAppConnectionsResponse, AppConnectionsServiceClient.ListAppConnectionsPagedResponse> listAppConnectionsSettings() {
            return this.listAppConnectionsSettings;
        }

        public UnaryCallSettings.Builder<GetAppConnectionRequest, AppConnection> getAppConnectionSettings() {
            return this.getAppConnectionSettings;
        }

        public UnaryCallSettings.Builder<CreateAppConnectionRequest, Operation> createAppConnectionSettings() {
            return this.createAppConnectionSettings;
        }

        public OperationCallSettings.Builder<CreateAppConnectionRequest, AppConnection, AppConnectionOperationMetadata> createAppConnectionOperationSettings() {
            return this.createAppConnectionOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateAppConnectionRequest, Operation> updateAppConnectionSettings() {
            return this.updateAppConnectionSettings;
        }

        public OperationCallSettings.Builder<UpdateAppConnectionRequest, AppConnection, AppConnectionOperationMetadata> updateAppConnectionOperationSettings() {
            return this.updateAppConnectionOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteAppConnectionRequest, Operation> deleteAppConnectionSettings() {
            return this.deleteAppConnectionSettings;
        }

        public OperationCallSettings.Builder<DeleteAppConnectionRequest, Empty, AppConnectionOperationMetadata> deleteAppConnectionOperationSettings() {
            return this.deleteAppConnectionOperationSettings;
        }

        public PagedCallSettings.Builder<ResolveAppConnectionsRequest, ResolveAppConnectionsResponse, AppConnectionsServiceClient.ResolveAppConnectionsPagedResponse> resolveAppConnectionsSettings() {
            return this.resolveAppConnectionsSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, AppConnectionsServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public AppConnectionsServiceStubSettings build() throws IOException {
            return new AppConnectionsServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

