/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.batch.v1alpha.stub;

import com.google.api.HttpRule;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.batch.v1alpha.BatchServiceClient;
import com.google.cloud.batch.v1alpha.CreateJobRequest;
import com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest;
import com.google.cloud.batch.v1alpha.DeleteJobRequest;
import com.google.cloud.batch.v1alpha.DeleteResourceAllowanceRequest;
import com.google.cloud.batch.v1alpha.GetJobRequest;
import com.google.cloud.batch.v1alpha.GetResourceAllowanceRequest;
import com.google.cloud.batch.v1alpha.GetTaskRequest;
import com.google.cloud.batch.v1alpha.Job;
import com.google.cloud.batch.v1alpha.ListJobsRequest;
import com.google.cloud.batch.v1alpha.ListJobsResponse;
import com.google.cloud.batch.v1alpha.ListResourceAllowancesRequest;
import com.google.cloud.batch.v1alpha.ListResourceAllowancesResponse;
import com.google.cloud.batch.v1alpha.ListTasksRequest;
import com.google.cloud.batch.v1alpha.ListTasksResponse;
import com.google.cloud.batch.v1alpha.OperationMetadata;
import com.google.cloud.batch.v1alpha.ResourceAllowance;
import com.google.cloud.batch.v1alpha.Task;
import com.google.cloud.batch.v1alpha.UpdateResourceAllowanceRequest;
import com.google.cloud.batch.v1alpha.stub.BatchServiceStub;
import com.google.cloud.batch.v1alpha.stub.BatchServiceStubSettings;
import com.google.cloud.batch.v1alpha.stub.HttpJsonBatchServiceCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonBatchServiceStub
extends BatchServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Empty.getDescriptor()).add(OperationMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<CreateJobRequest, Job> createJobMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.batch.v1alpha.BatchService/CreateJob").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1alpha/{parent=projects/*/locations/*}/jobs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "jobId", (Object)request.getJobId());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("job", (Message)request.getJob(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Job.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetJobRequest, Job> getJobMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.batch.v1alpha.BatchService/GetJob").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1alpha/{name=projects/*/locations/*/jobs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Job.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteJobRequest, Operation> deleteJobMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.batch.v1alpha.BatchService/DeleteJob").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1alpha/{name=projects/*/locations/*/jobs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "reason", (Object)request.getReason());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ListJobsRequest, ListJobsResponse> listJobsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.batch.v1alpha.BatchService/ListJobs").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1alpha/{parent=projects/*/locations/*}/jobs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListJobsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetTaskRequest, Task> getTaskMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.batch.v1alpha.BatchService/GetTask").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1alpha/{name=projects/*/locations/*/jobs/*/taskGroups/*/tasks/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Task.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListTasksRequest, ListTasksResponse> listTasksMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.batch.v1alpha.BatchService/ListTasks").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1alpha/{parent=projects/*/locations/*/jobs/*/taskGroups/*}/tasks", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListTasksResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateResourceAllowanceRequest, ResourceAllowance> createResourceAllowanceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.batch.v1alpha.BatchService/CreateResourceAllowance").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1alpha/{parent=projects/*/locations/*}/resourceAllowances", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "resourceAllowanceId", (Object)request.getResourceAllowanceId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("resourceAllowance", (Message)request.getResourceAllowance(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ResourceAllowance.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetResourceAllowanceRequest, ResourceAllowance> getResourceAllowanceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.batch.v1alpha.BatchService/GetResourceAllowance").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1alpha/{name=projects/*/locations/*/resourceAllowances/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ResourceAllowance.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteResourceAllowanceRequest, Operation> deleteResourceAllowanceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.batch.v1alpha.BatchService/DeleteResourceAllowance").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1alpha/{name=projects/*/locations/*/resourceAllowances/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "reason", (Object)request.getReason());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ListResourceAllowancesRequest, ListResourceAllowancesResponse> listResourceAllowancesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.batch.v1alpha.BatchService/ListResourceAllowances").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1alpha/{parent=projects/*/locations/*}/resourceAllowances", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListResourceAllowancesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateResourceAllowanceRequest, ResourceAllowance> updateResourceAllowanceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.batch.v1alpha.BatchService/UpdateResourceAllowance").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1alpha/{resourceAllowance.name=projects/*/locations/*/resourceAllowances/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resourceAllowance.name", (Object)request.getResourceAllowance().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("resourceAllowance", (Message)request.getResourceAllowance(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ResourceAllowance.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/ListLocations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1alpha/{name=projects/*}/locations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListLocationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/GetLocation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1alpha/{name=projects/*/locations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Location.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateJobRequest, Job> createJobCallable;
    private final UnaryCallable<GetJobRequest, Job> getJobCallable;
    private final UnaryCallable<DeleteJobRequest, Operation> deleteJobCallable;
    private final OperationCallable<DeleteJobRequest, Empty, OperationMetadata> deleteJobOperationCallable;
    private final UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable;
    private final UnaryCallable<ListJobsRequest, BatchServiceClient.ListJobsPagedResponse> listJobsPagedCallable;
    private final UnaryCallable<GetTaskRequest, Task> getTaskCallable;
    private final UnaryCallable<ListTasksRequest, ListTasksResponse> listTasksCallable;
    private final UnaryCallable<ListTasksRequest, BatchServiceClient.ListTasksPagedResponse> listTasksPagedCallable;
    private final UnaryCallable<CreateResourceAllowanceRequest, ResourceAllowance> createResourceAllowanceCallable;
    private final UnaryCallable<GetResourceAllowanceRequest, ResourceAllowance> getResourceAllowanceCallable;
    private final UnaryCallable<DeleteResourceAllowanceRequest, Operation> deleteResourceAllowanceCallable;
    private final OperationCallable<DeleteResourceAllowanceRequest, Empty, OperationMetadata> deleteResourceAllowanceOperationCallable;
    private final UnaryCallable<ListResourceAllowancesRequest, ListResourceAllowancesResponse> listResourceAllowancesCallable;
    private final UnaryCallable<ListResourceAllowancesRequest, BatchServiceClient.ListResourceAllowancesPagedResponse> listResourceAllowancesPagedCallable;
    private final UnaryCallable<UpdateResourceAllowanceRequest, ResourceAllowance> updateResourceAllowanceCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, BatchServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonBatchServiceStub create(BatchServiceStubSettings settings) throws IOException {
        return new HttpJsonBatchServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonBatchServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonBatchServiceStub(BatchServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonBatchServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonBatchServiceStub(BatchServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonBatchServiceStub(BatchServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonBatchServiceCallableFactory());
    }

    protected HttpJsonBatchServiceStub(BatchServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.CancelOperation", (Object)HttpRule.newBuilder().setPost("/v1alpha/{name=projects/*/locations/*/operations/*}:cancel").build()).put((Object)"google.longrunning.Operations.DeleteOperation", (Object)HttpRule.newBuilder().setDelete("/v1alpha/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*}/operations").build()).build());
        HttpJsonCallSettings createJobTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createJobMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getJobTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getJobMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteJobTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteJobMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listJobsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listJobsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getTaskTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getTaskMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listTasksTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listTasksMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createResourceAllowanceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createResourceAllowanceMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getResourceAllowanceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getResourceAllowanceMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteResourceAllowanceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteResourceAllowanceMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listResourceAllowancesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listResourceAllowancesMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateResourceAllowanceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateResourceAllowanceMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource_allowance.name", String.valueOf(request.getResourceAllowance().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listLocationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getLocationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.createJobCallable = callableFactory.createUnaryCallable(createJobTransportSettings, settings.createJobSettings(), clientContext);
        this.getJobCallable = callableFactory.createUnaryCallable(getJobTransportSettings, settings.getJobSettings(), clientContext);
        this.deleteJobCallable = callableFactory.createUnaryCallable(deleteJobTransportSettings, settings.deleteJobSettings(), clientContext);
        this.deleteJobOperationCallable = callableFactory.createOperationCallable(deleteJobTransportSettings, settings.deleteJobOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listJobsCallable = callableFactory.createUnaryCallable(listJobsTransportSettings, settings.listJobsSettings(), clientContext);
        this.listJobsPagedCallable = callableFactory.createPagedCallable(listJobsTransportSettings, settings.listJobsSettings(), clientContext);
        this.getTaskCallable = callableFactory.createUnaryCallable(getTaskTransportSettings, settings.getTaskSettings(), clientContext);
        this.listTasksCallable = callableFactory.createUnaryCallable(listTasksTransportSettings, settings.listTasksSettings(), clientContext);
        this.listTasksPagedCallable = callableFactory.createPagedCallable(listTasksTransportSettings, settings.listTasksSettings(), clientContext);
        this.createResourceAllowanceCallable = callableFactory.createUnaryCallable(createResourceAllowanceTransportSettings, settings.createResourceAllowanceSettings(), clientContext);
        this.getResourceAllowanceCallable = callableFactory.createUnaryCallable(getResourceAllowanceTransportSettings, settings.getResourceAllowanceSettings(), clientContext);
        this.deleteResourceAllowanceCallable = callableFactory.createUnaryCallable(deleteResourceAllowanceTransportSettings, settings.deleteResourceAllowanceSettings(), clientContext);
        this.deleteResourceAllowanceOperationCallable = callableFactory.createOperationCallable(deleteResourceAllowanceTransportSettings, settings.deleteResourceAllowanceOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listResourceAllowancesCallable = callableFactory.createUnaryCallable(listResourceAllowancesTransportSettings, settings.listResourceAllowancesSettings(), clientContext);
        this.listResourceAllowancesPagedCallable = callableFactory.createPagedCallable(listResourceAllowancesTransportSettings, settings.listResourceAllowancesSettings(), clientContext);
        this.updateResourceAllowanceCallable = callableFactory.createUnaryCallable(updateResourceAllowanceTransportSettings, settings.updateResourceAllowanceSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createJobMethodDescriptor);
        methodDescriptors.add(getJobMethodDescriptor);
        methodDescriptors.add(deleteJobMethodDescriptor);
        methodDescriptors.add(listJobsMethodDescriptor);
        methodDescriptors.add(getTaskMethodDescriptor);
        methodDescriptors.add(listTasksMethodDescriptor);
        methodDescriptors.add(createResourceAllowanceMethodDescriptor);
        methodDescriptors.add(getResourceAllowanceMethodDescriptor);
        methodDescriptors.add(deleteResourceAllowanceMethodDescriptor);
        methodDescriptors.add(listResourceAllowancesMethodDescriptor);
        methodDescriptors.add(updateResourceAllowanceMethodDescriptor);
        methodDescriptors.add(listLocationsMethodDescriptor);
        methodDescriptors.add(getLocationMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<CreateJobRequest, Job> createJobCallable() {
        return this.createJobCallable;
    }

    @Override
    public UnaryCallable<GetJobRequest, Job> getJobCallable() {
        return this.getJobCallable;
    }

    @Override
    public UnaryCallable<DeleteJobRequest, Operation> deleteJobCallable() {
        return this.deleteJobCallable;
    }

    @Override
    public OperationCallable<DeleteJobRequest, Empty, OperationMetadata> deleteJobOperationCallable() {
        return this.deleteJobOperationCallable;
    }

    @Override
    public UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable() {
        return this.listJobsCallable;
    }

    @Override
    public UnaryCallable<ListJobsRequest, BatchServiceClient.ListJobsPagedResponse> listJobsPagedCallable() {
        return this.listJobsPagedCallable;
    }

    @Override
    public UnaryCallable<GetTaskRequest, Task> getTaskCallable() {
        return this.getTaskCallable;
    }

    @Override
    public UnaryCallable<ListTasksRequest, ListTasksResponse> listTasksCallable() {
        return this.listTasksCallable;
    }

    @Override
    public UnaryCallable<ListTasksRequest, BatchServiceClient.ListTasksPagedResponse> listTasksPagedCallable() {
        return this.listTasksPagedCallable;
    }

    @Override
    public UnaryCallable<CreateResourceAllowanceRequest, ResourceAllowance> createResourceAllowanceCallable() {
        return this.createResourceAllowanceCallable;
    }

    @Override
    public UnaryCallable<GetResourceAllowanceRequest, ResourceAllowance> getResourceAllowanceCallable() {
        return this.getResourceAllowanceCallable;
    }

    @Override
    public UnaryCallable<DeleteResourceAllowanceRequest, Operation> deleteResourceAllowanceCallable() {
        return this.deleteResourceAllowanceCallable;
    }

    @Override
    public OperationCallable<DeleteResourceAllowanceRequest, Empty, OperationMetadata> deleteResourceAllowanceOperationCallable() {
        return this.deleteResourceAllowanceOperationCallable;
    }

    @Override
    public UnaryCallable<ListResourceAllowancesRequest, ListResourceAllowancesResponse> listResourceAllowancesCallable() {
        return this.listResourceAllowancesCallable;
    }

    @Override
    public UnaryCallable<ListResourceAllowancesRequest, BatchServiceClient.ListResourceAllowancesPagedResponse> listResourceAllowancesPagedCallable() {
        return this.listResourceAllowancesPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateResourceAllowanceRequest, ResourceAllowance> updateResourceAllowanceCallable() {
        return this.updateResourceAllowanceCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, BatchServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

