/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.baremetalsolution.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.baremetalsolution.v2.BareMetalSolutionClient;
import com.google.cloud.baremetalsolution.v2.CreateSnapshotSchedulePolicyRequest;
import com.google.cloud.baremetalsolution.v2.CreateVolumeSnapshotRequest;
import com.google.cloud.baremetalsolution.v2.DeleteSnapshotSchedulePolicyRequest;
import com.google.cloud.baremetalsolution.v2.DeleteVolumeSnapshotRequest;
import com.google.cloud.baremetalsolution.v2.GetInstanceRequest;
import com.google.cloud.baremetalsolution.v2.GetLunRequest;
import com.google.cloud.baremetalsolution.v2.GetNetworkRequest;
import com.google.cloud.baremetalsolution.v2.GetSnapshotSchedulePolicyRequest;
import com.google.cloud.baremetalsolution.v2.GetVolumeRequest;
import com.google.cloud.baremetalsolution.v2.GetVolumeSnapshotRequest;
import com.google.cloud.baremetalsolution.v2.Instance;
import com.google.cloud.baremetalsolution.v2.ListInstancesRequest;
import com.google.cloud.baremetalsolution.v2.ListInstancesResponse;
import com.google.cloud.baremetalsolution.v2.ListLunsRequest;
import com.google.cloud.baremetalsolution.v2.ListLunsResponse;
import com.google.cloud.baremetalsolution.v2.ListNetworksRequest;
import com.google.cloud.baremetalsolution.v2.ListNetworksResponse;
import com.google.cloud.baremetalsolution.v2.ListSnapshotSchedulePoliciesRequest;
import com.google.cloud.baremetalsolution.v2.ListSnapshotSchedulePoliciesResponse;
import com.google.cloud.baremetalsolution.v2.ListVolumeSnapshotsRequest;
import com.google.cloud.baremetalsolution.v2.ListVolumeSnapshotsResponse;
import com.google.cloud.baremetalsolution.v2.ListVolumesRequest;
import com.google.cloud.baremetalsolution.v2.ListVolumesResponse;
import com.google.cloud.baremetalsolution.v2.Lun;
import com.google.cloud.baremetalsolution.v2.Network;
import com.google.cloud.baremetalsolution.v2.OperationMetadata;
import com.google.cloud.baremetalsolution.v2.ResetInstanceRequest;
import com.google.cloud.baremetalsolution.v2.ResetInstanceResponse;
import com.google.cloud.baremetalsolution.v2.RestoreVolumeSnapshotRequest;
import com.google.cloud.baremetalsolution.v2.SnapshotSchedulePolicy;
import com.google.cloud.baremetalsolution.v2.UpdateSnapshotSchedulePolicyRequest;
import com.google.cloud.baremetalsolution.v2.UpdateVolumeRequest;
import com.google.cloud.baremetalsolution.v2.Volume;
import com.google.cloud.baremetalsolution.v2.VolumeSnapshot;
import com.google.cloud.baremetalsolution.v2.stub.BareMetalSolutionStub;
import com.google.cloud.baremetalsolution.v2.stub.BareMetalSolutionStubSettings;
import com.google.cloud.baremetalsolution.v2.stub.GrpcBareMetalSolutionCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcBareMetalSolutionStub
extends BareMetalSolutionStub {
    private static final MethodDescriptor<ListInstancesRequest, ListInstancesResponse> listInstancesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/ListInstances").setRequestMarshaller(ProtoUtils.marshaller((Message)ListInstancesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListInstancesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetInstanceRequest, Instance> getInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/GetInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)GetInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Instance.getDefaultInstance())).build();
    private static final MethodDescriptor<ResetInstanceRequest, Operation> resetInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/ResetInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)ResetInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListVolumesRequest, ListVolumesResponse> listVolumesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/ListVolumes").setRequestMarshaller(ProtoUtils.marshaller((Message)ListVolumesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListVolumesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetVolumeRequest, Volume> getVolumeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/GetVolume").setRequestMarshaller(ProtoUtils.marshaller((Message)GetVolumeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Volume.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateVolumeRequest, Operation> updateVolumeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/UpdateVolume").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateVolumeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListNetworksRequest, ListNetworksResponse> listNetworksMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/ListNetworks").setRequestMarshaller(ProtoUtils.marshaller((Message)ListNetworksRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListNetworksResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetNetworkRequest, Network> getNetworkMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/GetNetwork").setRequestMarshaller(ProtoUtils.marshaller((Message)GetNetworkRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Network.getDefaultInstance())).build();
    private static final MethodDescriptor<ListSnapshotSchedulePoliciesRequest, ListSnapshotSchedulePoliciesResponse> listSnapshotSchedulePoliciesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/ListSnapshotSchedulePolicies").setRequestMarshaller(ProtoUtils.marshaller((Message)ListSnapshotSchedulePoliciesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListSnapshotSchedulePoliciesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetSnapshotSchedulePolicyRequest, SnapshotSchedulePolicy> getSnapshotSchedulePolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/GetSnapshotSchedulePolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetSnapshotSchedulePolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SnapshotSchedulePolicy.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateSnapshotSchedulePolicyRequest, SnapshotSchedulePolicy> createSnapshotSchedulePolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/CreateSnapshotSchedulePolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateSnapshotSchedulePolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SnapshotSchedulePolicy.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateSnapshotSchedulePolicyRequest, SnapshotSchedulePolicy> updateSnapshotSchedulePolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/UpdateSnapshotSchedulePolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateSnapshotSchedulePolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SnapshotSchedulePolicy.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteSnapshotSchedulePolicyRequest, Empty> deleteSnapshotSchedulePolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/DeleteSnapshotSchedulePolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteSnapshotSchedulePolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateVolumeSnapshotRequest, VolumeSnapshot> createVolumeSnapshotMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/CreateVolumeSnapshot").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateVolumeSnapshotRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)VolumeSnapshot.getDefaultInstance())).build();
    private static final MethodDescriptor<RestoreVolumeSnapshotRequest, Operation> restoreVolumeSnapshotMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/RestoreVolumeSnapshot").setRequestMarshaller(ProtoUtils.marshaller((Message)RestoreVolumeSnapshotRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteVolumeSnapshotRequest, Empty> deleteVolumeSnapshotMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/DeleteVolumeSnapshot").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteVolumeSnapshotRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<GetVolumeSnapshotRequest, VolumeSnapshot> getVolumeSnapshotMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/GetVolumeSnapshot").setRequestMarshaller(ProtoUtils.marshaller((Message)GetVolumeSnapshotRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)VolumeSnapshot.getDefaultInstance())).build();
    private static final MethodDescriptor<ListVolumeSnapshotsRequest, ListVolumeSnapshotsResponse> listVolumeSnapshotsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/ListVolumeSnapshots").setRequestMarshaller(ProtoUtils.marshaller((Message)ListVolumeSnapshotsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListVolumeSnapshotsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLunRequest, Lun> getLunMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/GetLun").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLunRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Lun.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLunsRequest, ListLunsResponse> listLunsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.baremetalsolution.v2.BareMetalSolution/ListLuns").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLunsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLunsResponse.getDefaultInstance())).build();
    private final UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable;
    private final UnaryCallable<ListInstancesRequest, BareMetalSolutionClient.ListInstancesPagedResponse> listInstancesPagedCallable;
    private final UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable;
    private final UnaryCallable<ResetInstanceRequest, Operation> resetInstanceCallable;
    private final OperationCallable<ResetInstanceRequest, ResetInstanceResponse, OperationMetadata> resetInstanceOperationCallable;
    private final UnaryCallable<ListVolumesRequest, ListVolumesResponse> listVolumesCallable;
    private final UnaryCallable<ListVolumesRequest, BareMetalSolutionClient.ListVolumesPagedResponse> listVolumesPagedCallable;
    private final UnaryCallable<GetVolumeRequest, Volume> getVolumeCallable;
    private final UnaryCallable<UpdateVolumeRequest, Operation> updateVolumeCallable;
    private final OperationCallable<UpdateVolumeRequest, Volume, OperationMetadata> updateVolumeOperationCallable;
    private final UnaryCallable<ListNetworksRequest, ListNetworksResponse> listNetworksCallable;
    private final UnaryCallable<ListNetworksRequest, BareMetalSolutionClient.ListNetworksPagedResponse> listNetworksPagedCallable;
    private final UnaryCallable<GetNetworkRequest, Network> getNetworkCallable;
    private final UnaryCallable<ListSnapshotSchedulePoliciesRequest, ListSnapshotSchedulePoliciesResponse> listSnapshotSchedulePoliciesCallable;
    private final UnaryCallable<ListSnapshotSchedulePoliciesRequest, BareMetalSolutionClient.ListSnapshotSchedulePoliciesPagedResponse> listSnapshotSchedulePoliciesPagedCallable;
    private final UnaryCallable<GetSnapshotSchedulePolicyRequest, SnapshotSchedulePolicy> getSnapshotSchedulePolicyCallable;
    private final UnaryCallable<CreateSnapshotSchedulePolicyRequest, SnapshotSchedulePolicy> createSnapshotSchedulePolicyCallable;
    private final UnaryCallable<UpdateSnapshotSchedulePolicyRequest, SnapshotSchedulePolicy> updateSnapshotSchedulePolicyCallable;
    private final UnaryCallable<DeleteSnapshotSchedulePolicyRequest, Empty> deleteSnapshotSchedulePolicyCallable;
    private final UnaryCallable<CreateVolumeSnapshotRequest, VolumeSnapshot> createVolumeSnapshotCallable;
    private final UnaryCallable<RestoreVolumeSnapshotRequest, Operation> restoreVolumeSnapshotCallable;
    private final OperationCallable<RestoreVolumeSnapshotRequest, VolumeSnapshot, OperationMetadata> restoreVolumeSnapshotOperationCallable;
    private final UnaryCallable<DeleteVolumeSnapshotRequest, Empty> deleteVolumeSnapshotCallable;
    private final UnaryCallable<GetVolumeSnapshotRequest, VolumeSnapshot> getVolumeSnapshotCallable;
    private final UnaryCallable<ListVolumeSnapshotsRequest, ListVolumeSnapshotsResponse> listVolumeSnapshotsCallable;
    private final UnaryCallable<ListVolumeSnapshotsRequest, BareMetalSolutionClient.ListVolumeSnapshotsPagedResponse> listVolumeSnapshotsPagedCallable;
    private final UnaryCallable<GetLunRequest, Lun> getLunCallable;
    private final UnaryCallable<ListLunsRequest, ListLunsResponse> listLunsCallable;
    private final UnaryCallable<ListLunsRequest, BareMetalSolutionClient.ListLunsPagedResponse> listLunsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcBareMetalSolutionStub create(BareMetalSolutionStubSettings settings) throws IOException {
        return new GrpcBareMetalSolutionStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcBareMetalSolutionStub create(ClientContext clientContext) throws IOException {
        return new GrpcBareMetalSolutionStub(BareMetalSolutionStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcBareMetalSolutionStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcBareMetalSolutionStub(BareMetalSolutionStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcBareMetalSolutionStub(BareMetalSolutionStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcBareMetalSolutionCallableFactory());
    }

    protected GrpcBareMetalSolutionStub(BareMetalSolutionStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listInstancesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listInstancesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getInstanceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings resetInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(resetInstanceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listVolumesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listVolumesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getVolumeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getVolumeMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings updateVolumeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateVolumeMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"volume.name", (Object)String.valueOf(request.getVolume().getName()));
            return params.build();
        }).build();
        GrpcCallSettings listNetworksTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listNetworksMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getNetworkTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getNetworkMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listSnapshotSchedulePoliciesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listSnapshotSchedulePoliciesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getSnapshotSchedulePolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getSnapshotSchedulePolicyMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings createSnapshotSchedulePolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createSnapshotSchedulePolicyMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings updateSnapshotSchedulePolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateSnapshotSchedulePolicyMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"snapshot_schedule_policy.name", (Object)String.valueOf(request.getSnapshotSchedulePolicy().getName()));
            return params.build();
        }).build();
        GrpcCallSettings deleteSnapshotSchedulePolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteSnapshotSchedulePolicyMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings createVolumeSnapshotTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createVolumeSnapshotMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings restoreVolumeSnapshotTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(restoreVolumeSnapshotMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"volume_snapshot", (Object)String.valueOf(request.getVolumeSnapshot()));
            return params.build();
        }).build();
        GrpcCallSettings deleteVolumeSnapshotTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteVolumeSnapshotMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings getVolumeSnapshotTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getVolumeSnapshotMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listVolumeSnapshotsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listVolumeSnapshotsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getLunTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLunMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listLunsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLunsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        this.listInstancesCallable = callableFactory.createUnaryCallable(listInstancesTransportSettings, settings.listInstancesSettings(), clientContext);
        this.listInstancesPagedCallable = callableFactory.createPagedCallable(listInstancesTransportSettings, settings.listInstancesSettings(), clientContext);
        this.getInstanceCallable = callableFactory.createUnaryCallable(getInstanceTransportSettings, settings.getInstanceSettings(), clientContext);
        this.resetInstanceCallable = callableFactory.createUnaryCallable(resetInstanceTransportSettings, settings.resetInstanceSettings(), clientContext);
        this.resetInstanceOperationCallable = callableFactory.createOperationCallable(resetInstanceTransportSettings, settings.resetInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listVolumesCallable = callableFactory.createUnaryCallable(listVolumesTransportSettings, settings.listVolumesSettings(), clientContext);
        this.listVolumesPagedCallable = callableFactory.createPagedCallable(listVolumesTransportSettings, settings.listVolumesSettings(), clientContext);
        this.getVolumeCallable = callableFactory.createUnaryCallable(getVolumeTransportSettings, settings.getVolumeSettings(), clientContext);
        this.updateVolumeCallable = callableFactory.createUnaryCallable(updateVolumeTransportSettings, settings.updateVolumeSettings(), clientContext);
        this.updateVolumeOperationCallable = callableFactory.createOperationCallable(updateVolumeTransportSettings, settings.updateVolumeOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listNetworksCallable = callableFactory.createUnaryCallable(listNetworksTransportSettings, settings.listNetworksSettings(), clientContext);
        this.listNetworksPagedCallable = callableFactory.createPagedCallable(listNetworksTransportSettings, settings.listNetworksSettings(), clientContext);
        this.getNetworkCallable = callableFactory.createUnaryCallable(getNetworkTransportSettings, settings.getNetworkSettings(), clientContext);
        this.listSnapshotSchedulePoliciesCallable = callableFactory.createUnaryCallable(listSnapshotSchedulePoliciesTransportSettings, settings.listSnapshotSchedulePoliciesSettings(), clientContext);
        this.listSnapshotSchedulePoliciesPagedCallable = callableFactory.createPagedCallable(listSnapshotSchedulePoliciesTransportSettings, settings.listSnapshotSchedulePoliciesSettings(), clientContext);
        this.getSnapshotSchedulePolicyCallable = callableFactory.createUnaryCallable(getSnapshotSchedulePolicyTransportSettings, settings.getSnapshotSchedulePolicySettings(), clientContext);
        this.createSnapshotSchedulePolicyCallable = callableFactory.createUnaryCallable(createSnapshotSchedulePolicyTransportSettings, settings.createSnapshotSchedulePolicySettings(), clientContext);
        this.updateSnapshotSchedulePolicyCallable = callableFactory.createUnaryCallable(updateSnapshotSchedulePolicyTransportSettings, settings.updateSnapshotSchedulePolicySettings(), clientContext);
        this.deleteSnapshotSchedulePolicyCallable = callableFactory.createUnaryCallable(deleteSnapshotSchedulePolicyTransportSettings, settings.deleteSnapshotSchedulePolicySettings(), clientContext);
        this.createVolumeSnapshotCallable = callableFactory.createUnaryCallable(createVolumeSnapshotTransportSettings, settings.createVolumeSnapshotSettings(), clientContext);
        this.restoreVolumeSnapshotCallable = callableFactory.createUnaryCallable(restoreVolumeSnapshotTransportSettings, settings.restoreVolumeSnapshotSettings(), clientContext);
        this.restoreVolumeSnapshotOperationCallable = callableFactory.createOperationCallable(restoreVolumeSnapshotTransportSettings, settings.restoreVolumeSnapshotOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteVolumeSnapshotCallable = callableFactory.createUnaryCallable(deleteVolumeSnapshotTransportSettings, settings.deleteVolumeSnapshotSettings(), clientContext);
        this.getVolumeSnapshotCallable = callableFactory.createUnaryCallable(getVolumeSnapshotTransportSettings, settings.getVolumeSnapshotSettings(), clientContext);
        this.listVolumeSnapshotsCallable = callableFactory.createUnaryCallable(listVolumeSnapshotsTransportSettings, settings.listVolumeSnapshotsSettings(), clientContext);
        this.listVolumeSnapshotsPagedCallable = callableFactory.createPagedCallable(listVolumeSnapshotsTransportSettings, settings.listVolumeSnapshotsSettings(), clientContext);
        this.getLunCallable = callableFactory.createUnaryCallable(getLunTransportSettings, settings.getLunSettings(), clientContext);
        this.listLunsCallable = callableFactory.createUnaryCallable(listLunsTransportSettings, settings.listLunsSettings(), clientContext);
        this.listLunsPagedCallable = callableFactory.createPagedCallable(listLunsTransportSettings, settings.listLunsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable() {
        return this.listInstancesCallable;
    }

    @Override
    public UnaryCallable<ListInstancesRequest, BareMetalSolutionClient.ListInstancesPagedResponse> listInstancesPagedCallable() {
        return this.listInstancesPagedCallable;
    }

    @Override
    public UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable() {
        return this.getInstanceCallable;
    }

    @Override
    public UnaryCallable<ResetInstanceRequest, Operation> resetInstanceCallable() {
        return this.resetInstanceCallable;
    }

    @Override
    public OperationCallable<ResetInstanceRequest, ResetInstanceResponse, OperationMetadata> resetInstanceOperationCallable() {
        return this.resetInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<ListVolumesRequest, ListVolumesResponse> listVolumesCallable() {
        return this.listVolumesCallable;
    }

    @Override
    public UnaryCallable<ListVolumesRequest, BareMetalSolutionClient.ListVolumesPagedResponse> listVolumesPagedCallable() {
        return this.listVolumesPagedCallable;
    }

    @Override
    public UnaryCallable<GetVolumeRequest, Volume> getVolumeCallable() {
        return this.getVolumeCallable;
    }

    @Override
    public UnaryCallable<UpdateVolumeRequest, Operation> updateVolumeCallable() {
        return this.updateVolumeCallable;
    }

    @Override
    public OperationCallable<UpdateVolumeRequest, Volume, OperationMetadata> updateVolumeOperationCallable() {
        return this.updateVolumeOperationCallable;
    }

    @Override
    public UnaryCallable<ListNetworksRequest, ListNetworksResponse> listNetworksCallable() {
        return this.listNetworksCallable;
    }

    @Override
    public UnaryCallable<ListNetworksRequest, BareMetalSolutionClient.ListNetworksPagedResponse> listNetworksPagedCallable() {
        return this.listNetworksPagedCallable;
    }

    @Override
    public UnaryCallable<GetNetworkRequest, Network> getNetworkCallable() {
        return this.getNetworkCallable;
    }

    @Override
    public UnaryCallable<ListSnapshotSchedulePoliciesRequest, ListSnapshotSchedulePoliciesResponse> listSnapshotSchedulePoliciesCallable() {
        return this.listSnapshotSchedulePoliciesCallable;
    }

    @Override
    public UnaryCallable<ListSnapshotSchedulePoliciesRequest, BareMetalSolutionClient.ListSnapshotSchedulePoliciesPagedResponse> listSnapshotSchedulePoliciesPagedCallable() {
        return this.listSnapshotSchedulePoliciesPagedCallable;
    }

    @Override
    public UnaryCallable<GetSnapshotSchedulePolicyRequest, SnapshotSchedulePolicy> getSnapshotSchedulePolicyCallable() {
        return this.getSnapshotSchedulePolicyCallable;
    }

    @Override
    public UnaryCallable<CreateSnapshotSchedulePolicyRequest, SnapshotSchedulePolicy> createSnapshotSchedulePolicyCallable() {
        return this.createSnapshotSchedulePolicyCallable;
    }

    @Override
    public UnaryCallable<UpdateSnapshotSchedulePolicyRequest, SnapshotSchedulePolicy> updateSnapshotSchedulePolicyCallable() {
        return this.updateSnapshotSchedulePolicyCallable;
    }

    @Override
    public UnaryCallable<DeleteSnapshotSchedulePolicyRequest, Empty> deleteSnapshotSchedulePolicyCallable() {
        return this.deleteSnapshotSchedulePolicyCallable;
    }

    @Override
    public UnaryCallable<CreateVolumeSnapshotRequest, VolumeSnapshot> createVolumeSnapshotCallable() {
        return this.createVolumeSnapshotCallable;
    }

    @Override
    public UnaryCallable<RestoreVolumeSnapshotRequest, Operation> restoreVolumeSnapshotCallable() {
        return this.restoreVolumeSnapshotCallable;
    }

    @Override
    public OperationCallable<RestoreVolumeSnapshotRequest, VolumeSnapshot, OperationMetadata> restoreVolumeSnapshotOperationCallable() {
        return this.restoreVolumeSnapshotOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteVolumeSnapshotRequest, Empty> deleteVolumeSnapshotCallable() {
        return this.deleteVolumeSnapshotCallable;
    }

    @Override
    public UnaryCallable<GetVolumeSnapshotRequest, VolumeSnapshot> getVolumeSnapshotCallable() {
        return this.getVolumeSnapshotCallable;
    }

    @Override
    public UnaryCallable<ListVolumeSnapshotsRequest, ListVolumeSnapshotsResponse> listVolumeSnapshotsCallable() {
        return this.listVolumeSnapshotsCallable;
    }

    @Override
    public UnaryCallable<ListVolumeSnapshotsRequest, BareMetalSolutionClient.ListVolumeSnapshotsPagedResponse> listVolumeSnapshotsPagedCallable() {
        return this.listVolumeSnapshotsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLunRequest, Lun> getLunCallable() {
        return this.getLunCallable;
    }

    @Override
    public UnaryCallable<ListLunsRequest, ListLunsResponse> listLunsCallable() {
        return this.listLunsCallable;
    }

    @Override
    public UnaryCallable<ListLunsRequest, BareMetalSolutionClient.ListLunsPagedResponse> listLunsPagedCallable() {
        return this.listLunsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

