/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.asset.v1p2beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.asset.v1p2beta1.CreateFeedRequest;
import com.google.cloud.asset.v1p2beta1.DeleteFeedRequest;
import com.google.cloud.asset.v1p2beta1.Feed;
import com.google.cloud.asset.v1p2beta1.GetFeedRequest;
import com.google.cloud.asset.v1p2beta1.ListFeedsRequest;
import com.google.cloud.asset.v1p2beta1.ListFeedsResponse;
import com.google.cloud.asset.v1p2beta1.UpdateFeedRequest;
import com.google.cloud.asset.v1p2beta1.stub.AssetServiceStub;
import com.google.cloud.asset.v1p2beta1.stub.AssetServiceStubSettings;
import com.google.cloud.asset.v1p2beta1.stub.HttpJsonAssetServiceCallableFactory;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonAssetServiceStub
extends AssetServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<CreateFeedRequest, Feed> createFeedMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.asset.v1p2beta1.AssetService/CreateFeed").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1p2beta1/{parent=*/*}/feeds", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Feed.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetFeedRequest, Feed> getFeedMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.asset.v1p2beta1.AssetService/GetFeed").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1p2beta1/{name=*/*/feeds/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Feed.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListFeedsRequest, ListFeedsResponse> listFeedsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.asset.v1p2beta1.AssetService/ListFeeds").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1p2beta1/{parent=*/*}/feeds", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListFeedsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateFeedRequest, Feed> updateFeedMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.asset.v1p2beta1.AssetService/UpdateFeed").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1p2beta1/{feed.name=*/*/feeds/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "feed.name", (Object)request.getFeed().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Feed.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteFeedRequest, Empty> deleteFeedMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.asset.v1p2beta1.AssetService/DeleteFeed").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1p2beta1/{name=*/*/feeds/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateFeedRequest, Feed> createFeedCallable;
    private final UnaryCallable<GetFeedRequest, Feed> getFeedCallable;
    private final UnaryCallable<ListFeedsRequest, ListFeedsResponse> listFeedsCallable;
    private final UnaryCallable<UpdateFeedRequest, Feed> updateFeedCallable;
    private final UnaryCallable<DeleteFeedRequest, Empty> deleteFeedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonAssetServiceStub create(AssetServiceStubSettings settings) throws IOException {
        return new HttpJsonAssetServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonAssetServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonAssetServiceStub(AssetServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonAssetServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonAssetServiceStub(AssetServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonAssetServiceStub(AssetServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonAssetServiceCallableFactory());
    }

    protected HttpJsonAssetServiceStub(AssetServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings createFeedTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createFeedMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getFeedTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getFeedMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listFeedsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listFeedsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateFeedTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateFeedMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("feed.name", String.valueOf(request.getFeed().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteFeedTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteFeedMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.createFeedCallable = callableFactory.createUnaryCallable(createFeedTransportSettings, settings.createFeedSettings(), clientContext);
        this.getFeedCallable = callableFactory.createUnaryCallable(getFeedTransportSettings, settings.getFeedSettings(), clientContext);
        this.listFeedsCallable = callableFactory.createUnaryCallable(listFeedsTransportSettings, settings.listFeedsSettings(), clientContext);
        this.updateFeedCallable = callableFactory.createUnaryCallable(updateFeedTransportSettings, settings.updateFeedSettings(), clientContext);
        this.deleteFeedCallable = callableFactory.createUnaryCallable(deleteFeedTransportSettings, settings.deleteFeedSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createFeedMethodDescriptor);
        methodDescriptors.add(getFeedMethodDescriptor);
        methodDescriptors.add(listFeedsMethodDescriptor);
        methodDescriptors.add(updateFeedMethodDescriptor);
        methodDescriptors.add(deleteFeedMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<CreateFeedRequest, Feed> createFeedCallable() {
        return this.createFeedCallable;
    }

    @Override
    public UnaryCallable<GetFeedRequest, Feed> getFeedCallable() {
        return this.getFeedCallable;
    }

    @Override
    public UnaryCallable<ListFeedsRequest, ListFeedsResponse> listFeedsCallable() {
        return this.listFeedsCallable;
    }

    @Override
    public UnaryCallable<UpdateFeedRequest, Feed> updateFeedCallable() {
        return this.updateFeedCallable;
    }

    @Override
    public UnaryCallable<DeleteFeedRequest, Empty> deleteFeedCallable() {
        return this.deleteFeedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

