/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.asset.v1p2beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.asset.v1p2beta1.CreateFeedRequest;
import com.google.cloud.asset.v1p2beta1.DeleteFeedRequest;
import com.google.cloud.asset.v1p2beta1.Feed;
import com.google.cloud.asset.v1p2beta1.GetFeedRequest;
import com.google.cloud.asset.v1p2beta1.ListFeedsRequest;
import com.google.cloud.asset.v1p2beta1.ListFeedsResponse;
import com.google.cloud.asset.v1p2beta1.UpdateFeedRequest;
import com.google.cloud.asset.v1p2beta1.stub.AssetServiceStub;
import com.google.cloud.asset.v1p2beta1.stub.AssetServiceStubSettings;
import com.google.cloud.asset.v1p2beta1.stub.GrpcAssetServiceCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcAssetServiceStub
extends AssetServiceStub {
    private static final MethodDescriptor<CreateFeedRequest, Feed> createFeedMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.asset.v1p2beta1.AssetService/CreateFeed").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateFeedRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Feed.getDefaultInstance())).build();
    private static final MethodDescriptor<GetFeedRequest, Feed> getFeedMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.asset.v1p2beta1.AssetService/GetFeed").setRequestMarshaller(ProtoUtils.marshaller((Message)GetFeedRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Feed.getDefaultInstance())).build();
    private static final MethodDescriptor<ListFeedsRequest, ListFeedsResponse> listFeedsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.asset.v1p2beta1.AssetService/ListFeeds").setRequestMarshaller(ProtoUtils.marshaller((Message)ListFeedsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListFeedsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateFeedRequest, Feed> updateFeedMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.asset.v1p2beta1.AssetService/UpdateFeed").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateFeedRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Feed.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteFeedRequest, Empty> deleteFeedMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.asset.v1p2beta1.AssetService/DeleteFeed").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteFeedRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private final UnaryCallable<CreateFeedRequest, Feed> createFeedCallable;
    private final UnaryCallable<GetFeedRequest, Feed> getFeedCallable;
    private final UnaryCallable<ListFeedsRequest, ListFeedsResponse> listFeedsCallable;
    private final UnaryCallable<UpdateFeedRequest, Feed> updateFeedCallable;
    private final UnaryCallable<DeleteFeedRequest, Empty> deleteFeedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcAssetServiceStub create(AssetServiceStubSettings settings) throws IOException {
        return new GrpcAssetServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcAssetServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcAssetServiceStub(AssetServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcAssetServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcAssetServiceStub(AssetServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcAssetServiceStub(AssetServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcAssetServiceCallableFactory());
    }

    protected GrpcAssetServiceStub(AssetServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createFeedTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createFeedMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CreateFeedRequest>(){

            public Map<String, String> extract(CreateFeedRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getFeedTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getFeedMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetFeedRequest>(){

            public Map<String, String> extract(GetFeedRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listFeedsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listFeedsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListFeedsRequest>(){

            public Map<String, String> extract(ListFeedsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings updateFeedTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateFeedMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<UpdateFeedRequest>(){

            public Map<String, String> extract(UpdateFeedRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"feed.name", (Object)String.valueOf(request.getFeed().getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deleteFeedTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteFeedMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteFeedRequest>(){

            public Map<String, String> extract(DeleteFeedRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        this.createFeedCallable = callableFactory.createUnaryCallable(createFeedTransportSettings, settings.createFeedSettings(), clientContext);
        this.getFeedCallable = callableFactory.createUnaryCallable(getFeedTransportSettings, settings.getFeedSettings(), clientContext);
        this.listFeedsCallable = callableFactory.createUnaryCallable(listFeedsTransportSettings, settings.listFeedsSettings(), clientContext);
        this.updateFeedCallable = callableFactory.createUnaryCallable(updateFeedTransportSettings, settings.updateFeedSettings(), clientContext);
        this.deleteFeedCallable = callableFactory.createUnaryCallable(deleteFeedTransportSettings, settings.deleteFeedSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateFeedRequest, Feed> createFeedCallable() {
        return this.createFeedCallable;
    }

    @Override
    public UnaryCallable<GetFeedRequest, Feed> getFeedCallable() {
        return this.getFeedCallable;
    }

    @Override
    public UnaryCallable<ListFeedsRequest, ListFeedsResponse> listFeedsCallable() {
        return this.listFeedsCallable;
    }

    @Override
    public UnaryCallable<UpdateFeedRequest, Feed> updateFeedCallable() {
        return this.updateFeedCallable;
    }

    @Override
    public UnaryCallable<DeleteFeedRequest, Empty> deleteFeedCallable() {
        return this.deleteFeedCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

