/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.artifactregistry.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.devtools.artifactregistry.v1.ArtifactRegistrySettings;
import com.google.devtools.artifactregistry.v1.Attachment;
import com.google.devtools.artifactregistry.v1.AttachmentName;
import com.google.devtools.artifactregistry.v1.BatchDeleteVersionsMetadata;
import com.google.devtools.artifactregistry.v1.BatchDeleteVersionsRequest;
import com.google.devtools.artifactregistry.v1.CreateAttachmentRequest;
import com.google.devtools.artifactregistry.v1.CreateRepositoryRequest;
import com.google.devtools.artifactregistry.v1.CreateRuleRequest;
import com.google.devtools.artifactregistry.v1.CreateTagRequest;
import com.google.devtools.artifactregistry.v1.DeleteAttachmentRequest;
import com.google.devtools.artifactregistry.v1.DeleteFileRequest;
import com.google.devtools.artifactregistry.v1.DeletePackageRequest;
import com.google.devtools.artifactregistry.v1.DeleteRepositoryRequest;
import com.google.devtools.artifactregistry.v1.DeleteRuleRequest;
import com.google.devtools.artifactregistry.v1.DeleteTagRequest;
import com.google.devtools.artifactregistry.v1.DeleteVersionRequest;
import com.google.devtools.artifactregistry.v1.DockerImage;
import com.google.devtools.artifactregistry.v1.DockerImageName;
import com.google.devtools.artifactregistry.v1.ExportArtifactMetadata;
import com.google.devtools.artifactregistry.v1.ExportArtifactRequest;
import com.google.devtools.artifactregistry.v1.ExportArtifactResponse;
import com.google.devtools.artifactregistry.v1.File;
import com.google.devtools.artifactregistry.v1.FileName;
import com.google.devtools.artifactregistry.v1.GetAttachmentRequest;
import com.google.devtools.artifactregistry.v1.GetDockerImageRequest;
import com.google.devtools.artifactregistry.v1.GetFileRequest;
import com.google.devtools.artifactregistry.v1.GetMavenArtifactRequest;
import com.google.devtools.artifactregistry.v1.GetNpmPackageRequest;
import com.google.devtools.artifactregistry.v1.GetPackageRequest;
import com.google.devtools.artifactregistry.v1.GetProjectSettingsRequest;
import com.google.devtools.artifactregistry.v1.GetPythonPackageRequest;
import com.google.devtools.artifactregistry.v1.GetRepositoryRequest;
import com.google.devtools.artifactregistry.v1.GetRuleRequest;
import com.google.devtools.artifactregistry.v1.GetTagRequest;
import com.google.devtools.artifactregistry.v1.GetVPCSCConfigRequest;
import com.google.devtools.artifactregistry.v1.GetVersionRequest;
import com.google.devtools.artifactregistry.v1.ImportAptArtifactsMetadata;
import com.google.devtools.artifactregistry.v1.ImportAptArtifactsRequest;
import com.google.devtools.artifactregistry.v1.ImportAptArtifactsResponse;
import com.google.devtools.artifactregistry.v1.ImportYumArtifactsMetadata;
import com.google.devtools.artifactregistry.v1.ImportYumArtifactsRequest;
import com.google.devtools.artifactregistry.v1.ImportYumArtifactsResponse;
import com.google.devtools.artifactregistry.v1.ListAttachmentsRequest;
import com.google.devtools.artifactregistry.v1.ListAttachmentsResponse;
import com.google.devtools.artifactregistry.v1.ListDockerImagesRequest;
import com.google.devtools.artifactregistry.v1.ListDockerImagesResponse;
import com.google.devtools.artifactregistry.v1.ListFilesRequest;
import com.google.devtools.artifactregistry.v1.ListFilesResponse;
import com.google.devtools.artifactregistry.v1.ListMavenArtifactsRequest;
import com.google.devtools.artifactregistry.v1.ListMavenArtifactsResponse;
import com.google.devtools.artifactregistry.v1.ListNpmPackagesRequest;
import com.google.devtools.artifactregistry.v1.ListNpmPackagesResponse;
import com.google.devtools.artifactregistry.v1.ListPackagesRequest;
import com.google.devtools.artifactregistry.v1.ListPackagesResponse;
import com.google.devtools.artifactregistry.v1.ListPythonPackagesRequest;
import com.google.devtools.artifactregistry.v1.ListPythonPackagesResponse;
import com.google.devtools.artifactregistry.v1.ListRepositoriesRequest;
import com.google.devtools.artifactregistry.v1.ListRepositoriesResponse;
import com.google.devtools.artifactregistry.v1.ListRulesRequest;
import com.google.devtools.artifactregistry.v1.ListRulesResponse;
import com.google.devtools.artifactregistry.v1.ListTagsRequest;
import com.google.devtools.artifactregistry.v1.ListTagsResponse;
import com.google.devtools.artifactregistry.v1.ListVersionsRequest;
import com.google.devtools.artifactregistry.v1.ListVersionsResponse;
import com.google.devtools.artifactregistry.v1.LocationName;
import com.google.devtools.artifactregistry.v1.MavenArtifact;
import com.google.devtools.artifactregistry.v1.MavenArtifactName;
import com.google.devtools.artifactregistry.v1.NpmPackage;
import com.google.devtools.artifactregistry.v1.NpmPackageName;
import com.google.devtools.artifactregistry.v1.OperationMetadata;
import com.google.devtools.artifactregistry.v1.Package;
import com.google.devtools.artifactregistry.v1.PackageName;
import com.google.devtools.artifactregistry.v1.ProjectSettings;
import com.google.devtools.artifactregistry.v1.ProjectSettingsName;
import com.google.devtools.artifactregistry.v1.PythonPackage;
import com.google.devtools.artifactregistry.v1.PythonPackageName;
import com.google.devtools.artifactregistry.v1.Repository;
import com.google.devtools.artifactregistry.v1.RepositoryName;
import com.google.devtools.artifactregistry.v1.Rule;
import com.google.devtools.artifactregistry.v1.RuleName;
import com.google.devtools.artifactregistry.v1.Tag;
import com.google.devtools.artifactregistry.v1.UpdateFileRequest;
import com.google.devtools.artifactregistry.v1.UpdatePackageRequest;
import com.google.devtools.artifactregistry.v1.UpdateProjectSettingsRequest;
import com.google.devtools.artifactregistry.v1.UpdateRepositoryRequest;
import com.google.devtools.artifactregistry.v1.UpdateRuleRequest;
import com.google.devtools.artifactregistry.v1.UpdateTagRequest;
import com.google.devtools.artifactregistry.v1.UpdateVPCSCConfigRequest;
import com.google.devtools.artifactregistry.v1.UpdateVersionRequest;
import com.google.devtools.artifactregistry.v1.VPCSCConfig;
import com.google.devtools.artifactregistry.v1.Version;
import com.google.devtools.artifactregistry.v1.VpcscConfigName;
import com.google.devtools.artifactregistry.v1.stub.ArtifactRegistryStub;
import com.google.devtools.artifactregistry.v1.stub.ArtifactRegistryStubSettings;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ArtifactRegistryClient
implements BackgroundResource {
    private final ArtifactRegistrySettings settings;
    private final ArtifactRegistryStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final ArtifactRegistryClient create() throws IOException {
        return ArtifactRegistryClient.create(ArtifactRegistrySettings.newBuilder().build());
    }

    public static final ArtifactRegistryClient create(ArtifactRegistrySettings settings) throws IOException {
        return new ArtifactRegistryClient(settings);
    }

    public static final ArtifactRegistryClient create(ArtifactRegistryStub stub) {
        return new ArtifactRegistryClient(stub);
    }

    protected ArtifactRegistryClient(ArtifactRegistrySettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ArtifactRegistryStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected ArtifactRegistryClient(ArtifactRegistryStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final ArtifactRegistrySettings getSettings() {
        return this.settings;
    }

    public ArtifactRegistryStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListDockerImagesPagedResponse listDockerImages(String parent) {
        ListDockerImagesRequest request = ListDockerImagesRequest.newBuilder().setParent(parent).build();
        return this.listDockerImages(request);
    }

    public final ListDockerImagesPagedResponse listDockerImages(ListDockerImagesRequest request) {
        return (ListDockerImagesPagedResponse)((Object)this.listDockerImagesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDockerImagesRequest, ListDockerImagesPagedResponse> listDockerImagesPagedCallable() {
        return this.stub.listDockerImagesPagedCallable();
    }

    public final UnaryCallable<ListDockerImagesRequest, ListDockerImagesResponse> listDockerImagesCallable() {
        return this.stub.listDockerImagesCallable();
    }

    public final DockerImage getDockerImage(DockerImageName name) {
        GetDockerImageRequest request = GetDockerImageRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDockerImage(request);
    }

    public final DockerImage getDockerImage(String name) {
        GetDockerImageRequest request = GetDockerImageRequest.newBuilder().setName(name).build();
        return this.getDockerImage(request);
    }

    public final DockerImage getDockerImage(GetDockerImageRequest request) {
        return (DockerImage)this.getDockerImageCallable().call((Object)request);
    }

    public final UnaryCallable<GetDockerImageRequest, DockerImage> getDockerImageCallable() {
        return this.stub.getDockerImageCallable();
    }

    public final ListMavenArtifactsPagedResponse listMavenArtifacts(RepositoryName parent) {
        ListMavenArtifactsRequest request = ListMavenArtifactsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMavenArtifacts(request);
    }

    public final ListMavenArtifactsPagedResponse listMavenArtifacts(String parent) {
        ListMavenArtifactsRequest request = ListMavenArtifactsRequest.newBuilder().setParent(parent).build();
        return this.listMavenArtifacts(request);
    }

    public final ListMavenArtifactsPagedResponse listMavenArtifacts(ListMavenArtifactsRequest request) {
        return (ListMavenArtifactsPagedResponse)((Object)this.listMavenArtifactsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMavenArtifactsRequest, ListMavenArtifactsPagedResponse> listMavenArtifactsPagedCallable() {
        return this.stub.listMavenArtifactsPagedCallable();
    }

    public final UnaryCallable<ListMavenArtifactsRequest, ListMavenArtifactsResponse> listMavenArtifactsCallable() {
        return this.stub.listMavenArtifactsCallable();
    }

    public final MavenArtifact getMavenArtifact(MavenArtifactName name) {
        GetMavenArtifactRequest request = GetMavenArtifactRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getMavenArtifact(request);
    }

    public final MavenArtifact getMavenArtifact(String name) {
        GetMavenArtifactRequest request = GetMavenArtifactRequest.newBuilder().setName(name).build();
        return this.getMavenArtifact(request);
    }

    public final MavenArtifact getMavenArtifact(GetMavenArtifactRequest request) {
        return (MavenArtifact)this.getMavenArtifactCallable().call((Object)request);
    }

    public final UnaryCallable<GetMavenArtifactRequest, MavenArtifact> getMavenArtifactCallable() {
        return this.stub.getMavenArtifactCallable();
    }

    public final ListNpmPackagesPagedResponse listNpmPackages(RepositoryName parent) {
        ListNpmPackagesRequest request = ListNpmPackagesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listNpmPackages(request);
    }

    public final ListNpmPackagesPagedResponse listNpmPackages(String parent) {
        ListNpmPackagesRequest request = ListNpmPackagesRequest.newBuilder().setParent(parent).build();
        return this.listNpmPackages(request);
    }

    public final ListNpmPackagesPagedResponse listNpmPackages(ListNpmPackagesRequest request) {
        return (ListNpmPackagesPagedResponse)((Object)this.listNpmPackagesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNpmPackagesRequest, ListNpmPackagesPagedResponse> listNpmPackagesPagedCallable() {
        return this.stub.listNpmPackagesPagedCallable();
    }

    public final UnaryCallable<ListNpmPackagesRequest, ListNpmPackagesResponse> listNpmPackagesCallable() {
        return this.stub.listNpmPackagesCallable();
    }

    public final NpmPackage getNpmPackage(NpmPackageName name) {
        GetNpmPackageRequest request = GetNpmPackageRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getNpmPackage(request);
    }

    public final NpmPackage getNpmPackage(String name) {
        GetNpmPackageRequest request = GetNpmPackageRequest.newBuilder().setName(name).build();
        return this.getNpmPackage(request);
    }

    public final NpmPackage getNpmPackage(GetNpmPackageRequest request) {
        return (NpmPackage)this.getNpmPackageCallable().call((Object)request);
    }

    public final UnaryCallable<GetNpmPackageRequest, NpmPackage> getNpmPackageCallable() {
        return this.stub.getNpmPackageCallable();
    }

    public final ListPythonPackagesPagedResponse listPythonPackages(RepositoryName parent) {
        ListPythonPackagesRequest request = ListPythonPackagesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPythonPackages(request);
    }

    public final ListPythonPackagesPagedResponse listPythonPackages(String parent) {
        ListPythonPackagesRequest request = ListPythonPackagesRequest.newBuilder().setParent(parent).build();
        return this.listPythonPackages(request);
    }

    public final ListPythonPackagesPagedResponse listPythonPackages(ListPythonPackagesRequest request) {
        return (ListPythonPackagesPagedResponse)((Object)this.listPythonPackagesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPythonPackagesRequest, ListPythonPackagesPagedResponse> listPythonPackagesPagedCallable() {
        return this.stub.listPythonPackagesPagedCallable();
    }

    public final UnaryCallable<ListPythonPackagesRequest, ListPythonPackagesResponse> listPythonPackagesCallable() {
        return this.stub.listPythonPackagesCallable();
    }

    public final PythonPackage getPythonPackage(PythonPackageName name) {
        GetPythonPackageRequest request = GetPythonPackageRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPythonPackage(request);
    }

    public final PythonPackage getPythonPackage(String name) {
        GetPythonPackageRequest request = GetPythonPackageRequest.newBuilder().setName(name).build();
        return this.getPythonPackage(request);
    }

    public final PythonPackage getPythonPackage(GetPythonPackageRequest request) {
        return (PythonPackage)this.getPythonPackageCallable().call((Object)request);
    }

    public final UnaryCallable<GetPythonPackageRequest, PythonPackage> getPythonPackageCallable() {
        return this.stub.getPythonPackageCallable();
    }

    public final OperationFuture<ImportAptArtifactsResponse, ImportAptArtifactsMetadata> importAptArtifactsAsync(ImportAptArtifactsRequest request) {
        return this.importAptArtifactsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ImportAptArtifactsRequest, ImportAptArtifactsResponse, ImportAptArtifactsMetadata> importAptArtifactsOperationCallable() {
        return this.stub.importAptArtifactsOperationCallable();
    }

    public final UnaryCallable<ImportAptArtifactsRequest, Operation> importAptArtifactsCallable() {
        return this.stub.importAptArtifactsCallable();
    }

    public final OperationFuture<ImportYumArtifactsResponse, ImportYumArtifactsMetadata> importYumArtifactsAsync(ImportYumArtifactsRequest request) {
        return this.importYumArtifactsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ImportYumArtifactsRequest, ImportYumArtifactsResponse, ImportYumArtifactsMetadata> importYumArtifactsOperationCallable() {
        return this.stub.importYumArtifactsOperationCallable();
    }

    public final UnaryCallable<ImportYumArtifactsRequest, Operation> importYumArtifactsCallable() {
        return this.stub.importYumArtifactsCallable();
    }

    public final ListRepositoriesPagedResponse listRepositories(LocationName parent) {
        ListRepositoriesRequest request = ListRepositoriesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRepositories(request);
    }

    public final ListRepositoriesPagedResponse listRepositories(String parent) {
        ListRepositoriesRequest request = ListRepositoriesRequest.newBuilder().setParent(parent).build();
        return this.listRepositories(request);
    }

    public final ListRepositoriesPagedResponse listRepositories(ListRepositoriesRequest request) {
        return (ListRepositoriesPagedResponse)((Object)this.listRepositoriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRepositoriesRequest, ListRepositoriesPagedResponse> listRepositoriesPagedCallable() {
        return this.stub.listRepositoriesPagedCallable();
    }

    public final UnaryCallable<ListRepositoriesRequest, ListRepositoriesResponse> listRepositoriesCallable() {
        return this.stub.listRepositoriesCallable();
    }

    public final Repository getRepository(RepositoryName name) {
        GetRepositoryRequest request = GetRepositoryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRepository(request);
    }

    public final Repository getRepository(String name) {
        GetRepositoryRequest request = GetRepositoryRequest.newBuilder().setName(name).build();
        return this.getRepository(request);
    }

    public final Repository getRepository(GetRepositoryRequest request) {
        return (Repository)this.getRepositoryCallable().call((Object)request);
    }

    public final UnaryCallable<GetRepositoryRequest, Repository> getRepositoryCallable() {
        return this.stub.getRepositoryCallable();
    }

    public final OperationFuture<Repository, OperationMetadata> createRepositoryAsync(LocationName parent, Repository repository, String repositoryId) {
        CreateRepositoryRequest request = CreateRepositoryRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setRepository(repository).setRepositoryId(repositoryId).build();
        return this.createRepositoryAsync(request);
    }

    public final OperationFuture<Repository, OperationMetadata> createRepositoryAsync(String parent, Repository repository, String repositoryId) {
        CreateRepositoryRequest request = CreateRepositoryRequest.newBuilder().setParent(parent).setRepository(repository).setRepositoryId(repositoryId).build();
        return this.createRepositoryAsync(request);
    }

    public final OperationFuture<Repository, OperationMetadata> createRepositoryAsync(CreateRepositoryRequest request) {
        return this.createRepositoryOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateRepositoryRequest, Repository, OperationMetadata> createRepositoryOperationCallable() {
        return this.stub.createRepositoryOperationCallable();
    }

    public final UnaryCallable<CreateRepositoryRequest, Operation> createRepositoryCallable() {
        return this.stub.createRepositoryCallable();
    }

    public final Repository updateRepository(Repository repository, FieldMask updateMask) {
        UpdateRepositoryRequest request = UpdateRepositoryRequest.newBuilder().setRepository(repository).setUpdateMask(updateMask).build();
        return this.updateRepository(request);
    }

    public final Repository updateRepository(UpdateRepositoryRequest request) {
        return (Repository)this.updateRepositoryCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateRepositoryRequest, Repository> updateRepositoryCallable() {
        return this.stub.updateRepositoryCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRepositoryAsync(RepositoryName name) {
        DeleteRepositoryRequest request = DeleteRepositoryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteRepositoryAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRepositoryAsync(String name) {
        DeleteRepositoryRequest request = DeleteRepositoryRequest.newBuilder().setName(name).build();
        return this.deleteRepositoryAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRepositoryAsync(DeleteRepositoryRequest request) {
        return this.deleteRepositoryOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteRepositoryRequest, Empty, OperationMetadata> deleteRepositoryOperationCallable() {
        return this.stub.deleteRepositoryOperationCallable();
    }

    public final UnaryCallable<DeleteRepositoryRequest, Operation> deleteRepositoryCallable() {
        return this.stub.deleteRepositoryCallable();
    }

    public final ListPackagesPagedResponse listPackages(RepositoryName parent) {
        ListPackagesRequest request = ListPackagesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPackages(request);
    }

    public final ListPackagesPagedResponse listPackages(String parent) {
        ListPackagesRequest request = ListPackagesRequest.newBuilder().setParent(parent).build();
        return this.listPackages(request);
    }

    public final ListPackagesPagedResponse listPackages(ListPackagesRequest request) {
        return (ListPackagesPagedResponse)((Object)this.listPackagesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPackagesRequest, ListPackagesPagedResponse> listPackagesPagedCallable() {
        return this.stub.listPackagesPagedCallable();
    }

    public final UnaryCallable<ListPackagesRequest, ListPackagesResponse> listPackagesCallable() {
        return this.stub.listPackagesCallable();
    }

    public final Package getPackage(PackageName name) {
        GetPackageRequest request = GetPackageRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPackage(request);
    }

    public final Package getPackage(String name) {
        GetPackageRequest request = GetPackageRequest.newBuilder().setName(name).build();
        return this.getPackage(request);
    }

    public final Package getPackage(GetPackageRequest request) {
        return (Package)this.getPackageCallable().call((Object)request);
    }

    public final UnaryCallable<GetPackageRequest, Package> getPackageCallable() {
        return this.stub.getPackageCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deletePackageAsync(PackageName name) {
        DeletePackageRequest request = DeletePackageRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deletePackageAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deletePackageAsync(String name) {
        DeletePackageRequest request = DeletePackageRequest.newBuilder().setName(name).build();
        return this.deletePackageAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deletePackageAsync(DeletePackageRequest request) {
        return this.deletePackageOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeletePackageRequest, Empty, OperationMetadata> deletePackageOperationCallable() {
        return this.stub.deletePackageOperationCallable();
    }

    public final UnaryCallable<DeletePackageRequest, Operation> deletePackageCallable() {
        return this.stub.deletePackageCallable();
    }

    public final ListVersionsPagedResponse listVersions(String parent) {
        ListVersionsRequest request = ListVersionsRequest.newBuilder().setParent(parent).build();
        return this.listVersions(request);
    }

    public final ListVersionsPagedResponse listVersions(ListVersionsRequest request) {
        return (ListVersionsPagedResponse)((Object)this.listVersionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListVersionsRequest, ListVersionsPagedResponse> listVersionsPagedCallable() {
        return this.stub.listVersionsPagedCallable();
    }

    public final UnaryCallable<ListVersionsRequest, ListVersionsResponse> listVersionsCallable() {
        return this.stub.listVersionsCallable();
    }

    public final Version getVersion(String name) {
        GetVersionRequest request = GetVersionRequest.newBuilder().setName(name).build();
        return this.getVersion(request);
    }

    public final Version getVersion(GetVersionRequest request) {
        return (Version)this.getVersionCallable().call((Object)request);
    }

    public final UnaryCallable<GetVersionRequest, Version> getVersionCallable() {
        return this.stub.getVersionCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteVersionAsync(String name) {
        DeleteVersionRequest request = DeleteVersionRequest.newBuilder().setName(name).build();
        return this.deleteVersionAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteVersionAsync(DeleteVersionRequest request) {
        return this.deleteVersionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteVersionRequest, Empty, OperationMetadata> deleteVersionOperationCallable() {
        return this.stub.deleteVersionOperationCallable();
    }

    public final UnaryCallable<DeleteVersionRequest, Operation> deleteVersionCallable() {
        return this.stub.deleteVersionCallable();
    }

    public final OperationFuture<Empty, BatchDeleteVersionsMetadata> batchDeleteVersionsAsync(PackageName parent, List<String> names) {
        BatchDeleteVersionsRequest request = BatchDeleteVersionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllNames(names).build();
        return this.batchDeleteVersionsAsync(request);
    }

    public final OperationFuture<Empty, BatchDeleteVersionsMetadata> batchDeleteVersionsAsync(String parent, List<String> names) {
        BatchDeleteVersionsRequest request = BatchDeleteVersionsRequest.newBuilder().setParent(parent).addAllNames(names).build();
        return this.batchDeleteVersionsAsync(request);
    }

    public final OperationFuture<Empty, BatchDeleteVersionsMetadata> batchDeleteVersionsAsync(BatchDeleteVersionsRequest request) {
        return this.batchDeleteVersionsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchDeleteVersionsRequest, Empty, BatchDeleteVersionsMetadata> batchDeleteVersionsOperationCallable() {
        return this.stub.batchDeleteVersionsOperationCallable();
    }

    public final UnaryCallable<BatchDeleteVersionsRequest, Operation> batchDeleteVersionsCallable() {
        return this.stub.batchDeleteVersionsCallable();
    }

    public final Version updateVersion(Version version, FieldMask updateMask) {
        UpdateVersionRequest request = UpdateVersionRequest.newBuilder().setVersion(version).setUpdateMask(updateMask).build();
        return this.updateVersion(request);
    }

    public final Version updateVersion(UpdateVersionRequest request) {
        return (Version)this.updateVersionCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateVersionRequest, Version> updateVersionCallable() {
        return this.stub.updateVersionCallable();
    }

    public final ListFilesPagedResponse listFiles(RepositoryName parent) {
        ListFilesRequest request = ListFilesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listFiles(request);
    }

    public final ListFilesPagedResponse listFiles(String parent) {
        ListFilesRequest request = ListFilesRequest.newBuilder().setParent(parent).build();
        return this.listFiles(request);
    }

    public final ListFilesPagedResponse listFiles(ListFilesRequest request) {
        return (ListFilesPagedResponse)((Object)this.listFilesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListFilesRequest, ListFilesPagedResponse> listFilesPagedCallable() {
        return this.stub.listFilesPagedCallable();
    }

    public final UnaryCallable<ListFilesRequest, ListFilesResponse> listFilesCallable() {
        return this.stub.listFilesCallable();
    }

    public final File getFile(FileName name) {
        GetFileRequest request = GetFileRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getFile(request);
    }

    public final File getFile(String name) {
        GetFileRequest request = GetFileRequest.newBuilder().setName(name).build();
        return this.getFile(request);
    }

    public final File getFile(GetFileRequest request) {
        return (File)this.getFileCallable().call((Object)request);
    }

    public final UnaryCallable<GetFileRequest, File> getFileCallable() {
        return this.stub.getFileCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteFileAsync(FileName name) {
        DeleteFileRequest request = DeleteFileRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteFileAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteFileAsync(String name) {
        DeleteFileRequest request = DeleteFileRequest.newBuilder().setName(name).build();
        return this.deleteFileAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteFileAsync(DeleteFileRequest request) {
        return this.deleteFileOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteFileRequest, Empty, OperationMetadata> deleteFileOperationCallable() {
        return this.stub.deleteFileOperationCallable();
    }

    public final UnaryCallable<DeleteFileRequest, Operation> deleteFileCallable() {
        return this.stub.deleteFileCallable();
    }

    public final File updateFile(File file, FieldMask updateMask) {
        UpdateFileRequest request = UpdateFileRequest.newBuilder().setFile(file).setUpdateMask(updateMask).build();
        return this.updateFile(request);
    }

    public final File updateFile(UpdateFileRequest request) {
        return (File)this.updateFileCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateFileRequest, File> updateFileCallable() {
        return this.stub.updateFileCallable();
    }

    public final ListTagsPagedResponse listTags(String parent) {
        ListTagsRequest request = ListTagsRequest.newBuilder().setParent(parent).build();
        return this.listTags(request);
    }

    public final ListTagsPagedResponse listTags(ListTagsRequest request) {
        return (ListTagsPagedResponse)((Object)this.listTagsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTagsRequest, ListTagsPagedResponse> listTagsPagedCallable() {
        return this.stub.listTagsPagedCallable();
    }

    public final UnaryCallable<ListTagsRequest, ListTagsResponse> listTagsCallable() {
        return this.stub.listTagsCallable();
    }

    public final Tag getTag(String name) {
        GetTagRequest request = GetTagRequest.newBuilder().setName(name).build();
        return this.getTag(request);
    }

    public final Tag getTag(GetTagRequest request) {
        return (Tag)this.getTagCallable().call((Object)request);
    }

    public final UnaryCallable<GetTagRequest, Tag> getTagCallable() {
        return this.stub.getTagCallable();
    }

    public final Tag createTag(String parent, Tag tag, String tagId) {
        CreateTagRequest request = CreateTagRequest.newBuilder().setParent(parent).setTag(tag).setTagId(tagId).build();
        return this.createTag(request);
    }

    public final Tag createTag(CreateTagRequest request) {
        return (Tag)this.createTagCallable().call((Object)request);
    }

    public final UnaryCallable<CreateTagRequest, Tag> createTagCallable() {
        return this.stub.createTagCallable();
    }

    public final Tag updateTag(Tag tag, FieldMask updateMask) {
        UpdateTagRequest request = UpdateTagRequest.newBuilder().setTag(tag).setUpdateMask(updateMask).build();
        return this.updateTag(request);
    }

    public final Tag updateTag(UpdateTagRequest request) {
        return (Tag)this.updateTagCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateTagRequest, Tag> updateTagCallable() {
        return this.stub.updateTagCallable();
    }

    public final void deleteTag(String name) {
        DeleteTagRequest request = DeleteTagRequest.newBuilder().setName(name).build();
        this.deleteTag(request);
    }

    public final void deleteTag(DeleteTagRequest request) {
        this.deleteTagCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteTagRequest, Empty> deleteTagCallable() {
        return this.stub.deleteTagCallable();
    }

    public final Rule createRule(RepositoryName parent, Rule rule, String ruleId) {
        CreateRuleRequest request = CreateRuleRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setRule(rule).setRuleId(ruleId).build();
        return this.createRule(request);
    }

    public final Rule createRule(String parent, Rule rule, String ruleId) {
        CreateRuleRequest request = CreateRuleRequest.newBuilder().setParent(parent).setRule(rule).setRuleId(ruleId).build();
        return this.createRule(request);
    }

    public final Rule createRule(CreateRuleRequest request) {
        return (Rule)this.createRuleCallable().call((Object)request);
    }

    public final UnaryCallable<CreateRuleRequest, Rule> createRuleCallable() {
        return this.stub.createRuleCallable();
    }

    public final ListRulesPagedResponse listRules(RepositoryName parent) {
        ListRulesRequest request = ListRulesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRules(request);
    }

    public final ListRulesPagedResponse listRules(String parent) {
        ListRulesRequest request = ListRulesRequest.newBuilder().setParent(parent).build();
        return this.listRules(request);
    }

    public final ListRulesPagedResponse listRules(ListRulesRequest request) {
        return (ListRulesPagedResponse)((Object)this.listRulesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRulesRequest, ListRulesPagedResponse> listRulesPagedCallable() {
        return this.stub.listRulesPagedCallable();
    }

    public final UnaryCallable<ListRulesRequest, ListRulesResponse> listRulesCallable() {
        return this.stub.listRulesCallable();
    }

    public final Rule getRule(RuleName name) {
        GetRuleRequest request = GetRuleRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRule(request);
    }

    public final Rule getRule(String name) {
        GetRuleRequest request = GetRuleRequest.newBuilder().setName(name).build();
        return this.getRule(request);
    }

    public final Rule getRule(GetRuleRequest request) {
        return (Rule)this.getRuleCallable().call((Object)request);
    }

    public final UnaryCallable<GetRuleRequest, Rule> getRuleCallable() {
        return this.stub.getRuleCallable();
    }

    public final Rule updateRule(Rule rule, FieldMask updateMask) {
        UpdateRuleRequest request = UpdateRuleRequest.newBuilder().setRule(rule).setUpdateMask(updateMask).build();
        return this.updateRule(request);
    }

    public final Rule updateRule(UpdateRuleRequest request) {
        return (Rule)this.updateRuleCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateRuleRequest, Rule> updateRuleCallable() {
        return this.stub.updateRuleCallable();
    }

    public final void deleteRule(RuleName name) {
        DeleteRuleRequest request = DeleteRuleRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteRule(request);
    }

    public final void deleteRule(String name) {
        DeleteRuleRequest request = DeleteRuleRequest.newBuilder().setName(name).build();
        this.deleteRule(request);
    }

    public final void deleteRule(DeleteRuleRequest request) {
        this.deleteRuleCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteRuleRequest, Empty> deleteRuleCallable() {
        return this.stub.deleteRuleCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final ProjectSettings getProjectSettings(ProjectSettingsName name) {
        GetProjectSettingsRequest request = GetProjectSettingsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getProjectSettings(request);
    }

    public final ProjectSettings getProjectSettings(String name) {
        GetProjectSettingsRequest request = GetProjectSettingsRequest.newBuilder().setName(name).build();
        return this.getProjectSettings(request);
    }

    public final ProjectSettings getProjectSettings(GetProjectSettingsRequest request) {
        return (ProjectSettings)this.getProjectSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<GetProjectSettingsRequest, ProjectSettings> getProjectSettingsCallable() {
        return this.stub.getProjectSettingsCallable();
    }

    public final ProjectSettings updateProjectSettings(ProjectSettings projectSettings, FieldMask updateMask) {
        UpdateProjectSettingsRequest request = UpdateProjectSettingsRequest.newBuilder().setProjectSettings(projectSettings).setUpdateMask(updateMask).build();
        return this.updateProjectSettings(request);
    }

    public final ProjectSettings updateProjectSettings(UpdateProjectSettingsRequest request) {
        return (ProjectSettings)this.updateProjectSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateProjectSettingsRequest, ProjectSettings> updateProjectSettingsCallable() {
        return this.stub.updateProjectSettingsCallable();
    }

    public final VPCSCConfig getVPCSCConfig(VpcscConfigName name) {
        GetVPCSCConfigRequest request = GetVPCSCConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getVPCSCConfig(request);
    }

    public final VPCSCConfig getVPCSCConfig(String name) {
        GetVPCSCConfigRequest request = GetVPCSCConfigRequest.newBuilder().setName(name).build();
        return this.getVPCSCConfig(request);
    }

    public final VPCSCConfig getVPCSCConfig(GetVPCSCConfigRequest request) {
        return (VPCSCConfig)this.getVPCSCConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetVPCSCConfigRequest, VPCSCConfig> getVPCSCConfigCallable() {
        return this.stub.getVPCSCConfigCallable();
    }

    public final VPCSCConfig updateVPCSCConfig(VPCSCConfig vpcscConfig, FieldMask updateMask) {
        UpdateVPCSCConfigRequest request = UpdateVPCSCConfigRequest.newBuilder().setVpcscConfig(vpcscConfig).setUpdateMask(updateMask).build();
        return this.updateVPCSCConfig(request);
    }

    public final VPCSCConfig updateVPCSCConfig(UpdateVPCSCConfigRequest request) {
        return (VPCSCConfig)this.updateVPCSCConfigCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateVPCSCConfigRequest, VPCSCConfig> updateVPCSCConfigCallable() {
        return this.stub.updateVPCSCConfigCallable();
    }

    public final Package updatePackage(Package package_, FieldMask updateMask) {
        UpdatePackageRequest request = UpdatePackageRequest.newBuilder().setPackage(package_).setUpdateMask(updateMask).build();
        return this.updatePackage(request);
    }

    public final Package updatePackage(UpdatePackageRequest request) {
        return (Package)this.updatePackageCallable().call((Object)request);
    }

    public final UnaryCallable<UpdatePackageRequest, Package> updatePackageCallable() {
        return this.stub.updatePackageCallable();
    }

    public final ListAttachmentsPagedResponse listAttachments(RepositoryName parent) {
        ListAttachmentsRequest request = ListAttachmentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAttachments(request);
    }

    public final ListAttachmentsPagedResponse listAttachments(String parent) {
        ListAttachmentsRequest request = ListAttachmentsRequest.newBuilder().setParent(parent).build();
        return this.listAttachments(request);
    }

    public final ListAttachmentsPagedResponse listAttachments(ListAttachmentsRequest request) {
        return (ListAttachmentsPagedResponse)((Object)this.listAttachmentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAttachmentsRequest, ListAttachmentsPagedResponse> listAttachmentsPagedCallable() {
        return this.stub.listAttachmentsPagedCallable();
    }

    public final UnaryCallable<ListAttachmentsRequest, ListAttachmentsResponse> listAttachmentsCallable() {
        return this.stub.listAttachmentsCallable();
    }

    public final Attachment getAttachment(AttachmentName name) {
        GetAttachmentRequest request = GetAttachmentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAttachment(request);
    }

    public final Attachment getAttachment(String name) {
        GetAttachmentRequest request = GetAttachmentRequest.newBuilder().setName(name).build();
        return this.getAttachment(request);
    }

    public final Attachment getAttachment(GetAttachmentRequest request) {
        return (Attachment)this.getAttachmentCallable().call((Object)request);
    }

    public final UnaryCallable<GetAttachmentRequest, Attachment> getAttachmentCallable() {
        return this.stub.getAttachmentCallable();
    }

    public final OperationFuture<Attachment, OperationMetadata> createAttachmentAsync(RepositoryName parent, Attachment attachment, String attachmentId) {
        CreateAttachmentRequest request = CreateAttachmentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAttachment(attachment).setAttachmentId(attachmentId).build();
        return this.createAttachmentAsync(request);
    }

    public final OperationFuture<Attachment, OperationMetadata> createAttachmentAsync(String parent, Attachment attachment, String attachmentId) {
        CreateAttachmentRequest request = CreateAttachmentRequest.newBuilder().setParent(parent).setAttachment(attachment).setAttachmentId(attachmentId).build();
        return this.createAttachmentAsync(request);
    }

    public final OperationFuture<Attachment, OperationMetadata> createAttachmentAsync(CreateAttachmentRequest request) {
        return this.createAttachmentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateAttachmentRequest, Attachment, OperationMetadata> createAttachmentOperationCallable() {
        return this.stub.createAttachmentOperationCallable();
    }

    public final UnaryCallable<CreateAttachmentRequest, Operation> createAttachmentCallable() {
        return this.stub.createAttachmentCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAttachmentAsync(AttachmentName name) {
        DeleteAttachmentRequest request = DeleteAttachmentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteAttachmentAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAttachmentAsync(String name) {
        DeleteAttachmentRequest request = DeleteAttachmentRequest.newBuilder().setName(name).build();
        return this.deleteAttachmentAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAttachmentAsync(DeleteAttachmentRequest request) {
        return this.deleteAttachmentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteAttachmentRequest, Empty, OperationMetadata> deleteAttachmentOperationCallable() {
        return this.stub.deleteAttachmentOperationCallable();
    }

    public final UnaryCallable<DeleteAttachmentRequest, Operation> deleteAttachmentCallable() {
        return this.stub.deleteAttachmentCallable();
    }

    public final OperationFuture<ExportArtifactResponse, ExportArtifactMetadata> exportArtifactAsync(ExportArtifactRequest request) {
        return this.exportArtifactOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExportArtifactRequest, ExportArtifactResponse, ExportArtifactMetadata> exportArtifactOperationCallable() {
        return this.stub.exportArtifactOperationCallable();
    }

    public final UnaryCallable<ExportArtifactRequest, Operation> exportArtifactCallable() {
        return this.stub.exportArtifactCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAttachmentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAttachmentsRequest, ListAttachmentsResponse, Attachment, ListAttachmentsPage, ListAttachmentsFixedSizeCollection> {
        private ListAttachmentsFixedSizeCollection(List<ListAttachmentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAttachmentsFixedSizeCollection createEmptyCollection() {
            return new ListAttachmentsFixedSizeCollection(null, 0);
        }

        protected ListAttachmentsFixedSizeCollection createCollection(List<ListAttachmentsPage> pages, int collectionSize) {
            return new ListAttachmentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAttachmentsPage
    extends AbstractPage<ListAttachmentsRequest, ListAttachmentsResponse, Attachment, ListAttachmentsPage> {
        private ListAttachmentsPage(PageContext<ListAttachmentsRequest, ListAttachmentsResponse, Attachment> context, ListAttachmentsResponse response) {
            super(context, (Object)response);
        }

        private static ListAttachmentsPage createEmptyPage() {
            return new ListAttachmentsPage(null, null);
        }

        protected ListAttachmentsPage createPage(PageContext<ListAttachmentsRequest, ListAttachmentsResponse, Attachment> context, ListAttachmentsResponse response) {
            return new ListAttachmentsPage(context, response);
        }

        public ApiFuture<ListAttachmentsPage> createPageAsync(PageContext<ListAttachmentsRequest, ListAttachmentsResponse, Attachment> context, ApiFuture<ListAttachmentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAttachmentsPagedResponse
    extends AbstractPagedListResponse<ListAttachmentsRequest, ListAttachmentsResponse, Attachment, ListAttachmentsPage, ListAttachmentsFixedSizeCollection> {
        public static ApiFuture<ListAttachmentsPagedResponse> createAsync(PageContext<ListAttachmentsRequest, ListAttachmentsResponse, Attachment> context, ApiFuture<ListAttachmentsResponse> futureResponse) {
            ApiFuture<ListAttachmentsPage> futurePage = ListAttachmentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAttachmentsPagedResponse((ListAttachmentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAttachmentsPagedResponse(ListAttachmentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAttachmentsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListRulesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRulesRequest, ListRulesResponse, Rule, ListRulesPage, ListRulesFixedSizeCollection> {
        private ListRulesFixedSizeCollection(List<ListRulesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRulesFixedSizeCollection createEmptyCollection() {
            return new ListRulesFixedSizeCollection(null, 0);
        }

        protected ListRulesFixedSizeCollection createCollection(List<ListRulesPage> pages, int collectionSize) {
            return new ListRulesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRulesPage
    extends AbstractPage<ListRulesRequest, ListRulesResponse, Rule, ListRulesPage> {
        private ListRulesPage(PageContext<ListRulesRequest, ListRulesResponse, Rule> context, ListRulesResponse response) {
            super(context, (Object)response);
        }

        private static ListRulesPage createEmptyPage() {
            return new ListRulesPage(null, null);
        }

        protected ListRulesPage createPage(PageContext<ListRulesRequest, ListRulesResponse, Rule> context, ListRulesResponse response) {
            return new ListRulesPage(context, response);
        }

        public ApiFuture<ListRulesPage> createPageAsync(PageContext<ListRulesRequest, ListRulesResponse, Rule> context, ApiFuture<ListRulesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRulesPagedResponse
    extends AbstractPagedListResponse<ListRulesRequest, ListRulesResponse, Rule, ListRulesPage, ListRulesFixedSizeCollection> {
        public static ApiFuture<ListRulesPagedResponse> createAsync(PageContext<ListRulesRequest, ListRulesResponse, Rule> context, ApiFuture<ListRulesResponse> futureResponse) {
            ApiFuture<ListRulesPage> futurePage = ListRulesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRulesPagedResponse((ListRulesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRulesPagedResponse(ListRulesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRulesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListTagsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTagsRequest, ListTagsResponse, Tag, ListTagsPage, ListTagsFixedSizeCollection> {
        private ListTagsFixedSizeCollection(List<ListTagsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTagsFixedSizeCollection createEmptyCollection() {
            return new ListTagsFixedSizeCollection(null, 0);
        }

        protected ListTagsFixedSizeCollection createCollection(List<ListTagsPage> pages, int collectionSize) {
            return new ListTagsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTagsPage
    extends AbstractPage<ListTagsRequest, ListTagsResponse, Tag, ListTagsPage> {
        private ListTagsPage(PageContext<ListTagsRequest, ListTagsResponse, Tag> context, ListTagsResponse response) {
            super(context, (Object)response);
        }

        private static ListTagsPage createEmptyPage() {
            return new ListTagsPage(null, null);
        }

        protected ListTagsPage createPage(PageContext<ListTagsRequest, ListTagsResponse, Tag> context, ListTagsResponse response) {
            return new ListTagsPage(context, response);
        }

        public ApiFuture<ListTagsPage> createPageAsync(PageContext<ListTagsRequest, ListTagsResponse, Tag> context, ApiFuture<ListTagsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTagsPagedResponse
    extends AbstractPagedListResponse<ListTagsRequest, ListTagsResponse, Tag, ListTagsPage, ListTagsFixedSizeCollection> {
        public static ApiFuture<ListTagsPagedResponse> createAsync(PageContext<ListTagsRequest, ListTagsResponse, Tag> context, ApiFuture<ListTagsResponse> futureResponse) {
            ApiFuture<ListTagsPage> futurePage = ListTagsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTagsPagedResponse((ListTagsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTagsPagedResponse(ListTagsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTagsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFilesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListFilesRequest, ListFilesResponse, File, ListFilesPage, ListFilesFixedSizeCollection> {
        private ListFilesFixedSizeCollection(List<ListFilesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFilesFixedSizeCollection createEmptyCollection() {
            return new ListFilesFixedSizeCollection(null, 0);
        }

        protected ListFilesFixedSizeCollection createCollection(List<ListFilesPage> pages, int collectionSize) {
            return new ListFilesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListFilesPage
    extends AbstractPage<ListFilesRequest, ListFilesResponse, File, ListFilesPage> {
        private ListFilesPage(PageContext<ListFilesRequest, ListFilesResponse, File> context, ListFilesResponse response) {
            super(context, (Object)response);
        }

        private static ListFilesPage createEmptyPage() {
            return new ListFilesPage(null, null);
        }

        protected ListFilesPage createPage(PageContext<ListFilesRequest, ListFilesResponse, File> context, ListFilesResponse response) {
            return new ListFilesPage(context, response);
        }

        public ApiFuture<ListFilesPage> createPageAsync(PageContext<ListFilesRequest, ListFilesResponse, File> context, ApiFuture<ListFilesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListFilesPagedResponse
    extends AbstractPagedListResponse<ListFilesRequest, ListFilesResponse, File, ListFilesPage, ListFilesFixedSizeCollection> {
        public static ApiFuture<ListFilesPagedResponse> createAsync(PageContext<ListFilesRequest, ListFilesResponse, File> context, ApiFuture<ListFilesResponse> futureResponse) {
            ApiFuture<ListFilesPage> futurePage = ListFilesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListFilesPagedResponse((ListFilesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListFilesPagedResponse(ListFilesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFilesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListVersionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListVersionsRequest, ListVersionsResponse, Version, ListVersionsPage, ListVersionsFixedSizeCollection> {
        private ListVersionsFixedSizeCollection(List<ListVersionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListVersionsFixedSizeCollection createEmptyCollection() {
            return new ListVersionsFixedSizeCollection(null, 0);
        }

        protected ListVersionsFixedSizeCollection createCollection(List<ListVersionsPage> pages, int collectionSize) {
            return new ListVersionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListVersionsPage
    extends AbstractPage<ListVersionsRequest, ListVersionsResponse, Version, ListVersionsPage> {
        private ListVersionsPage(PageContext<ListVersionsRequest, ListVersionsResponse, Version> context, ListVersionsResponse response) {
            super(context, (Object)response);
        }

        private static ListVersionsPage createEmptyPage() {
            return new ListVersionsPage(null, null);
        }

        protected ListVersionsPage createPage(PageContext<ListVersionsRequest, ListVersionsResponse, Version> context, ListVersionsResponse response) {
            return new ListVersionsPage(context, response);
        }

        public ApiFuture<ListVersionsPage> createPageAsync(PageContext<ListVersionsRequest, ListVersionsResponse, Version> context, ApiFuture<ListVersionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListVersionsPagedResponse
    extends AbstractPagedListResponse<ListVersionsRequest, ListVersionsResponse, Version, ListVersionsPage, ListVersionsFixedSizeCollection> {
        public static ApiFuture<ListVersionsPagedResponse> createAsync(PageContext<ListVersionsRequest, ListVersionsResponse, Version> context, ApiFuture<ListVersionsResponse> futureResponse) {
            ApiFuture<ListVersionsPage> futurePage = ListVersionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListVersionsPagedResponse((ListVersionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListVersionsPagedResponse(ListVersionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListVersionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPackagesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPackagesRequest, ListPackagesResponse, Package, ListPackagesPage, ListPackagesFixedSizeCollection> {
        private ListPackagesFixedSizeCollection(List<ListPackagesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPackagesFixedSizeCollection createEmptyCollection() {
            return new ListPackagesFixedSizeCollection(null, 0);
        }

        protected ListPackagesFixedSizeCollection createCollection(List<ListPackagesPage> pages, int collectionSize) {
            return new ListPackagesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPackagesPage
    extends AbstractPage<ListPackagesRequest, ListPackagesResponse, Package, ListPackagesPage> {
        private ListPackagesPage(PageContext<ListPackagesRequest, ListPackagesResponse, Package> context, ListPackagesResponse response) {
            super(context, (Object)response);
        }

        private static ListPackagesPage createEmptyPage() {
            return new ListPackagesPage(null, null);
        }

        protected ListPackagesPage createPage(PageContext<ListPackagesRequest, ListPackagesResponse, Package> context, ListPackagesResponse response) {
            return new ListPackagesPage(context, response);
        }

        public ApiFuture<ListPackagesPage> createPageAsync(PageContext<ListPackagesRequest, ListPackagesResponse, Package> context, ApiFuture<ListPackagesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPackagesPagedResponse
    extends AbstractPagedListResponse<ListPackagesRequest, ListPackagesResponse, Package, ListPackagesPage, ListPackagesFixedSizeCollection> {
        public static ApiFuture<ListPackagesPagedResponse> createAsync(PageContext<ListPackagesRequest, ListPackagesResponse, Package> context, ApiFuture<ListPackagesResponse> futureResponse) {
            ApiFuture<ListPackagesPage> futurePage = ListPackagesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPackagesPagedResponse((ListPackagesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPackagesPagedResponse(ListPackagesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPackagesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListRepositoriesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRepositoriesRequest, ListRepositoriesResponse, Repository, ListRepositoriesPage, ListRepositoriesFixedSizeCollection> {
        private ListRepositoriesFixedSizeCollection(List<ListRepositoriesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRepositoriesFixedSizeCollection createEmptyCollection() {
            return new ListRepositoriesFixedSizeCollection(null, 0);
        }

        protected ListRepositoriesFixedSizeCollection createCollection(List<ListRepositoriesPage> pages, int collectionSize) {
            return new ListRepositoriesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRepositoriesPage
    extends AbstractPage<ListRepositoriesRequest, ListRepositoriesResponse, Repository, ListRepositoriesPage> {
        private ListRepositoriesPage(PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository> context, ListRepositoriesResponse response) {
            super(context, (Object)response);
        }

        private static ListRepositoriesPage createEmptyPage() {
            return new ListRepositoriesPage(null, null);
        }

        protected ListRepositoriesPage createPage(PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository> context, ListRepositoriesResponse response) {
            return new ListRepositoriesPage(context, response);
        }

        public ApiFuture<ListRepositoriesPage> createPageAsync(PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository> context, ApiFuture<ListRepositoriesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRepositoriesPagedResponse
    extends AbstractPagedListResponse<ListRepositoriesRequest, ListRepositoriesResponse, Repository, ListRepositoriesPage, ListRepositoriesFixedSizeCollection> {
        public static ApiFuture<ListRepositoriesPagedResponse> createAsync(PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository> context, ApiFuture<ListRepositoriesResponse> futureResponse) {
            ApiFuture<ListRepositoriesPage> futurePage = ListRepositoriesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRepositoriesPagedResponse((ListRepositoriesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRepositoriesPagedResponse(ListRepositoriesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRepositoriesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPythonPackagesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPythonPackagesRequest, ListPythonPackagesResponse, PythonPackage, ListPythonPackagesPage, ListPythonPackagesFixedSizeCollection> {
        private ListPythonPackagesFixedSizeCollection(List<ListPythonPackagesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPythonPackagesFixedSizeCollection createEmptyCollection() {
            return new ListPythonPackagesFixedSizeCollection(null, 0);
        }

        protected ListPythonPackagesFixedSizeCollection createCollection(List<ListPythonPackagesPage> pages, int collectionSize) {
            return new ListPythonPackagesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPythonPackagesPage
    extends AbstractPage<ListPythonPackagesRequest, ListPythonPackagesResponse, PythonPackage, ListPythonPackagesPage> {
        private ListPythonPackagesPage(PageContext<ListPythonPackagesRequest, ListPythonPackagesResponse, PythonPackage> context, ListPythonPackagesResponse response) {
            super(context, (Object)response);
        }

        private static ListPythonPackagesPage createEmptyPage() {
            return new ListPythonPackagesPage(null, null);
        }

        protected ListPythonPackagesPage createPage(PageContext<ListPythonPackagesRequest, ListPythonPackagesResponse, PythonPackage> context, ListPythonPackagesResponse response) {
            return new ListPythonPackagesPage(context, response);
        }

        public ApiFuture<ListPythonPackagesPage> createPageAsync(PageContext<ListPythonPackagesRequest, ListPythonPackagesResponse, PythonPackage> context, ApiFuture<ListPythonPackagesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPythonPackagesPagedResponse
    extends AbstractPagedListResponse<ListPythonPackagesRequest, ListPythonPackagesResponse, PythonPackage, ListPythonPackagesPage, ListPythonPackagesFixedSizeCollection> {
        public static ApiFuture<ListPythonPackagesPagedResponse> createAsync(PageContext<ListPythonPackagesRequest, ListPythonPackagesResponse, PythonPackage> context, ApiFuture<ListPythonPackagesResponse> futureResponse) {
            ApiFuture<ListPythonPackagesPage> futurePage = ListPythonPackagesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPythonPackagesPagedResponse((ListPythonPackagesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPythonPackagesPagedResponse(ListPythonPackagesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPythonPackagesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListNpmPackagesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNpmPackagesRequest, ListNpmPackagesResponse, NpmPackage, ListNpmPackagesPage, ListNpmPackagesFixedSizeCollection> {
        private ListNpmPackagesFixedSizeCollection(List<ListNpmPackagesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNpmPackagesFixedSizeCollection createEmptyCollection() {
            return new ListNpmPackagesFixedSizeCollection(null, 0);
        }

        protected ListNpmPackagesFixedSizeCollection createCollection(List<ListNpmPackagesPage> pages, int collectionSize) {
            return new ListNpmPackagesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNpmPackagesPage
    extends AbstractPage<ListNpmPackagesRequest, ListNpmPackagesResponse, NpmPackage, ListNpmPackagesPage> {
        private ListNpmPackagesPage(PageContext<ListNpmPackagesRequest, ListNpmPackagesResponse, NpmPackage> context, ListNpmPackagesResponse response) {
            super(context, (Object)response);
        }

        private static ListNpmPackagesPage createEmptyPage() {
            return new ListNpmPackagesPage(null, null);
        }

        protected ListNpmPackagesPage createPage(PageContext<ListNpmPackagesRequest, ListNpmPackagesResponse, NpmPackage> context, ListNpmPackagesResponse response) {
            return new ListNpmPackagesPage(context, response);
        }

        public ApiFuture<ListNpmPackagesPage> createPageAsync(PageContext<ListNpmPackagesRequest, ListNpmPackagesResponse, NpmPackage> context, ApiFuture<ListNpmPackagesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNpmPackagesPagedResponse
    extends AbstractPagedListResponse<ListNpmPackagesRequest, ListNpmPackagesResponse, NpmPackage, ListNpmPackagesPage, ListNpmPackagesFixedSizeCollection> {
        public static ApiFuture<ListNpmPackagesPagedResponse> createAsync(PageContext<ListNpmPackagesRequest, ListNpmPackagesResponse, NpmPackage> context, ApiFuture<ListNpmPackagesResponse> futureResponse) {
            ApiFuture<ListNpmPackagesPage> futurePage = ListNpmPackagesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListNpmPackagesPagedResponse((ListNpmPackagesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListNpmPackagesPagedResponse(ListNpmPackagesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNpmPackagesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListMavenArtifactsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMavenArtifactsRequest, ListMavenArtifactsResponse, MavenArtifact, ListMavenArtifactsPage, ListMavenArtifactsFixedSizeCollection> {
        private ListMavenArtifactsFixedSizeCollection(List<ListMavenArtifactsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListMavenArtifactsFixedSizeCollection createEmptyCollection() {
            return new ListMavenArtifactsFixedSizeCollection(null, 0);
        }

        protected ListMavenArtifactsFixedSizeCollection createCollection(List<ListMavenArtifactsPage> pages, int collectionSize) {
            return new ListMavenArtifactsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListMavenArtifactsPage
    extends AbstractPage<ListMavenArtifactsRequest, ListMavenArtifactsResponse, MavenArtifact, ListMavenArtifactsPage> {
        private ListMavenArtifactsPage(PageContext<ListMavenArtifactsRequest, ListMavenArtifactsResponse, MavenArtifact> context, ListMavenArtifactsResponse response) {
            super(context, (Object)response);
        }

        private static ListMavenArtifactsPage createEmptyPage() {
            return new ListMavenArtifactsPage(null, null);
        }

        protected ListMavenArtifactsPage createPage(PageContext<ListMavenArtifactsRequest, ListMavenArtifactsResponse, MavenArtifact> context, ListMavenArtifactsResponse response) {
            return new ListMavenArtifactsPage(context, response);
        }

        public ApiFuture<ListMavenArtifactsPage> createPageAsync(PageContext<ListMavenArtifactsRequest, ListMavenArtifactsResponse, MavenArtifact> context, ApiFuture<ListMavenArtifactsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListMavenArtifactsPagedResponse
    extends AbstractPagedListResponse<ListMavenArtifactsRequest, ListMavenArtifactsResponse, MavenArtifact, ListMavenArtifactsPage, ListMavenArtifactsFixedSizeCollection> {
        public static ApiFuture<ListMavenArtifactsPagedResponse> createAsync(PageContext<ListMavenArtifactsRequest, ListMavenArtifactsResponse, MavenArtifact> context, ApiFuture<ListMavenArtifactsResponse> futureResponse) {
            ApiFuture<ListMavenArtifactsPage> futurePage = ListMavenArtifactsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListMavenArtifactsPagedResponse((ListMavenArtifactsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListMavenArtifactsPagedResponse(ListMavenArtifactsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListMavenArtifactsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDockerImagesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDockerImagesRequest, ListDockerImagesResponse, DockerImage, ListDockerImagesPage, ListDockerImagesFixedSizeCollection> {
        private ListDockerImagesFixedSizeCollection(List<ListDockerImagesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDockerImagesFixedSizeCollection createEmptyCollection() {
            return new ListDockerImagesFixedSizeCollection(null, 0);
        }

        protected ListDockerImagesFixedSizeCollection createCollection(List<ListDockerImagesPage> pages, int collectionSize) {
            return new ListDockerImagesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDockerImagesPage
    extends AbstractPage<ListDockerImagesRequest, ListDockerImagesResponse, DockerImage, ListDockerImagesPage> {
        private ListDockerImagesPage(PageContext<ListDockerImagesRequest, ListDockerImagesResponse, DockerImage> context, ListDockerImagesResponse response) {
            super(context, (Object)response);
        }

        private static ListDockerImagesPage createEmptyPage() {
            return new ListDockerImagesPage(null, null);
        }

        protected ListDockerImagesPage createPage(PageContext<ListDockerImagesRequest, ListDockerImagesResponse, DockerImage> context, ListDockerImagesResponse response) {
            return new ListDockerImagesPage(context, response);
        }

        public ApiFuture<ListDockerImagesPage> createPageAsync(PageContext<ListDockerImagesRequest, ListDockerImagesResponse, DockerImage> context, ApiFuture<ListDockerImagesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDockerImagesPagedResponse
    extends AbstractPagedListResponse<ListDockerImagesRequest, ListDockerImagesResponse, DockerImage, ListDockerImagesPage, ListDockerImagesFixedSizeCollection> {
        public static ApiFuture<ListDockerImagesPagedResponse> createAsync(PageContext<ListDockerImagesRequest, ListDockerImagesResponse, DockerImage> context, ApiFuture<ListDockerImagesResponse> futureResponse) {
            ApiFuture<ListDockerImagesPage> futurePage = ListDockerImagesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDockerImagesPagedResponse((ListDockerImagesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDockerImagesPagedResponse(ListDockerImagesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDockerImagesFixedSizeCollection.createEmptyCollection());
        }
    }
}

