/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.artifactregistry.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.devtools.artifactregistry.v1.ArtifactRegistryClient;
import com.google.devtools.artifactregistry.v1.DockerImage;
import com.google.devtools.artifactregistry.v1.GetRepositoryRequest;
import com.google.devtools.artifactregistry.v1.ListDockerImagesRequest;
import com.google.devtools.artifactregistry.v1.ListDockerImagesResponse;
import com.google.devtools.artifactregistry.v1.ListRepositoriesRequest;
import com.google.devtools.artifactregistry.v1.ListRepositoriesResponse;
import com.google.devtools.artifactregistry.v1.Repository;
import com.google.devtools.artifactregistry.v1.stub.ArtifactRegistryStub;
import com.google.devtools.artifactregistry.v1.stub.GrpcArtifactRegistryStub;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class ArtifactRegistryStubSettings
extends StubSettings<ArtifactRegistryStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").build();
    private final PagedCallSettings<ListDockerImagesRequest, ListDockerImagesResponse, ArtifactRegistryClient.ListDockerImagesPagedResponse> listDockerImagesSettings;
    private final PagedCallSettings<ListRepositoriesRequest, ListRepositoriesResponse, ArtifactRegistryClient.ListRepositoriesPagedResponse> listRepositoriesSettings;
    private final UnaryCallSettings<GetRepositoryRequest, Repository> getRepositorySettings;
    private static final PagedListDescriptor<ListDockerImagesRequest, ListDockerImagesResponse, DockerImage> LIST_DOCKER_IMAGES_PAGE_STR_DESC = new PagedListDescriptor<ListDockerImagesRequest, ListDockerImagesResponse, DockerImage>(){

        public String emptyToken() {
            return "";
        }

        public ListDockerImagesRequest injectToken(ListDockerImagesRequest payload, String token) {
            return ListDockerImagesRequest.newBuilder((ListDockerImagesRequest)payload).setPageToken(token).build();
        }

        public ListDockerImagesRequest injectPageSize(ListDockerImagesRequest payload, int pageSize) {
            return ListDockerImagesRequest.newBuilder((ListDockerImagesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDockerImagesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDockerImagesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DockerImage> extractResources(ListDockerImagesResponse payload) {
            return payload.getDockerImagesList() == null ? ImmutableList.of() : payload.getDockerImagesList();
        }
    };
    private static final PagedListDescriptor<ListRepositoriesRequest, ListRepositoriesResponse, Repository> LIST_REPOSITORIES_PAGE_STR_DESC = new PagedListDescriptor<ListRepositoriesRequest, ListRepositoriesResponse, Repository>(){

        public String emptyToken() {
            return "";
        }

        public ListRepositoriesRequest injectToken(ListRepositoriesRequest payload, String token) {
            return ListRepositoriesRequest.newBuilder((ListRepositoriesRequest)payload).setPageToken(token).build();
        }

        public ListRepositoriesRequest injectPageSize(ListRepositoriesRequest payload, int pageSize) {
            return ListRepositoriesRequest.newBuilder((ListRepositoriesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListRepositoriesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListRepositoriesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Repository> extractResources(ListRepositoriesResponse payload) {
            return payload.getRepositoriesList() == null ? ImmutableList.of() : payload.getRepositoriesList();
        }
    };
    private static final PagedListResponseFactory<ListDockerImagesRequest, ListDockerImagesResponse, ArtifactRegistryClient.ListDockerImagesPagedResponse> LIST_DOCKER_IMAGES_PAGE_STR_FACT = new PagedListResponseFactory<ListDockerImagesRequest, ListDockerImagesResponse, ArtifactRegistryClient.ListDockerImagesPagedResponse>(){

        public ApiFuture<ArtifactRegistryClient.ListDockerImagesPagedResponse> getFuturePagedResponse(UnaryCallable<ListDockerImagesRequest, ListDockerImagesResponse> callable, ListDockerImagesRequest request, ApiCallContext context, ApiFuture<ListDockerImagesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DOCKER_IMAGES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ArtifactRegistryClient.ListDockerImagesPagedResponse.createAsync((PageContext<ListDockerImagesRequest, ListDockerImagesResponse, DockerImage>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListRepositoriesRequest, ListRepositoriesResponse, ArtifactRegistryClient.ListRepositoriesPagedResponse> LIST_REPOSITORIES_PAGE_STR_FACT = new PagedListResponseFactory<ListRepositoriesRequest, ListRepositoriesResponse, ArtifactRegistryClient.ListRepositoriesPagedResponse>(){

        public ApiFuture<ArtifactRegistryClient.ListRepositoriesPagedResponse> getFuturePagedResponse(UnaryCallable<ListRepositoriesRequest, ListRepositoriesResponse> callable, ListRepositoriesRequest request, ApiCallContext context, ApiFuture<ListRepositoriesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_REPOSITORIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ArtifactRegistryClient.ListRepositoriesPagedResponse.createAsync((PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListDockerImagesRequest, ListDockerImagesResponse, ArtifactRegistryClient.ListDockerImagesPagedResponse> listDockerImagesSettings() {
        return this.listDockerImagesSettings;
    }

    public PagedCallSettings<ListRepositoriesRequest, ListRepositoriesResponse, ArtifactRegistryClient.ListRepositoriesPagedResponse> listRepositoriesSettings() {
        return this.listRepositoriesSettings;
    }

    public UnaryCallSettings<GetRepositoryRequest, Repository> getRepositorySettings() {
        return this.getRepositorySettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ArtifactRegistryStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcArtifactRegistryStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "artifactregistry.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "artifactregistry.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ArtifactRegistryStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ArtifactRegistryStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ArtifactRegistryStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listDockerImagesSettings = settingsBuilder.listDockerImagesSettings().build();
        this.listRepositoriesSettings = settingsBuilder.listRepositoriesSettings().build();
        this.getRepositorySettings = settingsBuilder.getRepositorySettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ArtifactRegistryStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListDockerImagesRequest, ListDockerImagesResponse, ArtifactRegistryClient.ListDockerImagesPagedResponse> listDockerImagesSettings;
        private final PagedCallSettings.Builder<ListRepositoriesRequest, ListRepositoriesResponse, ArtifactRegistryClient.ListRepositoriesPagedResponse> listRepositoriesSettings;
        private final UnaryCallSettings.Builder<GetRepositoryRequest, Repository> getRepositorySettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listDockerImagesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DOCKER_IMAGES_PAGE_STR_FACT);
            this.listRepositoriesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_REPOSITORIES_PAGE_STR_FACT);
            this.getRepositorySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listDockerImagesSettings, this.listRepositoriesSettings, this.getRepositorySettings);
            Builder.initDefaults(this);
        }

        protected Builder(ArtifactRegistryStubSettings settings) {
            super((StubSettings)settings);
            this.listDockerImagesSettings = settings.listDockerImagesSettings.toBuilder();
            this.listRepositoriesSettings = settings.listRepositoriesSettings.toBuilder();
            this.getRepositorySettings = settings.getRepositorySettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listDockerImagesSettings, this.listRepositoriesSettings, this.getRepositorySettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ArtifactRegistryStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ArtifactRegistryStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ArtifactRegistryStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ArtifactRegistryStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(ArtifactRegistryStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listDockerImagesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listRepositoriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getRepositorySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListDockerImagesRequest, ListDockerImagesResponse, ArtifactRegistryClient.ListDockerImagesPagedResponse> listDockerImagesSettings() {
            return this.listDockerImagesSettings;
        }

        public PagedCallSettings.Builder<ListRepositoriesRequest, ListRepositoriesResponse, ArtifactRegistryClient.ListRepositoriesPagedResponse> listRepositoriesSettings() {
            return this.listRepositoriesSettings;
        }

        public UnaryCallSettings.Builder<GetRepositoryRequest, Repository> getRepositorySettings() {
            return this.getRepositorySettings;
        }

        public ArtifactRegistryStubSettings build() throws IOException {
            return new ArtifactRegistryStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

